# encoding: utf-8
# module bundlebuilder
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/plat-mac/bundlebuilder.pyo by generator 1.99
"""
bundlebuilder.py -- Tools to assemble MacOS X (application) bundles.

This module contains two classes to build so called "bundles" for
MacOS X. BundleBuilder is a general tool, AppBuilder is a subclass
specialized in building application bundles.

[Bundle|App]Builder objects are instantiated with a bunch of keyword
arguments, and have a build() method that will do all the work. See
the class doc strings for a description of the constructor arguments.

The module contains a main program that can be used in two ways:

  % python bundlebuilder.py [options] build
  % python buildapp.py [options] build

Where "buildapp.py" is a user-supplied setup.py-like script following
this model:

  from bundlebuilder import buildapp
  buildapp(<lots-of-keyword-args>)
"""

# imports
import shutil as shutil # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/shutil.pyc
import imp as imp # <module 'imp' (built-in)>
import errno as errno # <module 'errno' (built-in)>
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import getopt as getopt # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/getopt.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
import marshal as marshal # <module 'marshal' (built-in)>
import plistlib as __plistlib


# Variables with simple values

ARGV_EMULATOR = 'import argvemulator, os\n\nargvemulator.ArgvCollector().mainloop()\nexecfile(os.path.join(os.path.split(__file__)[0], "%(realmainprogram)s"))\n'

BOOTSTRAP_SCRIPT = '#!%(hashbang)s\n\nimport sys, os\nexecdir = os.path.dirname(sys.argv[0])\nexecutable = os.path.join(execdir, "%(executable)s")\nresdir = os.path.join(os.path.dirname(execdir), "Resources")\nlibdir = os.path.join(os.path.dirname(execdir), "Frameworks")\nmainprogram = os.path.join(resdir, "%(mainprogram)s")\n\nsys.argv.insert(1, mainprogram)\nif %(standalone)s or %(semi_standalone)s:\n    os.environ["PYTHONPATH"] = resdir\n    if %(standalone)s:\n        os.environ["PYTHONHOME"] = resdir\nelse:\n    pypath = os.getenv("PYTHONPATH", "")\n    if pypath:\n        pypath = ":" + pypath\n    os.environ["PYTHONPATH"] = resdir + pypath\nos.environ["PYTHONEXECUTABLE"] = executable\nos.environ["DYLD_LIBRARY_PATH"] = libdir\nos.environ["DYLD_FRAMEWORK_PATH"] = libdir\nos.execve(executable, sys.argv, os.environ)\n'

cmdline_doc = 'Usage:\n  python bundlebuilder.py [options] command\n  python mybuildscript.py [options] command\n\nCommands:\n  build      build the application\n  report     print a report\n\nOptions:\n  -b, --builddir=DIR     the build directory; defaults to "build"\n  -n, --name=NAME        application name\n  -r, --resource=FILE    extra file or folder to be copied to Resources\n  -f, --file=SRC:DST     extra file or folder to be copied into the bundle;\n                         DST must be a path relative to the bundle root\n  -e, --executable=FILE  the executable to be used\n  -m, --mainprogram=FILE the Python main program\n  -a, --argv             add a wrapper main program to create sys.argv\n  -p, --plist=FILE       .plist file (default: generate one)\n      --nib=NAME         main nib name\n  -c, --creator=CCCC     4-char creator code (default: \'????\')\n      --iconfile=FILE    filename of the icon (an .icns file) to be used\n                         as the Finder icon\n      --bundle-id=ID     the CFBundleIdentifier, in reverse-dns format\n                         (eg. org.python.BuildApplet; this is used for\n                         the preferences file name)\n  -l, --link             symlink files/folder instead of copying them\n      --link-exec        symlink the executable instead of copying it\n      --standalone       build a standalone application, which is fully\n                         independent of a Python installation\n      --semi-standalone  build a standalone application, which depends on\n                         an installed Python, yet includes all third-party\n                         modules.\n      --python=FILE      Python to use in #! line in stead of current Python\n      --lib=FILE         shared library or framework to be copied into\n                         the bundle\n  -x, --exclude=MODULE   exclude module (with --(semi-)standalone)\n  -i, --include=MODULE   include module (with --(semi-)standalone)\n      --package=PACKAGE  include a whole package (with --(semi-)standalone)\n      --strip            strip binaries (remove debug info)\n  -v, --verbose          increase verbosity level\n  -q, --quiet            decrease verbosity level\n  -h, --help             print this message\n'

EXT_LOADER = 'def __load():\n    import imp, sys, os\n    for p in sys.path:\n        path = os.path.join(p, "%(filename)s")\n        if os.path.exists(path):\n            break\n    else:\n        assert 0, "file not found: %(filename)s"\n    mod = imp.load_dynamic("%(name)s", path)\n\n__load()\ndel __load\n'

LIB = '/System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6'

MAGIC = '\xd1\xf2\r\n'

PYC_EXT = '.pyc'

SITE_PACKAGES = '/Library/Python/2.6/site-packages'
SITE_PY = "import sys\nif not %(semi_standalone)s:\n    del sys.path[1:]  # sys.path[0] is Contents/Resources/\nsys.path.append(sys.path[0] + '/Modules.zip')\n"

STRIP_EXEC = '/usr/bin/strip'

USE_ZIPIMPORT = True

ZIP_ARCHIVE = 'Modules.zip'

_mode = 'rb'

_suf = '.pyc'

_tp = 2

# functions

def buildapp(**kwargs): # reliably restored by inspect
    # no doc
    pass


def copy(src, dst, mkdirs=0): # reliably restored by inspect
    """ Copy a file or a directory. """
    pass


def copytodir(src, dstdir): # reliably restored by inspect
    """ Copy a file or a directory to an existing directory. """
    pass


def deepcopy(x, memo=None, _nil='[]'): # reliably restored by inspect
    """
    Deep copy operation on arbitrary Python objects.
    
        See the module's __doc__ string for more info.
    """
    pass


def findPackageContents(name, searchpath=None): # reliably restored by inspect
    # no doc
    pass


def getPycData(fullname, code, ispkg): # reliably restored by inspect
    # no doc
    pass


def isFramework(): # reliably restored by inspect
    # no doc
    pass


def main(builder=None): # reliably restored by inspect
    # no doc
    pass


def makedirs(dir): # reliably restored by inspect
    """
    Make all directories leading up to 'dir' including the leaf
        directory. Don't moan if any path element already exists.
    """
    pass


def pathjoin(*args): # reliably restored by inspect
    """
    Safe wrapper for os.path.join: asserts that all but the first
        argument are relative paths.
    """
    pass


def symlink(src, dst, mkdirs=0): # reliably restored by inspect
    """ Copy a file or a directory. """
    pass


def usage(msg=None): # reliably restored by inspect
    # no doc
    pass


def warnpy3k(message, category=None, stacklevel=1): # reliably restored by inspect
    """
    Issue a deprecation warning for Python 3.x related changes.
    
        Warnings are omitted unless Python is started with the -3 option.
    """
    pass


def writePyc(code, path): # reliably restored by inspect
    # no doc
    pass


# classes

class BundleBuilderError(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class function(object):
    """
    function(code, globals[, name[, argdefs[, closure]]])
    
    Create a function object from a code object and a dictionary.
    The optional name string overrides the name from the code object.
    The optional argdefs tuple specifies the default argument values.
    The optional closure tuple supplies the bindings for free variables.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __init__(self, code, globals, name=None, argdefs=None, closure=None): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    func_closure = property(lambda self: object()) # default
    func_code = property(lambda self: object()) # default
    func_defaults = property(lambda self: object()) # default
    func_dict = property(lambda self: object()) # default
    func_doc = property(lambda self: object()) # default
    func_globals = property(lambda self: object()) # default
    func_name = property(lambda self: object()) # default
    __closure__ = property(lambda self: object()) # default
    __code__ = property(lambda self: object()) # default
    __defaults__ = property(lambda self: object()) # default
    __globals__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''
    __name__ = 'function'


class Plist(__plistlib._InternalDict):
    """
    This class has been deprecated. Use readPlist() and writePlist()
        functions instead, together with regular dict objects.
    """
    @classmethod
    def fromFile(cls, *args, **kwargs): # real signature unknown
        """ Deprecated. Use the readPlist() function instead. """
        pass

    def write(self, *args, **kwargs): # real signature unknown
        """ Deprecated. Use the writePlist() function instead. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

AppBuilder = None # (!) real value is ''

BundleBuilder = None # (!) real value is ''

Defaults = None # (!) real value is ''

identifierRE = None # (!) real value is ''

MAYMISS_MODULES = [
    'mac',
    'os2',
    'nt',
    'ntpath',
    'dos',
    'dospath',
    'win32api',
    'ce',
    '_winreg',
    'nturl2path',
    'sitecustomize',
    'org.python.core',
    'riscos',
    'riscosenviron',
    'riscospath',
]

PYTHONFRAMEWORKGOODIES = [
    'Python',
    'Resources/English.lproj',
    'Resources/Info.plist',
    'Resources/version.plist',
]

SUFFIXES = [
    '.so',
    'module.so',
    '.py',
    '.pyc',
]

__all__ = [
    'BundleBuilder',
    'BundleBuilderError',
    'AppBuilder',
    'buildapp',
]

