# encoding: utf-8
# module calendar
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/calendar.pyo by generator 1.99
"""
Calendar printing functions

Note when comparing these calendars to the ones printed by cal(1): By
default, these calendars have Monday as the first day of the week, and
Sunday as the last (the European convention). Use setfirstweekday() to
set the first day of the week (0=Monday, 6=Sunday).
"""

# imports
import datetime as datetime # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/datetime.so
import sys as sys # <module 'sys' (built-in)>
import locale as _locale # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/locale.pyc
from exceptions import error


# Variables with simple values

EPOCH = 1970

February = 2

FRIDAY = 4

January = 1

MONDAY = 0

SATURDAY = 5

SUNDAY = 6

THURSDAY = 3

TUESDAY = 1

WEDNESDAY = 2

_colwidth = 20

_EPOCH_ORD = 719163

_spacing = 6

# functions

def calendar(*args, **kwargs): # real signature unknown
    """ Returns a year's calendar as a multi-line string. """
    pass


def firstweekday(*args, **kwargs): # real signature unknown
    pass


def format(cols, colwidth=20, spacing=6): # reliably restored by inspect
    """ Prints multi-column formatting for year calendars """
    pass


def formatstring(cols, colwidth=20, spacing=6): # reliably restored by inspect
    """ Returns a string formatted from n strings, centered within n columns. """
    pass


def isleap(year): # reliably restored by inspect
    """ Return 1 for leap years, 0 for non-leap years. """
    pass


def leapdays(y1, y2): # reliably restored by inspect
    """
    Return number of leap years in range [y1, y2).
           Assume y1 <= y2.
    """
    pass


def main(args): # reliably restored by inspect
    # no doc
    pass


def month(*args, **kwargs): # real signature unknown
    """ Return a month's calendar string (multi-line). """
    pass


def monthcalendar(*args, **kwargs): # real signature unknown
    """
    Return a matrix representing a month's calendar.
            Each row represents a week; days outside this month are zero.
    """
    pass


def monthrange(year, month): # reliably restored by inspect
    """
    Return weekday (0-6 ~ Mon-Sun) and number of days (28-31) for
           year, month.
    """
    pass


def prcal(*args, **kwargs): # real signature unknown
    """ Print a year's calendar. """
    pass


def prmonth(*args, **kwargs): # real signature unknown
    """ Print a month's calendar. """
    pass


def prweek(*args, **kwargs): # real signature unknown
    """ Print a single week (no newline). """
    pass


def setfirstweekday(firstweekday): # reliably restored by inspect
    # no doc
    pass


def timegm(tuple): # reliably restored by inspect
    """ Unrelated but handy function to calculate Unix timestamp from GMT. """
    pass


def week(*args, **kwargs): # real signature unknown
    """ Returns a single week in a string (no newline). """
    pass


def weekday(year, month, day): # reliably restored by inspect
    """
    Return weekday (0-6 ~ Mon-Sun) for year (1970-...), month (1-12),
           day (1-31).
    """
    pass


def weekheader(*args, **kwargs): # real signature unknown
    """ Return a header for a week. """
    pass


# classes

class Calendar(object):
    """
    Base calendar class. This class doesn't do any formatting. It simply
        provides data to subclasses.
    """
    def getfirstweekday(self, *args, **kwargs): # real signature unknown
        pass

    def itermonthdates(self, *args, **kwargs): # real signature unknown
        """
        Return an iterator for one month. The iterator will yield datetime.date
                values and will always iterate through complete weeks, so it will yield
                dates outside the specified month.
        """
        pass

    def itermonthdays(self, *args, **kwargs): # real signature unknown
        """
        Like itermonthdates(), but will yield day numbers. For days outside
                the specified month the day number is 0.
        """
        pass

    def itermonthdays2(self, *args, **kwargs): # real signature unknown
        """
        Like itermonthdates(), but will yield (day number, weekday number)
                tuples. For days outside the specified month the day number is 0.
        """
        pass

    def iterweekdays(self, *args, **kwargs): # real signature unknown
        """
        Return a iterator for one week of weekday numbers starting with the
                configured first one.
        """
        pass

    def monthdatescalendar(self, *args, **kwargs): # real signature unknown
        """
        Return a matrix (list of lists) representing a month's calendar.
                Each row represents a week; week entries are datetime.date values.
        """
        pass

    def monthdays2calendar(self, *args, **kwargs): # real signature unknown
        """
        Return a matrix representing a month's calendar.
                Each row represents a week; week entries are
                (day number, weekday number) tuples. Day numbers outside this month
                are zero.
        """
        pass

    def monthdayscalendar(self, *args, **kwargs): # real signature unknown
        """
        Return a matrix representing a month's calendar.
                Each row represents a week; days outside this month are zero.
        """
        pass

    def setfirstweekday(self, *args, **kwargs): # real signature unknown
        pass

    def yeardatescalendar(self, *args, **kwargs): # real signature unknown
        """
        Return the data for the specified year ready for formatting. The return
                value is a list of month rows. Each month row contains upto width months.
                Each month contains between 4 and 6 weeks and each week contains 1-7
                days. Days are datetime.date objects.
        """
        pass

    def yeardays2calendar(self, *args, **kwargs): # real signature unknown
        """
        Return the data for the specified year ready for formatting (similar to
                yeardatescalendar()). Entries in the week lists are
                (day number, weekday number) tuples. Day numbers outside this month are
                zero.
        """
        pass

    def yeardayscalendar(self, *args, **kwargs): # real signature unknown
        """
        Return the data for the specified year ready for formatting (similar to
                yeardatescalendar()). Entries in the week lists are day numbers.
                Day numbers outside this month are zero.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    firstweekday = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class HTMLCalendar(Calendar):
    """ This calendar returns complete HTML pages. """
    def formatday(self, *args, **kwargs): # real signature unknown
        """ Return a day as a table cell. """
        pass

    def formatmonth(self, *args, **kwargs): # real signature unknown
        """ Return a formatted month as a table. """
        pass

    def formatmonthname(self, *args, **kwargs): # real signature unknown
        """ Return a month name as a table row. """
        pass

    def formatweek(self, *args, **kwargs): # real signature unknown
        """ Return a complete week as a table row. """
        pass

    def formatweekday(self, *args, **kwargs): # real signature unknown
        """ Return a weekday name as a table header. """
        pass

    def formatweekheader(self, *args, **kwargs): # real signature unknown
        """ Return a header for a week as a table row. """
        pass

    def formatyear(self, *args, **kwargs): # real signature unknown
        """ Return a formatted year as a table of tables. """
        pass

    def formatyearpage(self, *args, **kwargs): # real signature unknown
        """ Return a formatted year as a complete HTML page. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    cssclasses = [
        'mon',
        'tue',
        'wed',
        'thu',
        'fri',
        'sat',
        'sun',
    ]


class IllegalMonthError(ValueError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class IllegalWeekdayError(ValueError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class LocaleHTMLCalendar(HTMLCalendar):
    """
    This class can be passed a locale name in the constructor and will return
        month and weekday names in the specified locale. If this locale includes
        an encoding all strings containing month and weekday names will be returned
        as unicode.
    """
    def formatmonthname(self, *args, **kwargs): # real signature unknown
        pass

    def formatweekday(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class TextCalendar(Calendar):
    """
    Subclass of Calendar that outputs a calendar as a simple plain text
        similar to the UNIX program cal.
    """
    def formatday(self, *args, **kwargs): # real signature unknown
        """ Returns a formatted day. """
        pass

    def formatmonth(self, *args, **kwargs): # real signature unknown
        """ Return a month's calendar string (multi-line). """
        pass

    def formatmonthname(self, *args, **kwargs): # real signature unknown
        """ Return a formatted month name. """
        pass

    def formatweek(self, *args, **kwargs): # real signature unknown
        """ Returns a single week in a string (no newline). """
        pass

    def formatweekday(self, *args, **kwargs): # real signature unknown
        """ Returns a formatted week day name. """
        pass

    def formatweekheader(self, *args, **kwargs): # real signature unknown
        """ Return a header for a week. """
        pass

    def formatyear(self, *args, **kwargs): # real signature unknown
        """ Returns a year's calendar as a multi-line string. """
        pass

    def prmonth(self, *args, **kwargs): # real signature unknown
        """ Print a month's calendar. """
        pass

    def prweek(self, *args, **kwargs): # real signature unknown
        """ Print a single week (no newline). """
        pass

    def pryear(self, *args, **kwargs): # real signature unknown
        """ Print a year's calendar. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class LocaleTextCalendar(TextCalendar):
    """
    This class can be passed a locale name in the constructor and will return
        month and weekday names in the specified locale. If this locale includes
        an encoding all strings containing month and weekday names will be returned
        as unicode.
    """
    def formatmonthname(self, *args, **kwargs): # real signature unknown
        pass

    def formatweekday(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

c = None # (!) real value is ''

day_abbr = None # (!) real value is ''

day_name = None # (!) real value is ''

mdays = [
    0,
    31,
    28,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31,
]

month_abbr = None # (!) real value is ''

month_name = None # (!) real value is ''

TimeEncoding = None # (!) real value is ''

_localized_day = None # (!) real value is ''

_localized_month = None # (!) real value is ''

__all__ = [
    'IllegalMonthError',
    'IllegalWeekdayError',
    'setfirstweekday',
    'firstweekday',
    'isleap',
    'leapdays',
    'weekday',
    'monthrange',
    'monthcalendar',
    'prmonth',
    'month',
    'prcal',
    'calendar',
    'timegm',
    'month_name',
    'month_abbr',
    'day_name',
    'day_abbr',
]

