# encoding: utf-8
# module copy
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/copy.pyo by generator 1.99
"""
Generic (shallow and deep) copying operations.

Interface summary:

        import copy

        x = copy.copy(y)        # make a shallow copy of y
        x = copy.deepcopy(y)    # make a deep copy of y

For module specific errors, copy.Error is raised.

The difference between shallow and deep copying is only relevant for
compound objects (objects that contain other objects, like lists or
class instances).

- A shallow copy constructs a new compound object and then (to the
  extent possible) inserts *the same objects* into it that the
  original contains.

- A deep copy constructs a new compound object and then, recursively,
  inserts *copies* into it of the objects found in the original.

Two problems often exist with deep copy operations that don't exist
with shallow copy operations:

 a) recursive objects (compound objects that, directly or indirectly,
    contain a reference to themselves) may cause a recursive loop

 b) because deep copy copies *everything* it may copy too much, e.g.
    administrative data structures that should be shared even between
    copies

Python's deep copy operation avoids these problems by:

 a) keeping a table of objects already copied during the current
    copying pass

 b) letting user-defined classes override the copying operation or the
    set of components copied

This version does not copy types like module, class, function, method,
nor stack trace, stack frame, nor file, socket, window, nor array, nor
any similar types.

Classes can use the same interfaces to control copying that they use
to control pickling: they can define methods called __getinitargs__(),
__getstate__() and __setstate__().  See the documentation for module
"pickle" for information on these methods.
"""
# no imports

# Variables with simple values

name = 'CodeType'

PyStringMap = None

# functions

def copy(x): # reliably restored by inspect
    """
    Shallow copy operation on arbitrary Python objects.
    
        See the module's __doc__ string for more info.
    """
    pass


def deepcopy(x, memo=None, _nil='[]'): # reliably restored by inspect
    """
    Deep copy operation on arbitrary Python objects.
    
        See the module's __doc__ string for more info.
    """
    pass


def _copy_immutable(x): # reliably restored by inspect
    # no doc
    pass


def _copy_inst(x): # reliably restored by inspect
    # no doc
    pass


def _copy_with_constructor(x): # reliably restored by inspect
    # no doc
    pass


def _copy_with_copy_method(x): # reliably restored by inspect
    # no doc
    pass


def _deepcopy_atomic(x, memo): # reliably restored by inspect
    # no doc
    pass


def _deepcopy_dict(x, memo): # reliably restored by inspect
    # no doc
    pass


def _deepcopy_inst(x, memo): # reliably restored by inspect
    # no doc
    pass


def _deepcopy_list(x, memo): # reliably restored by inspect
    # no doc
    pass


def _deepcopy_tuple(x, memo): # reliably restored by inspect
    # no doc
    pass


def _keep_alive(x, memo): # reliably restored by inspect
    """
    Keeps a reference to the object x in the memo.
    
        Because we remember objects by their id, we have
        to assure that possibly temporary objects are kept
        alive by referencing them.
        We store a reference at the id of the memo, which should
        normally not be used unless someone tries to deepcopy
        the memo itself...
    """
    pass


def _reconstruct(x, info, deep, memo=None): # reliably restored by inspect
    # no doc
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# classes

class Error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


error = Error


class t(object):
    """
    set(iterable) --> set object
    
    Build an unordered collection of unique elements.
    """
    def add(self, *args, **kwargs): # real signature unknown
        """
        Add an element to a set.
        
        This has no effect if the element is already present.
        """
        pass

    def clear(self, *args, **kwargs): # real signature unknown
        """ Remove all elements from this set. """
        pass

    def copy(self, *args, **kwargs): # real signature unknown
        """ Return a shallow copy of a set. """
        pass

    def difference(self, *args, **kwargs): # real signature unknown
        """
        Return the difference of two or more sets as a new set.
        
        (i.e. all elements that are in this set but not the others.)
        """
        pass

    def difference_update(self, *args, **kwargs): # real signature unknown
        """ Remove all elements of another set from this set. """
        pass

    def discard(self, *args, **kwargs): # real signature unknown
        """
        Remove an element from a set if it is a member.
        
        If the element is not a member, do nothing.
        """
        pass

    def intersection(self, *args, **kwargs): # real signature unknown
        """
        Return the intersection of two sets as a new set.
        
        (i.e. all elements that are in both sets.)
        """
        pass

    def intersection_update(self, *args, **kwargs): # real signature unknown
        """ Update a set with the intersection of itself and another. """
        pass

    def isdisjoint(self, *args, **kwargs): # real signature unknown
        """ Return True if two sets have a null intersection. """
        pass

    def issubset(self, *args, **kwargs): # real signature unknown
        """ Report whether another set contains this set. """
        pass

    def issuperset(self, *args, **kwargs): # real signature unknown
        """ Report whether this set contains another set. """
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        """
        Remove and return an arbitrary set element.
        Raises KeyError if the set is empty.
        """
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        """
        Remove an element from a set; it must be a member.
        
        If the element is not a member, raise a KeyError.
        """
        pass

    def symmetric_difference(self, *args, **kwargs): # real signature unknown
        """
        Return the symmetric difference of two sets as a new set.
        
        (i.e. all elements that are in exactly one of the sets.)
        """
        pass

    def symmetric_difference_update(self, *args, **kwargs): # real signature unknown
        """ Update a set with the symmetric difference of itself and another. """
        pass

    def union(self, *args, **kwargs): # real signature unknown
        """
        Return the union of sets as a new set.
        
        (i.e. all elements that are in either set.)
        """
        pass

    def update(self, *args, **kwargs): # real signature unknown
        """ Update a set with the union of itself and others. """
        pass

    def __and__(self, y): # real signature unknown; restored from __doc__
        """ x.__and__(y) <==> x&y """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x. """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __iand__(self, y): # real signature unknown; restored from __doc__
        """ x.__iand__(y) <==> x&y """
        pass

    def __init__(self, iterable): # real signature unknown; restored from __doc__
        pass

    def __ior__(self, y): # real signature unknown; restored from __doc__
        """ x.__ior__(y) <==> x|y """
        pass

    def __isub__(self, y): # real signature unknown; restored from __doc__
        """ x.__isub__(y) <==> x-y """
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __ixor__(self, y): # real signature unknown; restored from __doc__
        """ x.__ixor__(y) <==> x^y """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __or__(self, y): # real signature unknown; restored from __doc__
        """ x.__or__(y) <==> x|y """
        pass

    def __rand__(self, y): # real signature unknown; restored from __doc__
        """ x.__rand__(y) <==> y&x """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling. """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __ror__(self, y): # real signature unknown; restored from __doc__
        """ x.__ror__(y) <==> y|x """
        pass

    def __rsub__(self, y): # real signature unknown; restored from __doc__
        """ x.__rsub__(y) <==> y-x """
        pass

    def __rxor__(self, y): # real signature unknown; restored from __doc__
        """ x.__rxor__(y) <==> y^x """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ S.__sizeof__() -> size of S in memory, in bytes """
        pass

    def __sub__(self, y): # real signature unknown; restored from __doc__
        """ x.__sub__(y) <==> x-y """
        pass

    def __xor__(self, y): # real signature unknown; restored from __doc__
        """ x.__xor__(y) <==> x^y """
        pass

    __hash__ = None


# variables with complex values

dispatch_table = {
    complex: 
        None # (!) real value is ''
    ,
    None:  # (!) real value is ''
        None # (!) real value is ''
    ,
    None:  # (!) real value is ''
        None # (!) real value is ''
    ,
    None:  # (!) real value is ''
        None # (!) real value is ''
    ,
}

_copy_dispatch = {
    bool: 
        _copy_immutable
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        _copy_inst
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    complex: 
        '<value is a self-reference, replaced by this string>'
    ,
    float: 
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    int: 
        '<value is a self-reference, replaced by this string>'
    ,
    list: 
        _copy_with_constructor
    ,
    long: 
        '<value is a self-reference, replaced by this string>'
    ,
    dict: 
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    xrange: 
        '<value is a self-reference, replaced by this string>'
    ,
    set: 
        '<value is a self-reference, replaced by this string>'
    ,
    frozenset: 
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    bytes: 
        '<value is a self-reference, replaced by this string>'
    ,
    tuple: 
        '<value is a self-reference, replaced by this string>'
    ,
    type: 
        '<value is a self-reference, replaced by this string>'
    ,
    unicode: 
        '<value is a self-reference, replaced by this string>'
    ,
}

_deepcopy_dispatch = {
    bool: 
        _deepcopy_atomic
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        _deepcopy_inst
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    complex: 
        '<value is a self-reference, replaced by this string>'
    ,
    float: 
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    int: 
        '<value is a self-reference, replaced by this string>'
    ,
    list: 
        _deepcopy_list
    ,
    long: 
        '<value is a self-reference, replaced by this string>'
    ,
    dict: 
        _deepcopy_dict
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    xrange: 
        '<value is a self-reference, replaced by this string>'
    ,
    None:  # (!) real value is ''
        '<value is a self-reference, replaced by this string>'
    ,
    bytes: 
        '<value is a self-reference, replaced by this string>'
    ,
    tuple: 
        _deepcopy_tuple
    ,
    type: 
        '<value is a self-reference, replaced by this string>'
    ,
    unicode: 
        '<value is a self-reference, replaced by this string>'
    ,
}

_EmptyClass = None # (!) real value is ''

__all__ = [
    'Error',
    'copy',
    'deepcopy',
]

