# encoding: utf-8
# module distutils.bcppcompiler
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/distutils/bcppcompiler.pyo by generator 1.99
"""
distutils.bcppcompiler

Contains BorlandCCompiler, an implementation of the abstract CCompiler class
for the Borland C++ compiler.
"""

# imports
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/distutils/log.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: bcppcompiler.py 61000 2008-02-23 17:40:11Z christian.heimes $'

# functions

def gen_lib_options(compiler, library_dirs, runtime_library_dirs, libraries): # reliably restored by inspect
    """
    Generate linker options for searching library directories and
        linking with specific libraries.  'libraries' and 'library_dirs' are,
        respectively, lists of library names (not filenames!) and search
        directories.  Returns a list of command-line options suitable for use
        with some compiler (depending on the two format strings passed in).
    """
    pass


def gen_preprocess_options(macros, include_dirs): # reliably restored by inspect
    """
    Generate C pre-processor options (-D, -U, -I) as used by at least
        two types of compilers: the typical Unix compiler and Visual C++.
        'macros' is the usual thing, a list of 1- or 2-tuples, where (name,)
        means undefine (-U) macro 'name', and (name,value) means define (-D)
        macro 'name' to 'value'.  'include_dirs' is just a list of directory
        names to be added to the header file search path (-I).  Returns a list
        of command-line options suitable for either Unix compilers or Visual
        C++.
    """
    pass


def newer(source, target): # reliably restored by inspect
    """
    Return true if 'source' exists and is more recently modified than
        'target', or if 'source' exists and 'target' doesn't.  Return false if
        both exist and 'target' is the same age or younger than 'source'.
        Raise DistutilsFileError if 'source' does not exist.
    """
    pass


def write_file(filename, contents): # reliably restored by inspect
    """
    Create a file with the specified name and write 'contents' (a
        sequence of strings without line terminators) to it.
    """
    pass


# classes

class CompileError(__distutils_errors.CCompilerError):
    """ Failure to compile one or more C/C++ source files. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsExecError(__distutils_errors.DistutilsError):
    """
    Any problems executing an external program (such as the C
        compiler, when compiling C files).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsPlatformError(__distutils_errors.DistutilsError):
    """
    We don't know how to do something on the current platform (but
        we do know how to do it on some platform) -- eg. trying to compile
        C files on a platform not supported by a CCompiler subclass.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class LibError(__distutils_errors.CCompilerError):
    """
    Failure to create a static library from one or more C/C++ object
        files.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class LinkError(__distutils_errors.CCompilerError):
    """
    Failure to link one or more C/C++ object files into an executable
        or shared library file.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnknownFileError(__distutils_errors.CCompilerError):
    """ Attempt to process an unknown file type. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

BCPPCompiler = None # (!) real value is ''

CCompiler = None # (!) real value is ''

