# encoding: utf-8
# module distutils.spawn
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/distutils/spawn.pyo by generator 1.99
"""
distutils.spawn

Provides the 'spawn()' function, a front-end to various platform-
specific functions for launching another program in a sub-process.
Also provides the 'find_executable()' to search the path for a given
executable name.
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/distutils/log.pyc
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/string.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: spawn.py 37828 2004-11-10 22:23:15Z loewis $'

# functions

def find_executable(executable, path=None): # reliably restored by inspect
    """
    Try to find 'executable' in the directories listed in 'path' (a
        string listing directories separated by 'os.pathsep'; defaults to
        os.environ['PATH']).  Returns the complete filename or None if not
        found.
    """
    pass


def spawn(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Run another program, specified as a command list 'cmd', in a new
        process.  'cmd' is just the argument list for the new process, ie.
        cmd[0] is the program to run and cmd[1:] are the rest of its arguments.
        There is no way to run a program with a name different from that of its
        executable.
    
        If 'search_path' is true (the default), the system's executable
        search path will be used to find the program; otherwise, cmd[0]
        must be the exact path to the executable.  If 'dry_run' is true,
        the command will not actually be run.
    
        Raise DistutilsExecError if running the program fails in any way; just
        return on success.
    """
    pass


def _nt_quote_args(args): # reliably restored by inspect
    """
    Quote command-line arguments for DOS/Windows conventions: just
        wraps every argument which contains blanks in double quotes, and
        returns a new argument list.
    """
    pass


def _spawn_nt(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    # no doc
    pass


def _spawn_os2(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    # no doc
    pass


def _spawn_posix(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    # no doc
    pass


# classes

class CCompilerError(Exception):
    """ Some compile/link operation failed. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class CompileError(__distutils_errors.CCompilerError):
    """ Failure to compile one or more C/C++ source files. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsError(Exception):
    """ The root of all Distutils evil. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class DistutilsArgError(__distutils_errors.DistutilsError):
    """
    Raised by fancy_getopt in response to getopt.error -- ie. an
        error in the command line usage.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsClassError(__distutils_errors.DistutilsError):
    """
    Some command class (or possibly distribution class, if anyone
        feels a need to subclass Distribution) is found not to be holding
        up its end of the bargain, ie. implementing some part of the
        "command "interface.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsExecError(__distutils_errors.DistutilsError):
    """
    Any problems executing an external program (such as the C
        compiler, when compiling C files).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsFileError(__distutils_errors.DistutilsError):
    """
    Any problems in the filesystem: expected file not found, etc.
        Typically this is for problems that we detect before IOError or
        OSError could be raised.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsGetoptError(__distutils_errors.DistutilsError):
    """ The option table provided to 'fancy_getopt()' is bogus. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsInternalError(__distutils_errors.DistutilsError):
    """
    Internal inconsistencies or impossibilities (obviously, this
        should never be seen if the code is working!).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsModuleError(__distutils_errors.DistutilsError):
    """
    Unable to load an expected module, or to find an expected class
        within some module (in particular, command modules and classes).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsOptionError(__distutils_errors.DistutilsError):
    """
    Syntactic/semantic errors in command options, such as use of
        mutually conflicting options, or inconsistent options,
        badly-spelled values, etc.  No distinction is made between option
        values originating in the setup script, the command line, config
        files, or what-have-you -- but if we *know* something originated in
        the setup script, we'll raise DistutilsSetupError instead.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsPlatformError(__distutils_errors.DistutilsError):
    """
    We don't know how to do something on the current platform (but
        we do know how to do it on some platform) -- eg. trying to compile
        C files on a platform not supported by a CCompiler subclass.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsSetupError(__distutils_errors.DistutilsError):
    """
    For errors that can be definitely blamed on the setup script,
        such as invalid keyword arguments to 'setup()'.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsTemplateError(__distutils_errors.DistutilsError):
    """ Syntax error in a file list template. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class LibError(__distutils_errors.CCompilerError):
    """
    Failure to create a static library from one or more C/C++ object
        files.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class LinkError(__distutils_errors.CCompilerError):
    """
    Failure to link one or more C/C++ object files into an executable
        or shared library file.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class PreprocessError(__distutils_errors.CCompilerError):
    """ Failure to preprocess one or more C/C++ files. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnknownFileError(__distutils_errors.CCompilerError):
    """ Attempt to process an unknown file type. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


