# encoding: utf-8
# module email.charset
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/email/charset.pyo by generator 1.99
# no doc

# imports
import email.errors as errors # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/email/errors.pyc
import email as email # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/email/__init__.pyc

# Variables with simple values

BASE64 = 2

DEFAULT_CHARSET = 'us-ascii'

MISC_LEN = 7

QP = 1

SHORTEST = 3

# functions

def add_alias(alias, canonical): # reliably restored by inspect
    """
    Add a character set alias.
    
        alias is the alias name, e.g. latin-1
        canonical is the character set's canonical name, e.g. iso-8859-1
    """
    pass


def add_charset(charset, header_enc=None, body_enc=None, output_charset=None): # reliably restored by inspect
    """
    Add character set properties to the global registry.
    
        charset is the input character set, and must be the canonical name of a
        character set.
    
        Optional header_enc and body_enc is either Charset.QP for
        quoted-printable, Charset.BASE64 for base64 encoding, Charset.SHORTEST for
        the shortest of qp or base64 encoding, or None for no encoding.  SHORTEST
        is only valid for header_enc.  It describes how message headers and
        message bodies in the input charset are to be encoded.  Default is no
        encoding.
    
        Optional output_charset is the character set that the output should be
        in.  Conversions will proceed from input charset, to Unicode, to the
        output charset when the method Charset.convert() is called.  The default
        is to output in the same character set as the input.
    
        Both input_charset and output_charset must have Unicode codec entries in
        the module's charset-to-codec mapping; use add_codec(charset, codecname)
        to add codecs the module does not know about.  See the codecs module's
        documentation for more information.
    """
    pass


def add_codec(charset, codecname): # reliably restored by inspect
    """
    Add a codec that map characters in the given charset to/from Unicode.
    
        charset is the canonical name of a character set.  codecname is the name
        of a Python codec, as appropriate for the second argument to the unicode()
        built-in, or to the encode() method of a Unicode string.
    """
    pass


def encode_7or8bit(msg): # reliably restored by inspect
    """ Set the Content-Transfer-Encoding header to 7bit or 8bit. """
    pass


# no classes
# variables with complex values

ALIASES = {
    'ascii': 'us-ascii',
    'cp949': 'ks_c_5601-1987',
    'euc_jp': 'euc-jp',
    'euc_kr': 'euc-kr',
    'latin-1': 'iso-8859-1',
    'latin-10': 'iso-8859-16',
    'latin-2': 'iso-8859-2',
    'latin-3': 'iso-8859-3',
    'latin-4': 'iso-8859-4',
    'latin-5': 'iso-8859-9',
    'latin-6': 'iso-8859-10',
    'latin-7': 'iso-8859-13',
    'latin-8': 'iso-8859-14',
    'latin-9': 'iso-8859-15',
    'latin_1': 'iso-8859-1',
    'latin_10': 'iso-8859-16',
    'latin_2': 'iso-8859-2',
    'latin_3': 'iso-8859-3',
    'latin_4': 'iso-8859-4',
    'latin_5': 'iso-8859-9',
    'latin_6': 'iso-8859-10',
    'latin_7': 'iso-8859-13',
    'latin_8': 'iso-8859-14',
    'latin_9': 'iso-8859-15',
}

Charset = None # (!) real value is ''

CHARSETS = {
    '8bit': (
        None,
        2,
        'utf-8',
    ),
    'big5': (
        2,
        2,
        None,
    ),
    'euc-jp': (
        2,
        None,
        'iso-2022-jp',
    ),
    'gb2312': '<value is a self-reference, replaced by this string>',
    'iso-2022-jp': (
        2,
        None,
        None,
    ),
    'iso-8859-1': (
        1,
        1,
        None,
    ),
    'iso-8859-10': '<value is a self-reference, replaced by this string>',
    'iso-8859-13': '<value is a self-reference, replaced by this string>',
    'iso-8859-14': '<value is a self-reference, replaced by this string>',
    'iso-8859-15': '<value is a self-reference, replaced by this string>',
    'iso-8859-16': '<value is a self-reference, replaced by this string>',
    'iso-8859-2': '<value is a self-reference, replaced by this string>',
    'iso-8859-3': '<value is a self-reference, replaced by this string>',
    'iso-8859-4': '<value is a self-reference, replaced by this string>',
    'iso-8859-9': '<value is a self-reference, replaced by this string>',
    'koi8-r': '<value is a self-reference, replaced by this string>',
    'shift_jis': '<value is a self-reference, replaced by this string>',
    'us-ascii': (
        None,
        None,
        None,
    ),
    'utf-8': (
        3,
        2,
        'utf-8',
    ),
    'viscii': '<value is a self-reference, replaced by this string>',
    'windows-1252': '<value is a self-reference, replaced by this string>',
}

CODEC_MAP = {
    'big5': 'big5_tw',
    'gb2312': 'eucgb2312_cn',
    'us-ascii': None,
}

__all__ = [
    'Charset',
    'add_alias',
    'add_charset',
    'add_codec',
]

