# encoding: utf-8
# module ihooks
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/ihooks.pyo by generator 1.99
"""
Import hook support.

Consistent use of this module will make it possible to change the
different mechanisms involved in loading modules independently.

While the built-in module imp exports interfaces to the built-in
module searching and loading algorithm, and it is possible to replace
the built-in function __import__ in order to change the semantics of
the import statement, until now it has been difficult to combine the
effect of different __import__ hacks, like loading modules from URLs
by rimport.py, or restricted execution by rexec.py.

This module defines three new concepts:

1) A "file system hooks" class provides an interface to a filesystem.

One hooks class is defined (Hooks), which uses the interface provided
by standard modules os and os.path.  It should be used as the base
class for other hooks classes.

2) A "module loader" class provides an interface to search for a
module in a search path and to load it.  It defines a method which
searches for a module in a single directory; by overriding this method
one can redefine the details of the search.  If the directory is None,
built-in and frozen modules are searched instead.

Two module loader class are defined, both implementing the search
strategy used by the built-in __import__ function: ModuleLoader uses
the imp module's find_module interface, while HookableModuleLoader
uses a file system hooks class to interact with the file system.  Both
use the imp module's load_* interfaces to actually load the module.

3) A "module importer" class provides an interface to import a
module, as well as interfaces to reload and unload a module.  It also
provides interfaces to install and uninstall itself instead of the
default __import__ and reload (and unload) functions.

One module importer class is defined (ModuleImporter), which uses a
module loader instance passed in (by default HookableModuleLoader is
instantiated).

The classes defined here should be used as base classes for extended
functionality along those lines.

If a module importer class supports dotted names, its import_module()
must return a different value depending on whether it is called on
behalf of a "from ... import ..." statement or not.  (This is caused
by the way the __import__ hook is used by the Python interpreter.)  It
would also do wise to install a different version of reload().
"""

# imports
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import imp as imp # <module 'imp' (built-in)>
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

BUILTIN_MODULE = 6

current_importer = None

C_BUILTIN = 6
C_EXTENSION = 3

default_importer = None

FROZEN_MODULE = 7

PKG_DIRECTORY = 5

PY_COMPILED = 2
PY_FROZEN = 7
PY_SOURCE = 1

VERBOSE = 0

# functions

def install(importer=None): # reliably restored by inspect
    # no doc
    pass


def uninstall(): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

BasicModuleImporter = None # (!) real value is ''

BasicModuleLoader = None # (!) real value is ''

FancyModuleLoader = None # (!) real value is ''

Hooks = None # (!) real value is ''

ModuleImporter = None # (!) real value is ''

ModuleLoader = None # (!) real value is ''

_Verbose = None # (!) real value is ''

__all__ = [
    'BasicModuleLoader',
    'Hooks',
    'ModuleLoader',
    'FancyModuleLoader',
    'BasicModuleImporter',
    'ModuleImporter',
    'install',
    'uninstall',
]

