# encoding: utf-8
# module json.decoder
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/json/decoder.pyo by generator 1.99
""" Implementation of JSONDecoder """

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import sys as sys # <module 'sys' (built-in)>
from _json import c_scanstring, scanstring


# Variables with simple values

DEFAULT_ENCODING = 'utf-8'

FLAGS = 88

NaN = nan

NegInf = -inf

PosInf = inf

# functions

def errmsg(msg, doc, pos, end=None): # reliably restored by inspect
    # no doc
    pass


def JSONArray(match, context, _w='<built-in method match of _sre.SRE_Pattern object at 0x100547ab0>'): # reliably restored by inspect
    # no doc
    pass


def JSONConstant(match, context, c="{'Infinity': inf, 'NaN': nan, '-Infinity': -inf, 'false': False, 'null': None, 'true': True}"): # reliably restored by inspect
    # no doc
    pass


def JSONNumber(match, context): # reliably restored by inspect
    # no doc
    pass


def JSONObject(match, context, _w='<built-in method match of _sre.SRE_Pattern object at 0x100547ab0>'): # reliably restored by inspect
    # no doc
    pass


def JSONString(match, context): # reliably restored by inspect
    # no doc
    pass


def linecol(doc, pos): # reliably restored by inspect
    # no doc
    pass


def pattern(pattern, flags=88): # reliably restored by inspect
    # no doc
    pass


def py_scanstring(s, end, encoding=None, strict=True, _b='{\'r\': u\'\\r\', \'"\': u\'"\', \'t\': u\'\\t\', \'f\': u\'\\x0c\', \'b\': u\'\\x08\', \'\\\\\': u\'\\\\\', \'/\': u\'/\', \'n\': u\'\\n\'}', _m='<built-in method match of _sre.SRE_Pattern object at 0x1004ff2d0>'): # reliably restored by inspect
    # no doc
    pass


# classes

class JSONDecoder(object):
    """
    Simple JSON <http://json.org> decoder
    
        Performs the following translations in decoding by default:
    
        +---------------+-------------------+
        | JSON          | Python            |
        +===============+===================+
        | object        | dict              |
        +---------------+-------------------+
        | array         | list              |
        +---------------+-------------------+
        | string        | unicode           |
        +---------------+-------------------+
        | number (int)  | int, long         |
        +---------------+-------------------+
        | number (real) | float             |
        +---------------+-------------------+
        | true          | True              |
        +---------------+-------------------+
        | false         | False             |
        +---------------+-------------------+
        | null          | None              |
        +---------------+-------------------+
    
        It also understands ``NaN``, ``Infinity``, and ``-Infinity`` as
        their corresponding ``float`` values, which is outside the JSON spec.
    """
    def decode(self, *args, **kwargs): # real signature unknown
        """
        Return the Python representation of ``s`` (a ``str`` or ``unicode``
                instance containing a JSON document)
        """
        pass

    def raw_decode(self, *args, **kwargs): # real signature unknown
        """
        Decode a JSON document from ``s`` (a ``str`` or ``unicode`` beginning
                with a JSON document) and return a 2-tuple of the Python
                representation and the index in ``s`` where the document ended.
        
                This can be used to decode a JSON document from a string that may
                have extraneous data at the end.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        ``encoding`` determines the encoding used to interpret any ``str``
                objects decoded by this instance (utf-8 by default).  It has no
                effect when decoding ``unicode`` objects.
        
                Note that currently only encodings that are a superset of ASCII work,
                strings of other encodings should be passed in as ``unicode``.
        
                ``object_hook``, if specified, will be called with the result of
                every JSON object decoded and its return value will be used in
                place of the given ``dict``.  This can be used to provide custom
                deserializations (e.g. to support JSON-RPC class hinting).
        
                ``parse_float``, if specified, will be called with the string
                of every JSON float to be decoded. By default this is equivalent to
                float(num_str). This can be used to use another datatype or parser
                for JSON floats (e.g. decimal.Decimal).
        
                ``parse_int``, if specified, will be called with the string
                of every JSON int to be decoded. By default this is equivalent to
                int(num_str). This can be used to use another datatype or parser
                for JSON integers (e.g. float).
        
                ``parse_constant``, if specified, will be called with one of the
                following strings: -Infinity, Infinity, NaN, null, true, false.
                This can be used to raise an exception if invalid JSON numbers
                are encountered.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    _scanner = None # (!) real value is ''
    __all__ = [
        '__init__',
        'decode',
        'raw_decode',
    ]
    __dict__ = None # (!) real value is ''


class Scanner(object):
    # no doc
    def iterscan(self, *args, **kwargs): # real signature unknown
        """ Yield match, end_idx for each match """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

ANYTHING = [
    JSONObject,
    JSONArray,
    JSONString,
    JSONConstant,
    JSONNumber,
]

BACKSLASH = {
    '"': u'"',
    '/': u'/',
    '\\': u'\\',
    'b': u'\x08',
    'f': u'\x0c',
    'n': u'\n',
    'r': u'\r',
    't': u'\t',
}

JSONScanner = None # (!) real value is ''

STRINGCHUNK = None # (!) real value is ''

WHITESPACE = None # (!) real value is ''

_CONSTANTS = {
    '-Infinity': -inf,
    'Infinity': inf,
    'NaN': nan,
    'false': False,
    'null': None,
    'true': True,
}

__all__ = [
    'JSONDecoder',
]

