# encoding: utf-8
# module lib2to3.fixes.fix_dict
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixes/fix_dict.pyo by generator 1.99
"""
Fixer for dict methods.

d.keys() -> list(d.keys())
d.items() -> list(d.items())
d.values() -> list(d.values())

d.iterkeys() -> iter(d.keys())
d.iteritems() -> iter(d.items())
d.itervalues() -> iter(d.values())

Except in certain very specific contexts: the iter() can be dropped
when the context is list(), sorted(), iter() or for...in; the list()
can be dropped when the context is list() or sorted() (but not iter()
or for...in!). Special contexts that apply to both: list(), sorted(), tuple()
set(), any(), all(), sum().

Note: iter(d.keys()) could be written as iter(d) but since the
original d.iterkeys() was also redundant we don't fix this.  And there
are (rare) contexts where it makes a difference (e.g. when passing it
as an argument to a function that introspects the argument).
"""

# imports
import lib2to3.patcomp as patcomp # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/patcomp.pyc
import lib2to3.pytree as pytree # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pytree.pyc
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/token.pyc
import lib2to3.fixer_util as fixer_util # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixer_util.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# functions

def ArgList(args, lparen="Leaf(7, '(')", rparen="Leaf(8, ')')"): # reliably restored by inspect
    """ A parenthesised argument list, used by Call() """
    pass


def Call(func_name, args=None, prefix=None): # reliably restored by inspect
    """ A function call """
    pass


def Dot(): # reliably restored by inspect
    """ A period (.) leaf """
    pass


def LParen(): # reliably restored by inspect
    # no doc
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


def RParen(): # reliably restored by inspect
    # no doc
    pass


# classes

class FixDict(__lib2to3_fixer_base.BaseFix):
    # no doc
    def in_special_context(self, *args, **kwargs): # real signature unknown
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    P1 = "power< func=NAME trailer< '(' node=any ')' > any* >"
    p1 = None # (!) real value is ''
    P2 = "for_stmt< 'for' any 'in' node=any ':' any* >\n            | comp_for< 'for' any 'in' node=any any* >\n         "
    p2 = None # (!) real value is ''
    PATTERN = "\n    power< head=any+\n         trailer< '.' method=('keys'|'items'|'values'|\n                              'iterkeys'|'iteritems'|'itervalues') >\n         parens=trailer< '(' ')' >\n         tail=any*\n    >\n    "


# variables with complex values

iter_exempt = None # (!) real value is ''

