# encoding: utf-8
# module lib2to3.fixes.fix_idioms
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixes/fix_idioms.pyo by generator 1.99
"""
Adjust some old Python 2 idioms to their modern counterparts.

* Change some type comparisons to isinstance() calls:
    type(x) == T -> isinstance(x, T)
    type(x) is T -> isinstance(x, T)
    type(x) != T -> not isinstance(x, T)
    type(x) is not T -> not isinstance(x, T)

* Change "while 1:" into "while True:".

* Change both

    v = list(EXPR)
    v.sort()
    foo(v)

and the more general

    v = EXPR
    v.sort()
    foo(v)

into

    v = sorted(EXPR)
    foo(v)
"""

# imports
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixer_base.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base
import lib2to3.pytree as __lib2to3_pytree


# Variables with simple values

CMP = "(n='!=' | '==' | 'is' | n=comp_op< 'is' 'not' >)"

TYPE = "power< 'type' trailer< '(' x=any ')' > >"

# functions

def Call(func_name, args=None, prefix=None): # reliably restored by inspect
    """ A function call """
    pass


def Comma(): # reliably restored by inspect
    """ A comma leaf """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


# classes

class FixIdioms(__lib2to3_fixer_base.BaseFix):
    # no doc
    def match(self, *args, **kwargs): # real signature unknown
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def transform_isinstance(self, *args, **kwargs): # real signature unknown
        pass

    def transform_sort(self, *args, **kwargs): # real signature unknown
        pass

    def transform_while(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    explicit = True
    PATTERN = "\n        isinstance=comparison< power< 'type' trailer< '(' x=any ')' > > (n='!=' | '==' | 'is' | n=comp_op< 'is' 'not' >) T=any >\n        |\n        isinstance=comparison< T=any (n='!=' | '==' | 'is' | n=comp_op< 'is' 'not' >) power< 'type' trailer< '(' x=any ')' > > >\n        |\n        while_stmt< 'while' while='1' ':' any+ >\n        |\n        sorted=any<\n            any*\n            simple_stmt<\n              expr_stmt< id1=any '='\n                         power< list='list' trailer< '(' (not arglist<any+>) any ')' > >\n              >\n              '\\n'\n            >\n            sort=\n            simple_stmt<\n              power< id2=any\n                     trailer< '.' 'sort' > trailer< '(' ')' >\n              >\n              '\\n'\n            >\n            next=any*\n        >\n        |\n        sorted=any<\n            any*\n            simple_stmt< expr_stmt< id1=any '=' expr=any > '\\n' >\n            sort=\n            simple_stmt<\n              power< id2=any\n                     trailer< '.' 'sort' > trailer< '(' ')' >\n              >\n              '\\n'\n            >\n            next=any*\n        >\n    "


class Node(__lib2to3_pytree.Base):
    """ Concrete implementation for interior nodes. """
    def append_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.append(child)'. This method also
                sets the child's parent attribute appropriately.
        """
        pass

    def clone(self, *args, **kwargs): # real signature unknown
        """ Returns a cloned (deep) copy of self. """
        pass

    def get_prefix(self, *args, **kwargs): # real signature unknown
        """
        Returns the prefix for the node.
        
                This passes the call on to the first child.
        """
        pass

    def insert_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.insert(i, child)'. This method also
                sets the child's parent attribute appropriately.
        """
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """ Returns a post-order iterator for the tree. """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """ Returns a pre-order iterator for the tree. """
        pass

    def set_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children[i] = child'. This method also sets the
                child's parent attribute appropriately.
        """
        pass

    def set_prefix(self, *args, **kwargs): # real signature unknown
        """
        Sets the prefix for the node.
        
                This passes the responsibility on to the first child.
        """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """ Compares two nodes for equality. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes a type constant (a symbol number >= 256), a sequence of
                child nodes, and an optional context keyword argument.
        
                As a side effect, the parent pointers of the children are updated.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Returns a canonical string representation. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """
        Returns a pretty string representation.
        
                This reproduces the input source exactly.
        """
        pass


# variables with complex values

syms = None # (!) real value is ''

