# encoding: utf-8
# module lib2to3.fixes.fix_urllib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixes/fix_urllib.pyo by generator 1.99
"""
Fix changes imports of urllib which are now incompatible.
   This is rather similar to fix_imports, but because of the more
   complex nature of the fixing for urllib, it has its own fixer.
"""

# imports
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixer_base.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base
import lib2to3.fixes.fix_imports as __lib2to3_fixes_fix_imports


# functions

def alternates(members): # reliably restored by inspect
    # no doc
    pass


def attr_chain(obj, attr): # reliably restored by inspect
    """
    Follow an attribute chain.
    
        If you have a chain of objects where a.foo -> b, b.foo-> c, etc,
        use this to iterate over all objects in the chain. Iteration is
        terminated by getattr(x, attr) is None.
    
        Args:
            obj: the starting object
            attr: the name of the chaining attribute
    
        Yields:
            Each successive object in the chain.
    """
    pass


def build_pattern(): # reliably restored by inspect
    # no doc
    pass


def Comma(): # reliably restored by inspect
    """ A comma leaf """
    pass


def FromImport(package_name, name_leafs): # reliably restored by inspect
    """
    Return an import statement in the form:
            from package import name_leafs
    """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


def Newline(): # reliably restored by inspect
    """ A newline literal """
    pass


# classes

class FixImports(__lib2to3_fixer_base.BaseFix):
    # no doc
    def build_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def compile_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def match(self, *args, **kwargs): # real signature unknown
        pass

    def start_tree(self, *args, **kwargs): # real signature unknown
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    mapping = {
        'BaseHTTPServer': 'http.server',
        'CGIHTTPServer': 'http.server',
        'ConfigParser': 'configparser',
        'Cookie': 'http.cookies',
        'Dialog': 'tkinter.dialog',
        'DocXMLRPCServer': 'xmlrpc.server',
        'FileDialog': 'tkinter.filedialog',
        'Queue': 'queue',
        'ScrolledText': 'tkinter.scrolledtext',
        'SimpleDialog': 'tkinter.simpledialog',
        'SimpleHTTPServer': 'http.server',
        'SimpleXMLRPCServer': 'xmlrpc.server',
        'SocketServer': 'socketserver',
        'StringIO': 'io',
        'Tix': 'tkinter.tix',
        'Tkconstants': 'tkinter.constants',
        'Tkdnd': 'tkinter.dnd',
        'Tkinter': 'tkinter',
        'UserList': 'collections',
        'UserString': 'collections',
        '__builtin__': 'builtins',
        '_winreg': 'winreg',
        'cPickle': 'pickle',
        'cStringIO': 'io',
        'commands': 'subprocess',
        'cookielib': 'http.cookiejar',
        'copy_reg': 'copyreg',
        'dbhash': 'dbm.bsd',
        'dbm': 'dbm.ndbm',
        'dumbdbm': 'dbm.dumb',
        'dummy_thread': '_dummy_thread',
        'gdbm': 'dbm.gnu',
        'httplib': 'http.client',
        'markupbase': '_markupbase',
        'repr': 'reprlib',
        'robotparser': 'urllib.robotparser',
        'thread': '_thread',
        'tkColorChooser': 'tkinter.colorchooser',
        'tkCommonDialog': 'tkinter.commondialog',
        'tkFileDialog': 'tkinter.filedialog',
        'tkFont': 'tkinter.font',
        'tkMessageBox': 'tkinter.messagebox',
        'tkSimpleDialog': 'tkinter.simpledialog',
        'turtle': 'tkinter.turtle',
        'urlparse': 'urllib.parse',
        'xmlrpclib': 'xmlrpc.client',
    }
    order = 'pre'


class FixUrllib(__lib2to3_fixes_fix_imports.FixImports):
    # no doc
    def build_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def transform_dot(self, *args, **kwargs): # real signature unknown
        """ Transform for calls to module members in code. """
        pass

    def transform_import(self, *args, **kwargs): # real signature unknown
        """
        Transform for the basic import case. Replaces the old
                   import name with a comma separated list of its
                   replacements.
        """
        pass

    def transform_member(self, *args, **kwargs): # real signature unknown
        """
        Transform for imports of specific module elements. Replaces
                   the module to be imported from with the appropriate new
                   module.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass


# variables with complex values

MAPPING = {
    'urllib': [
        (
            'urllib.request',
            [
                'URLOpener',
                'FancyURLOpener',
                'urlretrieve',
                '_urlopener',
                'urlcleanup',
            ],
        ),
        (
            'urllib.parse',
            [
                'quote',
                'quote_plus',
                'unquote',
                'unquote_plus',
                'urlencode',
                'pahtname2url',
                'url2pathname',
            ],
        ),
        (
            'urllib.error',
            [
                'ContentTooShortError',
            ],
        ),
    ],
    'urllib2': [
        (
            'urllib.request',
            [
                'urlopen',
                'install_opener',
                'build_opener',
                'Request',
                'OpenerDirector',
                'BaseHandler',
                'HTTPDefaultErrorHandler',
                'HTTPRedirectHandler',
                'HTTPCookieProcessor',
                'ProxyHandler',
                'HTTPPasswordMgr',
                'HTTPPasswordMgrWithDefaultRealm',
                'AbstractBasicAuthHandler',
                'HTTPBasicAuthHandler',
                'ProxyBasicAuthHandler',
                'AbstractDigestAuthHandler',
                'HTTPDigestAuthHander',
                'ProxyDigestAuthHandler',
                'HTTPHandler',
                'HTTPSHandler',
                'FileHandler',
                'FTPHandler',
                'CacheFTPHandler',
                'UnknownHandler',
            ],
        ),
        (
            'urllib.error',
            [
                'URLError',
                'HTTPError',
            ],
        ),
    ],
}

