# encoding: utf-8
# module lib2to3.refactor
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/refactor.pyo by generator 1.99
"""
Refactoring framework.

Used as a main program, this can refactor any number of files and/or
recursively descend down directories.  Imported as a module, this
provides infrastructure to write your own refactoring tool.
"""

# imports
import lib2to3.fixes as fixes # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixes/__init__.pyc
import operator as operator # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/operator.so
import lib2to3.pgen2.tokenize as tokenize # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/tokenize.pyc
import lib2to3.patcomp as patcomp # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/patcomp.pyc
import lib2to3.pytree as pytree # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pytree.pyc
import lib2to3.pgen2.driver as driver # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/driver.pyc
import sys as sys # <module 'sys' (built-in)>
import lib2to3.pygram as pygram # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pygram.pyc
import logging as logging # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/logging/__init__.pyc
import difflib as difflib # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/difflib.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
from itertools import chain


# Variables with simple values

__author__ = 'Guido van Rossum <guido@python.org>'

# functions

def diff_texts(a, b, filename): # reliably restored by inspect
    """ Return a unified diff of two strings. """
    pass


def get_all_fix_names(fixer_pkg, remove_prefix=True): # reliably restored by inspect
    """ Return a sorted list of all available fix names in the given package. """
    pass


def get_fixers_from_package(pkg_name): # reliably restored by inspect
    """ Return the fully qualified names for fixers in the package pkg_name. """
    pass


def get_headnode_dict(fixer_list): # reliably restored by inspect
    """
    Accepts a list of fixers and returns a dictionary
            of head node type --> fixer list.
    """
    pass


def get_head_types(pat): # reliably restored by inspect
    """
    Accepts a pytree Pattern Node and returns a set
            of the pattern types which will match first.
    """
    pass


# classes

class defaultdict(dict):
    """
    defaultdict(default_factory) --> dict with default factory
    
    The default factory is called without arguments to produce
    a new value when a key is not present, in __getitem__ only.
    A defaultdict compares equal to a dict with the same items.
    """
    def copy(self): # real signature unknown; restored from __doc__
        """ D.copy() -> a shallow copy of D. """
        pass

    def __copy__(self, *args, **kwargs): # real signature unknown
        """ D.copy() -> a shallow copy of D. """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, default_factory): # real signature unknown; restored from __doc__
        pass

    def __missing__(self, key): # real signature unknown; restored from __doc__
        """
        __missing__(key) # Called by __getitem__ for missing key; pseudo-code:
          if self.default_factory is None: raise KeyError((key,))
          self[key] = value = self.default_factory()
          return value
        """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling. """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    default_factory = property(lambda self: object()) # default


class FixerError(Exception):
    """ A fixer could not be loaded. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class RefactoringTool(object):
    # no doc
    def gen_lines(self, *args, **kwargs): # real signature unknown
        """
        Generates lines as expected by tokenize from a list of lines.
        
                This strips the first len(indent + self.PS1) characters off each line.
        """
        pass

    def get_fixers(self, *args, **kwargs): # real signature unknown
        """
        Inspects the options to load the requested patterns and handlers.
        
                Returns:
                  (pre_order, post_order), where pre_order is the list of fixers that
                  want a pre-order AST traversal, and post_order is the list that want
                  post-order traversal.
        """
        pass

    def log_debug(self, *args, **kwargs): # real signature unknown
        pass

    def log_error(self, *args, **kwargs): # real signature unknown
        """ Called when an error occurs. """
        pass

    def log_message(self, *args, **kwargs): # real signature unknown
        """ Hook to log a message. """
        pass

    def parse_block(self, *args, **kwargs): # real signature unknown
        """
        Parses a block into a tree.
        
                This is necessary to get correct line number / offset information
                in the parser diagnostics and embedded into the parse tree.
        """
        pass

    def print_output(self, *args, **kwargs): # real signature unknown
        """ Called with lines of output to give to the user. """
        pass

    def processed_file(self, *args, **kwargs): # real signature unknown
        """ Called when a file has been refactored, and there are changes. """
        pass

    def refactor(self, *args, **kwargs): # real signature unknown
        """ Refactor a list of files and directories. """
        pass

    def refactor_dir(self, *args, **kwargs): # real signature unknown
        """
        Descends down a directory and refactor every Python file found.
        
                Python files are assumed to have a .py extension.
        
                Files and subdirectories starting with '.' are skipped.
        """
        pass

    def refactor_docstring(self, *args, **kwargs): # real signature unknown
        """
        Refactors a docstring, looking for doctests.
        
                This returns a modified version of the input string.  It looks
                for doctests, which start with a ">>>" prompt, and may be
                continued with "..." prompts, as long as the "..." is indented
                the same as the ">>>".
        
                (Unfortunately we can't use the doctest module's parser,
                since, like most parsers, it is not geared towards preserving
                the original source.)
        """
        pass

    def refactor_doctest(self, *args, **kwargs): # real signature unknown
        """
        Refactors one doctest.
        
                A doctest is given as a block of lines, the first of which starts
                with ">>>" (possibly indented), while the remaining lines start
                with "..." (identically indented).
        """
        pass

    def refactor_file(self, *args, **kwargs): # real signature unknown
        """ Refactors a file. """
        pass

    def refactor_stdin(self, *args, **kwargs): # real signature unknown
        pass

    def refactor_string(self, *args, **kwargs): # real signature unknown
        """
        Refactor a given input string.
        
                Args:
                    data: a string holding the code to be refactored.
                    name: a human-readable name for use in error/log messages.
        
                Returns:
                    An AST corresponding to the refactored input stream; None if
                    there were errors during the parse.
        """
        pass

    def refactor_tree(self, *args, **kwargs): # real signature unknown
        """
        Refactors a parse tree (modifying the tree in place).
        
                Args:
                    tree: a pytree.Node instance representing the root of the tree
                          to be refactored.
                    name: a human-readable name for this tree.
        
                Returns:
                    True if the tree was modified, False otherwise.
        """
        pass

    def summarize(self, *args, **kwargs): # real signature unknown
        pass

    def traverse_by(self, *args, **kwargs): # real signature unknown
        """
        Traverse an AST, applying a set of fixers to each node.
        
                This is a helper method for refactor_tree().
        
                Args:
                    fixers: a list of fixer instances.
                    traversal: a generator that yields AST nodes.
        
                Returns:
                    None
        """
        pass

    def wrap_toks(self, *args, **kwargs): # real signature unknown
        """ Wraps a tokenize stream to systematically modify start/end. """
        pass

    def write_file(self, *args, **kwargs): # real signature unknown
        """
        Writes a string to a file.
        
                It first shows a unified diff between the old text and the new text, and
                then rewrites the file; the latter is only done if the write option is
                set.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Args:
                    fixer_names: a list of fixers to import
                    options: an dict with configuration.
                    explicit: a list of fixers to run even if they are explicit.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    CLASS_PREFIX = 'Fix'
    FILE_PREFIX = 'fix_'
    PS1 = '>>> '
    PS2 = '... '
    _default_options = {
        'print_function': False,
    }
    __dict__ = None # (!) real value is ''


