# encoding: utf-8
# module locale
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/locale.pyo by generator 1.99
"""
Locale support.

    The module provides low-level access to the C lib's locale APIs
    and adds high level number formatting APIs as well as a locale
    aliasing engine to complement these.

    The aliasing engine includes support for many commonly used locale
    names and maps them to values suitable for passing to the C lib's
    setlocale() function. It also includes default encodings for all
    supported locale names.
"""

# imports
import functools as functools # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/functools.pyc
import encodings as encodings # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/encodings/__init__.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import operator as operator # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/operator.so
import sys as sys # <module 'sys' (built-in)>
from _locale import (_localeconv, _setlocale, localeconv, nl_langinfo, 
    strcoll, strxfrm)


# Variables with simple values

ABDAY_1 = 14
ABDAY_2 = 15
ABDAY_3 = 16
ABDAY_4 = 17
ABDAY_5 = 18
ABDAY_6 = 19
ABDAY_7 = 20

ABMON_1 = 33
ABMON_10 = 42
ABMON_11 = 43
ABMON_12 = 44
ABMON_2 = 34
ABMON_3 = 35
ABMON_4 = 36
ABMON_5 = 37
ABMON_6 = 38
ABMON_7 = 39
ABMON_8 = 40
ABMON_9 = 41

ALT_DIGITS = 49

AM_STR = 5

CHAR_MAX = 127

CODESET = 0

CRNCYSTR = 56

DAY_1 = 7
DAY_2 = 8
DAY_3 = 9
DAY_4 = 10
DAY_5 = 11
DAY_6 = 12
DAY_7 = 13

D_FMT = 2

D_T_FMT = 1

ERA = 45

ERA_D_FMT = 46

ERA_D_T_FMT = 47

ERA_T_FMT = 48

LC_ALL = 0
LC_COLLATE = 1
LC_CTYPE = 2
LC_MESSAGES = 6
LC_MONETARY = 3
LC_NUMERIC = 4
LC_TIME = 5

MON_1 = 21
MON_10 = 30
MON_11 = 31
MON_12 = 32
MON_2 = 22
MON_3 = 23
MON_4 = 24
MON_5 = 25
MON_6 = 26
MON_7 = 27
MON_8 = 28
MON_9 = 29

NOEXPR = 53

PM_STR = 6

RADIXCHAR = 50

THOUSEP = 51

T_FMT = 3

T_FMT_AMPM = 4

YESEXPR = 52

# functions

def atof(string, func=float): # reliably restored by inspect
    """ Parses a string as a float according to the locale settings. """
    pass


def atoi(str): # reliably restored by inspect
    """ Converts a string to an integer according to the locale settings. """
    pass


def currency(val, symbol=True, grouping=False, international=False): # reliably restored by inspect
    """
    Formats val according to the currency settings
        in the current locale.
    """
    pass


def format(percent, value, grouping=False, monetary=False, *additional): # reliably restored by inspect
    """
    Returns the locale-aware substitution of a %? specifier
        (percent).
    
        additional is for format strings which contain one or more
        '*' modifiers.
    """
    pass


def format_string(f, val, grouping=False): # reliably restored by inspect
    """
    Formats a string in the same way that the % formatting would use,
        but takes the current locale into account.
        Grouping is applied if the third parameter is true.
    """
    pass


def getdefaultlocale(envvars="('LC_ALL', 'LC_CTYPE', 'LANG', 'LANGUAGE')"): # reliably restored by inspect
    """
    Tries to determine the default locale settings and returns
            them as tuple (language code, encoding).
    
            According to POSIX, a program which has not called
            setlocale(LC_ALL, "") runs using the portable 'C' locale.
            Calling setlocale(LC_ALL, "") lets it use the default locale as
            defined by the LANG variable. Since we don't want to interfere
            with the current locale setting we thus emulate the behavior
            in the way described above.
    
            To maintain compatibility with other platforms, not only the
            LANG variable is tested, but a list of variables given as
            envvars parameter. The first found to be defined will be
            used. envvars defaults to the search path used in GNU gettext;
            it must always contain the variable name 'LANG'.
    
            Except for the code 'C', the language code corresponds to RFC
            1766.  code and encoding can be None in case the values cannot
            be determined.
    """
    pass


def getlocale(category=2): # reliably restored by inspect
    """
    Returns the current setting for the given locale category as
            tuple (language code, encoding).
    
            category may be one of the LC_* value except LC_ALL. It
            defaults to LC_CTYPE.
    
            Except for the code 'C', the language code corresponds to RFC
            1766.  code and encoding can be None in case the values cannot
            be determined.
    """
    pass


def getpreferredencoding(do_setlocale=True): # reliably restored by inspect
    """
    Return the charset that the user is likely using,
                according to the system configuration.
    """
    pass


def normalize(localename): # reliably restored by inspect
    """
    Returns a normalized locale code for the given locale
            name.
    
            The returned locale code is formatted for use with
            setlocale().
    
            If normalization fails, the original name is returned
            unchanged.
    
            If the given encoding is not known, the function defaults to
            the default encoding for the locale code just like setlocale()
            does.
    """
    pass


def resetlocale(category=0): # reliably restored by inspect
    """
    Sets the locale for category to the default setting.
    
            The default setting is determined by calling
            getdefaultlocale(). category defaults to LC_ALL.
    """
    pass


def setlocale(category, locale=None): # reliably restored by inspect
    """
    Set the locale for the given category.  The locale can be
            a string, a locale tuple (language code, encoding), or None.
    
            Locale tuples are converted to strings the locale aliasing
            engine.  Locale strings are passed directly to the C lib.
    
            category may be given as one of the LC_* values.
    """
    pass


def str(val): # reliably restored by inspect
    """ Convert float to integer, taking the locale into account. """
    pass


def _build_localename(localetuple): # reliably restored by inspect
    """
    Builds a locale code from the given tuple (language code,
            encoding).
    
            No aliasing or normalizing takes place.
    """
    pass


def _group(s, monetary=False): # reliably restored by inspect
    # no doc
    pass


def _parse_localename(localename): # reliably restored by inspect
    """
    Parses the locale code for localename and returns the
            result as tuple (language code, encoding).
    
            The localename is normalized and passed through the locale
            alias engine. A ValueError is raised in case the locale name
            cannot be parsed.
    
            The language code corresponds to RFC 1766.  code and encoding
            can be None in case the values cannot be determined or are
            unknown to this implementation.
    """
    pass


def _print_locale(): # reliably restored by inspect
    """ Test function. """
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# classes

class Error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

locale_alias = {
    'a3': 'a3_AZ.KOI8-C',
    'a3_az': 'a3_AZ.KOI8-C',
    'a3_az.koi8c': 'a3_AZ.KOI8-C',
    'af': 'af_ZA.ISO8859-1',
    'af_za': 'af_ZA.ISO8859-1',
    'af_za.iso88591': 'af_ZA.ISO8859-1',
    'am': 'am_ET.UTF-8',
    'am_et': 'am_ET.UTF-8',
    'american': 'en_US.ISO8859-1',
    'american.iso88591': 'en_US.ISO8859-1',
    'ar': 'ar_AA.ISO8859-6',
    'ar_aa': 'ar_AA.ISO8859-6',
    'ar_aa.iso88596': 'ar_AA.ISO8859-6',
    'ar_ae': 'ar_AE.ISO8859-6',
    'ar_ae.iso88596': 'ar_AE.ISO8859-6',
    'ar_bh': 'ar_BH.ISO8859-6',
    'ar_bh.iso88596': 'ar_BH.ISO8859-6',
    'ar_dz': 'ar_DZ.ISO8859-6',
    'ar_dz.iso88596': 'ar_DZ.ISO8859-6',
    'ar_eg': 'ar_EG.ISO8859-6',
    'ar_eg.iso88596': 'ar_EG.ISO8859-6',
    'ar_iq': 'ar_IQ.ISO8859-6',
    'ar_iq.iso88596': 'ar_IQ.ISO8859-6',
    'ar_jo': 'ar_JO.ISO8859-6',
    'ar_jo.iso88596': 'ar_JO.ISO8859-6',
    'ar_kw': 'ar_KW.ISO8859-6',
    'ar_kw.iso88596': 'ar_KW.ISO8859-6',
    'ar_lb': 'ar_LB.ISO8859-6',
    'ar_lb.iso88596': 'ar_LB.ISO8859-6',
    'ar_ly': 'ar_LY.ISO8859-6',
    'ar_ly.iso88596': 'ar_LY.ISO8859-6',
    'ar_ma': 'ar_MA.ISO8859-6',
    'ar_ma.iso88596': 'ar_MA.ISO8859-6',
    'ar_om': 'ar_OM.ISO8859-6',
    'ar_om.iso88596': 'ar_OM.ISO8859-6',
    'ar_qa': 'ar_QA.ISO8859-6',
    'ar_qa.iso88596': 'ar_QA.ISO8859-6',
    'ar_sa': 'ar_SA.ISO8859-6',
    'ar_sa.iso88596': 'ar_SA.ISO8859-6',
    'ar_sd': 'ar_SD.ISO8859-6',
    'ar_sd.iso88596': 'ar_SD.ISO8859-6',
    'ar_sy': 'ar_SY.ISO8859-6',
    'ar_sy.iso88596': 'ar_SY.ISO8859-6',
    'ar_tn': 'ar_TN.ISO8859-6',
    'ar_tn.iso88596': 'ar_TN.ISO8859-6',
    'ar_ye': 'ar_YE.ISO8859-6',
    'ar_ye.iso88596': 'ar_YE.ISO8859-6',
    'arabic': 'ar_AA.ISO8859-6',
    'arabic.iso88596': 'ar_AA.ISO8859-6',
    'az': 'az_AZ.ISO8859-9E',
    'az_az': 'az_AZ.ISO8859-9E',
    'az_az.iso88599e': 'az_AZ.ISO8859-9E',
    'be': 'be_BY.CP1251',
    'be_by': 'be_BY.CP1251',
    'be_by.cp1251': 'be_BY.CP1251',
    'be_by.microsoftcp1251': 'be_BY.CP1251',
    'bg': 'bg_BG.CP1251',
    'bg_bg': 'bg_BG.CP1251',
    'bg_bg.cp1251': 'bg_BG.CP1251',
    'bg_bg.iso88595': 'bg_BG.ISO8859-5',
    'bg_bg.koi8r': 'bg_BG.KOI8-R',
    'bg_bg.microsoftcp1251': 'bg_BG.CP1251',
    'bn_in': 'bn_IN.UTF-8',
    'bokmal': 'nb_NO.ISO8859-1',
    'bokm\xe5l': 'nb_NO.ISO8859-1',
    'br': 'br_FR.ISO8859-1',
    'br_fr': 'br_FR.ISO8859-1',
    'br_fr.iso88591': 'br_FR.ISO8859-1',
    'br_fr.iso885914': 'br_FR.ISO8859-14',
    'br_fr.iso885915': 'br_FR.ISO8859-15',
    'br_fr.iso885915@euro': 'br_FR.ISO8859-15',
    'br_fr.utf8@euro': 'br_FR.UTF-8',
    'br_fr@euro': 'br_FR.ISO8859-15',
    'bs': 'bs_BA.ISO8859-2',
    'bs_ba': 'bs_BA.ISO8859-2',
    'bs_ba.iso88592': 'bs_BA.ISO8859-2',
    'bulgarian': 'bg_BG.CP1251',
    'c': 'C',
    'c-french': 'fr_CA.ISO8859-1',
    'c-french.iso88591': 'fr_CA.ISO8859-1',
    'c.en': 'C',
    'c.iso88591': 'en_US.ISO8859-1',
    'c_c': 'C',
    'c_c.c': 'C',
    'ca': 'ca_ES.ISO8859-1',
    'ca_es': 'ca_ES.ISO8859-1',
    'ca_es.iso88591': 'ca_ES.ISO8859-1',
    'ca_es.iso885915': 'ca_ES.ISO8859-15',
    'ca_es.iso885915@euro': 'ca_ES.ISO8859-15',
    'ca_es.utf8@euro': 'ca_ES.UTF-8',
    'ca_es@euro': 'ca_ES.ISO8859-15',
    'catalan': 'ca_ES.ISO8859-1',
    'cextend': 'en_US.ISO8859-1',
    'cextend.en': 'en_US.ISO8859-1',
    'chinese-s': 'zh_CN.eucCN',
    'chinese-t': 'zh_TW.eucTW',
    'croatian': 'hr_HR.ISO8859-2',
    'cs': 'cs_CZ.ISO8859-2',
    'cs_cs': 'cs_CZ.ISO8859-2',
    'cs_cs.iso88592': 'cs_CS.ISO8859-2',
    'cs_cz': 'cs_CZ.ISO8859-2',
    'cs_cz.iso88592': 'cs_CZ.ISO8859-2',
    'cy': 'cy_GB.ISO8859-1',
    'cy_gb': 'cy_GB.ISO8859-1',
    'cy_gb.iso88591': 'cy_GB.ISO8859-1',
    'cy_gb.iso885914': 'cy_GB.ISO8859-14',
    'cy_gb.iso885915': 'cy_GB.ISO8859-15',
    'cy_gb@euro': 'cy_GB.ISO8859-15',
    'cz': 'cs_CZ.ISO8859-2',
    'cz_cz': 'cs_CZ.ISO8859-2',
    'czech': 'cs_CZ.ISO8859-2',
    'da': 'da_DK.ISO8859-1',
    'da_dk': 'da_DK.ISO8859-1',
    'da_dk.88591': 'da_DK.ISO8859-1',
    'da_dk.885915': 'da_DK.ISO8859-15',
    'da_dk.iso88591': 'da_DK.ISO8859-1',
    'da_dk.iso885915': 'da_DK.ISO8859-15',
    'da_dk@euro': 'da_DK.ISO8859-15',
    'danish': 'da_DK.ISO8859-1',
    'danish.iso88591': 'da_DK.ISO8859-1',
    'dansk': 'da_DK.ISO8859-1',
    'de': 'de_DE.ISO8859-1',
    'de_at': 'de_AT.ISO8859-1',
    'de_at.iso88591': 'de_AT.ISO8859-1',
    'de_at.iso885915': 'de_AT.ISO8859-15',
    'de_at.iso885915@euro': 'de_AT.ISO8859-15',
    'de_at.utf8@euro': 'de_AT.UTF-8',
    'de_at@euro': 'de_AT.ISO8859-15',
    'de_be': 'de_BE.ISO8859-1',
    'de_be.iso88591': 'de_BE.ISO8859-1',
    'de_be.iso885915': 'de_BE.ISO8859-15',
    'de_be.iso885915@euro': 'de_BE.ISO8859-15',
    'de_be.utf8@euro': 'de_BE.UTF-8',
    'de_be@euro': 'de_BE.ISO8859-15',
    'de_ch': 'de_CH.ISO8859-1',
    'de_ch.iso88591': 'de_CH.ISO8859-1',
    'de_ch.iso885915': 'de_CH.ISO8859-15',
    'de_ch@euro': 'de_CH.ISO8859-15',
    'de_de': 'de_DE.ISO8859-1',
    'de_de.88591': 'de_DE.ISO8859-1',
    'de_de.885915': 'de_DE.ISO8859-15',
    'de_de.885915@euro': 'de_DE.ISO8859-15',
    'de_de.iso88591': 'de_DE.ISO8859-1',
    'de_de.iso885915': 'de_DE.ISO8859-15',
    'de_de.iso885915@euro': 'de_DE.ISO8859-15',
    'de_de.utf8@euro': 'de_DE.UTF-8',
    'de_de@euro': 'de_DE.ISO8859-15',
    'de_lu': 'de_LU.ISO8859-1',
    'de_lu.iso88591': 'de_LU.ISO8859-1',
    'de_lu.iso885915': 'de_LU.ISO8859-15',
    'de_lu.iso885915@euro': 'de_LU.ISO8859-15',
    'de_lu.utf8@euro': 'de_LU.UTF-8',
    'de_lu@euro': 'de_LU.ISO8859-15',
    'deutsch': 'de_DE.ISO8859-1',
    'dutch': 'nl_NL.ISO8859-1',
    'dutch.iso88591': 'nl_BE.ISO8859-1',
    'ee': 'ee_EE.ISO8859-4',
    'ee_ee': 'ee_EE.ISO8859-4',
    'ee_ee.iso88594': 'ee_EE.ISO8859-4',
    'eesti': 'et_EE.ISO8859-1',
    'el': 'el_GR.ISO8859-7',
    'el_gr': 'el_GR.ISO8859-7',
    'el_gr.iso88597': 'el_GR.ISO8859-7',
    'el_gr@euro': 'el_GR.ISO8859-15',
    'en': 'en_US.ISO8859-1',
    'en.iso88591': 'en_US.ISO8859-1',
    'en_au': 'en_AU.ISO8859-1',
    'en_au.iso88591': 'en_AU.ISO8859-1',
    'en_be': 'en_BE.ISO8859-1',
    'en_be@euro': 'en_BE.ISO8859-15',
    'en_bw': 'en_BW.ISO8859-1',
    'en_bw.iso88591': 'en_BW.ISO8859-1',
    'en_ca': 'en_CA.ISO8859-1',
    'en_ca.iso88591': 'en_CA.ISO8859-1',
    'en_gb': 'en_GB.ISO8859-1',
    'en_gb.88591': 'en_GB.ISO8859-1',
    'en_gb.iso88591': 'en_GB.ISO8859-1',
    'en_gb.iso885915': 'en_GB.ISO8859-15',
    'en_gb@euro': 'en_GB.ISO8859-15',
    'en_hk': 'en_HK.ISO8859-1',
    'en_hk.iso88591': 'en_HK.ISO8859-1',
    'en_ie': 'en_IE.ISO8859-1',
    'en_ie.iso88591': 'en_IE.ISO8859-1',
    'en_ie.iso885915': 'en_IE.ISO8859-15',
    'en_ie.iso885915@euro': 'en_IE.ISO8859-15',
    'en_ie.utf8@euro': 'en_IE.UTF-8',
    'en_ie@euro': 'en_IE.ISO8859-15',
    'en_in': 'en_IN.ISO8859-1',
    'en_nz': 'en_NZ.ISO8859-1',
    'en_nz.iso88591': 'en_NZ.ISO8859-1',
    'en_ph': 'en_PH.ISO8859-1',
    'en_ph.iso88591': 'en_PH.ISO8859-1',
    'en_sg': 'en_SG.ISO8859-1',
    'en_sg.iso88591': 'en_SG.ISO8859-1',
    'en_uk': 'en_GB.ISO8859-1',
    'en_us': 'en_US.ISO8859-1',
    'en_us.88591': 'en_US.ISO8859-1',
    'en_us.885915': 'en_US.ISO8859-15',
    'en_us.iso88591': 'en_US.ISO8859-1',
    'en_us.iso885915': 'en_US.ISO8859-15',
    'en_us.iso885915@euro': 'en_US.ISO8859-15',
    'en_us@euro': 'en_US.ISO8859-15',
    'en_us@euro@euro': 'en_US.ISO8859-15',
    'en_za': 'en_ZA.ISO8859-1',
    'en_za.88591': 'en_ZA.ISO8859-1',
    'en_za.iso88591': 'en_ZA.ISO8859-1',
    'en_za.iso885915': 'en_ZA.ISO8859-15',
    'en_za@euro': 'en_ZA.ISO8859-15',
    'en_zw': 'en_ZW.ISO8859-1',
    'en_zw.iso88591': 'en_ZW.ISO8859-1',
    'eng_gb': 'en_GB.ISO8859-1',
    'eng_gb.8859': 'en_GB.ISO8859-1',
    'english': 'en_EN.ISO8859-1',
    'english.iso88591': 'en_EN.ISO8859-1',
    'english_uk': 'en_GB.ISO8859-1',
    'english_uk.8859': 'en_GB.ISO8859-1',
    'english_united-states': 'en_US.ISO8859-1',
    'english_united-states.437': 'C',
    'english_us': 'en_US.ISO8859-1',
    'english_us.8859': 'en_US.ISO8859-1',
    'english_us.ascii': 'en_US.ISO8859-1',
    'eo': 'eo_XX.ISO8859-3',
    'eo_eo': 'eo_EO.ISO8859-3',
    'eo_eo.iso88593': 'eo_EO.ISO8859-3',
    'eo_xx': 'eo_XX.ISO8859-3',
    'eo_xx.iso88593': 'eo_XX.ISO8859-3',
    'es': 'es_ES.ISO8859-1',
    'es_ar': 'es_AR.ISO8859-1',
    'es_ar.iso88591': 'es_AR.ISO8859-1',
    'es_bo': 'es_BO.ISO8859-1',
    'es_bo.iso88591': 'es_BO.ISO8859-1',
    'es_cl': 'es_CL.ISO8859-1',
    'es_cl.iso88591': 'es_CL.ISO8859-1',
    'es_co': 'es_CO.ISO8859-1',
    'es_co.iso88591': 'es_CO.ISO8859-1',
    'es_cr': 'es_CR.ISO8859-1',
    'es_cr.iso88591': 'es_CR.ISO8859-1',
    'es_do': 'es_DO.ISO8859-1',
    'es_do.iso88591': 'es_DO.ISO8859-1',
    'es_ec': 'es_EC.ISO8859-1',
    'es_ec.iso88591': 'es_EC.ISO8859-1',
    'es_es': 'es_ES.ISO8859-1',
    'es_es.88591': 'es_ES.ISO8859-1',
    'es_es.iso88591': 'es_ES.ISO8859-1',
    'es_es.iso885915': 'es_ES.ISO8859-15',
    'es_es.iso885915@euro': 'es_ES.ISO8859-15',
    'es_es.utf8@euro': 'es_ES.UTF-8',
    'es_es@euro': 'es_ES.ISO8859-15',
    'es_gt': 'es_GT.ISO8859-1',
    'es_gt.iso88591': 'es_GT.ISO8859-1',
    'es_hn': 'es_HN.ISO8859-1',
    'es_hn.iso88591': 'es_HN.ISO8859-1',
    'es_mx': 'es_MX.ISO8859-1',
    'es_mx.iso88591': 'es_MX.ISO8859-1',
    'es_ni': 'es_NI.ISO8859-1',
    'es_ni.iso88591': 'es_NI.ISO8859-1',
    'es_pa': 'es_PA.ISO8859-1',
    'es_pa.iso88591': 'es_PA.ISO8859-1',
    'es_pa.iso885915': 'es_PA.ISO8859-15',
    'es_pa@euro': 'es_PA.ISO8859-15',
    'es_pe': 'es_PE.ISO8859-1',
    'es_pe.iso88591': 'es_PE.ISO8859-1',
    'es_pe.iso885915': 'es_PE.ISO8859-15',
    'es_pe@euro': 'es_PE.ISO8859-15',
    'es_pr': 'es_PR.ISO8859-1',
    'es_pr.iso88591': 'es_PR.ISO8859-1',
    'es_py': 'es_PY.ISO8859-1',
    'es_py.iso88591': 'es_PY.ISO8859-1',
    'es_py.iso885915': 'es_PY.ISO8859-15',
    'es_py@euro': 'es_PY.ISO8859-15',
    'es_sv': 'es_SV.ISO8859-1',
    'es_sv.iso88591': 'es_SV.ISO8859-1',
    'es_sv.iso885915': 'es_SV.ISO8859-15',
    'es_sv@euro': 'es_SV.ISO8859-15',
    'es_us': 'es_US.ISO8859-1',
    'es_us.iso88591': 'es_US.ISO8859-1',
    'es_uy': 'es_UY.ISO8859-1',
    'es_uy.iso88591': 'es_UY.ISO8859-1',
    'es_uy.iso885915': 'es_UY.ISO8859-15',
    'es_uy@euro': 'es_UY.ISO8859-15',
    'es_ve': 'es_VE.ISO8859-1',
    'es_ve.iso88591': 'es_VE.ISO8859-1',
    'es_ve.iso885915': 'es_VE.ISO8859-15',
    'es_ve@euro': 'es_VE.ISO8859-15',
    'estonian': 'et_EE.ISO8859-1',
    'et': 'et_EE.ISO8859-15',
    'et_ee': 'et_EE.ISO8859-15',
    'et_ee.iso88591': 'et_EE.ISO8859-1',
    'et_ee.iso885913': 'et_EE.ISO8859-13',
    'et_ee.iso885915': 'et_EE.ISO8859-15',
    'et_ee.iso88594': 'et_EE.ISO8859-4',
    'et_ee@euro': 'et_EE.ISO8859-15',
    'eu': 'eu_ES.ISO8859-1',
    'eu_es': 'eu_ES.ISO8859-1',
    'eu_es.iso88591': 'eu_ES.ISO8859-1',
    'eu_es.iso885915': 'eu_ES.ISO8859-15',
    'eu_es.iso885915@euro': 'eu_ES.ISO8859-15',
    'eu_es.utf8@euro': 'eu_ES.UTF-8',
    'eu_es@euro': 'eu_ES.ISO8859-15',
    'fa': 'fa_IR.UTF-8',
    'fa_ir': 'fa_IR.UTF-8',
    'fa_ir.isiri3342': 'fa_IR.ISIRI-3342',
    'fi': 'fi_FI.ISO8859-15',
    'fi_fi': 'fi_FI.ISO8859-15',
    'fi_fi.88591': 'fi_FI.ISO8859-1',
    'fi_fi.iso88591': 'fi_FI.ISO8859-1',
    'fi_fi.iso885915': 'fi_FI.ISO8859-15',
    'fi_fi.iso885915@euro': 'fi_FI.ISO8859-15',
    'fi_fi.utf8@euro': 'fi_FI.UTF-8',
    'fi_fi@euro': 'fi_FI.ISO8859-15',
    'finnish': 'fi_FI.ISO8859-1',
    'finnish.iso88591': 'fi_FI.ISO8859-1',
    'fo': 'fo_FO.ISO8859-1',
    'fo_fo': 'fo_FO.ISO8859-1',
    'fo_fo.iso88591': 'fo_FO.ISO8859-1',
    'fo_fo.iso885915': 'fo_FO.ISO8859-15',
    'fo_fo@euro': 'fo_FO.ISO8859-15',
    'fr': 'fr_FR.ISO8859-1',
    'fr_be': 'fr_BE.ISO8859-1',
    'fr_be.88591': 'fr_BE.ISO8859-1',
    'fr_be.iso88591': 'fr_BE.ISO8859-1',
    'fr_be.iso885915': 'fr_BE.ISO8859-15',
    'fr_be.iso885915@euro': 'fr_BE.ISO8859-15',
    'fr_be.utf8@euro': 'fr_BE.UTF-8',
    'fr_be@euro': 'fr_BE.ISO8859-15',
    'fr_ca': 'fr_CA.ISO8859-1',
    'fr_ca.88591': 'fr_CA.ISO8859-1',
    'fr_ca.iso88591': 'fr_CA.ISO8859-1',
    'fr_ca.iso885915': 'fr_CA.ISO8859-15',
    'fr_ca@euro': 'fr_CA.ISO8859-15',
    'fr_ch': 'fr_CH.ISO8859-1',
    'fr_ch.88591': 'fr_CH.ISO8859-1',
    'fr_ch.iso88591': 'fr_CH.ISO8859-1',
    'fr_ch.iso885915': 'fr_CH.ISO8859-15',
    'fr_ch@euro': 'fr_CH.ISO8859-15',
    'fr_fr': 'fr_FR.ISO8859-1',
    'fr_fr.88591': 'fr_FR.ISO8859-1',
    'fr_fr.iso88591': 'fr_FR.ISO8859-1',
    'fr_fr.iso885915': 'fr_FR.ISO8859-15',
    'fr_fr.iso885915@euro': 'fr_FR.ISO8859-15',
    'fr_fr.utf8@euro': 'fr_FR.UTF-8',
    'fr_fr@euro': 'fr_FR.ISO8859-15',
    'fr_lu': 'fr_LU.ISO8859-1',
    'fr_lu.88591': 'fr_LU.ISO8859-1',
    'fr_lu.iso88591': 'fr_LU.ISO8859-1',
    'fr_lu.iso885915': 'fr_LU.ISO8859-15',
    'fr_lu.iso885915@euro': 'fr_LU.ISO8859-15',
    'fr_lu.utf8@euro': 'fr_LU.UTF-8',
    'fr_lu@euro': 'fr_LU.ISO8859-15',
    'fran\xe7ais': 'fr_FR.ISO8859-1',
    'fre_fr': 'fr_FR.ISO8859-1',
    'fre_fr.8859': 'fr_FR.ISO8859-1',
    'french': 'fr_FR.ISO8859-1',
    'french.iso88591': 'fr_CH.ISO8859-1',
    'french_france': 'fr_FR.ISO8859-1',
    'french_france.8859': 'fr_FR.ISO8859-1',
    'ga': 'ga_IE.ISO8859-1',
    'ga_ie': 'ga_IE.ISO8859-1',
    'ga_ie.iso88591': 'ga_IE.ISO8859-1',
    'ga_ie.iso885914': 'ga_IE.ISO8859-14',
    'ga_ie.iso885915': 'ga_IE.ISO8859-15',
    'ga_ie.iso885915@euro': 'ga_IE.ISO8859-15',
    'ga_ie.utf8@euro': 'ga_IE.UTF-8',
    'ga_ie@euro': 'ga_IE.ISO8859-15',
    'galego': 'gl_ES.ISO8859-1',
    'galician': 'gl_ES.ISO8859-1',
    'gd': 'gd_GB.ISO8859-1',
    'gd_gb': 'gd_GB.ISO8859-1',
    'gd_gb.iso88591': 'gd_GB.ISO8859-1',
    'gd_gb.iso885914': 'gd_GB.ISO8859-14',
    'gd_gb.iso885915': 'gd_GB.ISO8859-15',
    'gd_gb@euro': 'gd_GB.ISO8859-15',
    'ger_de': 'de_DE.ISO8859-1',
    'ger_de.8859': 'de_DE.ISO8859-1',
    'german': 'de_DE.ISO8859-1',
    'german.iso88591': 'de_CH.ISO8859-1',
    'german_germany': 'de_DE.ISO8859-1',
    'german_germany.8859': 'de_DE.ISO8859-1',
    'gl': 'gl_ES.ISO8859-1',
    'gl_es': 'gl_ES.ISO8859-1',
    'gl_es.iso88591': 'gl_ES.ISO8859-1',
    'gl_es.iso885915': 'gl_ES.ISO8859-15',
    'gl_es.iso885915@euro': 'gl_ES.ISO8859-15',
    'gl_es.utf8@euro': 'gl_ES.UTF-8',
    'gl_es@euro': 'gl_ES.ISO8859-15',
    'greek': 'el_GR.ISO8859-7',
    'greek.iso88597': 'el_GR.ISO8859-7',
    'gu_in': 'gu_IN.UTF-8',
    'gv': 'gv_GB.ISO8859-1',
    'gv_gb': 'gv_GB.ISO8859-1',
    'gv_gb.iso88591': 'gv_GB.ISO8859-1',
    'gv_gb.iso885914': 'gv_GB.ISO8859-14',
    'gv_gb.iso885915': 'gv_GB.ISO8859-15',
    'gv_gb@euro': 'gv_GB.ISO8859-15',
    'he': 'he_IL.ISO8859-8',
    'he_il': 'he_IL.ISO8859-8',
    'he_il.cp1255': 'he_IL.CP1255',
    'he_il.iso88598': 'he_IL.ISO8859-8',
    'he_il.microsoftcp1255': 'he_IL.CP1255',
    'hebrew': 'iw_IL.ISO8859-8',
    'hebrew.iso88598': 'iw_IL.ISO8859-8',
    'hi': 'hi_IN.ISCII-DEV',
    'hi_in': 'hi_IN.ISCII-DEV',
    'hi_in.isciidev': 'hi_IN.ISCII-DEV',
    'hr': 'hr_HR.ISO8859-2',
    'hr_hr': 'hr_HR.ISO8859-2',
    'hr_hr.iso88592': 'hr_HR.ISO8859-2',
    'hrvatski': 'hr_HR.ISO8859-2',
    'hu': 'hu_HU.ISO8859-2',
    'hu_hu': 'hu_HU.ISO8859-2',
    'hu_hu.iso88592': 'hu_HU.ISO8859-2',
    'hungarian': 'hu_HU.ISO8859-2',
    'icelandic': 'is_IS.ISO8859-1',
    'icelandic.iso88591': 'is_IS.ISO8859-1',
    'id': 'id_ID.ISO8859-1',
    'id_id': 'id_ID.ISO8859-1',
    'in': 'id_ID.ISO8859-1',
    'in_id': 'id_ID.ISO8859-1',
    'is': 'is_IS.ISO8859-1',
    'is_is': 'is_IS.ISO8859-1',
    'is_is.iso88591': 'is_IS.ISO8859-1',
    'is_is.iso885915': 'is_IS.ISO8859-15',
    'is_is@euro': 'is_IS.ISO8859-15',
    'iso-8859-1': 'en_US.ISO8859-1',
    'iso-8859-15': 'en_US.ISO8859-15',
    'iso8859-1': 'en_US.ISO8859-1',
    'iso8859-15': 'en_US.ISO8859-15',
    'iso_8859_1': 'en_US.ISO8859-1',
    'iso_8859_15': 'en_US.ISO8859-15',
    'it': 'it_IT.ISO8859-1',
    'it_ch': 'it_CH.ISO8859-1',
    'it_ch.iso88591': 'it_CH.ISO8859-1',
    'it_ch.iso885915': 'it_CH.ISO8859-15',
    'it_ch@euro': 'it_CH.ISO8859-15',
    'it_it': 'it_IT.ISO8859-1',
    'it_it.88591': 'it_IT.ISO8859-1',
    'it_it.iso88591': 'it_IT.ISO8859-1',
    'it_it.iso885915': 'it_IT.ISO8859-15',
    'it_it.iso885915@euro': 'it_IT.ISO8859-15',
    'it_it.utf8@euro': 'it_IT.UTF-8',
    'it_it@euro': 'it_IT.ISO8859-15',
    'italian': 'it_IT.ISO8859-1',
    'italian.iso88591': 'it_IT.ISO8859-1',
    'iu': 'iu_CA.NUNACOM-8',
    'iu_ca': 'iu_CA.NUNACOM-8',
    'iu_ca.nunacom8': 'iu_CA.NUNACOM-8',
    'iw': 'he_IL.ISO8859-8',
    'iw_il': 'he_IL.ISO8859-8',
    'iw_il.iso88598': 'he_IL.ISO8859-8',
    'ja': 'ja_JP.eucJP',
    'ja.jis': 'ja_JP.JIS7',
    'ja.sjis': 'ja_JP.SJIS',
    'ja_jp': 'ja_JP.eucJP',
    'ja_jp.ajec': 'ja_JP.eucJP',
    'ja_jp.euc': 'ja_JP.eucJP',
    'ja_jp.eucjp': 'ja_JP.eucJP',
    'ja_jp.iso-2022-jp': 'ja_JP.JIS7',
    'ja_jp.iso2022jp': 'ja_JP.JIS7',
    'ja_jp.jis': 'ja_JP.JIS7',
    'ja_jp.jis7': 'ja_JP.JIS7',
    'ja_jp.mscode': 'ja_JP.SJIS',
    'ja_jp.sjis': 'ja_JP.SJIS',
    'ja_jp.ujis': 'ja_JP.eucJP',
    'japan': 'ja_JP.eucJP',
    'japanese': 'ja_JP.eucJP',
    'japanese-euc': 'ja_JP.eucJP',
    'japanese.euc': 'ja_JP.eucJP',
    'japanese.sjis': 'ja_JP.SJIS',
    'jp_jp': 'ja_JP.eucJP',
    'ka': 'ka_GE.GEORGIAN-ACADEMY',
    'ka_ge': 'ka_GE.GEORGIAN-ACADEMY',
    'ka_ge.georgianacademy': 'ka_GE.GEORGIAN-ACADEMY',
    'ka_ge.georgianps': 'ka_GE.GEORGIAN-PS',
    'ka_ge.georgianrs': 'ka_GE.GEORGIAN-ACADEMY',
    'kl': 'kl_GL.ISO8859-1',
    'kl_gl': 'kl_GL.ISO8859-1',
    'kl_gl.iso88591': 'kl_GL.ISO8859-1',
    'kl_gl.iso885915': 'kl_GL.ISO8859-15',
    'kl_gl@euro': 'kl_GL.ISO8859-15',
    'km_kh': 'km_KH.UTF-8',
    'kn_in': 'kn_IN.UTF-8',
    'ko': 'ko_KR.eucKR',
    'ko_kr': 'ko_KR.eucKR',
    'ko_kr.euc': 'ko_KR.eucKR',
    'ko_kr.euckr': 'ko_KR.eucKR',
    'korean': 'ko_KR.eucKR',
    'korean.euc': 'ko_KR.eucKR',
    'kw': 'kw_GB.ISO8859-1',
    'kw_gb': 'kw_GB.ISO8859-1',
    'kw_gb.iso88591': 'kw_GB.ISO8859-1',
    'kw_gb.iso885914': 'kw_GB.ISO8859-14',
    'kw_gb.iso885915': 'kw_GB.ISO8859-15',
    'kw_gb@euro': 'kw_GB.ISO8859-15',
    'ky': 'ky_KG.UTF-8',
    'ky_kg': 'ky_KG.UTF-8',
    'lithuanian': 'lt_LT.ISO8859-13',
    'lo': 'lo_LA.MULELAO-1',
    'lo_la': 'lo_LA.MULELAO-1',
    'lo_la.cp1133': 'lo_LA.IBM-CP1133',
    'lo_la.ibmcp1133': 'lo_LA.IBM-CP1133',
    'lo_la.mulelao1': 'lo_LA.MULELAO-1',
    'lt': 'lt_LT.ISO8859-13',
    'lt_lt': 'lt_LT.ISO8859-13',
    'lt_lt.iso885913': 'lt_LT.ISO8859-13',
    'lt_lt.iso88594': 'lt_LT.ISO8859-4',
    'lv': 'lv_LV.ISO8859-13',
    'lv_lv': 'lv_LV.ISO8859-13',
    'lv_lv.iso885913': 'lv_LV.ISO8859-13',
    'lv_lv.iso88594': 'lv_LV.ISO8859-4',
    'mi': 'mi_NZ.ISO8859-1',
    'mi_nz': 'mi_NZ.ISO8859-1',
    'mi_nz.iso88591': 'mi_NZ.ISO8859-1',
    'mk': 'mk_MK.ISO8859-5',
    'mk_mk': 'mk_MK.ISO8859-5',
    'mk_mk.cp1251': 'mk_MK.CP1251',
    'mk_mk.iso88595': 'mk_MK.ISO8859-5',
    'mk_mk.microsoftcp1251': 'mk_MK.CP1251',
    'mr_in': 'mr_IN.UTF-8',
    'ms': 'ms_MY.ISO8859-1',
    'ms_my': 'ms_MY.ISO8859-1',
    'ms_my.iso88591': 'ms_MY.ISO8859-1',
    'mt': 'mt_MT.ISO8859-3',
    'mt_mt': 'mt_MT.ISO8859-3',
    'mt_mt.iso88593': 'mt_MT.ISO8859-3',
    'nb': 'nb_NO.ISO8859-1',
    'nb_no': 'nb_NO.ISO8859-1',
    'nb_no.88591': 'nb_NO.ISO8859-1',
    'nb_no.iso88591': 'nb_NO.ISO8859-1',
    'nb_no.iso885915': 'nb_NO.ISO8859-15',
    'nb_no@euro': 'nb_NO.ISO8859-15',
    'nl': 'nl_NL.ISO8859-1',
    'nl_be': 'nl_BE.ISO8859-1',
    'nl_be.88591': 'nl_BE.ISO8859-1',
    'nl_be.iso88591': 'nl_BE.ISO8859-1',
    'nl_be.iso885915': 'nl_BE.ISO8859-15',
    'nl_be.iso885915@euro': 'nl_BE.ISO8859-15',
    'nl_be.utf8@euro': 'nl_BE.UTF-8',
    'nl_be@euro': 'nl_BE.ISO8859-15',
    'nl_nl': 'nl_NL.ISO8859-1',
    'nl_nl.88591': 'nl_NL.ISO8859-1',
    'nl_nl.iso88591': 'nl_NL.ISO8859-1',
    'nl_nl.iso885915': 'nl_NL.ISO8859-15',
    'nl_nl.iso885915@euro': 'nl_NL.ISO8859-15',
    'nl_nl.utf8@euro': 'nl_NL.UTF-8',
    'nl_nl@euro': 'nl_NL.ISO8859-15',
    'nn': 'nn_NO.ISO8859-1',
    'nn_no': 'nn_NO.ISO8859-1',
    'nn_no.88591': 'nn_NO.ISO8859-1',
    'nn_no.iso88591': 'nn_NO.ISO8859-1',
    'nn_no.iso885915': 'nn_NO.ISO8859-15',
    'nn_no@euro': 'nn_NO.ISO8859-15',
    'no': 'no_NO.ISO8859-1',
    'no@nynorsk': 'ny_NO.ISO8859-1',
    'no_no': 'no_NO.ISO8859-1',
    'no_no.88591': 'no_NO.ISO8859-1',
    'no_no.iso88591': 'no_NO.ISO8859-1',
    'no_no.iso885915': 'no_NO.ISO8859-15',
    'no_no@euro': 'no_NO.ISO8859-15',
    'norwegian': 'no_NO.ISO8859-1',
    'norwegian.iso88591': 'no_NO.ISO8859-1',
    'nr': 'nr_ZA.ISO8859-1',
    'nr_za': 'nr_ZA.ISO8859-1',
    'nr_za.iso88591': 'nr_ZA.ISO8859-1',
    'nso': 'nso_ZA.ISO8859-15',
    'nso_za': 'nso_ZA.ISO8859-15',
    'nso_za.iso885915': 'nso_ZA.ISO8859-15',
    'ny': 'ny_NO.ISO8859-1',
    'ny_no': 'ny_NO.ISO8859-1',
    'ny_no.88591': 'ny_NO.ISO8859-1',
    'ny_no.iso88591': 'ny_NO.ISO8859-1',
    'ny_no.iso885915': 'ny_NO.ISO8859-15',
    'ny_no@euro': 'ny_NO.ISO8859-15',
    'nynorsk': 'nn_NO.ISO8859-1',
    'oc': 'oc_FR.ISO8859-1',
    'oc_fr': 'oc_FR.ISO8859-1',
    'oc_fr.iso88591': 'oc_FR.ISO8859-1',
    'oc_fr.iso885915': 'oc_FR.ISO8859-15',
    'oc_fr@euro': 'oc_FR.ISO8859-15',
    'pa_in': 'pa_IN.UTF-8',
    'pd': 'pd_US.ISO8859-1',
    'pd_de': 'pd_DE.ISO8859-1',
    'pd_de.iso88591': 'pd_DE.ISO8859-1',
    'pd_de.iso885915': 'pd_DE.ISO8859-15',
    'pd_de@euro': 'pd_DE.ISO8859-15',
    'pd_us': 'pd_US.ISO8859-1',
    'pd_us.iso88591': 'pd_US.ISO8859-1',
    'pd_us.iso885915': 'pd_US.ISO8859-15',
    'pd_us@euro': 'pd_US.ISO8859-15',
    'ph': 'ph_PH.ISO8859-1',
    'ph_ph': 'ph_PH.ISO8859-1',
    'ph_ph.iso88591': 'ph_PH.ISO8859-1',
    'pl': 'pl_PL.ISO8859-2',
    'pl_pl': 'pl_PL.ISO8859-2',
    'pl_pl.iso88592': 'pl_PL.ISO8859-2',
    'polish': 'pl_PL.ISO8859-2',
    'portuguese': 'pt_PT.ISO8859-1',
    'portuguese.iso88591': 'pt_PT.ISO8859-1',
    'portuguese_brazil': 'pt_BR.ISO8859-1',
    'portuguese_brazil.8859': 'pt_BR.ISO8859-1',
    'posix': 'C',
    'posix-utf2': 'C',
    'pp': 'pp_AN.ISO8859-1',
    'pp_an': 'pp_AN.ISO8859-1',
    'pp_an.iso88591': 'pp_AN.ISO8859-1',
    'pt': 'pt_PT.ISO8859-1',
    'pt_br': 'pt_BR.ISO8859-1',
    'pt_br.88591': 'pt_BR.ISO8859-1',
    'pt_br.iso88591': 'pt_BR.ISO8859-1',
    'pt_br.iso885915': 'pt_BR.ISO8859-15',
    'pt_br@euro': 'pt_BR.ISO8859-15',
    'pt_pt': 'pt_PT.ISO8859-1',
    'pt_pt.88591': 'pt_PT.ISO8859-1',
    'pt_pt.iso88591': 'pt_PT.ISO8859-1',
    'pt_pt.iso885915': 'pt_PT.ISO8859-15',
    'pt_pt.iso885915@euro': 'pt_PT.ISO8859-15',
    'pt_pt.utf8@euro': 'pt_PT.UTF-8',
    'pt_pt@euro': 'pt_PT.ISO8859-15',
    'ro': 'ro_RO.ISO8859-2',
    'ro_ro': 'ro_RO.ISO8859-2',
    'ro_ro.iso88592': 'ro_RO.ISO8859-2',
    'romanian': 'ro_RO.ISO8859-2',
    'ru': 'ru_RU.ISO8859-5',
    'ru_ru': 'ru_RU.ISO8859-5',
    'ru_ru.cp1251': 'ru_RU.CP1251',
    'ru_ru.iso88595': 'ru_RU.ISO8859-5',
    'ru_ru.koi8r': 'ru_RU.KOI8-R',
    'ru_ru.microsoftcp1251': 'ru_RU.CP1251',
    'ru_ua': 'ru_UA.KOI8-U',
    'ru_ua.cp1251': 'ru_UA.CP1251',
    'ru_ua.koi8u': 'ru_UA.KOI8-U',
    'ru_ua.microsoftcp1251': 'ru_UA.CP1251',
    'rumanian': 'ro_RO.ISO8859-2',
    'russian': 'ru_RU.ISO8859-5',
    'rw': 'rw_RW.ISO8859-1',
    'rw_rw': 'rw_RW.ISO8859-1',
    'rw_rw.iso88591': 'rw_RW.ISO8859-1',
    'se_no': 'se_NO.UTF-8',
    'serbocroatian': 'sr_CS.ISO8859-2',
    'sh': 'sr_CS.ISO8859-2',
    'sh_hr': 'sh_HR.ISO8859-2',
    'sh_hr.iso88592': 'hr_HR.ISO8859-2',
    'sh_sp': 'sr_CS.ISO8859-2',
    'sh_yu': 'sr_CS.ISO8859-2',
    'si': 'si_LK.UTF-8',
    'si_lk': 'si_LK.UTF-8',
    'sinhala': 'si_LK.UTF-8',
    'sk': 'sk_SK.ISO8859-2',
    'sk_sk': 'sk_SK.ISO8859-2',
    'sk_sk.iso88592': 'sk_SK.ISO8859-2',
    'sl': 'sl_SI.ISO8859-2',
    'sl_cs': 'sl_CS.ISO8859-2',
    'sl_si': 'sl_SI.ISO8859-2',
    'sl_si.iso88592': 'sl_SI.ISO8859-2',
    'slovak': 'sk_SK.ISO8859-2',
    'slovene': 'sl_SI.ISO8859-2',
    'slovenian': 'sl_SI.ISO8859-2',
    'sp': 'sr_CS.ISO8859-5',
    'sp_yu': 'sr_CS.ISO8859-5',
    'spanish': 'es_ES.ISO8859-1',
    'spanish.iso88591': 'es_ES.ISO8859-1',
    'spanish_spain': 'es_ES.ISO8859-1',
    'spanish_spain.8859': 'es_ES.ISO8859-1',
    'sq': 'sq_AL.ISO8859-2',
    'sq_al': 'sq_AL.ISO8859-2',
    'sq_al.iso88592': 'sq_AL.ISO8859-2',
    'sr': 'sr_CS.ISO8859-5',
    'sr@cyrillic': 'sr_CS.ISO8859-5',
    'sr@latn': 'sr_CS.ISO8859-2',
    'sr_cs.iso88592': 'sr_CS.ISO8859-2',
    'sr_cs.iso88592@latn': 'sr_CS.ISO8859-2',
    'sr_cs.iso88595': 'sr_CS.ISO8859-5',
    'sr_cs.utf8@latn': 'sr_CS.UTF-8',
    'sr_cs@latn': 'sr_CS.ISO8859-2',
    'sr_sp': 'sr_CS.ISO8859-2',
    'sr_yu': 'sr_CS.ISO8859-5',
    'sr_yu.cp1251@cyrillic': 'sr_CS.CP1251',
    'sr_yu.iso88592': 'sr_CS.ISO8859-2',
    'sr_yu.iso88595': 'sr_CS.ISO8859-5',
    'sr_yu.iso88595@cyrillic': 'sr_CS.ISO8859-5',
    'sr_yu.microsoftcp1251@cyrillic': 'sr_CS.CP1251',
    'sr_yu.utf8@cyrillic': 'sr_CS.UTF-8',
    'sr_yu@cyrillic': 'sr_CS.ISO8859-5',
    'ss': 'ss_ZA.ISO8859-1',
    'ss_za': 'ss_ZA.ISO8859-1',
    'ss_za.iso88591': 'ss_ZA.ISO8859-1',
    'st': 'st_ZA.ISO8859-1',
    'st_za': 'st_ZA.ISO8859-1',
    'st_za.iso88591': 'st_ZA.ISO8859-1',
    'sv': 'sv_SE.ISO8859-1',
    'sv_fi': 'sv_FI.ISO8859-1',
    'sv_fi.iso88591': 'sv_FI.ISO8859-1',
    'sv_fi.iso885915': 'sv_FI.ISO8859-15',
    'sv_fi.iso885915@euro': 'sv_FI.ISO8859-15',
    'sv_fi.utf8@euro': 'sv_FI.UTF-8',
    'sv_fi@euro': 'sv_FI.ISO8859-15',
    'sv_se': 'sv_SE.ISO8859-1',
    'sv_se.88591': 'sv_SE.ISO8859-1',
    'sv_se.iso88591': 'sv_SE.ISO8859-1',
    'sv_se.iso885915': 'sv_SE.ISO8859-15',
    'sv_se@euro': 'sv_SE.ISO8859-15',
    'swedish': 'sv_SE.ISO8859-1',
    'swedish.iso88591': 'sv_SE.ISO8859-1',
    'ta': 'ta_IN.TSCII-0',
    'ta_in': 'ta_IN.TSCII-0',
    'ta_in.tscii': 'ta_IN.TSCII-0',
    'ta_in.tscii0': 'ta_IN.TSCII-0',
    'tg': 'tg_TJ.KOI8-C',
    'tg_tj': 'tg_TJ.KOI8-C',
    'tg_tj.koi8c': 'tg_TJ.KOI8-C',
    'th': 'th_TH.ISO8859-11',
    'th_th': 'th_TH.ISO8859-11',
    'th_th.iso885911': 'th_TH.ISO8859-11',
    'th_th.tactis': 'th_TH.TIS620',
    'th_th.tis620': 'th_TH.TIS620',
    'thai': 'th_TH.ISO8859-11',
    'tl': 'tl_PH.ISO8859-1',
    'tl_ph': 'tl_PH.ISO8859-1',
    'tl_ph.iso88591': 'tl_PH.ISO8859-1',
    'tn': 'tn_ZA.ISO8859-15',
    'tn_za': 'tn_ZA.ISO8859-15',
    'tn_za.iso885915': 'tn_ZA.ISO8859-15',
    'tr': 'tr_TR.ISO8859-9',
    'tr_tr': 'tr_TR.ISO8859-9',
    'tr_tr.iso88599': 'tr_TR.ISO8859-9',
    'ts': 'ts_ZA.ISO8859-1',
    'ts_za': 'ts_ZA.ISO8859-1',
    'ts_za.iso88591': 'ts_ZA.ISO8859-1',
    'tt': 'tt_RU.TATAR-CYR',
    'tt_ru': 'tt_RU.TATAR-CYR',
    'tt_ru.koi8c': 'tt_RU.KOI8-C',
    'tt_ru.tatarcyr': 'tt_RU.TATAR-CYR',
    'turkish': 'tr_TR.ISO8859-9',
    'turkish.iso88599': 'tr_TR.ISO8859-9',
    'uk': 'uk_UA.KOI8-U',
    'uk_ua': 'uk_UA.KOI8-U',
    'uk_ua.cp1251': 'uk_UA.CP1251',
    'uk_ua.iso88595': 'uk_UA.ISO8859-5',
    'uk_ua.koi8u': 'uk_UA.KOI8-U',
    'uk_ua.microsoftcp1251': 'uk_UA.CP1251',
    'univ': 'en_US.utf',
    'universal': 'en_US.utf',
    'universal.utf8@ucs4': 'en_US.UTF-8',
    'ur': 'ur_PK.CP1256',
    'ur_pk': 'ur_PK.CP1256',
    'ur_pk.cp1256': 'ur_PK.CP1256',
    'ur_pk.microsoftcp1256': 'ur_PK.CP1256',
    'uz': 'uz_UZ.UTF-8',
    'uz_uz': 'uz_UZ.UTF-8',
    'uz_uz.iso88591': 'uz_UZ.ISO8859-1',
    'uz_uz.utf8@cyrillic': 'uz_UZ.UTF-8',
    'uz_uz@cyrillic': 'uz_UZ.UTF-8',
    've': 've_ZA.UTF-8',
    've_za': 've_ZA.UTF-8',
    'vi': 'vi_VN.TCVN',
    'vi_vn': 'vi_VN.TCVN',
    'vi_vn.tcvn': 'vi_VN.TCVN',
    'vi_vn.tcvn5712': 'vi_VN.TCVN',
    'vi_vn.viscii': 'vi_VN.VISCII',
    'vi_vn.viscii111': 'vi_VN.VISCII',
    'wa': 'wa_BE.ISO8859-1',
    'wa_be': 'wa_BE.ISO8859-1',
    'wa_be.iso88591': 'wa_BE.ISO8859-1',
    'wa_be.iso885915': 'wa_BE.ISO8859-15',
    'wa_be.iso885915@euro': 'wa_BE.ISO8859-15',
    'wa_be@euro': 'wa_BE.ISO8859-15',
    'xh': 'xh_ZA.ISO8859-1',
    'xh_za': 'xh_ZA.ISO8859-1',
    'xh_za.iso88591': 'xh_ZA.ISO8859-1',
    'yi': 'yi_US.CP1255',
    'yi_us': 'yi_US.CP1255',
    'yi_us.cp1255': 'yi_US.CP1255',
    'yi_us.microsoftcp1255': 'yi_US.CP1255',
    'zh': 'zh_CN.eucCN',
    'zh_cn': 'zh_CN.gb2312',
    'zh_cn.big5': 'zh_TW.big5',
    'zh_cn.euc': 'zh_CN.eucCN',
    'zh_cn.gb18030': 'zh_CN.gb18030',
    'zh_cn.gb2312': 'zh_CN.gb2312',
    'zh_cn.gbk': 'zh_CN.gbk',
    'zh_hk': 'zh_HK.big5hkscs',
    'zh_hk.big5': 'zh_HK.big5',
    'zh_hk.big5hkscs': 'zh_HK.big5hkscs',
    'zh_tw': 'zh_TW.big5',
    'zh_tw.big5': 'zh_TW.big5',
    'zh_tw.euc': 'zh_TW.eucTW',
    'zh_tw.euctw': 'zh_TW.eucTW',
    'zu': 'zu_ZA.ISO8859-1',
    'zu_za': 'zu_ZA.ISO8859-1',
    'zu_za.iso88591': 'zu_ZA.ISO8859-1',
}

locale_encoding_alias = {
    '437': 'C',
    'ajec': 'eucJP',
    'ascii': 'ISO8859-1',
    'c': 'C',
    'en': 'ISO8859-1',
    'euc_jp': 'eucJP',
    'euc_kr': 'eucKR',
    'iso2022_jp': 'JIS7',
    'iso8859_1': 'ISO8859-1',
    'iso8859_10': 'ISO8859-10',
    'iso8859_11': 'ISO8859-11',
    'iso8859_13': 'ISO8859-13',
    'iso8859_14': 'ISO8859-14',
    'iso8859_15': 'ISO8859-15',
    'iso8859_2': 'ISO8859-2',
    'iso8859_3': 'ISO8859-3',
    'iso8859_4': 'ISO8859-4',
    'iso8859_5': 'ISO8859-5',
    'iso8859_6': 'ISO8859-6',
    'iso8859_7': 'ISO8859-7',
    'iso8859_8': 'ISO8859-8',
    'iso8859_9': 'ISO8859-9',
    'jis': 'JIS7',
    'jis7': 'JIS7',
    'koi8_r': 'KOI8-R',
    'koi8_u': 'KOI8-U',
    'latin_1': 'ISO8859-1',
    'shift_jis': 'SJIS',
    'tactis': 'TACTIS',
    'utf_8': 'UTF8',
}

windows_locale = {
    4: 'zh_CHS',
    1025: 'ar_SA',
    1026: 'bg_BG',
    1027: 'ca_ES',
    1028: 'zh_TW',
    1029: 'cs_CZ',
    1030: 'da_DK',
    1031: 'de_DE',
    1032: 'el_GR',
    1033: 'en_US',
    1034: 'es_ES',
    1035: 'fi_FI',
    1036: 'fr_FR',
    1037: 'he_IL',
    1038: 'hu_HU',
    1039: 'is_IS',
    1040: 'it_IT',
    1041: 'ja_JP',
    1042: 'ko_KR',
    1043: 'nl_NL',
    1044: 'nb_NO',
    1045: 'pl_PL',
    1046: 'pt_BR',
    1047: 'rm_CH',
    1048: 'ro_RO',
    1049: 'ru_RU',
    1050: 'hr_HR',
    1051: 'sk_SK',
    1052: 'sq_AL',
    1053: 'sv_SE',
    1054: 'th_TH',
    1055: 'tr_TR',
    1056: 'ur_PK',
    1057: 'id_ID',
    1058: 'uk_UA',
    1059: 'be_BY',
    1060: 'sl_SI',
    1061: 'et_EE',
    1062: 'lv_LV',
    1063: 'lt_LT',
    1065: 'fa_IR',
    1066: 'vi_VN',
    1067: 'hy_AM',
    1068: 'az_AZ',
    1069: 'eu_ES',
    1071: 'mk_MK',
    1074: 'tn_ZA',
    1076: 'xh_ZA',
    1077: 'zu_ZA',
    1078: 'af_ZA',
    1079: 'ka_GE',
    1080: 'fo_FO',
    1081: 'hi_IN',
    1082: 'mt_MT',
    1083: 'se_NO',
    1086: 'ms_MY',
    1087: 'kk_KZ',
    1088: 'ky_KG',
    1089: 'sw_KE',
    1091: 'uz_UZ',
    1092: 'tt_RU',
    1093: 'bn_IN',
    1094: 'pa_IN',
    1095: 'gu_IN',
    1096: 'or_IN',
    1097: 'ta_IN',
    1098: 'te_IN',
    1099: 'kn_IN',
    1100: 'ml_IN',
    1102: 'mr_IN',
    1103: 'sa_IN',
    1104: 'mn_MN',
    1106: 'cy_GB',
    1110: 'gl_ES',
    1111: 'kok_IN',
    1114: 'syr_SY',
    1117: 'iu_CA',
    1121: 'ne_NP',
    1122: 'fy_NL',
    1123: 'ps_AF',
    1124: 'fil_PH',
    1125: 'div_MV',
    1131: 'quz_BO',
    1132: 'ns_ZA',
    1134: 'lb_LU',
    1146: 'arn_CL',
    1148: 'moh_CA',
    1150: 'br_FR',
    1153: 'mi_NZ',
    1154: 'oc_FR',
    1164: 'gbz_AF',
    2049: 'ar_IQ',
    2052: 'zh_CN',
    2055: 'de_CH',
    2057: 'en_GB',
    2058: 'es_MX',
    2060: 'fr_BE',
    2064: 'it_CH',
    2067: 'nl_BE',
    2068: 'nn_NO',
    2070: 'pt_PT',
    2074: 'sr_SP',
    2077: 'sv_FI',
    2080: 'ur_IN',
    2092: 'az_AZ',
    2107: 'se_SE',
    2108: 'ga_IE',
    2110: 'ms_BN',
    2115: 'uz_UZ',
    2141: 'iu_CA',
    2155: 'quz_EC',
    3073: 'ar_EG',
    3076: 'zh_HK',
    3079: 'de_AT',
    3081: 'en_AU',
    3082: 'es_ES',
    3084: 'fr_CA',
    3098: 'sr_SP',
    3131: 'se_FI',
    3179: 'quz_PE',
    4097: 'ar_LY',
    4100: 'zh_SG',
    4103: 'de_LU',
    4105: 'en_CA',
    4106: 'es_GT',
    4108: 'fr_CH',
    4122: 'hr_BA',
    4155: 'smj_NO',
    5121: 'ar_DZ',
    5124: 'zh_MO',
    5127: 'de_LI',
    5129: 'en_NZ',
    5130: 'es_CR',
    5132: 'fr_LU',
    5146: 'bs_BA',
    5179: 'smj_SE',
    6145: 'ar_MA',
    6153: 'en_IE',
    6154: 'es_PA',
    6156: 'fr_MC',
    6170: 'sr_BA',
    6203: 'sma_NO',
    7169: 'ar_TN',
    7177: 'en_ZA',
    7178: 'es_DO',
    7194: 'sr_BA',
    7227: 'sma_SE',
    8193: 'ar_OM',
    8201: 'en_JA',
    8202: 'es_VE',
    8218: 'bs_BA',
    8251: 'sms_FI',
    9217: 'ar_YE',
    9225: 'en_CB',
    9226: 'es_CO',
    9275: 'smn_FI',
    10241: 'ar_SY',
    10249: 'en_BZ',
    10250: 'es_PE',
    11265: 'ar_JO',
    11273: 'en_TT',
    11274: 'es_AR',
    12289: 'ar_LB',
    12297: 'en_ZW',
    12298: 'es_EC',
    13313: 'ar_KW',
    13321: 'en_PH',
    13322: 'es_CL',
    14337: 'ar_AE',
    14346: 'es_UR',
    15361: 'ar_BH',
    15370: 'es_PY',
    16385: 'ar_QA',
    16394: 'es_BO',
    17418: 'es_SV',
    18442: 'es_HN',
    19466: 'es_NI',
    20490: 'es_PR',
    31748: 'zh_CHT',
}

_override_localeconv = {}

_percent_re = None # (!) real value is ''

__all__ = [
    'getlocale',
    'getdefaultlocale',
    'getpreferredencoding',
    'Error',
    'setlocale',
    'resetlocale',
    'localeconv',
    'strcoll',
    'strxfrm',
    'str',
    'atof',
    'atoi',
    'format',
    'format_string',
    'currency',
    'normalize',
    'LC_CTYPE',
    'LC_COLLATE',
    'LC_TIME',
    'LC_MONETARY',
    'LC_NUMERIC',
    'LC_ALL',
    'CHAR_MAX',
    'LC_MESSAGES',
]

