# encoding: utf-8
# module logging.__init__
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/logging/__init__.pyo by generator 1.99
"""
Logging package for Python. Based on PEP 282 and comments thereto in
comp.lang.python, and influenced by Apache's log4j system.

Should work under Python versions >= 1.5.2, except that source line
information is not available unless 'sys._getframe()' is.

Copyright (C) 2001-2008 Vinay Sajip. All Rights Reserved.

To use, simply 'import logging' and log away!
"""

# imports
import cStringIO as cStringIO # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/cStringIO.so
import atexit as atexit # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/atexit.pyc
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/string.pyc
import sys as sys # <module 'sys' (built-in)>
import codecs as codecs # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/codecs.pyc
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/types.pyc
import thread as thread # <module 'thread' (built-in)>
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/traceback.pyc
import threading as threading # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/threading.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

BASIC_FORMAT = '%(levelname)s:%(name)s:%(message)s'

CRITICAL = 50

DEBUG = 10

ERROR = 40

FATAL = 50

INFO = 20

logProcesses = 1
logThreads = 1

NOTSET = 0

raiseExceptions = 1

WARN = 30
WARNING = 30

_lock = None

_srcfile = '/System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/logging/__init__.py'
_startTime = 1322565372.3316219

__author__ = 'Vinay Sajip <vinay_sajip@red-dove.com>'

__date__ = '24 January 2008'

__status__ = 'production'

__version__ = '0.5.0.5'

# functions

def addLevelName(level, levelName): # reliably restored by inspect
    """
    Associate 'levelName' with 'level'.
    
        This is used when converting levels to text during message formatting.
    """
    pass


def basicConfig(**kwargs): # reliably restored by inspect
    """
    Do basic configuration for the logging system.
    
        This function does nothing if the root logger already has handlers
        configured. It is a convenience method intended for use by simple scripts
        to do one-shot configuration of the logging package.
    
        The default behaviour is to create a StreamHandler which writes to
        sys.stderr, set a formatter using the BASIC_FORMAT format string, and
        add the handler to the root logger.
    
        A number of optional keyword arguments may be specified, which can alter
        the default behaviour.
    
        filename  Specifies that a FileHandler be created, using the specified
                  filename, rather than a StreamHandler.
        filemode  Specifies the mode to open the file, if filename is specified
                  (if filemode is unspecified, it defaults to 'a').
        format    Use the specified format string for the handler.
        datefmt   Use the specified date/time format.
        level     Set the root logger level to the specified level.
        stream    Use the specified stream to initialize the StreamHandler. Note
                  that this argument is incompatible with 'filename' - if both
                  are present, 'stream' is ignored.
    
        Note that you could specify a stream created using open(filename, mode)
        rather than passing the filename and mode in. However, it should be
        remembered that StreamHandler does not close its stream (since it may be
        using sys.stdout or sys.stderr), whereas FileHandler closes its stream
        when the handler is closed.
    """
    pass


def critical(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'CRITICAL' on the root logger. """
    pass


def currentframe(): # reliably restored by inspect
    # no doc
    pass


def debug(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'DEBUG' on the root logger. """
    pass


def disable(level): # reliably restored by inspect
    """ Disable all logging calls less severe than 'level'. """
    pass


def error(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'ERROR' on the root logger. """
    pass


def exception(msg, *args): # reliably restored by inspect
    """
    Log a message with severity 'ERROR' on the root logger,
        with exception information.
    """
    pass


def fatal(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'CRITICAL' on the root logger. """
    pass


def getLevelName(level): # reliably restored by inspect
    """
    Return the textual representation of logging level 'level'.
    
        If the level is one of the predefined levels (CRITICAL, ERROR, WARNING,
        INFO, DEBUG) then you get the corresponding string. If you have
        associated levels with names using addLevelName then the name you have
        associated with 'level' is returned.
    
        If a numeric value corresponding to one of the defined levels is passed
        in, the corresponding string representation is returned.
    
        Otherwise, the string "Level %s" % level is returned.
    """
    pass


def getLogger(name=None): # reliably restored by inspect
    """
    Return a logger with the specified name, creating it if necessary.
    
        If no name is specified, return the root logger.
    """
    pass


def getLoggerClass(): # reliably restored by inspect
    """ Return the class to be used when instantiating a logger. """
    pass


def info(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'INFO' on the root logger. """
    pass


def log(level, msg, *args, **kwargs): # reliably restored by inspect
    """ Log 'msg % args' with the integer severity 'level' on the root logger. """
    pass


def makeLogRecord(dict): # reliably restored by inspect
    """
    Make a LogRecord whose attributes are defined by the specified dictionary,
        This function is useful for converting a logging event received over
        a socket connection (which is sent as a dictionary) into a LogRecord
        instance.
    """
    pass


def setLoggerClass(klass): # reliably restored by inspect
    """
    Set the class to be used when instantiating a logger. The class should
        define __init__() such that only a name argument is required, and the
        __init__() should call Logger.__init__()
    """
    pass


def shutdown(handlerList='[]'): # reliably restored by inspect
    """
    Perform any cleanup actions in the logging system (e.g. flushing
        buffers).
    
        Should be called at application exit.
    """
    pass


def warn(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'WARNING' on the root logger. """
    pass


def warning(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'WARNING' on the root logger. """
    pass


def _acquireLock(): # reliably restored by inspect
    """
    Acquire the module-level lock for serializing access to shared data.
    
        This should be released with _releaseLock().
    """
    pass


def _releaseLock(): # reliably restored by inspect
    """ Release the module-level lock acquired by calling _acquireLock(). """
    pass


# no classes
# variables with complex values

BufferingFormatter = None # (!) real value is ''

FileHandler = None # (!) real value is ''

Filter = None # (!) real value is ''

Filterer = None # (!) real value is ''

Formatter = None # (!) real value is ''

Handler = None # (!) real value is ''

Logger = None # (!) forward: _loggerClass, real value is ''

LoggerAdapter = None # (!) real value is ''

LogRecord = None # (!) real value is ''

Manager = None # (!) real value is ''

PlaceHolder = None # (!) real value is ''

root = None # (!) real value is ''

RootLogger = None # (!) real value is ''

StreamHandler = None # (!) real value is ''

_defaultFormatter = None # (!) real value is ''

_handlerList = []

_handlers = {}

_levelNames = {
    0: 'NOTSET',
    10: 'DEBUG',
    20: 'INFO',
    30: 'WARNING',
    40: 'ERROR',
    50: 'CRITICAL',
    'CRITICAL': 50,
    'DEBUG': 10,
    'ERROR': 40,
    'INFO': 20,
    'NOTSET': 0,
    'WARN': 30,
    'WARNING': 30,
}

_loggerClass = None # (!) real value is ''

__all__ = [
    'BASIC_FORMAT',
    'BufferingFormatter',
    'CRITICAL',
    'DEBUG',
    'ERROR',
    'FATAL',
    'FileHandler',
    'Filter',
    'Filterer',
    'Formatter',
    'Handler',
    'INFO',
    'LogRecord',
    'Logger',
    'Manager',
    'NOTSET',
    'PlaceHolder',
    'RootLogger',
    'StreamHandler',
    'WARN',
    'WARNING',
]

