# encoding: utf-8
# module pickletools
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/pickletools.pyo by generator 1.99
"""
"Executable documentation" for the pickle module.

Extensive comments about the pickle protocols and pickle-machine opcodes
can be found here.  Some functions meant for external use:

genops(pickle)
   Generate all the opcodes in a pickle, as (opcode, arg, position) triples.

dis(pickle, out=None, memo=None, indentlevel=4)
   Print a symbolic disassembly of a pickle.
"""

# imports
from _struct import _unpack


# Variables with simple values

TAKEN_FROM_ARGUMENT1 = -2
TAKEN_FROM_ARGUMENT4 = -3

UP_TO_NEWLINE = -1

_dis_test = '\n>>> import pickle\n>>> x = [1, 2, (3, 4), {\'abc\': u"def"}]\n>>> pkl = pickle.dumps(x, 0)\n>>> dis(pkl)\n    0: (    MARK\n    1: l        LIST       (MARK at 0)\n    2: p    PUT        0\n    5: I    INT        1\n    8: a    APPEND\n    9: I    INT        2\n   12: a    APPEND\n   13: (    MARK\n   14: I        INT        3\n   17: I        INT        4\n   20: t        TUPLE      (MARK at 13)\n   21: p    PUT        1\n   24: a    APPEND\n   25: (    MARK\n   26: d        DICT       (MARK at 25)\n   27: p    PUT        2\n   30: S    STRING     \'abc\'\n   37: p    PUT        3\n   40: V    UNICODE    u\'def\'\n   45: p    PUT        4\n   48: s    SETITEM\n   49: a    APPEND\n   50: .    STOP\nhighest protocol among opcodes = 0\n\nTry again with a "binary" pickle.\n\n>>> pkl = pickle.dumps(x, 1)\n>>> dis(pkl)\n    0: ]    EMPTY_LIST\n    1: q    BINPUT     0\n    3: (    MARK\n    4: K        BININT1    1\n    6: K        BININT1    2\n    8: (        MARK\n    9: K            BININT1    3\n   11: K            BININT1    4\n   13: t            TUPLE      (MARK at 8)\n   14: q        BINPUT     1\n   16: }        EMPTY_DICT\n   17: q        BINPUT     2\n   19: U        SHORT_BINSTRING \'abc\'\n   24: q        BINPUT     3\n   26: X        BINUNICODE u\'def\'\n   34: q        BINPUT     4\n   36: s        SETITEM\n   37: e        APPENDS    (MARK at 3)\n   38: .    STOP\nhighest protocol among opcodes = 1\n\nExercise the INST/OBJ/BUILD family.\n\n>>> import random\n>>> dis(pickle.dumps(random.random, 0))\n    0: c    GLOBAL     \'random random\'\n   15: p    PUT        0\n   18: .    STOP\nhighest protocol among opcodes = 0\n\n>>> from pickletools import _Example\n>>> x = [_Example(42)] * 2\n>>> dis(pickle.dumps(x, 0))\n    0: (    MARK\n    1: l        LIST       (MARK at 0)\n    2: p    PUT        0\n    5: (    MARK\n    6: i        INST       \'pickletools _Example\' (MARK at 5)\n   28: p    PUT        1\n   31: (    MARK\n   32: d        DICT       (MARK at 31)\n   33: p    PUT        2\n   36: S    STRING     \'value\'\n   45: p    PUT        3\n   48: I    INT        42\n   52: s    SETITEM\n   53: b    BUILD\n   54: a    APPEND\n   55: g    GET        1\n   58: a    APPEND\n   59: .    STOP\nhighest protocol among opcodes = 0\n\n>>> dis(pickle.dumps(x, 1))\n    0: ]    EMPTY_LIST\n    1: q    BINPUT     0\n    3: (    MARK\n    4: (        MARK\n    5: c            GLOBAL     \'pickletools _Example\'\n   27: q            BINPUT     1\n   29: o            OBJ        (MARK at 4)\n   30: q        BINPUT     2\n   32: }        EMPTY_DICT\n   33: q        BINPUT     3\n   35: U        SHORT_BINSTRING \'value\'\n   42: q        BINPUT     4\n   44: K        BININT1    42\n   46: s        SETITEM\n   47: b        BUILD\n   48: h        BINGET     2\n   50: e        APPENDS    (MARK at 3)\n   51: .    STOP\nhighest protocol among opcodes = 1\n\nTry "the canonical" recursive-object test.\n\n>>> L = []\n>>> T = L,\n>>> L.append(T)\n>>> L[0] is T\nTrue\n>>> T[0] is L\nTrue\n>>> L[0][0] is L\nTrue\n>>> T[0][0] is T\nTrue\n>>> dis(pickle.dumps(L, 0))\n    0: (    MARK\n    1: l        LIST       (MARK at 0)\n    2: p    PUT        0\n    5: (    MARK\n    6: g        GET        0\n    9: t        TUPLE      (MARK at 5)\n   10: p    PUT        1\n   13: a    APPEND\n   14: .    STOP\nhighest protocol among opcodes = 0\n\n>>> dis(pickle.dumps(L, 1))\n    0: ]    EMPTY_LIST\n    1: q    BINPUT     0\n    3: (    MARK\n    4: h        BINGET     0\n    6: t        TUPLE      (MARK at 3)\n    7: q    BINPUT     1\n    9: a    APPEND\n   10: .    STOP\nhighest protocol among opcodes = 1\n\nNote that, in the protocol 0 pickle of the recursive tuple, the disassembler\nhas to emulate the stack in order to realize that the POP opcode at 16 gets\nrid of the MARK at 0.\n\n>>> dis(pickle.dumps(T, 0))\n    0: (    MARK\n    1: (        MARK\n    2: l            LIST       (MARK at 1)\n    3: p        PUT        0\n    6: (        MARK\n    7: g            GET        0\n   10: t            TUPLE      (MARK at 6)\n   11: p        PUT        1\n   14: a        APPEND\n   15: 0        POP\n   16: 0        POP        (MARK at 0)\n   17: g    GET        1\n   20: .    STOP\nhighest protocol among opcodes = 0\n\n>>> dis(pickle.dumps(T, 1))\n    0: (    MARK\n    1: ]        EMPTY_LIST\n    2: q        BINPUT     0\n    4: (        MARK\n    5: h            BINGET     0\n    7: t            TUPLE      (MARK at 4)\n    8: q        BINPUT     1\n   10: a        APPEND\n   11: 1        POP_MARK   (MARK at 0)\n   12: h    BINGET     1\n   14: .    STOP\nhighest protocol among opcodes = 1\n\nTry protocol 2.\n\n>>> dis(pickle.dumps(L, 2))\n    0: \\x80 PROTO      2\n    2: ]    EMPTY_LIST\n    3: q    BINPUT     0\n    5: h    BINGET     0\n    7: \\x85 TUPLE1\n    8: q    BINPUT     1\n   10: a    APPEND\n   11: .    STOP\nhighest protocol among opcodes = 2\n\n>>> dis(pickle.dumps(T, 2))\n    0: \\x80 PROTO      2\n    2: ]    EMPTY_LIST\n    3: q    BINPUT     0\n    5: h    BINGET     0\n    7: \\x85 TUPLE1\n    8: q    BINPUT     1\n   10: a    APPEND\n   11: 0    POP\n   12: h    BINGET     1\n   14: .    STOP\nhighest protocol among opcodes = 2\n'

_memo_test = '\n>>> import pickle\n>>> from StringIO import StringIO\n>>> f = StringIO()\n>>> p = pickle.Pickler(f, 2)\n>>> x = [1, 2, 3]\n>>> p.dump(x)\n>>> p.dump(x)\n>>> f.seek(0)\n>>> memo = {}\n>>> dis(f, memo=memo)\n    0: \\x80 PROTO      2\n    2: ]    EMPTY_LIST\n    3: q    BINPUT     0\n    5: (    MARK\n    6: K        BININT1    1\n    8: K        BININT1    2\n   10: K        BININT1    3\n   12: e        APPENDS    (MARK at 5)\n   13: .    STOP\nhighest protocol among opcodes = 2\n>>> dis(f, memo=memo)\n   14: \\x80 PROTO      2\n   16: h    BINGET     0\n   18: .    STOP\nhighest protocol among opcodes = 2\n'

# functions

def decode_long(data): # reliably restored by inspect
    """
    Decode a long from a two's complement little-endian binary string.
    
        >>> decode_long('')
        0L
        >>> decode_long("\xff\x00")
        255L
        >>> decode_long("\xff\x7f")
        32767L
        >>> decode_long("\x00\xff")
        -256L
        >>> decode_long("\x00\x80")
        -32768L
        >>> decode_long("\x80")
        -128L
        >>> decode_long("\x7f")
        127L
    """
    pass


def dis(pickle, out=None, memo=None, indentlevel=4): # reliably restored by inspect
    """
    Produce a symbolic disassembly of a pickle.
    
        'pickle' is a file-like object, or string, containing a (at least one)
        pickle.  The pickle is disassembled from the current position, through
        the first STOP opcode encountered.
    
        Optional arg 'out' is a file-like object to which the disassembly is
        printed.  It defaults to sys.stdout.
    
        Optional arg 'memo' is a Python dict, used as the pickle's memo.  It
        may be mutated by dis(), if the pickle contains PUT or BINPUT opcodes.
        Passing the same memo object to another dis() call then allows disassembly
        to proceed across multiple pickles that were all created by the same
        pickler with the same memo.  Ordinarily you don't need to worry about this.
    
        Optional arg indentlevel is the number of blanks by which to indent
        a new MARK level.  It defaults to 4.
    
        In addition to printing the disassembly, some sanity checks are made:
    
        + All embedded opcode arguments "make sense".
    
        + Explicit and implicit pop operations have enough items on the stack.
    
        + When an opcode implicitly refers to a markobject, a markobject is
          actually on the stack.
    
        + A memo entry isn't referenced before it's defined.
    
        + The markobject isn't stored in the memo.
    
        + A memo entry isn't redefined.
    """
    pass


def genops(pickle): # reliably restored by inspect
    """
    Generate all the opcodes in a pickle.
    
        'pickle' is a file-like object, or string, containing the pickle.
    
        Each opcode in the pickle is generated, from the current pickle position,
        stopping after a STOP opcode is delivered.  A triple is generated for
        each opcode:
    
            opcode, arg, pos
    
        opcode is an OpcodeInfo record, describing the current opcode.
    
        If the opcode has an argument embedded in the pickle, arg is its decoded
        value, as a Python object.  If the opcode doesn't have an argument, arg
        is None.
    
        If the pickle has a tell() method, pos was the value of pickle.tell()
        before reading the current opcode.  If the pickle is a string object,
        it's wrapped in a StringIO object, and the latter's tell() result is
        used.  Else (the pickle doesn't have a tell(), and it's not obvious how
        to query its current position) pos is None.
    """
    pass


def optimize(p): # reliably restored by inspect
    """ Optimize a pickle string by removing unused PUT opcodes """
    pass


def read_decimalnl_long(f): # reliably restored by inspect
    """
    >>> import StringIO
    
        >>> read_decimalnl_long(StringIO.StringIO("1234\n56"))
        Traceback (most recent call last):
        ...
        ValueError: trailing 'L' required in '1234'
    
        Someday the trailing 'L' will probably go away from this output.
    
        >>> read_decimalnl_long(StringIO.StringIO("1234L\n56"))
        1234L
    
        >>> read_decimalnl_long(StringIO.StringIO("123456789012345678901234L\n6"))
        123456789012345678901234L
    """
    pass


def read_decimalnl_short(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_decimalnl_short(StringIO.StringIO("1234\n56"))
        1234
    
        >>> read_decimalnl_short(StringIO.StringIO("1234L\n56"))
        Traceback (most recent call last):
        ...
        ValueError: trailing 'L' not allowed in '1234L'
    """
    pass


def read_float8(f): # reliably restored by inspect
    """
    >>> import StringIO, struct
        >>> raw = struct.pack(">d", -1.25)
        >>> raw
        '\xbf\xf4\x00\x00\x00\x00\x00\x00'
        >>> read_float8(StringIO.StringIO(raw + "\n"))
        -1.25
    """
    pass


def read_floatnl(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_floatnl(StringIO.StringIO("-1.25\n6"))
        -1.25
    """
    pass


def read_int4(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_int4(StringIO.StringIO('\xff\x00\x00\x00'))
        255
        >>> read_int4(StringIO.StringIO('\x00\x00\x00\x80')) == -(2**31)
        True
    """
    pass


def read_long1(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_long1(StringIO.StringIO("\x00"))
        0L
        >>> read_long1(StringIO.StringIO("\x02\xff\x00"))
        255L
        >>> read_long1(StringIO.StringIO("\x02\xff\x7f"))
        32767L
        >>> read_long1(StringIO.StringIO("\x02\x00\xff"))
        -256L
        >>> read_long1(StringIO.StringIO("\x02\x00\x80"))
        -32768L
    """
    pass


def read_long4(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_long4(StringIO.StringIO("\x02\x00\x00\x00\xff\x00"))
        255L
        >>> read_long4(StringIO.StringIO("\x02\x00\x00\x00\xff\x7f"))
        32767L
        >>> read_long4(StringIO.StringIO("\x02\x00\x00\x00\x00\xff"))
        -256L
        >>> read_long4(StringIO.StringIO("\x02\x00\x00\x00\x00\x80"))
        -32768L
        >>> read_long1(StringIO.StringIO("\x00\x00\x00\x00"))
        0L
    """
    pass


def read_string1(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_string1(StringIO.StringIO("\x00"))
        ''
        >>> read_string1(StringIO.StringIO("\x03abcdef"))
        'abc'
    """
    pass


def read_string4(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_string4(StringIO.StringIO("\x00\x00\x00\x00abc"))
        ''
        >>> read_string4(StringIO.StringIO("\x03\x00\x00\x00abcdef"))
        'abc'
        >>> read_string4(StringIO.StringIO("\x00\x00\x00\x03abcdef"))
        Traceback (most recent call last):
        ...
        ValueError: expected 50331648 bytes in a string4, but only 6 remain
    """
    pass


def read_stringnl(f, decode=True, stripquotes=True): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_stringnl(StringIO.StringIO("'abcd'\nefg\n"))
        'abcd'
    
        >>> read_stringnl(StringIO.StringIO("\n"))
        Traceback (most recent call last):
        ...
        ValueError: no string quotes around ''
    
        >>> read_stringnl(StringIO.StringIO("\n"), stripquotes=False)
        ''
    
        >>> read_stringnl(StringIO.StringIO("''\n"))
        ''
    
        >>> read_stringnl(StringIO.StringIO('"abcd"'))
        Traceback (most recent call last):
        ...
        ValueError: no newline found when trying to read stringnl
    
        Embedded escapes are undone in the result.
        >>> read_stringnl(StringIO.StringIO(r"'a\n\\b\x00c\td'" + "\n'e'"))
        'a\n\\b\x00c\td'
    """
    pass


def read_stringnl_noescape(f): # reliably restored by inspect
    # no doc
    pass


def read_stringnl_noescape_pair(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_stringnl_noescape_pair(StringIO.StringIO("Queue\nEmpty\njunk"))
        'Queue Empty'
    """
    pass


def read_uint1(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_uint1(StringIO.StringIO('\xff'))
        255
    """
    pass


def read_uint2(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_uint2(StringIO.StringIO('\xff\x00'))
        255
        >>> read_uint2(StringIO.StringIO('\xff\xff'))
        65535
    """
    pass


def read_unicodestring4(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> s = u'abcd\uabcd'
        >>> enc = s.encode('utf-8')
        >>> enc
        'abcd\xea\xaf\x8d'
        >>> n = chr(len(enc)) + chr(0) * 3  # little-endian 4-byte length
        >>> t = read_unicodestring4(StringIO.StringIO(n + enc + 'junk'))
        >>> s == t
        True
    
        >>> read_unicodestring4(StringIO.StringIO(n + enc[:-1]))
        Traceback (most recent call last):
        ...
        ValueError: expected 7 bytes in a unicodestring4, but only 6 remain
    """
    pass


def read_unicodestringnl(f): # reliably restored by inspect
    """
    >>> import StringIO
        >>> read_unicodestringnl(StringIO.StringIO("abc\uabcd\njunk"))
        u'abc\uabcd'
    """
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# classes

class ArgumentDescriptor(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    doc = property(lambda self: object()) # default
    n = property(lambda self: object()) # default
    name = property(lambda self: object()) # default
    reader = property(lambda self: object()) # default

    __slots__ = (
        'name',
        'n',
        'reader',
        'doc',
    )


class OpcodeInfo(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    arg = property(lambda self: object()) # default
    code = property(lambda self: object()) # default
    doc = property(lambda self: object()) # default
    name = property(lambda self: object()) # default
    proto = property(lambda self: object()) # default
    stack_after = property(lambda self: object()) # default
    stack_before = property(lambda self: object()) # default

    __slots__ = (
        'name',
        'code',
        'arg',
        'stack_before',
        'stack_after',
        'proto',
        'doc',
    )


class StackObject(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    doc = property(lambda self: object()) # default
    name = property(lambda self: object()) # default
    obtype = property(lambda self: object()) # default

    __slots__ = (
        'name',
        'obtype',
        'doc',
    )


# variables with complex values

anyobject = None # (!) real value is ''

code2op = {
    '(': None, # (!) real value is ''
    ')': None, # (!) real value is ''
    '.': None, # (!) real value is ''
    '0': None, # (!) real value is ''
    '1': None, # (!) real value is ''
    '2': None, # (!) real value is ''
    'F': None, # (!) real value is ''
    'G': None, # (!) real value is ''
    'I': None, # (!) real value is ''
    'J': None, # (!) real value is ''
    'K': None, # (!) real value is ''
    'L': None, # (!) real value is ''
    'M': None, # (!) real value is ''
    'N': None, # (!) real value is ''
    'P': None, # (!) real value is ''
    'Q': None, # (!) real value is ''
    'R': None, # (!) real value is ''
    'S': None, # (!) real value is ''
    'T': None, # (!) real value is ''
    'U': None, # (!) real value is ''
    'V': None, # (!) real value is ''
    'X': None, # (!) real value is ''
    ']': None, # (!) real value is ''
    'a': None, # (!) real value is ''
    'b': None, # (!) real value is ''
    'c': None, # (!) real value is ''
    'd': None, # (!) real value is ''
    'e': None, # (!) real value is ''
    'g': None, # (!) real value is ''
    'h': None, # (!) real value is ''
    'i': None, # (!) real value is ''
    'j': None, # (!) real value is ''
    'l': None, # (!) real value is ''
    'o': None, # (!) real value is ''
    'p': None, # (!) real value is ''
    'q': None, # (!) real value is ''
    'r': None, # (!) real value is ''
    's': None, # (!) real value is ''
    't': None, # (!) real value is ''
    'u': None, # (!) real value is ''
    '}': None, # (!) real value is ''
    '\x80': None, # (!) real value is ''
    '\x81': None, # (!) real value is ''
    '\x82': None, # (!) real value is ''
    '\x83': None, # (!) real value is ''
    '\x84': None, # (!) real value is ''
    '\x85': None, # (!) real value is ''
    '\x86': None, # (!) real value is ''
    '\x87': None, # (!) real value is ''
    '\x88': None, # (!) real value is ''
    '\x89': None, # (!) real value is ''
    '\x8a': None, # (!) real value is ''
    '\x8b': None, # (!) real value is ''
}

decimalnl_long = None # (!) real value is ''

decimalnl_short = None # (!) real value is ''

float8 = None # (!) real value is ''

floatnl = None # (!) real value is ''

int4 = None # (!) real value is ''

long1 = None # (!) real value is ''

long4 = None # (!) real value is ''

markobject = None # (!) real value is ''

opcodes = [
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
    None, # (!) real value is ''
]

pybool = None # (!) real value is ''

pydict = None # (!) real value is ''

pyfloat = None # (!) real value is ''

pyint = None # (!) real value is ''

pyinteger_or_bool = None # (!) real value is ''

pylist = None # (!) real value is ''

pylong = None # (!) real value is ''

pynone = None # (!) real value is ''

pystring = None # (!) real value is ''

pytuple = None # (!) real value is ''

pyunicode = None # (!) real value is ''

stackslice = None # (!) real value is ''

string1 = None # (!) real value is ''

string4 = None # (!) real value is ''

stringnl = None # (!) real value is ''

stringnl_noescape = None # (!) real value is ''

stringnl_noescape_pair = None # (!) real value is ''

uint1 = None # (!) real value is ''

uint2 = None # (!) real value is ''

unicodestring4 = None # (!) real value is ''

unicodestringnl = None # (!) real value is ''

_Example = None # (!) real value is ''

__all__ = [
    'dis',
    'genops',
    'optimize',
]

__test__ = {
    'disassembler_memo_test': '\n>>> import pickle\n>>> from StringIO import StringIO\n>>> f = StringIO()\n>>> p = pickle.Pickler(f, 2)\n>>> x = [1, 2, 3]\n>>> p.dump(x)\n>>> p.dump(x)\n>>> f.seek(0)\n>>> memo = {}\n>>> dis(f, memo=memo)\n    0: \\x80 PROTO      2\n    2: ]    EMPTY_LIST\n    3: q    BINPUT     0\n    5: (    MARK\n    6: K        BININT1    1\n    8: K        BININT1    2\n   10: K        BININT1    3\n   12: e        APPENDS    (MARK at 5)\n   13: .    STOP\nhighest protocol among opcodes = 2\n>>> dis(f, memo=memo)\n   14: \\x80 PROTO      2\n   16: h    BINGET     0\n   18: .    STOP\nhighest protocol among opcodes = 2\n',
    'disassembler_test': '\n>>> import pickle\n>>> x = [1, 2, (3, 4), {\'abc\': u"def"}]\n>>> pkl = pickle.dumps(x, 0)\n>>> dis(pkl)\n    0: (    MARK\n    1: l        LIST       (MARK at 0)\n    2: p    PUT        0\n    5: I    INT        1\n    8: a    APPEND\n    9: I    INT        2\n   12: a    APPEND\n   13: (    MARK\n   14: I        INT        3\n   17: I        INT        4\n   20: t        TUPLE      (MARK at 13)\n   21: p    PUT        1\n   24: a    APPEND\n   25: (    MARK\n   26: d        DICT       (MARK at 25)\n   27: p    PUT        2\n   30: S    STRING     \'abc\'\n   37: p    PUT        3\n   40: V    UNICODE    u\'def\'\n   45: p    PUT        4\n   48: s    SETITEM\n   49: a    APPEND\n   50: .    STOP\nhighest protocol among opcodes = 0\n\nTry again with a "binary" pickle.\n\n>>> pkl = pickle.dumps(x, 1)\n>>> dis(pkl)\n    0: ]    EMPTY_LIST\n    1: q    BINPUT     0\n    3: (    MARK\n    4: K        BININT1    1\n    6: K        BININT1    2\n    8: (        MARK\n    9: K            BININT1    3\n   11: K            BININT1    4\n   13: t            TUPLE      (MARK at 8)\n   14: q        BINPUT     1\n   16: }        EMPTY_DICT\n   17: q        BINPUT     2\n   19: U        SHORT_BINSTRING \'abc\'\n   24: q        BINPUT     3\n   26: X        BINUNICODE u\'def\'\n   34: q        BINPUT     4\n   36: s        SETITEM\n   37: e        APPENDS    (MARK at 3)\n   38: .    STOP\nhighest protocol among opcodes = 1\n\nExercise the INST/OBJ/BUILD family.\n\n>>> import random\n>>> dis(pickle.dumps(random.random, 0))\n    0: c    GLOBAL     \'random random\'\n   15: p    PUT        0\n   18: .    STOP\nhighest protocol among opcodes = 0\n\n>>> from pickletools import _Example\n>>> x = [_Example(42)] * 2\n>>> dis(pickle.dumps(x, 0))\n    0: (    MARK\n    1: l        LIST       (MARK at 0)\n    2: p    PUT        0\n    5: (    MARK\n    6: i        INST       \'pickletools _Example\' (MARK at 5)\n   28: p    PUT        1\n   31: (    MARK\n   32: d        DICT       (MARK at 31)\n   33: p    PUT        2\n   36: S    STRING     \'value\'\n   45: p    PUT        3\n   48: I    INT        42\n   52: s    SETITEM\n   53: b    BUILD\n   54: a    APPEND\n   55: g    GET        1\n   58: a    APPEND\n   59: .    STOP\nhighest protocol among opcodes = 0\n\n>>> dis(pickle.dumps(x, 1))\n    0: ]    EMPTY_LIST\n    1: q    BINPUT     0\n    3: (    MARK\n    4: (        MARK\n    5: c            GLOBAL     \'pickletools _Example\'\n   27: q            BINPUT     1\n   29: o            OBJ        (MARK at 4)\n   30: q        BINPUT     2\n   32: }        EMPTY_DICT\n   33: q        BINPUT     3\n   35: U        SHORT_BINSTRING \'value\'\n   42: q        BINPUT     4\n   44: K        BININT1    42\n   46: s        SETITEM\n   47: b        BUILD\n   48: h        BINGET     2\n   50: e        APPENDS    (MARK at 3)\n   51: .    STOP\nhighest protocol among opcodes = 1\n\nTry "the canonical" recursive-object test.\n\n>>> L = []\n>>> T = L,\n>>> L.append(T)\n>>> L[0] is T\nTrue\n>>> T[0] is L\nTrue\n>>> L[0][0] is L\nTrue\n>>> T[0][0] is T\nTrue\n>>> dis(pickle.dumps(L, 0))\n    0: (    MARK\n    1: l        LIST       (MARK at 0)\n    2: p    PUT        0\n    5: (    MARK\n    6: g        GET        0\n    9: t        TUPLE      (MARK at 5)\n   10: p    PUT        1\n   13: a    APPEND\n   14: .    STOP\nhighest protocol among opcodes = 0\n\n>>> dis(pickle.dumps(L, 1))\n    0: ]    EMPTY_LIST\n    1: q    BINPUT     0\n    3: (    MARK\n    4: h        BINGET     0\n    6: t        TUPLE      (MARK at 3)\n    7: q    BINPUT     1\n    9: a    APPEND\n   10: .    STOP\nhighest protocol among opcodes = 1\n\nNote that, in the protocol 0 pickle of the recursive tuple, the disassembler\nhas to emulate the stack in order to realize that the POP opcode at 16 gets\nrid of the MARK at 0.\n\n>>> dis(pickle.dumps(T, 0))\n    0: (    MARK\n    1: (        MARK\n    2: l            LIST       (MARK at 1)\n    3: p        PUT        0\n    6: (        MARK\n    7: g            GET        0\n   10: t            TUPLE      (MARK at 6)\n   11: p        PUT        1\n   14: a        APPEND\n   15: 0        POP\n   16: 0        POP        (MARK at 0)\n   17: g    GET        1\n   20: .    STOP\nhighest protocol among opcodes = 0\n\n>>> dis(pickle.dumps(T, 1))\n    0: (    MARK\n    1: ]        EMPTY_LIST\n    2: q        BINPUT     0\n    4: (        MARK\n    5: h            BINGET     0\n    7: t            TUPLE      (MARK at 4)\n    8: q        BINPUT     1\n   10: a        APPEND\n   11: 1        POP_MARK   (MARK at 0)\n   12: h    BINGET     1\n   14: .    STOP\nhighest protocol among opcodes = 1\n\nTry protocol 2.\n\n>>> dis(pickle.dumps(L, 2))\n    0: \\x80 PROTO      2\n    2: ]    EMPTY_LIST\n    3: q    BINPUT     0\n    5: h    BINGET     0\n    7: \\x85 TUPLE1\n    8: q    BINPUT     1\n   10: a    APPEND\n   11: .    STOP\nhighest protocol among opcodes = 2\n\n>>> dis(pickle.dumps(T, 2))\n    0: \\x80 PROTO      2\n    2: ]    EMPTY_LIST\n    3: q    BINPUT     0\n    5: h    BINGET     0\n    7: \\x85 TUPLE1\n    8: q    BINPUT     1\n   10: a    APPEND\n   11: 0    POP\n   12: h    BINGET     1\n   14: .    STOP\nhighest protocol among opcodes = 2\n',
}

