# encoding: utf-8
# module pkgutil
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/pkgutil.pyo by generator 1.99
""" Utilities to support packages. """

# imports
import imp as imp # <module 'imp' (built-in)>
import zipimport as zipimport # <module 'zipimport' (built-in)>
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
from zipimport import zipimporter


# functions

def extend_path(path, name): # reliably restored by inspect
    """
    Extend a package's path.
    
        Intended use is to place the following code in a package's __init__.py:
    
            from pkgutil import extend_path
            __path__ = extend_path(__path__, __name__)
    
        This will add to the package's __path__ all subdirectories of
        directories on sys.path named after the package.  This is useful
        if one wants to distribute different parts of a single logical
        package as multiple directories.
    
        It also looks for *.pkg files beginning where * matches the name
        argument.  This feature is similar to *.pth files (see site.py),
        except that it doesn't special-case lines starting with 'import'.
        A *.pkg file is trusted at face value: apart from checking for
        duplicates, all entries found in a *.pkg file are added to the
        path, regardless of whether they are exist the filesystem.  (This
        is a feature.)
    
        If the input path is not a list (as is the case for frozen
        packages) it is returned unchanged.  The input path is not
        modified; an extended copy is returned.  Items are only appended
        to the copy at the end.
    
        It is assumed that sys.path is a sequence.  Items of sys.path that
        are not (unicode or 8-bit) strings referring to existing
        directories are ignored.  Unicode items of sys.path that cause
        errors when used as filenames may cause this function to raise an
        exception (in line with os.path.isdir() behavior).
    """
    pass


def find_loader(fullname): # reliably restored by inspect
    """
    Find a PEP 302 "loader" object for fullname
    
        If fullname contains dots, path must be the containing package's __path__.
        Returns None if the module cannot be found or imported. This function uses
        iter_importers(), and is thus subject to the same limitations regarding
        platform-specific special import locations such as the Windows registry.
    """
    pass


def get_data(package, resource): # reliably restored by inspect
    """
    Get a resource from a package.
    
        This is a wrapper round the PEP 302 loader get_data API. The package
        argument should be the name of a package, in standard module format
        (foo.bar). The resource argument should be in the form of a relative
        filename, using '/' as the path separator. The parent directory name '..'
        is not allowed, and nor is a rooted name (starting with a '/').
    
        The function returns a binary string, which is the contents of the
        specified resource.
    
        For packages located in the filesystem, which have already been imported,
        this is the rough equivalent of
    
            d = os.path.dirname(sys.modules[package].__file__)
            data = open(os.path.join(d, resource), 'rb').read()
    
        If the package cannot be located or loaded, or it uses a PEP 302 loader
        which does not support get_data(), then None is returned.
    """
    pass


def get_importer(path_item): # reliably restored by inspect
    """
    Retrieve a PEP 302 importer for the given path item
    
        The returned importer is cached in sys.path_importer_cache
        if it was newly created by a path hook.
    
        If there is no importer, a wrapper around the basic import
        machinery is returned. This wrapper is never inserted into
        the importer cache (None is inserted instead).
    
        The cache (or part of it) can be cleared manually if a
        rescan of sys.path_hooks is necessary.
    """
    pass


def get_loader(module_or_name): # reliably restored by inspect
    """
    Get a PEP 302 "loader" object for module_or_name
    
        If the module or package is accessible via the normal import
        mechanism, a wrapper around the relevant part of that machinery
        is returned.  Returns None if the module cannot be found or imported.
        If the named module is not already imported, its containing package
        (if any) is imported, in order to establish the package __path__.
    
        This function uses iter_importers(), and is thus subject to the same
        limitations regarding platform-specific special import locations such
        as the Windows registry.
    """
    pass


def iter_importers(fullname=None): # reliably restored by inspect
    """
    Yield PEP 302 importers for the given module name
    
        If fullname contains a '.', the importers will be for the package
        containing fullname, otherwise they will be importers for sys.meta_path,
        sys.path, and Python's "classic" import machinery, in that order.  If
        the named module is in a package, that package is imported as a side
        effect of invoking this function.
    
        Non PEP 302 mechanisms (e.g. the Windows registry) used by the
        standard import machinery to find files in alternative locations
        are partially supported, but are searched AFTER sys.path. Normally,
        these locations are searched BEFORE sys.path, preventing sys.path
        entries from shadowing them.
    
        For this to cause a visible difference in behaviour, there must
        be a module or package name that is accessible via both sys.path
        and one of the non PEP 302 file system mechanisms. In this case,
        the emulation will find the former version, while the builtin
        import mechanism will find the latter.
    
        Items of the following types can be affected by this discrepancy:
            imp.C_EXTENSION, imp.PY_SOURCE, imp.PY_COMPILED, imp.PKG_DIRECTORY
    """
    pass


def iter_importer_modules(*args, **kw): # reliably restored by inspect
    # no doc
    pass


def iter_modules(path=None, prefix=None): # reliably restored by inspect
    """
    Yields (module_loader, name, ispkg) for all submodules on path,
        or, if path is None, all top-level modules on sys.path.
    
        'path' should be either None or a list of paths to look for
        modules in.
    
        'prefix' is a string to output on the front of every module name
        on output.
    """
    pass


def iter_zipimport_modules(importer, prefix=None): # reliably restored by inspect
    # no doc
    pass


def read_code(stream): # reliably restored by inspect
    # no doc
    pass


def simplegeneric(func): # reliably restored by inspect
    """ Make a trivial single-dispatch generic function """
    pass


def walk_packages(path=None, prefix=None, onerror=None): # reliably restored by inspect
    """
    Yields (module_loader, name, ispkg) for all modules recursively
        on path, or, if path is None, all accessible modules.
    
        'path' should be either None or a list of paths to look for
        modules in.
    
        'prefix' is a string to output on the front of every module name
        on output.
    
        Note that this function must import all *packages* (NOT all
        modules!) on the given path, in order to access the __path__
        attribute to find submodules.
    
        'onerror' is a function which gets called with one argument (the
        name of the package which was being imported) if any exception
        occurs while trying to import a package.  If no onerror function is
        supplied, ImportErrors are caught and ignored, while all other
        exceptions are propagated, terminating the search.
    
        Examples:
    
        # list all modules python can access
        walk_packages()
    
        # list all submodules of ctypes
        walk_packages(ctypes.__path__, ctypes.__name__+'.')
    """
    pass


# classes

class ModuleType(object):
    """
    module(name[, doc])
    
    Create a module object.
    The name must be a string; the optional doc argument can have any type.
    """
    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, name, doc=None): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    __dict__ = None # (!) real value is ''


# variables with complex values

ImpImporter = None # (!) real value is ''

ImpLoader = None # (!) real value is ''

__all__ = [
    'get_importer',
    'iter_importers',
    'get_loader',
    'find_loader',
    'walk_packages',
    'iter_modules',
    'ImpImporter',
    'ImpLoader',
    'read_code',
    'extend_path',
]

