# encoding: utf-8
# module random
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/random.pyo by generator 1.99
"""
Random variable generators.

    integers
    --------
           uniform within range

    sequences
    ---------
           pick random element
           pick random sample
           generate random permutation

    distributions on the real line:
    ------------------------------
           uniform
           triangular
           normal (Gaussian)
           lognormal
           negative exponential
           gamma
           beta
           pareto
           Weibull

    distributions on the circle (angles 0 to 2pi)
    ---------------------------------------------
           circular uniform
           von Mises

General notes on the underlying Mersenne Twister core generator:

* The period is 2**19937-1.
* It is one of the most extensively tested generators in existence.
* Without a direct way to compute N steps forward, the semantics of
  jumpahead(n) are weakened to simply jump to another distant state and rely
  on the large period to avoid overlapping sequences.
* The random() method is implemented in C, executes in a single Python step,
  and is, therefore, threadsafe.
"""

# imports
import _random as _random # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/_random.so
from binascii import _hexlify

from math import _acos, _ceil, _cos, _exp, _log, _sin, _sqrt

from _warnings import _warn

import _random as ___random


# Variables with simple values

BPF = 53

LOG4 = 1.3862943611198906

NV_MAGICCONST = 1.7155277699214135

RECIP_BPF = 1.1102230246251565e-16

SG_MAGICCONST = 2.5040773967762742

TWOPI = 6.2831853071795862

_e = 2.7182818284590451

_pi = 3.1415926535897931

# functions

def betavariate(*args, **kwargs): # real signature unknown
    """
    Beta distribution.
    
            Conditions on the parameters are alpha > 0 and beta > 0.
            Returned values range between 0 and 1.
    """
    pass


def choice(*args, **kwargs): # real signature unknown
    """ Choose a random element from a non-empty sequence. """
    pass


def expovariate(*args, **kwargs): # real signature unknown
    """
    Exponential distribution.
    
            lambd is 1.0 divided by the desired mean.  (The parameter would be
            called "lambda", but that is a reserved word in Python.)  Returned
            values range from 0 to positive infinity.
    """
    pass


def gammavariate(*args, **kwargs): # real signature unknown
    """
    Gamma distribution.  Not the gamma function!
    
            Conditions on the parameters are alpha > 0 and beta > 0.
    """
    pass


def gauss(*args, **kwargs): # real signature unknown
    """
    Gaussian distribution.
    
            mu is the mean, and sigma is the standard deviation.  This is
            slightly faster than the normalvariate() function.
    
            Not thread-safe without a lock around calls.
    """
    pass


def getrandbits(k): # real signature unknown; restored from __doc__
    """ getrandbits(k) -> x.  Generates a long int with k random bits. """
    pass


def getstate(*args, **kwargs): # real signature unknown
    """ Return internal state; can be passed to setstate() later. """
    pass


def jumpahead(p_int): # real signature unknown; restored from __doc__
    """ jumpahead(int) -> None.  Create new state from existing state and integer. """
    pass


def lognormvariate(*args, **kwargs): # real signature unknown
    """
    Log normal distribution.
    
            If you take the natural logarithm of this distribution, you'll get a
            normal distribution with mean mu and standard deviation sigma.
            mu can have any value, and sigma must be greater than zero.
    """
    pass


def normalvariate(*args, **kwargs): # real signature unknown
    """
    Normal distribution.
    
            mu is the mean, and sigma is the standard deviation.
    """
    pass


def paretovariate(*args, **kwargs): # real signature unknown
    """ Pareto distribution.  alpha is the shape parameter. """
    pass


def randint(*args, **kwargs): # real signature unknown
    """ Return random integer in range [a, b], including both end points. """
    pass


def random(): # real signature unknown; restored from __doc__
    """ random() -> x in the interval [0, 1). """
    pass


def randrange(*args, **kwargs): # real signature unknown
    """
    Choose a random item from range(start, stop[, step]).
    
            This fixes the problem with randint() which includes the
            endpoint; in Python this is usually not what you want.
            Do not supply the 'int', 'default', and 'maxwidth' arguments.
    """
    pass


def sample(xrange, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    Chooses k unique random elements from a population sequence.
    
            Returns a new list containing elements from the population while
            leaving the original population unchanged.  The resulting list is
            in selection order so that all sub-slices will also be valid random
            samples.  This allows raffle winners (the sample) to be partitioned
            into grand prize and second place winners (the subslices).
    
            Members of the population need not be hashable or unique.  If the
            population contains repeats, then each occurrence is a possible
            selection in the sample.
    
            To choose a sample in a range of integers, use xrange as an argument.
            This is especially fast and space efficient for sampling from a
            large population:   sample(xrange(10000000), 60)
    """
    pass


def seed(*args, **kwargs): # real signature unknown
    """
    Initialize internal state from hashable object.
    
            None or no argument seeds from current time or from an operating
            system specific randomness source if available.
    
            If a is not None or an int or long, hash(a) is used instead.
    """
    pass


def setstate(*args, **kwargs): # real signature unknown
    """ Restore internal state from object returned by getstate(). """
    pass


def shuffle(*args, **kwargs): # real signature unknown
    """
    x, random=random.random -> shuffle list x in place; return None.
    
            Optional arg random is a 0-argument function returning a random
            float in [0.0, 1.0); by default, the standard random.random.
    """
    pass


def triangular(*args, **kwargs): # real signature unknown
    """
    Triangular distribution.
    
            Continuous distribution bounded by given lower and upper limits,
            and having a given mode value in-between.
    
            http://en.wikipedia.org/wiki/Triangular_distribution
    """
    pass


def uniform(*args, **kwargs): # real signature unknown
    """ Get a random number in the range [a, b). """
    pass


def vonmisesvariate(*args, **kwargs): # real signature unknown
    """
    Circular data distribution.
    
            mu is the mean angle, expressed in radians between 0 and 2*pi, and
            kappa is the concentration parameter, which must be greater than or
            equal to zero.  If kappa is equal to zero, this distribution reduces
            to a uniform random angle over the range 0 to 2*pi.
    """
    pass


def weibullvariate(*args, **kwargs): # real signature unknown
    """
    Weibull distribution.
    
            alpha is the scale parameter and beta is the shape parameter.
    """
    pass


def _test(N=2000): # reliably restored by inspect
    # no doc
    pass


def _test_generator(n, func, args): # reliably restored by inspect
    # no doc
    pass


def _urandom(n): # reliably restored by inspect
    """
    urandom(n) -> str
    
            Return a string of n random bytes suitable for cryptographic use.
    """
    pass


# classes

class Random(___random.Random):
    """
    Random number generator base class used by bound module functions.
    
        Used to instantiate instances of Random to get generators that don't
        share state.  Especially useful for multi-threaded programs, creating
        a different instance of Random for each thread, and using the jumpahead()
        method to ensure that the generated sequences seen by each thread don't
        overlap.
    
        Class Random can also be subclassed if you want to use a different basic
        generator of your own devising: in that case, override the following
        methods: random(), seed(), getstate(), setstate() and jumpahead().
        Optionally, implement a getrandbits() method so that randrange() can cover
        arbitrarily large ranges.
    """
    def betavariate(self, *args, **kwargs): # real signature unknown
        """
        Beta distribution.
        
                Conditions on the parameters are alpha > 0 and beta > 0.
                Returned values range between 0 and 1.
        """
        pass

    def choice(self, *args, **kwargs): # real signature unknown
        """ Choose a random element from a non-empty sequence. """
        pass

    def expovariate(self, *args, **kwargs): # real signature unknown
        """
        Exponential distribution.
        
                lambd is 1.0 divided by the desired mean.  (The parameter would be
                called "lambda", but that is a reserved word in Python.)  Returned
                values range from 0 to positive infinity.
        """
        pass

    def gammavariate(self, *args, **kwargs): # real signature unknown
        """
        Gamma distribution.  Not the gamma function!
        
                Conditions on the parameters are alpha > 0 and beta > 0.
        """
        pass

    def gauss(self, *args, **kwargs): # real signature unknown
        """
        Gaussian distribution.
        
                mu is the mean, and sigma is the standard deviation.  This is
                slightly faster than the normalvariate() function.
        
                Not thread-safe without a lock around calls.
        """
        pass

    def getstate(self, *args, **kwargs): # real signature unknown
        """ Return internal state; can be passed to setstate() later. """
        pass

    def lognormvariate(self, *args, **kwargs): # real signature unknown
        """
        Log normal distribution.
        
                If you take the natural logarithm of this distribution, you'll get a
                normal distribution with mean mu and standard deviation sigma.
                mu can have any value, and sigma must be greater than zero.
        """
        pass

    def normalvariate(self, *args, **kwargs): # real signature unknown
        """
        Normal distribution.
        
                mu is the mean, and sigma is the standard deviation.
        """
        pass

    def paretovariate(self, *args, **kwargs): # real signature unknown
        """ Pareto distribution.  alpha is the shape parameter. """
        pass

    def randint(self, *args, **kwargs): # real signature unknown
        """ Return random integer in range [a, b], including both end points. """
        pass

    def randrange(self, *args, **kwargs): # real signature unknown
        """
        Choose a random item from range(start, stop[, step]).
        
                This fixes the problem with randint() which includes the
                endpoint; in Python this is usually not what you want.
                Do not supply the 'int', 'default', and 'maxwidth' arguments.
        """
        pass

    def sample(self, xrange, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Chooses k unique random elements from a population sequence.
        
                Returns a new list containing elements from the population while
                leaving the original population unchanged.  The resulting list is
                in selection order so that all sub-slices will also be valid random
                samples.  This allows raffle winners (the sample) to be partitioned
                into grand prize and second place winners (the subslices).
        
                Members of the population need not be hashable or unique.  If the
                population contains repeats, then each occurrence is a possible
                selection in the sample.
        
                To choose a sample in a range of integers, use xrange as an argument.
                This is especially fast and space efficient for sampling from a
                large population:   sample(xrange(10000000), 60)
        """
        pass

    def seed(self, *args, **kwargs): # real signature unknown
        """
        Initialize internal state from hashable object.
        
                None or no argument seeds from current time or from an operating
                system specific randomness source if available.
        
                If a is not None or an int or long, hash(a) is used instead.
        """
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        """ Restore internal state from object returned by getstate(). """
        pass

    def shuffle(self, *args, **kwargs): # real signature unknown
        """
        x, random=random.random -> shuffle list x in place; return None.
        
                Optional arg random is a 0-argument function returning a random
                float in [0.0, 1.0); by default, the standard random.random.
        """
        pass

    def triangular(self, *args, **kwargs): # real signature unknown
        """
        Triangular distribution.
        
                Continuous distribution bounded by given lower and upper limits,
                and having a given mode value in-between.
        
                http://en.wikipedia.org/wiki/Triangular_distribution
        """
        pass

    def uniform(self, *args, **kwargs): # real signature unknown
        """ Get a random number in the range [a, b). """
        pass

    def vonmisesvariate(self, *args, **kwargs): # real signature unknown
        """
        Circular data distribution.
        
                mu is the mean angle, expressed in radians between 0 and 2*pi, and
                kappa is the concentration parameter, which must be greater than or
                equal to zero.  If kappa is equal to zero, this distribution reduces
                to a uniform random angle over the range 0 to 2*pi.
        """
        pass

    def weibullvariate(self, *args, **kwargs): # real signature unknown
        """
        Weibull distribution.
        
                alpha is the scale parameter and beta is the shape parameter.
        """
        pass

    def _randbelow(self, *args, **kwargs): # real signature unknown
        """
        Return a random int in the range [0,n)
        
                Handles the case where n has more bits than returned
                by a single call to the underlying generator.
        """
        pass

    def __getstate__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize an instance.
        
                Optional argument x controls seeding, as for Random.seed().
        """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        pass

    def __setstate__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    VERSION = 3
    __dict__ = None # (!) real value is ''


class SystemRandom(Random):
    """
    Alternate random number generator using sources provided
        by the operating system (such as /dev/urandom on Unix or
        CryptGenRandom on Windows).
    
         Not available on all systems (see os.urandom() for details).
    """
    def getrandbits(self, k): # real signature unknown; restored from __doc__
        """ getrandbits(k) -> x.  Generates a long int with k random bits. """
        pass

    def getstate(self, *args, **kwargs): # real signature unknown
        """ Method should not be called for a system random number generator. """
        pass

    def jumpahead(self, *args, **kwargs): # real signature unknown
        """ Stub method.  Not used for a system random number generator. """
        pass

    def random(self, *args, **kwargs): # real signature unknown
        """ Get the next random number in the range [0.0, 1.0). """
        pass

    def seed(self, *args, **kwargs): # real signature unknown
        """ Stub method.  Not used for a system random number generator. """
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        """ Method should not be called for a system random number generator. """
        pass

    def _notimplemented(self, *args, **kwargs): # real signature unknown
        """ Method should not be called for a system random number generator. """
        pass

    def _stub(self, *args, **kwargs): # real signature unknown
        """ Stub method.  Not used for a system random number generator. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize an instance.
        
                Optional argument x controls seeding, as for Random.seed().
        """
        pass


class WichmannHill(Random):
    # no doc
    def getstate(self, *args, **kwargs): # real signature unknown
        """ Return internal state; can be passed to setstate() later. """
        pass

    def jumpahead(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Act as if n calls to random() were made, but quickly.
        
                n is an int, greater than or equal to 0.
        
                Example use:  If you have 2 threads and know that each will
                consume no more than a million random numbers, create two Random
                objects r1 and r2, then do
                    r2.setstate(r1.getstate())
                    r2.jumpahead(1000000)
                Then r1 and r2 will use guaranteed-disjoint segments of the full
                period.
        """
        pass

    def random(self, *args, **kwargs): # real signature unknown
        """ Get the next random number in the range [0.0, 1.0). """
        pass

    def seed(self, *args, **kwargs): # real signature unknown
        """
        Initialize internal state from hashable object.
        
                None or no argument seeds from current time or from an operating
                system specific randomness source if available.
        
                If a is not None or an int or long, hash(a) is used instead.
        
                If a is an int or long, a is used directly.  Distinct values between
                0 and 27814431486575L inclusive are guaranteed to yield distinct
                internal states (this guarantee is specific to the default
                Wichmann-Hill generator).
        """
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        """ Restore internal state from object returned by getstate(). """
        pass

    def whseed(self, *args, **kwargs): # real signature unknown
        """
        Seed from hashable object's hash code.
        
                None or no argument seeds from current time.  It is not guaranteed
                that objects with distinct hash codes lead to distinct internal
                states.
        
                This is obsolete, provided for compatibility with the seed routine
                used prior to Python 2.1.  Use the .seed() method instead.
        """
        pass

    def _WichmannHill__whseed(self, *args, **kwargs): # real signature unknown
        """
        Set the Wichmann-Hill seed from (x, y, z).
        
                These must be integers in the range [0, 256).
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize an instance.
        
                Optional argument x controls seeding, as for Random.seed().
        """
        pass

    VERSION = 1


class _BuiltinMethodType(object):
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    __self__ = property(lambda self: object()) # default

    __name__ = 'builtin_function_or_method'


class _MethodType(object):
    """
    instancemethod(function, instance, class)
    
    Create an instance method object.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, function, instance, p_class): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    im_class = property(lambda self: object()) # default
    im_func = property(lambda self: object()) # default
    im_self = property(lambda self: object()) # default
    __func__ = property(lambda self: object()) # default
    __self__ = property(lambda self: object()) # default


# variables with complex values

division = None # (!) real value is ''

_inst = None # (!) real value is ''

__all__ = [
    'Random',
    'seed',
    'random',
    'uniform',
    'randint',
    'choice',
    'sample',
    'randrange',
    'shuffle',
    'normalvariate',
    'lognormvariate',
    'expovariate',
    'vonmisesvariate',
    'gammavariate',
    'triangular',
    'gauss',
    'betavariate',
    'paretovariate',
    'weibullvariate',
    'getstate',
    'setstate',
    'jumpahead',
    'WichmannHill',
    'getrandbits',
    'SystemRandom',
]

