# encoding: utf-8
# module re
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyo by generator 1.99
"""
Support for regular expressions (RE).

This module provides regular expression matching operations similar to
those found in Perl.  It supports both 8-bit and Unicode strings; both
the pattern and the strings being processed can contain null bytes and
characters outside the US ASCII range.

Regular expressions can contain both special and ordinary characters.
Most ordinary characters, like "A", "a", or "0", are the simplest
regular expressions; they simply match themselves.  You can
concatenate ordinary characters, so last matches the string 'last'.

The special characters are:
    "."      Matches any character except a newline.
    "^"      Matches the start of the string.
    "$"      Matches the end of the string or just before the newline at
             the end of the string.
    "*"      Matches 0 or more (greedy) repetitions of the preceding RE.
             Greedy means that it will match as many repetitions as possible.
    "+"      Matches 1 or more (greedy) repetitions of the preceding RE.
    "?"      Matches 0 or 1 (greedy) of the preceding RE.
    *?,+?,?? Non-greedy versions of the previous three special characters.
    {m,n}    Matches from m to n repetitions of the preceding RE.
    {m,n}?   Non-greedy version of the above.
    "\\"     Either escapes special characters or signals a special sequence.
    []       Indicates a set of characters.
             A "^" as the first character indicates a complementing set.
    "|"      A|B, creates an RE that will match either A or B.
    (...)    Matches the RE inside the parentheses.
             The contents can be retrieved or matched later in the string.
    (?iLmsux) Set the I, L, M, S, U, or X flag for the RE (see below).
    (?:...)  Non-grouping version of regular parentheses.
    (?P<name>...) The substring matched by the group is accessible by name.
    (?P=name)     Matches the text matched earlier by the group named name.
    (?#...)  A comment; ignored.
    (?=...)  Matches if ... matches next, but doesn't consume the string.
    (?!...)  Matches if ... doesn't match next.
    (?<=...) Matches if preceded by ... (must be fixed length).
    (?<!...) Matches if not preceded by ... (must be fixed length).
    (?(id/name)yes|no) Matches yes pattern if the group with id/name matched,
                       the (optional) no pattern otherwise.

The special sequences consist of "\\" and a character from the list
below.  If the ordinary character is not on the list, then the
resulting RE will match the second character.
    \number  Matches the contents of the group of the same number.
    \A       Matches only at the start of the string.
    \Z       Matches only at the end of the string.
    \b       Matches the empty string, but only at the start or end of a word.
    \B       Matches the empty string, but not at the start or end of a word.
    \d       Matches any decimal digit; equivalent to the set [0-9].
    \D       Matches any non-digit character; equivalent to the set [^0-9].
    \s       Matches any whitespace character; equivalent to [ \t\n\r\f\v].
    \S       Matches any non-whitespace character; equiv. to [^ \t\n\r\f\v].
    \w       Matches any alphanumeric character; equivalent to [a-zA-Z0-9_].
             With LOCALE, it will match the set [0-9_] plus characters defined
             as letters for the current locale.
    \W       Matches the complement of \w.
    \\       Matches a literal backslash.

This module exports the following functions:
    match    Match a regular expression pattern to the beginning of a string.
    search   Search a string for the presence of a pattern.
    sub      Substitute occurrences of a pattern found in a string.
    subn     Same as sub, but also return the number of substitutions made.
    split    Split a string by the occurrences of a pattern.
    findall  Find all occurrences of a pattern in a string.
    finditer Return an iterator yielding a match object for each match.
    compile  Compile a pattern into a RegexObject.
    purge    Clear the regular expression cache.
    escape   Backslash all non-alphanumerics in a string.

Some of the functions in this module takes flags as optional parameters:
    I  IGNORECASE  Perform case-insensitive matching.
    L  LOCALE      Make \w, \W, \b, \B, dependent on the current locale.
    M  MULTILINE   "^" matches the beginning of lines (after a newline)
                   as well as the string.
                   "$" matches the end of lines (before a newline) as well
                   as the end of the string.
    S  DOTALL      "." matches any character at all, including the newline.
    X  VERBOSE     Ignore whitespace and comments for nicer looking RE's.
    U  UNICODE     Make \w, \W, \b, \B, dependent on the Unicode locale.

This module also defines an exception 'error'.
"""

# imports
import sre_compile as sre_compile # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/sre_compile.pyc
import copy_reg as copy_reg # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/copy_reg.pyc
import sys as sys # <module 'sys' (built-in)>
import sre_parse as sre_parse # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/sre_parse.pyc
from _sre import _pattern_type


# Variables with simple values

DEBUG = 128

DOTALL = 16
I = 2

IGNORECASE = 2
L = 4

LOCALE = 4
M = 8

MULTILINE = 8
S = 16
T = 1

TEMPLATE = 1
U = 32

UNICODE = 32

VERBOSE = 64
X = 64

_MAXCACHE = 100

__version__ = '2.2.1'

# functions

def compile(pattern, flags=0): # reliably restored by inspect
    """ Compile a regular expression pattern, returning a pattern object. """
    pass


def escape(pattern): # reliably restored by inspect
    """ Escape all non-alphanumeric characters in pattern. """
    pass


def findall(pattern, string, flags=0): # reliably restored by inspect
    """
    Return a list of all non-overlapping matches in the string.
    
        If one or more groups are present in the pattern, return a
        list of groups; this will be a list of tuples if the pattern
        has more than one group.
    
        Empty matches are included in the result.
    """
    pass


def finditer(pattern, string, flags=0): # reliably restored by inspect
    """
    Return an iterator over all non-overlapping matches in the
            string.  For each match, the iterator returns a match object.
    
            Empty matches are included in the result.
    """
    pass


def match(pattern, string, flags=0): # reliably restored by inspect
    """
    Try to apply the pattern at the start of the string, returning
        a match object, or None if no match was found.
    """
    pass


def purge(): # reliably restored by inspect
    """ Clear the regular expression cache """
    pass


def search(pattern, string, flags=0): # reliably restored by inspect
    """
    Scan through string looking for a match to the pattern, returning
        a match object, or None if no match was found.
    """
    pass


def split(pattern, string, maxsplit=0): # reliably restored by inspect
    """
    Split the source string by the occurrences of the pattern,
        returning a list containing the resulting substrings.
    """
    pass


def sub(pattern, repl, string, count=0): # reliably restored by inspect
    """
    Return the string obtained by replacing the leftmost
        non-overlapping occurrences of the pattern in string by the
        replacement repl.  repl can be either a string or a callable;
        if a callable, it's passed the match object and must return
        a replacement string to be used.
    """
    pass


def subn(pattern, repl, string, count=0): # reliably restored by inspect
    """
    Return a 2-tuple containing (new_string, number).
        new_string is the string obtained by replacing the leftmost
        non-overlapping occurrences of the pattern in the source
        string by the replacement repl.  number is the number of
        substitutions that were made. repl can be either a string or a
        callable; if a callable, it's passed the match object and must
        return a replacement string to be used.
    """
    pass


def template(pattern, flags=0): # reliably restored by inspect
    """ Compile a template pattern, returning a pattern object """
    pass


def _compile(*key): # reliably restored by inspect
    # no doc
    pass


def _compile_repl(*key): # reliably restored by inspect
    # no doc
    pass


def _expand(pattern, match, template): # reliably restored by inspect
    # no doc
    pass


def _pickle(p): # reliably restored by inspect
    # no doc
    pass


def _subx(pattern, template): # reliably restored by inspect
    # no doc
    pass


# classes

class error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

Scanner = None # (!) real value is ''

_alphanum = {
    '0': 1,
    '1': 1,
    '2': 1,
    '3': 1,
    '4': 1,
    '5': 1,
    '6': 1,
    '7': 1,
    '8': 1,
    '9': 1,
    'A': 1,
    'B': 1,
    'C': 1,
    'D': 1,
    'E': 1,
    'F': 1,
    'G': 1,
    'H': 1,
    'I': 1,
    'J': 1,
    'K': 1,
    'L': 1,
    'M': 1,
    'N': 1,
    'O': 1,
    'P': 1,
    'Q': 1,
    'R': 1,
    'S': 1,
    'T': 1,
    'U': 1,
    'V': 1,
    'W': 1,
    'X': 1,
    'Y': 1,
    'Z': 1,
    'a': 1,
    'b': 1,
    'c': 1,
    'd': 1,
    'e': 1,
    'f': 1,
    'g': 1,
    'h': 1,
    'i': 1,
    'j': 1,
    'k': 1,
    'l': 1,
    'm': 1,
    'n': 1,
    'o': 1,
    'p': 1,
    'q': 1,
    'r': 1,
    's': 1,
    't': 1,
    'u': 1,
    'v': 1,
    'w': 1,
    'x': 1,
    'y': 1,
    'z': 1,
}

_cache = {
    (
        bytes,
        '\n    \\$(?:\n      (?P<escaped>\\$) |   # Escape sequence of two delimiters\n      (?P<named>[_a-z][_a-z0-9]*)      |   # delimiter and a Python identifier\n      {(?P<braced>[_a-z][_a-z0-9]*)}   |   # delimiter and a braced identifier\n      (?P<invalid>)              # Other ill-formed delimiter exprs\n    )\n    ',
        66,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '"(?:[^"\\n\\r\\\\]|(?:"")|(?:\\\\x[0-9a-fA-F]+)|(?:\\\\.))*"',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '#.*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        "'(?:[^'\\n\\r\\\\]|(?:'')|(?:\\\\x[0-9a-fA-F]+)|(?:\\\\.))*'",
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '(?:"(?:[^"\\n\\r\\\\]|(?:"")|(?:\\\\x[0-9a-fA-F]+)|(?:\\\\.))*")|(?:\'(?:[^\'\\n\\r\\\\]|(?:\'\')|(?:\\\\x[0-9a-fA-F]+)|(?:\\\\.))*\')',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '(?:.*\\.)?(\\w+)\\(([^\\)]*)\\).*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '([A-Za-z_]+)[0-9]?[A-Za-z_]*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '([A-Za-z_][0-9A-Za-z_]*)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '([A-Za-z_][0-9A-Za-z_]*\\s*=)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '([a-zA-Z_]+[0-9a-zA-Z]*)\\.(?:pyc|pyo|(?:[a-zA-Z_]+-\\d\\d[a-zA-Z]*\\.)?(?:so|pyd))',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '(\\([+-]?[0-9](?:\\s*,\\s*[+-]?[0-9])*\\))|([+-]?[0-9]+\\.?[0-9]*(?:[Ee]?[+-]?[0-9]+\\.?[0-9]*)?)|(\'[0-9A-Za-z_.,\\+\\-&\\*% ]*\')|("[0-9A-Za-z_.,\\+\\-&\\*% ]*")|(\\[\\])|(\\{\\})|(\\(\\))|(True|False|None)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '(\\*?\\*?[A-Za-z_][0-9A-Za-z_]*)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '.*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '.*(?s)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '/(?:\\*(?:[^*]*\\*+)+?/|/[^\\n]*(?:\\n[^\\n]*)*?(?:(?<!\\\\)|\\Z))',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '/System/Library/Frameworks/Python\\.framework/Versions/(.+)/lib/python\\1/(.+)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '/\\*(?:[^*]*\\*+)+?/',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '<!--[\\s\\S]*?-->',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        'True|False',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[ \\f\\t]*((\\\\\\r?\\n|#[^\\r\\n]*|([uU]?[rR]?\'\'\'|[uU]?[rR]?"""))|((\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)|(0[xX][\\da-fA-F]+[lL]?|0[bB][01]+[lL]?|(0[oO][0-7]+)|(0[0-7]*)[lL]?|[1-9]\\d*[lL]?))|((\\*\\*=?|>>=?|<<=?|<>|!=|//=?|[+\\-*/%&|^=<>]=?|~)|[][(){}]|(\\r?\\n|[:;.,`@]))|([uU]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*(\'|\\\\\\r?\\n)|[uU]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*("|\\\\\\r?\\n))|[a-zA-Z_]\\w*)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[ \\f\\t]*(\\\\\\r?\\n[ \\f\\t]*)*(#[^\\r\\n]*)?(((\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)|(0[xX][\\da-fA-F]+[lL]?|0[bB][01]+[lL]?|(0[oO][0-7]+)|(0[0-7]*)[lL]?|[1-9]\\d*[lL]?))|((\\*\\*=?|>>=?|<<=?|<>|!=|//=?|[+\\-*/%&|^=<>]=?|~)|[][(){}]|(\\r?\\n|[:;.,`@]))|([uU]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*\'|[uU]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*")|[a-zA-Z_]\\w*)',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[+\\-]',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[0123456789ABCDEFabcdef]+',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[0123456789]+',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!"#$%&\'()*+,\\-./:;<=?@[\\\\\\]\\^_`{|}~]+',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!"#$%&\'()*+\\-./:;<=>?@[\\\\\\]\\^_`{|}~]+',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[0][01234567]*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[A-Za-z_][0-9A-Za-z_]*(?:\\(.*\\))?',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[^"\\\\]*(?:(?:\\\\.|"(?!""))[^"\\\\]*)*"""',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[^"\\\\]*(?:\\\\.[^"\\\\]*)*"',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        "[^'\\\\]*(?:(?:\\\\.|'(?!''))[^'\\\\]*)*'''",
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        "[^'\\\\]*(?:\\\\.[^'\\\\]*)*'",
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ][abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_:]*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ][abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_\\-:]*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_][abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_\\-.]*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '[eE]',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '\\*\\*|\\*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        '\\/\\/(\\\\\\n|.)*',
        0,
    ): 
        None # (!) real value is ''
    ,
    (
        '<value is a self-reference, replaced by this string>',
        'gt|lt|amp|nbsp|quot',
        0,
    ): 
        None # (!) real value is ''
    ,
}

_cache_repl = {}

__all__ = [
    'match',
    'search',
    'sub',
    'subn',
    'split',
    'findall',
    'compile',
    'purge',
    'template',
    'escape',
    'I',
    'L',
    'M',
    'S',
    'X',
    'U',
    'IGNORECASE',
    'LOCALE',
    'MULTILINE',
    'DOTALL',
    'VERBOSE',
    'UNICODE',
    'error',
    'finditer',
]

