# encoding: utf-8
# module rexec
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/rexec.pyo by generator 1.99
"""
Restricted execution facilities.

The class RExec exports methods r_exec(), r_eval(), r_execfile(), and
r_import(), which correspond roughly to the built-in operations
exec, eval(), execfile() and import, but executing the code in an
environment that only exposes those built-in operations that are
deemed safe.  To this end, a modest collection of 'fake' modules is
created which mimics the standard modules by the same names.  It is a
policy decision which built-in modules and operations are made
available; this module provides a reasonable default, but derived
classes can change the policies e.g. by overriding or extending class
variables like ok_builtin_modules or methods like make_sys().

XXX To do:
- r_open should allow writing tmp dir
- r_exec etc. with explicit globals/locals? (Use rexec("exec ... in ...")?)
"""

# imports
import imp as imp # <module 'imp' (built-in)>
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import sys as sys # <module 'sys' (built-in)>
import ihooks as ihooks # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/ihooks.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

TEMPLATE = '\ndef %s(self, *args):\n        return getattr(self.mod, self.name).%s(*args)\n'

# functions

def test(): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

FileBase = None # (!) real value is ''

FileDelegate = None # (!) real value is ''

FileWrapper = None # (!) real value is ''

RExec = None # (!) real value is ''

RHooks = None # (!) real value is ''

RModuleImporter = ihooks.ModuleImporter

RModuleLoader = ihooks.FancyModuleLoader

__all__ = [
    'RExec',
]

