# encoding: utf-8
# module site
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/site.pyo by generator 1.99
"""
Append module search paths for third-party packages to sys.path.

****************************************************************
* This module is automatically imported during initialization. *
****************************************************************

In earlier versions of Python (up to 1.5a3), scripts or modules that
needed to use site-specific modules would place ``import site''
somewhere near the top of their code.  Because of the automatic
import, this is no longer necessary (but code that does it still
works).

This will append site-specific paths to the module search path.  On
Unix (including Mac OSX), it starts with sys.prefix and
sys.exec_prefix (if different) and appends
lib/python<version>/site-packages as well as lib/site-python.
On other platforms (such as Windows), it tries each of the
prefixes directly, as well as with lib/site-packages appended.  The
resulting directories, if they exist, are appended to sys.path, and
also inspected for path configuration files.

A path configuration file is a file whose name has the form
<package>.pth; its contents are additional directories (one per line)
to be added to sys.path.  Non-existing directories (or
non-directories) are never added to sys.path; no directory is added to
sys.path more than once.  Blank lines and lines beginning with
'#' are skipped. Lines starting with 'import' are executed.

For example, suppose sys.prefix and sys.exec_prefix are set to
/usr/local and there is a directory /usr/local/lib/python2.5/site-packages
with three subdirectories, foo, bar and spam, and two path
configuration files, foo.pth and bar.pth.  Assume foo.pth contains the
following:

  # foo package configuration
  foo
  bar
  bletch

and bar.pth contains:

  # bar package configuration
  bar

Then the following directories are added to sys.path, in this order:

  /usr/local/lib/python2.5/site-packages/bar
  /usr/local/lib/python2.5/site-packages/foo

Note that bletch is omitted because it doesn't exist; bar precedes foo
because bar.pth comes alphabetically before foo.pth; and spam is
omitted because it is not mentioned in either path configuration file.

After these path manipulations, an attempt is made to import a module
named sitecustomize, which can perform arbitrary additional
site-specific customizations.  If this import fails with an
ImportError exception, it is silently ignored.
"""

# imports
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

ENABLE_USER_SITE = True

USER_BASE = '/Users/jetbrains/.local'
USER_SITE = '/Users/jetbrains/.local/lib/python2.6/site-packages'

# functions

def abs__file__(): # reliably restored by inspect
    """ Set all module' __file__ attribute to an absolute path """
    pass


def addbuilddir(): # reliably restored by inspect
    """
    Append ./build/lib.<platform> in case we're running in the build dir
        (especially for Guido :-)
    """
    pass


def addpackage(sitedir, name, known_paths): # reliably restored by inspect
    """
    Process a .pth file within the site-packages directory:
           For each line in the file, either combine it with sitedir to a path
           and add that to known_paths, or execute it if it starts with 'import '.
    """
    pass


def addsitedir(sitedir, known_paths=None): # reliably restored by inspect
    """
    Add 'sitedir' argument to sys.path if missing and handle .pth files in
        'sitedir'
    """
    pass


def addsitepackages(known_paths): # reliably restored by inspect
    """ Add site-packages (and possibly site-python) to sys.path """
    pass


def addusersitepackages(known_paths): # reliably restored by inspect
    """
    Add a per user site-package to sys.path
    
        Each user has its own python directory with site-packages in the
        home directory.
    
        USER_BASE is the root directory for all Python versions
    
        USER_SITE is the user specific site-packages directory
    
        USER_SITE/.. can be used for data.
    """
    pass


def aliasmbcs(): # reliably restored by inspect
    """
    On Windows, some default encodings are not provided by Python,
        while they are always available as "mbcs" in each locale. Make
        them usable by aliasing to "mbcs" in such a case.
    """
    pass


def check_enableusersite(): # reliably restored by inspect
    """
    Check if user site directory is safe for inclusion
    
        The function tests for the command line flag (including environment var),
        process uid/gid equal to effective uid/gid.
    
        None: Disabled for security reasons
        False: Disabled by user (command line option)
        True: Safe and enabled
    """
    pass


def execsitecustomize(): # reliably restored by inspect
    """ Run custom site specific code, if available. """
    pass


def execusercustomize(): # reliably restored by inspect
    """ Run custom user specific code, if available. """
    pass


def main(): # reliably restored by inspect
    # no doc
    pass


def makepath(*paths): # reliably restored by inspect
    # no doc
    pass


def removeduppaths(): # reliably restored by inspect
    """
    Remove duplicate entries from sys.path along with making them
        absolute
    """
    pass


def setBEGINLIBPATH(): # reliably restored by inspect
    """
    The OS/2 EMX port has optional extension modules that do double duty
        as DLLs (and must use the .DLL file extension) for other extensions.
        The library search path needs to be amended so these will be found
        during module import.  Use BEGINLIBPATH so that these are at the start
        of the library search path.
    """
    pass


def setcopyright(): # reliably restored by inspect
    """ Set 'copyright' and 'credits' in __builtin__ """
    pass


def setencoding(): # reliably restored by inspect
    """
    Set the string encoding used by the Unicode implementation.  The
        default is 'ascii', but if you're willing to experiment, you can
        change this.
    """
    pass


def sethelper(): # reliably restored by inspect
    # no doc
    pass


def setquit(): # reliably restored by inspect
    """
    Define new built-ins 'quit' and 'exit'.
        These are simply strings that display a hint on how to exit.
    """
    pass


def _init_pathinfo(): # reliably restored by inspect
    """ Return a set containing all existing directory entries from sys.path """
    pass


def _script(): # reliably restored by inspect
    # no doc
    pass


# classes

class _Helper(object):
    """
    Define the built-in 'help'.
        This is a wrapper around pydoc.help (with a twist).
    """
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _Printer(object):
    """
    interactive prompt objects for printing the license text, a list of
        contributors and the copyright notice.
    """
    def _Printer__setup(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    MAXLINES = 23
    __dict__ = None # (!) real value is ''


# variables with complex values

PREFIXES = [
    '/System/Library/Frameworks/Python.framework/Versions/2.6',
    '/System/Library/Frameworks/Python.framework/Versions/2.6',
]

