# encoding: utf-8
# module sre_constants
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/sre_constants.pyo by generator 1.99
""" Internal support module for sre """
# no imports

# Variables with simple values

ANY = 'any'

ANY_ALL = 'any_all'

ASSERT = 'assert'

ASSERT_NOT = 'assert_not'

AT = 'at'
AT_BEGINNING = 'at_beginning'

AT_BEGINNING_LINE = 'at_beginning_line'
AT_BEGINNING_STRING = 'at_beginning_string'

AT_BOUNDARY = 'at_boundary'
AT_END = 'at_end'

AT_END_LINE = 'at_end_line'
AT_END_STRING = 'at_end_string'

AT_LOC_BOUNDARY = 'at_loc_boundary'

AT_LOC_NON_BOUNDARY = 'at_loc_non_boundary'

AT_NON_BOUNDARY = 'at_non_boundary'

AT_UNI_BOUNDARY = 'at_uni_boundary'

AT_UNI_NON_BOUNDARY = 'at_uni_non_boundary'

BIGCHARSET = 'bigcharset'

BRANCH = 'branch'

CALL = 'call'
CATEGORY = 'category'

CATEGORY_DIGIT = 'category_digit'
CATEGORY_LINEBREAK = 'category_linebreak'

CATEGORY_LOC_NOT_WORD = 'category_loc_not_word'

CATEGORY_LOC_WORD = 'category_loc_word'

CATEGORY_NOT_DIGIT = 'category_not_digit'
CATEGORY_NOT_LINEBREAK = 'category_not_linebreak'
CATEGORY_NOT_SPACE = 'category_not_space'
CATEGORY_NOT_WORD = 'category_not_word'

CATEGORY_SPACE = 'category_space'

CATEGORY_UNI_DIGIT = 'category_uni_digit'
CATEGORY_UNI_LINEBREAK = 'category_uni_linebreak'

CATEGORY_UNI_NOT_DIGIT = 'category_uni_not_digit'
CATEGORY_UNI_NOT_LINEBREAK = 'category_uni_not_linebreak'
CATEGORY_UNI_NOT_SPACE = 'category_uni_not_space'
CATEGORY_UNI_NOT_WORD = 'category_uni_not_word'

CATEGORY_UNI_SPACE = 'category_uni_space'
CATEGORY_UNI_WORD = 'category_uni_word'

CATEGORY_WORD = 'category_word'

CHARSET = 'charset'

FAILURE = 'failure'

GROUPREF = 'groupref'

GROUPREF_EXISTS = 'groupref_exists'
GROUPREF_IGNORE = 'groupref_ignore'

IN = 'in'
INFO = 'info'
IN_IGNORE = 'in_ignore'

JUMP = 'jump'

LITERAL = 'literal'

LITERAL_IGNORE = 'literal_ignore'

MAGIC = 20031017
MARK = 'mark'
MAXREPEAT = 65535

MAX_REPEAT = 'max_repeat'
MAX_UNTIL = 'max_until'

MIN_REPEAT = 'min_repeat'

MIN_REPEAT_ONE = 'min_repeat_one'

MIN_UNTIL = 'min_until'

NEGATE = 'negate'

NOT_LITERAL = 'not_literal'

NOT_LITERAL_IGNORE = 'not_literal_ignore'

RANGE = 'range'

REPEAT = 'repeat'

REPEAT_ONE = 'repeat_one'

SRE_FLAG_DEBUG = 128
SRE_FLAG_DOTALL = 16
SRE_FLAG_IGNORECASE = 2
SRE_FLAG_LOCALE = 4
SRE_FLAG_MULTILINE = 8
SRE_FLAG_TEMPLATE = 1
SRE_FLAG_UNICODE = 32
SRE_FLAG_VERBOSE = 64

SRE_INFO_CHARSET = 4
SRE_INFO_LITERAL = 2
SRE_INFO_PREFIX = 1

SUBPATTERN = 'subpattern'
SUCCESS = 'success'

# functions

def makedict(list): # reliably restored by inspect
    # no doc
    pass


# classes

class error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

ATCODES = {
    'at_beginning': 0,
    'at_beginning_line': 1,
    'at_beginning_string': 2,
    'at_boundary': 3,
    'at_end': 5,
    'at_end_line': 6,
    'at_end_string': 7,
    'at_loc_boundary': 8,
    'at_loc_non_boundary': 9,
    'at_non_boundary': 4,
    'at_uni_boundary': 10,
    'at_uni_non_boundary': 11,
}

AT_LOCALE = {
    'at_boundary': 'at_loc_boundary',
    'at_non_boundary': 'at_loc_non_boundary',
}

AT_MULTILINE = {
    'at_beginning': 'at_beginning_line',
    'at_end': 'at_end_line',
}

AT_UNICODE = {
    'at_boundary': 'at_uni_boundary',
    'at_non_boundary': 'at_uni_non_boundary',
}

CHCODES = {
    'category_digit': 0,
    'category_linebreak': 6,
    'category_loc_not_word': 9,
    'category_loc_word': 8,
    'category_not_digit': 1,
    'category_not_linebreak': 7,
    'category_not_space': 3,
    'category_not_word': 5,
    'category_space': 2,
    'category_uni_digit': 10,
    'category_uni_linebreak': 16,
    'category_uni_not_digit': 11,
    'category_uni_not_linebreak': 17,
    'category_uni_not_space': 13,
    'category_uni_not_word': 15,
    'category_uni_space': 12,
    'category_uni_word': 14,
    'category_word': 4,
}

CH_LOCALE = {
    'category_digit': 'category_digit',
    'category_linebreak': 'category_linebreak',
    'category_not_digit': 'category_not_digit',
    'category_not_linebreak': 'category_not_linebreak',
    'category_not_space': 'category_not_space',
    'category_not_word': 'category_loc_not_word',
    'category_space': 'category_space',
    'category_word': 'category_loc_word',
}

CH_UNICODE = {
    'category_digit': 'category_uni_digit',
    'category_linebreak': 'category_uni_linebreak',
    'category_not_digit': 'category_uni_not_digit',
    'category_not_linebreak': 'category_uni_not_linebreak',
    'category_not_space': 'category_uni_not_space',
    'category_not_word': 'category_uni_not_word',
    'category_space': 'category_uni_space',
    'category_word': 'category_uni_word',
}

OPCODES = {
    'any': 2,
    'any_all': 3,
    'assert': 4,
    'assert_not': 5,
    'at': 6,
    'bigcharset': 11,
    'branch': 7,
    'call': 8,
    'category': 9,
    'charset': 10,
    'failure': 0,
    'groupref': 12,
    'groupref_exists': 13,
    'groupref_ignore': 14,
    'in': 15,
    'in_ignore': 16,
    'info': 17,
    'jump': 18,
    'literal': 19,
    'literal_ignore': 20,
    'mark': 21,
    'max_until': 22,
    'min_repeat_one': 31,
    'min_until': 23,
    'negate': 26,
    'not_literal': 24,
    'not_literal_ignore': 25,
    'range': 27,
    'repeat': 28,
    'repeat_one': 29,
    'subpattern': 30,
    'success': 1,
}

OP_IGNORE = {
    'groupref': 'groupref_ignore',
    'in': 'in_ignore',
    'literal': 'literal_ignore',
    'not_literal': 'not_literal_ignore',
}

