# encoding: utf-8
# module ssl
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/ssl.pyo by generator 1.99
"""
This module provides some more Pythonic support for SSL.

Object types:

  SSLSocket -- subtype of socket.socket which does SSL over the socket

Exceptions:

  SSLError -- exception raised for I/O errors

Functions:

  cert_time_to_seconds -- convert time string used for certificate
                          notBefore and notAfter functions to integer
                          seconds past the Epoch (the time values
                          returned from time.time())

  fetch_server_certificate (HOST, PORT) -- fetch the certificate provided
                          by the server running on HOST at port PORT.  No
                          validation of the certificate is performed.

Integer constants:

SSL_ERROR_ZERO_RETURN
SSL_ERROR_WANT_READ
SSL_ERROR_WANT_WRITE
SSL_ERROR_WANT_X509_LOOKUP
SSL_ERROR_SYSCALL
SSL_ERROR_SSL
SSL_ERROR_WANT_CONNECT

SSL_ERROR_EOF
SSL_ERROR_INVALID_ERROR_CODE

The following group define certificate requirements that one side is
allowing/requiring from the other side:

CERT_NONE - no certificates from the other side are required (or will
            be looked at if provided)
CERT_OPTIONAL - certificates are not required, but if provided will be
                validated, and if validation fails, the connection will
                also fail
CERT_REQUIRED - certificates are required, and will be validated, and
                if validation fails, the connection will also fail

The following constants identify various SSL protocol variants:

PROTOCOL_SSLv2
PROTOCOL_SSLv3
PROTOCOL_SSLv23
PROTOCOL_TLSv1
"""

# imports
import base64 as base64 # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/base64.pyc
import _ssl as _ssl # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/_ssl.so
import textwrap as textwrap # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/textwrap.pyc
from _socket import _getnameinfo

from _ssl import RAND_add, RAND_egd, RAND_status

import socket as __socket


# Variables with simple values

CERT_NONE = 0
CERT_OPTIONAL = 1
CERT_REQUIRED = 2

PEM_FOOTER = '-----END CERTIFICATE-----'
PEM_HEADER = '-----BEGIN CERTIFICATE-----'

PROTOCOL_SSLv2 = 0
PROTOCOL_SSLv23 = 2
PROTOCOL_SSLv3 = 1
PROTOCOL_TLSv1 = 3

SSL_ERROR_EOF = 8

SSL_ERROR_INVALID_ERROR_CODE = 9

SSL_ERROR_SSL = 1
SSL_ERROR_SYSCALL = 5

SSL_ERROR_WANT_CONNECT = 7
SSL_ERROR_WANT_READ = 2
SSL_ERROR_WANT_WRITE = 3

SSL_ERROR_WANT_X509_LOOKUP = 4

SSL_ERROR_ZERO_RETURN = 6

# functions

def cert_time_to_seconds(cert_time): # reliably restored by inspect
    """
    Takes a date-time string in standard ASN1_print form
        ("MON DAY 24HOUR:MINUTE:SEC YEAR TIMEZONE") and return
        a Python time value in seconds past the epoch.
    """
    pass


def DER_cert_to_PEM_cert(der_cert_bytes): # reliably restored by inspect
    """
    Takes a certificate in binary DER format and returns the
        PEM version of it as a string.
    """
    pass


def get_protocol_name(protocol_code): # reliably restored by inspect
    # no doc
    pass


def get_server_certificate(addr, ssl_version=1, ca_certs=None): # reliably restored by inspect
    """
    Retrieve the certificate from the server at the specified address,
        and return it as a PEM-encoded string.
        If 'ca_certs' is specified, validate the server cert against it.
        If 'ssl_version' is specified, use it in the connection attempt.
    """
    pass


def PEM_cert_to_DER_cert(pem_cert_string): # reliably restored by inspect
    """
    Takes a certificate in ASCII PEM format and returns the
        DER-encoded version of it as a byte sequence
    """
    pass


def sslwrap_simple(sock, keyfile=None, certfile=None): # reliably restored by inspect
    """
    A replacement for the old socket.ssl function.  Designed
        for compability with Python 2.5 and earlier.  Will disappear in
        Python 3.0.
    """
    pass


def wrap_socket(sock, keyfile=None, certfile=None, server_side=False, cert_reqs=0, ssl_version=2, ca_certs=None, do_handshake_on_connect=True, suppress_ragged_eofs=True): # reliably restored by inspect
    # no doc
    pass


# classes

class socket(object):
    """
    socket([family[, type[, proto]]]) -> socket object
    
    Open a socket of the given type.  The family argument specifies the
    address family; it defaults to AF_INET.  The type argument specifies
    whether this is a stream (SOCK_STREAM, this is the default)
    or datagram (SOCK_DGRAM) socket.  The protocol argument defaults to 0,
    specifying the default protocol.  Keyword arguments are accepted.
    
    A socket object represents one endpoint of a network connection.
    
    Methods of socket objects (keyword arguments not allowed):
    
    accept() -- accept a connection, returning new socket and client address
    bind(addr) -- bind the socket to a local address
    close() -- close the socket
    connect(addr) -- connect the socket to a remote address
    connect_ex(addr) -- connect, return an error code instead of an exception
    dup() -- return a new socket object identical to the current one [*]
    fileno() -- return underlying file descriptor
    getpeername() -- return remote address [*]
    getsockname() -- return local address
    getsockopt(level, optname[, buflen]) -- get socket options
    gettimeout() -- return timeout or None
    listen(n) -- start listening for incoming connections
    makefile([mode, [bufsize]]) -- return a file object for the socket [*]
    recv(buflen[, flags]) -- receive data
    recv_into(buffer[, nbytes[, flags]]) -- receive data (into a buffer)
    recvfrom(buflen[, flags]) -- receive data and sender's address
    recvfrom_into(buffer[, nbytes, [, flags])
      -- receive data and sender's address (into a buffer)
    sendall(data[, flags]) -- send all data
    send(data[, flags]) -- send data, may not send all of it
    sendto(data[, flags], addr) -- send data to a given address
    setblocking(0 | 1) -- set or clear the blocking I/O flag
    setsockopt(level, optname, value) -- set socket options
    settimeout(None | float) -- set or clear the timeout
    shutdown(how) -- shut down traffic in one or both directions
    
     [*] not available on all platforms!
    """
    def accept(self): # real signature unknown; restored from __doc__
        """
        accept() -> (socket object, address info)
        
        Wait for an incoming connection.  Return a new socket representing the
        connection, and the address of the client.  For IP sockets, the address
        info is a pair (hostaddr, port).
        """
        pass

    def bind(self, address): # real signature unknown; restored from __doc__
        """
        bind(address)
        
        Bind the socket to a local address.  For IP sockets, the address is a
        pair (host, port); the host must refer to the local host. For raw packet
        sockets the address is a tuple (ifname, proto [,pkttype [,hatype]])
        """
        pass

    def close(self): # real signature unknown; restored from __doc__
        """
        close()
        
        Close the socket.  It cannot be used after this call.
        """
        pass

    def connect(self, address): # real signature unknown; restored from __doc__
        """
        connect(address)
        
        Connect the socket to a remote address.  For IP sockets, the address
        is a pair (host, port).
        """
        pass

    def connect_ex(self, address): # real signature unknown; restored from __doc__
        """
        connect_ex(address) -> errno
        
        This is like connect(address), but returns an error code (the errno value)
        instead of raising an exception when an error occurs.
        """
        pass

    def dup(self): # real signature unknown; restored from __doc__
        """
        dup() -> socket object
        
                Return a new socket object connected to the same system resource.
        """
        return socket

    def fileno(self): # real signature unknown; restored from __doc__
        """
        fileno() -> integer
        
        Return the integer file descriptor of the socket.
        """
        return 0

    def getpeername(self): # real signature unknown; restored from __doc__
        """
        getpeername() -> address info
        
        Return the address of the remote endpoint.  For IP sockets, the address
        info is a pair (hostaddr, port).
        """
        pass

    def getsockname(self): # real signature unknown; restored from __doc__
        """
        getsockname() -> address info
        
        Return the address of the local endpoint.  For IP sockets, the address
        info is a pair (hostaddr, port).
        """
        pass

    def getsockopt(self, level, option, buffersize=None): # real signature unknown; restored from __doc__
        """
        getsockopt(level, option[, buffersize]) -> value
        
        Get a socket option.  See the Unix manual for level and option.
        If a nonzero buffersize argument is given, the return value is a
        string of that length; otherwise it is an integer.
        """
        pass

    def gettimeout(self): # real signature unknown; restored from __doc__
        """
        gettimeout() -> timeout
        
        Returns the timeout in floating seconds associated with socket 
        operations. A timeout of None indicates that timeouts on socket 
        operations are disabled.
        """
        pass

    def listen(self, backlog): # real signature unknown; restored from __doc__
        """
        listen(backlog)
        
        Enable a server to accept connections.  The backlog argument must be at
        least 1; it specifies the number of unaccepted connection that the system
        will allow before refusing new connections.
        """
        pass

    def makefile(self, mode=None, bufsize=None): # real signature unknown; restored from __doc__
        """
        makefile([mode[, bufsize]]) -> file object
        
                Return a regular file object corresponding to the socket.  The mode
                and bufsize arguments are as for the built-in open() function.
        """
        return file('/dev/null')

    def sendall(self, data, flags=None): # real signature unknown; restored from __doc__
        """
        sendall(data[, flags])
        
        Send a data string to the socket.  For the optional flags
        argument, see the Unix manual.  This calls send() repeatedly
        until all data is sent.  If an error occurs, it's impossible
        to tell how much data has been sent.
        """
        pass

    def setblocking(self, flag): # real signature unknown; restored from __doc__
        """
        setblocking(flag)
        
        Set the socket to blocking (flag is true) or non-blocking (false).
        setblocking(True) is equivalent to settimeout(None);
        setblocking(False) is equivalent to settimeout(0.0).
        """
        pass

    def setsockopt(self, level, option, value): # real signature unknown; restored from __doc__
        """
        setsockopt(level, option, value)
        
        Set a socket option.  See the Unix manual for level and option.
        The value argument can either be an integer or a string.
        """
        pass

    def settimeout(self, timeout): # real signature unknown; restored from __doc__
        """
        settimeout(timeout)
        
        Set a timeout on socket operations.  'timeout' can be a float,
        giving in seconds, or None.  Setting a timeout of None disables
        the timeout feature and is equivalent to setblocking(1).
        Setting a timeout of zero is the same as setblocking(0).
        """
        pass

    def shutdown(self, flag): # real signature unknown; restored from __doc__
        """
        shutdown(flag)
        
        Shut down the reading side of the socket (flag == SHUT_RD), the writing side
        of the socket (flag == SHUT_WR), or both ends (flag == SHUT_RDWR).
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    family = property(lambda self: object()) # default
    proto = property(lambda self: object()) # default
    recv = property(lambda self: object()) # default
    recvfrom = property(lambda self: object()) # default
    recvfrom_into = property(lambda self: object()) # default
    recv_into = property(lambda self: object()) # default
    send = property(lambda self: object()) # default
    sendto = property(lambda self: object()) # default
    type = property(lambda self: object()) # default
    _sock = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    __slots__ = [
        '_sock',
        '__weakref__',
        'recv',
        'recvfrom',
        'recv_into',
        'recvfrom_into',
        'send',
        'sendto',
    ]


class SSLError(__socket.error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SSLSocket(__socket._socketobject):
    """
    This class implements a subtype of socket.socket that wraps
        the underlying OS socket in an SSL context when necessary, and
        provides read and write methods over that channel.
    """
    def accept(self, *args, **kwargs): # real signature unknown
        """
        Accepts a new connection from a remote client, and returns
                a tuple containing that new connection wrapped with a server-side
                SSL channel, and the address of the remote client.
        """
        pass

    def cipher(self, *args, **kwargs): # real signature unknown
        pass

    def close(self, *args, **kwargs): # real signature unknown
        pass

    def connect(self, *args, **kwargs): # real signature unknown
        """
        Connects to remote ADDR, and then wraps the connection in
                an SSL channel.
        """
        pass

    def do_handshake(self, *args, **kwargs): # real signature unknown
        """ Perform a TLS/SSL handshake. """
        pass

    def getpeercert(self, *args, **kwargs): # real signature unknown
        """
        Returns a formatted version of the data in the
                certificate provided by the other end of the SSL channel.
                Return None if no certificate was provided, {} if a
                certificate was provided, but not validated.
        """
        pass

    def makefile(self, *args, **kwargs): # real signature unknown
        """
        Make and return a file-like object that
                works with the SSL connection.  Just use the code
                from the socket module.
        """
        pass

    def pending(self, *args, **kwargs): # real signature unknown
        pass

    def read(self, *args, **kwargs): # real signature unknown
        """
        Read up to LEN bytes and return them.
                Return zero-length string on EOF.
        """
        pass

    def recv(self, *args, **kwargs): # real signature unknown
        pass

    def recvfrom(self, *args, **kwargs): # real signature unknown
        pass

    def recvfrom_into(self, *args, **kwargs): # real signature unknown
        pass

    def recv_into(self, *args, **kwargs): # real signature unknown
        pass

    def send(self, *args, **kwargs): # real signature unknown
        pass

    def sendall(self, *args, **kwargs): # real signature unknown
        pass

    def sendto(self, *args, **kwargs): # real signature unknown
        pass

    def shutdown(self, *args, **kwargs): # real signature unknown
        pass

    def unwrap(self, *args, **kwargs): # real signature unknown
        pass

    def write(self, *args, **kwargs): # real signature unknown
        """
        Write DATA to the underlying SSL channel.  Returns
                number of bytes of DATA actually transmitted.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __dict__ = None # (!) real value is ''


class _fileobject(object):
    """ Faux file object attached to a socket object. """
    def close(self, *args, **kwargs): # real signature unknown
        pass

    def fileno(self, *args, **kwargs): # real signature unknown
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        pass

    def next(self, *args, **kwargs): # real signature unknown
        pass

    def read(self, *args, **kwargs): # real signature unknown
        pass

    def readline(self, *args, **kwargs): # real signature unknown
        pass

    def readlines(self, *args, **kwargs): # real signature unknown
        pass

    def write(self, *args, **kwargs): # real signature unknown
        pass

    def writelines(self, *args, **kwargs): # real signature unknown
        pass

    def _getclosed(self, *args, **kwargs): # real signature unknown
        pass

    def _get_wbuf_len(self, *args, **kwargs): # real signature unknown
        pass

    def __del__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    bufsize = property(lambda self: object()) # default
    closed = property(lambda self: object()) # default
    mode = property(lambda self: object()) # default
    softspace = property(lambda self: object()) # default
    _close = property(lambda self: object()) # default
    _rbuf = property(lambda self: object()) # default
    _rbufsize = property(lambda self: object()) # default
    _sock = property(lambda self: object()) # default
    _wbuf = property(lambda self: object()) # default
    _wbufsize = property(lambda self: object()) # default

    default_bufsize = 8192
    name = '<socket>'
    __slots__ = [
        'mode',
        'bufsize',
        'softspace',
        '_sock',
        '_rbufsize',
        '_wbufsize',
        '_rbuf',
        '_wbuf',
        '_close',
    ]


