# encoding: utf-8
# module telnetlib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/telnetlib.pyo by generator 1.99
"""
TELNET client class.

Based on RFC 854: TELNET Protocol Specification, by J. Postel and
J. Reynolds

Example:

>>> from telnetlib import Telnet
>>> tn = Telnet('www.python.org', 79)   # connect to finger port
>>> tn.write('guido\r\n')
>>> print tn.read_all()
Login       Name               TTY         Idle    When    Where
guido    Guido van Rossum      pts/2        <Dec  2 11:10> snag.cnri.reston..

>>>

Note that read_all() won't read until eof -- it just reads some data
-- but it guarantees to read at least one byte unless EOF is hit.

It is possible to pass a Telnet object to select.select() in order to
wait until more data is available.  Note that in this case,
read_eager() may return '' even if there was data on the socket,
because the protocol negotiation may have eaten the data.  This is why
EOFError is needed in some cases to distinguish between "no data" and
"connection closed" (since the socket also appears ready for reading
when it is closed).

To do:
- option negotiation
- timeout should be intrinsic to the connection object instead of an
  option on one of the read calls only
"""

# imports
import select as select # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/select.so
import sys as sys # <module 'sys' (built-in)>
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/socket.pyc

# Variables with simple values

AO = '\xf5'

AUTHENTICATION = '%'

AYT = '\xf6'

BINARY = '\x00'

BM = '\x13'

BRK = '\xf3'

CHARSET = '*'

COM_PORT_OPTION = ','

DEBUGLEVEL = 0
DET = '\x14'

DM = '\xf2'

DO = '\xfd'
DONT = '\xfe'

EC = '\xf7'
ECHO = '\x01'

EL = '\xf8'

ENCRYPT = '&'

EOR = '\x19'

EXOPL = '\xff'

FORWARD_X = '1'

GA = '\xf9'

IAC = '\xff'

IP = '\xf4'

KERMIT = '/'

LFLOW = '!'

LINEMODE = '"'

LOGOUT = '\x12'

NAMS = '\x04'
NAOCRD = '\n'
NAOFFD = '\r'
NAOHTD = '\x0c'
NAOHTS = '\x0b'
NAOL = '\x08'
NAOLFD = '\x10'
NAOP = '\t'
NAOVTD = '\x0f'
NAOVTS = '\x0e'
NAWS = '\x1f'

NEW_ENVIRON = "'"

NOOPT = '\x00'
NOP = '\xf1'

OLD_ENVIRON = '$'

OUTMRK = '\x1b'

PRAGMA_HEARTBEAT = '\x8c'
PRAGMA_LOGON = '\x8a'

RCP = '\x02'
RCTE = '\x07'

RSP = '+'

SB = '\xfa'

SE = '\xf0'

SEND_URL = '0'

SGA = '\x03'

SNDLOC = '\x17'

SSPI_LOGON = '\x8b'

STATUS = '\x05'

SUPDUP = '\x15'
SUPDUPOUTPUT = '\x16'

SUPPRESS_LOCAL_ECHO = '-'

TELNET_PORT = 23

theNULL = '\x00'

TLS = '.'

TM = '\x06'

TN3270E = '('

TSPEED = ' '

TTYLOC = '\x1c'
TTYPE = '\x18'

TUID = '\x1a'

VT3270REGIME = '\x1d'

WILL = '\xfb'

WONT = '\xfc'

X3PAD = '\x1e'

XASCII = '\x11'
XAUTH = ')'

XDISPLOC = '#'

# functions

def test(): # reliably restored by inspect
    """
    Test program for telnetlib.
    
        Usage: python telnetlib.py [-d] ... [host [port]]
    
        Default host is localhost; default port is 23.
    """
    pass


# no classes
# variables with complex values

Telnet = None # (!) real value is ''

__all__ = [
    'Telnet',
]

