# encoding: utf-8
# module timeit
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/timeit.pyo by generator 1.99
"""
Tool for measuring execution time of small code snippets.

This module avoids a number of common traps for measuring execution
times.  See also Tim Peters' introduction to the Algorithms chapter in
the Python Cookbook, published by O'Reilly.

Library usage: see the Timer class.

Command line usage:
    python timeit.py [-n N] [-r N] [-s S] [-t] [-c] [-h] [statement]

Options:
  -n/--number N: how many times to execute 'statement' (default: see below)
  -r/--repeat N: how many times to repeat the timer (default 3)
  -s/--setup S: statement to be executed once initially (default 'pass')
  -t/--time: use time.time() (default on Unix)
  -c/--clock: use time.clock() (default on Windows)
  -v/--verbose: print raw timing results; repeat for more digits precision
  -h/--help: print this usage message and exit
  statement: statement to be timed (default 'pass')

A multi-line statement may be given by specifying each line as a
separate argument; indented lines are possible by enclosing an
argument in quotes and using leading spaces.  Multiple -s options are
treated similarly.

If -n is not given, a suitable number of loops is calculated by trying
successive powers of 10 until the total time is at least 0.2 seconds.

The difference in default timer function is because on Windows,
clock() has microsecond granularity but time()'s granularity is 1/60th
of a second; on Unix, clock() has 1/100th of a second granularity and
time() is much more precise.  On either platform, the default timer
functions measure wall clock time, not the CPU time.  This means that
other processes running on the same computer may interfere with the
timing.  The best thing to do when accurate timing is necessary is to
repeat the timing a few times and use the best time.  The -r option is
good for this; the default of 3 repetitions is probably enough in most
cases.  On Unix, you can use clock() to measure CPU time.

Note: there is a certain baseline overhead associated with executing a
pass statement.  The code here doesn't try to hide it, but you should
be aware of it.  The baseline overhead can be measured by invoking the
program without arguments.

The baseline overhead differs between Python versions!  Also, to
fairly compare older Python versions to Python 2.3, you may want to
use python -O for the older versions to avoid timing SET_LINENO
instructions.
"""

# imports
import sys as sys # <module 'sys' (built-in)>
import itertools as itertools # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/itertools.so
import gc as gc # <module 'gc' (built-in)>
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/time.so

# Variables with simple values

default_number = 1000000
default_repeat = 3

dummy_src_name = '<timeit-src>'

template = '\ndef inner(_it, _timer):\n    %(setup)s\n    _t0 = _timer()\n    for _i in _it:\n        %(stmt)s\n    _t1 = _timer()\n    return _t1 - _t0\n'

# functions

def default_timer(*args, **kwargs): # real signature unknown
    """
    time() -> floating point number
    
    Return the current time in seconds since the Epoch.
    Fractions of a second may be present if the system clock provides them.
    """
    pass


def main(args=None): # reliably restored by inspect
    """
    Main program, used when run as a script.
    
        The optional argument specifies the command line to be parsed,
        defaulting to sys.argv[1:].
    
        The return value is an exit code to be passed to sys.exit(); it
        may be None to indicate success.
    
        When an exception happens during timing, a traceback is printed to
        stderr and the return value is 1.  Exceptions at other times
        (including the template compilation) are not caught.
    """
    pass


def reindent(src, indent): # reliably restored by inspect
    """ Helper to reindent a multi-line statement. """
    pass


def repeat(stmt=None, setup=None, timer='<built-in function time>', repeat=3, number=1000000): # reliably restored by inspect
    """ Convenience function to create Timer object and call repeat method. """
    pass


def timeit(stmt=None, setup=None, timer='<built-in function time>', number=1000000): # reliably restored by inspect
    """ Convenience function to create Timer object and call timeit method. """
    pass


def _template_func(setup, func): # reliably restored by inspect
    """ Create a timer function. Used if the "statement" is a callable. """
    pass


# no classes
# variables with complex values

Timer = None # (!) real value is ''

__all__ = [
    'Timer',
]

