# encoding: utf-8
# module traceback
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/traceback.pyo by generator 1.99
""" Extract, format and print information about Python stack traces. """

# imports
import sys as sys # <module 'sys' (built-in)>
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/types.pyc
import linecache as linecache # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/linecache.pyc

# functions

def extract_stack(f=None, limit=None): # reliably restored by inspect
    """
    Extract the raw traceback from the current stack frame.
    
        The return value has the same format as for extract_tb().  The
        optional 'f' and 'limit' arguments have the same meaning as for
        print_stack().  Each item in the list is a quadruple (filename,
        line number, function name, text), and the entries are in order
        from oldest to newest stack frame.
    """
    pass


def extract_tb(tb, limit=None): # reliably restored by inspect
    """
    Return list of up to limit pre-processed entries from traceback.
    
        This is useful for alternate formatting of stack traces.  If
        'limit' is omitted or None, all entries are extracted.  A
        pre-processed stack trace entry is a quadruple (filename, line
        number, function name, text) representing the information that is
        usually printed for a stack trace.  The text is a string with
        leading and trailing whitespace stripped; if the source is not
        available it is None.
    """
    pass


def format_exc(limit=None): # reliably restored by inspect
    """ Like print_exc() but return a string. """
    pass


def format_exception(etype, value, tb, limit=None): # reliably restored by inspect
    """
    Format a stack trace and the exception information.
    
        The arguments have the same meaning as the corresponding arguments
        to print_exception().  The return value is a list of strings, each
        ending in a newline and some containing internal newlines.  When
        these lines are concatenated and printed, exactly the same text is
        printed as does print_exception().
    """
    pass


def format_exception_only(etype, value): # reliably restored by inspect
    """
    Format the exception part of a traceback.
    
        The arguments are the exception type and value such as given by
        sys.last_type and sys.last_value. The return value is a list of
        strings, each ending in a newline.
    
        Normally, the list contains a single string; however, for
        SyntaxError exceptions, it contains several lines that (when
        printed) display detailed information about where the syntax
        error occurred.
    
        The message indicating which exception occurred is always the last
        string in the list.
    """
    pass


def format_list(extracted_list): # reliably restored by inspect
    """
    Format a list of traceback entry tuples for printing.
    
        Given a list of tuples as returned by extract_tb() or
        extract_stack(), return a list of strings ready for printing.
        Each string in the resulting list corresponds to the item with the
        same index in the argument list.  Each string ends in a newline;
        the strings may contain internal newlines as well, for those items
        whose source text line is not None.
    """
    pass


def format_stack(f=None, limit=None): # reliably restored by inspect
    """ Shorthand for 'format_list(extract_stack(f, limit))'. """
    pass


def format_tb(tb, limit=None): # reliably restored by inspect
    """ A shorthand for 'format_list(extract_stack(f, limit)). """
    pass


def print_exc(limit=None, file=None): # reliably restored by inspect
    """
    Shorthand for 'print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback, limit, file)'.
        (In fact, it uses sys.exc_info() to retrieve the same information
        in a thread-safe way.)
    """
    pass


def print_exception(etype, value, tb, limit=None, file=None): # reliably restored by inspect
    """
    Print exception up to 'limit' stack trace entries from 'tb' to 'file'.
    
        This differs from print_tb() in the following ways: (1) if
        traceback is not None, it prints a header "Traceback (most recent
        call last):"; (2) it prints the exception type and value after the
        stack trace; (3) if type is SyntaxError and value has the
        appropriate format, it prints the line where the syntax error
        occurred with a caret on the next line indicating the approximate
        position of the error.
    """
    pass


def print_last(limit=None, file=None): # reliably restored by inspect
    """
    This is a shorthand for 'print_exception(sys.last_type,
        sys.last_value, sys.last_traceback, limit, file)'.
    """
    pass


def print_list(extracted_list, file=None): # reliably restored by inspect
    """
    Print the list of tuples as returned by extract_tb() or
        extract_stack() as a formatted stack trace to the given file.
    """
    pass


def print_stack(f=None, limit=None, file=None): # reliably restored by inspect
    """
    Print a stack trace from its invocation point.
    
        The optional 'f' argument can be used to specify an alternate
        stack frame at which to start. The optional 'limit' and 'file'
        arguments have the same meaning as for print_exception().
    """
    pass


def print_tb(tb, limit=None, file=None): # reliably restored by inspect
    """
    Print up to 'limit' stack trace entries from the traceback 'tb'.
    
        If 'limit' is omitted or None, all entries are printed.  If 'file'
        is omitted or None, the output goes to sys.stderr; otherwise
        'file' should be an open file or file-like object with a write()
        method.
    """
    pass


def tb_lineno(tb): # reliably restored by inspect
    """
    Calculate correct line number of traceback given in tb.
    
        Obsolete in 2.3.
    """
    pass


def _format_final_exc_line(etype, value): # reliably restored by inspect
    """ Return a list of a single line -- normal case for format_exception_only """
    pass


def _print(file, str=None, terminator=None): # reliably restored by inspect
    # no doc
    pass


def _some_str(value): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

__all__ = [
    'extract_stack',
    'extract_tb',
    'format_exception',
    'format_exception_only',
    'format_list',
    'format_stack',
    'format_tb',
    'print_exc',
    'format_exc',
    'print_exception',
    'print_last',
    'print_stack',
    'print_tb',
    'tb_lineno',
]

