# encoding: utf-8
# module warnings
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/warnings.pyo by generator 1.99
""" Python part of the warnings subsystem. """

# imports
import sys as sys # <module 'sys' (built-in)>
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/types.pyc
import linecache as linecache # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/linecache.pyc
from _warnings import warn, warn_explicit


# Variables with simple values

defaultaction = 'default'

default_action = 'default'

# functions

def filterwarnings(action, message=None, category="<type 'exceptions.Warning'>", module=None, lineno=0, append=0): # reliably restored by inspect
    """
    Insert an entry into the list of warnings filters (at the front).
    
        Use assertions to check that all arguments have the right type.
    """
    pass


def formatwarning(message, category, filename, lineno, line=None): # reliably restored by inspect
    """ Function to format a warning the standard way. """
    pass


def resetwarnings(): # reliably restored by inspect
    """ Clear the list of warning filters, so that no filters are active. """
    pass


def showwarning(message, category, filename, lineno, file=None, line=None): # reliably restored by inspect
    """ Hook to write a warning to a file; replace if you like. """
    pass


def simplefilter(action, category="<type 'exceptions.Warning'>", lineno=0, append=0): # reliably restored by inspect
    """
    Insert a simple entry into the list of warnings filters (at the front).
    
        A simple filter matches all modules and messages.
    """
    pass


def warnpy3k(message, category=None, stacklevel=1): # reliably restored by inspect
    """
    Issue a deprecation warning for Python 3.x related changes.
    
        Warnings are omitted unless Python is started with the -3 option.
    """
    pass


def _getaction(action): # reliably restored by inspect
    # no doc
    pass


def _getcategory(category): # reliably restored by inspect
    # no doc
    pass


def _processoptions(args): # reliably restored by inspect
    # no doc
    pass


def _setoption(arg): # reliably restored by inspect
    # no doc
    pass


def _show_warning(message, category, filename, lineno, file=None, line=None): # reliably restored by inspect
    """ Hook to write a warning to a file; replace if you like. """
    pass


# classes

class catch_warnings(object):
    """
    A context manager that copies and restores the warnings filter upon
        exiting the context.
    
        The 'record' argument specifies whether warnings should be captured by a
        custom implementation of warnings.showwarning() and be appended to a list
        returned by the context manager. Otherwise None is returned by the context
        manager. The objects appended to the list are arguments whose attributes
        mirror the arguments to showwarning().
    
        The 'module' argument is to specify an alternative module to the module
        named 'warnings' and imported under that name. This argument is only useful
        when testing the warnings module itself.
    """
    def __enter__(self, *args, **kwargs): # real signature unknown
        pass

    def __exit__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Specify whether to record warnings and if an alternative module
                should be used other than sys.modules['warnings'].
        
                For compatibility with Python 3.0, please consider all arguments to be
                keyword-only.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class WarningMessage(object):
    """ Holds the result of a single showwarning() call. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _WARNING_DETAILS = (
        'message',
        'category',
        'filename',
        'lineno',
        'file',
        'line',
    )
    __dict__ = None # (!) real value is ''


class _OptionError(Exception):
    """ Exception used by option processing helpers. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

filters = [
    (
        'ignore',
        None,
        PendingDeprecationWarning,
        None,
        0,
    ),
    (
        'ignore',
        None,
        ImportWarning,
        None,
        0,
    ),
    (
        'ignore',
        None,
        BytesWarning,
        None,
        0,
    ),
]

onceregistry = {}

once_registry = {}

__all__ = [
    'warn',
    'showwarning',
    'formatwarning',
    'filterwarnings',
    'resetwarnings',
    'catch_warnings',
]

