# encoding: utf-8
# module webbrowser
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/webbrowser.pyo by generator 1.99
""" Interfaces for launching and remotely controlling Web browsers. """

# imports
import subprocess as subprocess # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/subprocess.pyc
import ic as ic # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/plat-mac/ic.pyc
import stat as stat # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/stat.pyc
import sys as sys # <module 'sys' (built-in)>
import shlex as shlex # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/shlex.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# functions

def get(using=None): # reliably restored by inspect
    """ Return a browser launcher instance appropriate for the environment. """
    pass


def main(): # reliably restored by inspect
    # no doc
    pass


def open(url, new=0, autoraise=1): # reliably restored by inspect
    # no doc
    pass


def open_new(url): # reliably restored by inspect
    # no doc
    pass


def open_new_tab(url): # reliably restored by inspect
    # no doc
    pass


def register(name, klass, instance=None, update_tryorder=1): # reliably restored by inspect
    """ Register a browser connector and, optionally, connection. """
    pass


def register_X_browsers(): # reliably restored by inspect
    # no doc
    pass


def _iscommand(cmd): # reliably restored by inspect
    """
    Return True if cmd is executable or can be found on the executable
        search path.
    """
    pass


def _isexecutable(cmd): # reliably restored by inspect
    # no doc
    pass


def _synthesize(browser, update_tryorder=1): # reliably restored by inspect
    """
    Attempt to synthesize a controller base on existing controllers.
    
        This is useful to create a controller when a user specifies a path to
        an entry in the BROWSER environment variable -- we can copy a general
        controller to operate using a specific installation of the desired
        browser in this way.
    
        If we can't create a controller in this way, or if there is no
        executable for the requested browser, return [None, None].
    """
    pass


# classes

class BaseBrowser(object):
    """ Parent class for all browsers. Do not use directly. """
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def open_new(self, *args, **kwargs): # real signature unknown
        pass

    def open_new_tab(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    args = [
        '%s',
    ]
    __dict__ = None # (!) real value is ''


class GenericBrowser(BaseBrowser):
    """
    Class for all browsers started with a command
           and without remote functionality.
    """
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class BackgroundBrowser(GenericBrowser):
    """
    Class for all browsers which are to be started in the
           background.
    """
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnixBrowser(BaseBrowser):
    """ Parent class for all Unix browsers with remote functionality. """
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def _invoke(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    background = False
    raise_opts = None
    redirect_stdout = True
    remote_action = None
    remote_action_newtab = None
    remote_action_newwin = None
    remote_args = [
        '%action',
        '%s',
    ]


class Elinks(UnixBrowser):
    """ Launcher class for Elinks browsers. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    background = False
    redirect_stdout = False
    remote_action = ''
    remote_action_newtab = ',new-tab'
    remote_action_newwin = ',new-window'
    remote_args = [
        '-remote',
        'openURL(%s%action)',
    ]


class Error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class Galeon(UnixBrowser):
    """ Launcher class for Galeon/Epiphany browsers. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    background = True
    raise_opts = [
        '-noraise',
        '',
    ]
    remote_action = '-n'
    remote_action_newwin = '-w'
    remote_args = [
        '%action',
        '%s',
    ]


class Grail(BaseBrowser):
    # no doc
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def _find_grail_rc(self, *args, **kwargs): # real signature unknown
        pass

    def _remote(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class InternetConfig(BaseBrowser):
    # no doc
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class Konqueror(BaseBrowser):
    """
    Controller for the KDE File Manager (kfm, or Konqueror).
    
        See the output of ``kfmclient --commands``
        for more information on the Konqueror remote-control interface.
    """
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class MacOSX(BaseBrowser):
    """
    Launcher class for Aqua browsers on Mac OS X
    
            Optionally specify a browser name on instantiation.  Note that this
            will not work for Aqua browsers if the user has moved the application
            package after installation.
    
            If no browser is specified, the default browser, as specified in the
            Internet System Preferences panel, will be used.
    """
    def open(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class Netscape(UnixBrowser):
    """ Launcher class for Mozilla/Netscape browsers. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    background = True
    raise_opts = [
        '-noraise',
        '-raise',
    ]
    remote_action = ''
    remote_action_newtab = ',new-tab'
    remote_action_newwin = ',new-window'
    remote_args = [
        '-remote',
        'openURL(%s%action)',
    ]


Mozilla = Netscape


class Opera(UnixBrowser):
    """ Launcher class for Opera browser. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    background = True
    raise_opts = [
        '',
        '-raise',
    ]
    remote_action = ''
    remote_action_newtab = ',new-page'
    remote_action_newwin = ',new-window'
    remote_args = [
        '-remote',
        'openURL(%s%action)',
    ]


# variables with complex values

_browsers = {
    'internet-config': [
        InternetConfig,
        None,
    ],
    'macosx': [
        None,
        None, # (!) real value is ''
    ],
}

_tryorder = [
    'MacOSX',
    'internet-config',
]

__all__ = [
    'Error',
    'open',
    'open_new',
    'open_new_tab',
    'get',
    'register',
]

