# encoding: utf-8
# module xml.dom.__init__
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/xml/dom/__init__.pyo by generator 1.99
"""
W3C Document Object Model implementation for Python.

The Python mapping of the Document Object Model is documented in the
Python Library Reference in the section on the xml.dom package.

This package contains the following modules:

minidom -- A simple implementation of the Level 1 DOM with namespace
           support added (based on the Level 2 specification) and other
           minor Level 2 functionality.

pulldom -- DOM builder supporting on-demand tree-building for selected
           subtrees of the document.
"""
# no imports

# Variables with simple values

DOMSTRING_SIZE_ERR = 2

EMPTY_NAMESPACE = None
EMPTY_PREFIX = None

HIERARCHY_REQUEST_ERR = 3

INDEX_SIZE_ERR = 1

INUSE_ATTRIBUTE_ERR = 10

INVALID_ACCESS_ERR = 15

INVALID_CHARACTER_ERR = 5

INVALID_MODIFICATION_ERR = 13

INVALID_STATE_ERR = 11

NAMESPACE_ERR = 14

NOT_FOUND_ERR = 8

NOT_SUPPORTED_ERR = 9

NO_DATA_ALLOWED_ERR = 6

NO_MODIFICATION_ALLOWED_ERR = 7

SYNTAX_ERR = 12

VALIDATION_ERR = 16

WRONG_DOCUMENT_ERR = 4

XHTML_NAMESPACE = 'http://www.w3.org/1999/xhtml'

XMLNS_NAMESPACE = 'http://www.w3.org/2000/xmlns/'

XML_NAMESPACE = 'http://www.w3.org/XML/1998/namespace'

# functions

def getDOMImplementation(name=None, features='()'): # reliably restored by inspect
    """
    getDOMImplementation(name = None, features = ()) -> DOM implementation.
    
        Return a suitable DOM implementation. The name is either
        well-known, the module name of a DOM implementation, or None. If
        it is not None, imports the corresponding module and returns
        DOMImplementation object if the import succeeds.
    
        If name is not given, consider the available implementations to
        find one with the required feature set. If no implementation can
        be found, raise an ImportError. The features list must be a sequence
        of (feature, version) pairs which are passed to hasFeature.
    """
    pass


def registerDOMImplementation(name, factory): # reliably restored by inspect
    """
    registerDOMImplementation(name, factory)
    
        Register the factory function with the name. The factory function
        should return an object which implements the DOMImplementation
        interface. The factory function can either return the same object,
        or a new one (e.g. if that implementation supports some
        customization).
    """
    pass


# classes

class DOMException(Exception):
    """
    Abstract base class for DOM exceptions.
        Exceptions with specific codes are specializations of this class.
    """
    def _get_code(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class DomstringSizeErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 2


class HierarchyRequestErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 3


class IndexSizeErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 1


class InuseAttributeErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 10


class InvalidAccessErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 15


class InvalidCharacterErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 5


class InvalidModificationErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 13


class InvalidStateErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 11


class NamespaceErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 14


class NoDataAllowedErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 6


class NoModificationAllowedErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 7


class NotFoundErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 8


class NotSupportedErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 9


class SyntaxErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 12


class ValidationErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 16


class WrongDocumentErr(DOMException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    code = 4


# variables with complex values

Node = None # (!) real value is ''

UserDataHandler = None # (!) real value is ''

