/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.codeInsight.daemon.lambda;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspection;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.testFramework.IdeaTestUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MostSpecificResolutionTest extends LightDaemonAnalyzerTestCase {
  @NonNls static final String BASE_PATH = "/codeInsight/daemonCodeAnalyzer/lambda/mostSpecific";

  @NotNull
  @Override
  protected LocalInspectionTool[] configureLocalInspectionTools() {
    return new LocalInspectionTool[]{
      new UnusedSymbolLocalInspection(),
    };
  }

  public void testVoidConflict() throws Exception {
    doTest();
  }

  public void testNestedLambdaSpecifics() throws Exception {
    doTest();
  }

  public void testBothVarargs() throws Exception {
    doTest();
  }

  public void testNestedVarargs() throws Exception {
    doTest();
  }

  public void testMostSpecificForSameFunctionalTypes() throws Exception {
    doTest();
  }

  public void testIDEA121884() throws Exception {
    doTest();
  }

  public void testIDEA121999() throws Exception {
    doTest();
  }

  public void testRelatedSAMErasures() throws Exception {
    doTest();
  }

  public void testJDK8034223() throws Exception {
    doTest();
  }

  public void testIDEA123352() throws Exception {
    doTest();
  }

  public void testIncompleteMethodInInterface() throws Exception {
    doTest(false);
  }

  public void testMostSpecificByReturnType() throws Exception {
    doTest();
  }

  public void testDifferentParamsLength() throws Exception {
    doTest(false);
  }

  public void testNoReturnTypeResolutionForThrownException() throws Exception {
    doTest(false);
  }

  public void testBoxingAndOverloadResolution() throws Exception {
    doTest();
  }

  public void testSuperMethodsInExactCheck() throws Exception {
    doTest();
  }

  public void testTargetTypeParameter() throws Exception {
    doTest(false);
  }

  public void testJDK8042508() throws Exception {
    doTest(false);
  }

  public void testIDEA125855() throws Exception {
    doTest();
  }

  public void testIDEA127584() throws Exception {
    doTest();
  }

  private void doTest() {
    doTest(true);
  }

  private void doTest(boolean warnings) {
    IdeaTestUtil.setTestVersion(JavaSdkVersion.JDK_1_8, getModule(), getTestRootDisposable());
    doTest(BASE_PATH + "/" + getTestName(false) + ".java", warnings, false);
  }

  @Override
  protected Sdk getProjectJDK() {
    return IdeaTestUtil.getMockJdk18();
  }
}
