# encoding: utf-8
# module BaseHTTPServer
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/BaseHTTPServer.pyo by generator 1.99
"""
HTTP server base class.

Note: the class in this module doesn't implement any HTTP request; see
SimpleHTTPServer for simple implementations of GET, HEAD and POST
(including CGI scripts).  It does, however, optionally implement HTTP/1.1
persistent connections, as of version 0.3.

Contents:

- BaseHTTPRequestHandler: HTTP request handler base class
- test: test function

XXX To do:

- log requests even later (to capture byte count)
- log user-agent header and other interesting goodies
- send error log to separate file
"""

# imports
import mimetools as mimetools # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/mimetools.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyc
import sys as sys # <module 'sys' (built-in)>
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so
import SocketServer as SocketServer # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/SocketServer.pyc

# Variables with simple values

DEFAULT_ERROR_CONTENT_TYPE = 'text/html'

DEFAULT_ERROR_MESSAGE = '<head>\n<title>Error response</title>\n</head>\n<body>\n<h1>Error response</h1>\n<p>Error code %(code)d.\n<p>Message: %(message)s.\n<p>Error code explanation: %(code)s = %(explain)s.\n</body>\n'

__version__ = '0.3'

# functions

def filterwarnings(action, message=None, category="<type 'exceptions.Warning'>", module=None, lineno=0, append=0): # reliably restored by inspect
    """
    Insert an entry into the list of warnings filters (at the front).
    
        'action' -- one of "error", "ignore", "always", "default", "module",
                    or "once"
        'message' -- a regex that the warning message must match
        'category' -- a class that the warning must be a subclass of
        'module' -- a regex that the module name must match
        'lineno' -- an integer line number, 0 matches all warnings
        'append' -- if true, append to the list of filters
    """
    pass


def test(HandlerClass='<class BaseHTTPServer.BaseHTTPRequestHandler at 0x104bbb600>', ServerClass='<class BaseHTTPServer.HTTPServer at 0x104bbb598>', protocol=None): # reliably restored by inspect
    """
    Test the HTTP request handler class.
    
        This runs an HTTP server on port 8000 (or the first command line
        argument).
    """
    pass


def _quote_html(html): # reliably restored by inspect
    # no doc
    pass


# classes

class catch_warnings(object):
    """
    A context manager that copies and restores the warnings filter upon
        exiting the context.
    
        The 'record' argument specifies whether warnings should be captured by a
        custom implementation of warnings.showwarning() and be appended to a list
        returned by the context manager. Otherwise None is returned by the context
        manager. The objects appended to the list are arguments whose attributes
        mirror the arguments to showwarning().
    
        The 'module' argument is to specify an alternative module to the module
        named 'warnings' and imported under that name. This argument is only useful
        when testing the warnings module itself.
    """
    def __enter__(self, *args, **kwargs): # real signature unknown
        pass

    def __exit__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Specify whether to record warnings and if an alternative module
                should be used other than sys.modules['warnings'].
        
                For compatibility with Python 3.0, please consider all arguments to be
                keyword-only.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

BaseHTTPRequestHandler = None # (!) real value is ''

HTTPServer = None # (!) real value is ''

__all__ = [
    'HTTPServer',
    'BaseHTTPRequestHandler',
]

