# encoding: utf-8
# module Bastion
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/Bastion.pyo by generator 1.99
"""
Bastionification utility.

A bastion (for another object -- the 'original') is an object that has
the same methods as the original but does not give access to its
instance variables.  Bastions have a number of uses, but the most
obvious one is to provide code executing in restricted mode with a
safe interface to an object implemented in unrestricted mode.

The bastionification routine has an optional second argument which is
a filter function.  Only those methods for which the filter method
(called with the method name as argument) returns true are accessible.
The default filter method returns true unless the method name begins
with an underscore.

There are a number of possible implementations of bastions.  We use a
'lazy' approach where the bastion's __getattr__() discipline does all
the work for a particular method the first time it is used.  This is
usually fastest, especially if the user doesn't call all available
methods.  The retrieved methods are stored as instance variables of
the bastion, so the overhead is only occurred on the first use of each
method.

Detail: the bastion class has a __repr__() discipline which includes
the repr() of the original object.  This is precomputed when the
bastion is created.
"""
# no imports

# functions

def Bastion(object, filter='<function <lambda> at 0x10c36ca28>', name=None, bastionclass='<class Bastion.BastionClass at 0x10c3a5ae0>'): # reliably restored by inspect
    """
    Create a bastion for an object, using an optional filter.
    
        See the Bastion module's documentation for background.
    
        Arguments:
    
        object - the original object
        filter - a predicate that decides whether a function name is OK;
                 by default all names are OK that don't start with '_'
        name - the name of the object; default repr(object)
        bastionclass - class used to create the bastion; default BastionClass
    """
    pass


def _test(): # reliably restored by inspect
    """ Test the Bastion() function. """
    pass


# classes

class MethodType(object):
    """
    instancemethod(function, instance, class)
    
    Create an instance method object.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, function, instance, p_class): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    im_class = property(lambda self: object()) # default
    im_func = property(lambda self: object()) # default
    im_self = property(lambda self: object()) # default
    __func__ = property(lambda self: object()) # default
    __self__ = property(lambda self: object()) # default


# variables with complex values

BastionClass = None # (!) real value is ''

__all__ = [
    'BastionClass',
    'Bastion',
]

