# encoding: utf-8
# module __future__
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/__future__.pyo by generator 1.99
"""
Record of phased-in incompatible language changes.

Each line is of the form:

    FeatureName = "_Feature(" OptionalRelease "," MandatoryRelease ","
                              CompilerFlag ")"

where, normally, OptionalRelease < MandatoryRelease, and both are 5-tuples
of the same form as sys.version_info:

    (PY_MAJOR_VERSION, # the 2 in 2.1.0a3; an int
     PY_MINOR_VERSION, # the 1; an int
     PY_MICRO_VERSION, # the 0; an int
     PY_RELEASE_LEVEL, # "alpha", "beta", "candidate" or "final"; string
     PY_RELEASE_SERIAL # the 3; an int
    )

OptionalRelease records the first release in which

    from __future__ import FeatureName

was accepted.

In the case of MandatoryReleases that have not yet occurred,
MandatoryRelease predicts the release in which the feature will become part
of the language.

Else MandatoryRelease records when the feature became part of the language;
in releases at or after that, modules no longer need

    from __future__ import FeatureName

to use the feature in question, but may continue to use such imports.

MandatoryRelease may also be None, meaning that a planned feature got
dropped.

Instances of class _Feature have two corresponding methods,
.getOptionalRelease() and .getMandatoryRelease().

CompilerFlag is the (bitfield) flag that should be passed in the fourth
argument to the builtin function compile() to enable the feature in
dynamically compiled code.  This flag is stored in the .compiler_flag
attribute on _Future instances.  These values must match the appropriate
#defines of CO_xxx flags in Include/compile.h.

No feature line is ever to be deleted from this file.
"""
# no imports

# Variables with simple values

CO_FUTURE_ABSOLUTE_IMPORT = 16384

CO_FUTURE_DIVISION = 8192

CO_FUTURE_PRINT_FUNCTION = 65536

CO_FUTURE_UNICODE_LITERALS = 131072

CO_FUTURE_WITH_STATEMENT = 32768

CO_GENERATOR_ALLOWED = 0

CO_NESTED = 16

# no functions
# no classes
# variables with complex values

absolute_import = None # (!) real value is ''

all_feature_names = [
    'nested_scopes',
    'generators',
    'division',
    'absolute_import',
    'with_statement',
    'print_function',
    'unicode_literals',
]

division = None # (!) real value is ''

generators = None # (!) real value is ''

nested_scopes = None # (!) real value is ''

print_function = None # (!) real value is ''

unicode_literals = None # (!) real value is ''

with_statement = None # (!) real value is ''

_Feature = None # (!) real value is ''

__all__ = [
    'all_feature_names',
    'nested_scopes',
    'generators',
    'division',
    'absolute_import',
    'with_statement',
    'print_function',
    'unicode_literals',
]

