# encoding: utf-8
# module _struct
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/_struct.so by generator 1.99
"""
Functions to convert between Python values and C structs represented
as Python strings. It uses format strings (explained below) as compact
descriptions of the lay-out of the C structs and the intended conversion
to/from Python values.

The optional first format char indicates byte order, size and alignment:
  @: native order, size & alignment (default)
  =: native order, std. size & alignment
  <: little-endian, std. size & alignment
  >: big-endian, std. size & alignment
  !: same as >

The remaining chars indicate types of args and must match exactly;
these can be preceded by a decimal repeat count:
  x: pad byte (no data); c:char; b:signed byte; B:unsigned byte;
  ?: _Bool (requires C99; if not available, char is used instead)
  h:short; H:unsigned short; i:int; I:unsigned int;
  l:long; L:unsigned long; f:float; d:double.
Special cases (preceding decimal count indicates length):
  s:string (array of char); p: pascal string (with count byte).
Special case (only available in native format):
  P:an integer type that is wide enough to hold a pointer.
Special case (not in native mode unless 'long long' in platform C):
  q:long long; Q:unsigned long long
Whitespace between formats is ignored.

The variable struct.error is an exception raised on errors.
"""
# no imports

# Variables with simple values

_PY_STRUCT_FLOAT_COERCE = 1

_PY_STRUCT_RANGE_CHECKING = 1

__version__ = '0.2'

# functions

def calcsize(*args, **kwargs): # real signature unknown
    """ Return size of C struct described by format string fmt. """
    pass


def pack(*args, **kwargs): # real signature unknown
    """ Return string containing values v1, v2, ... packed according to fmt. """
    pass


def pack_into(*args, **kwargs): # real signature unknown
    """
    Pack the values v1, v2, ... according to fmt.
    Write the packed bytes into the writable buffer buf starting at offset.
    """
    pass


def unpack(*args, **kwargs): # real signature unknown
    """
    Unpack the string containing packed C structure data, according to fmt.
    Requires len(string) == calcsize(fmt).
    """
    pass


def unpack_from(*args, **kwargs): # real signature unknown
    """
    Unpack the buffer, containing packed C structure data, according to
    fmt, starting at offset. Requires len(buffer[offset:]) >= calcsize(fmt).
    """
    pass


def _clearcache(*args, **kwargs): # real signature unknown
    """ Clear the internal cache. """
    pass


# classes

class error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class Struct(object):
    """ Compiled struct object """
    def pack(self, v1, v2, *more): # real signature unknown; restored from __doc__
        """
        S.pack(v1, v2, ...) -> string
        
        Return a string containing values v1, v2, ... packed according to this
        Struct's format. See struct.__doc__ for more on format strings.
        """
        return ""

    def pack_into(self, buffer, offset, v1, v2, *more): # real signature unknown; restored from __doc__
        """
        S.pack_into(buffer, offset, v1, v2, ...)
        
        Pack the values v1, v2, ... according to this Struct's format, write 
        the packed bytes into the writable buffer buf starting at offset.  Note
        that the offset is not an optional argument.  See struct.__doc__ for 
        more on format strings.
        """
        pass

    def unpack(self, p_str): # real signature unknown; restored from __doc__
        """
        S.unpack(str) -> (v1, v2, ...)
        
        Return tuple containing values unpacked according to this Struct's format.
        Requires len(str) == self.size. See struct.__doc__ for more on format
        strings.
        """
        pass

    def unpack_from(self, buffer, offset=None): # real signature unknown; restored from __doc__
        """
        S.unpack_from(buffer[, offset]) -> (v1, v2, ...)
        
        Return tuple containing values unpacked according to this Struct's format.
        Unlike unpack, unpack_from can unpack values from any object supporting
        the buffer API, not just str. Requires len(buffer[offset:]) >= self.size.
        See struct.__doc__ for more on format strings.
        """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    format = property(lambda self: object()) # default
    size = property(lambda self: object()) # default


