# encoding: utf-8
# module aepack
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/plat-mac/aepack.pyo by generator 1.99
"""
Tools for use in AppleEvent clients and servers:
conversion between AE types and python types

pack(x) converts a Python object to an AEDesc object
unpack(desc) does the reverse
coerce(x, wanted_sample) coerces a python object to another python object
"""

# imports
import aetypes as aetypes # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/plat-mac/aetypes.pyc
import Carbon as Carbon # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/plat-mac/Carbon/__init__.pyc
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/types.pyc
import MacOS as MacOS # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/MacOS.so
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/struct.pyc
import Carbon.AE as AE # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/plat-mac/Carbon/AE.pyc
from _AE import AEDescType


# Variables with simple values

cADBAddress = 'cadb'
cAddressSpec = 'cadr'
cAEList = 'list'
cAppleTalkAddress = 'cat '
cApplication = 'capp'
cArc = 'carc'

cBoolean = 'bool'
cBusAddress = 'cbus'

cCell = 'ccel'
cChar = 'cha '
cColorTable = 'clrt'
cColumn = 'ccol'

cDevSpec = 'cdev'
cDocument = 'docu'
cDrawingArea = 'cdrw'

cEnumeration = 'enum'
cEthernetAddress = 'cen '

cFile = 'file'
cFireWireAddress = 'cfw '
cFixed = 'fixd'
cFixedPoint = 'fpnt'
cFixedRectangle = 'frct'
cFTPItem = 'ftp '

cGraphicLine = 'glin'
cGraphicObject = 'cgob'
cGraphicShape = 'cgsh'
cGraphicText = 'cgtx'
cGroupedGraphic = 'cpic'

cHTML = 'html'

cInsertionLoc = 'insl'
cInsertionPoint = 'cins'
cInternetAddress = 'IPAD'
cIntlText = 'itxt'
cIntlWritingCode = 'intl'
cIPAddress = 'cip '
cItem = 'citm'

cKeystroke = 'kprs'

cLine = 'clin'
cLocalTalkAddress = 'clt '
cLongDateTime = 'ldt '
cLongFixed = 'lfxd'
cLongFixedPoint = 'lfpt'
cLongFixedRectangle = 'lfrc'
cLongInteger = 'long'
cLongPoint = 'lpnt'
cLongRectangle = 'lrct'

cMachineLoc = 'mLoc'
cMenu = 'cmnu'
cMenuItem = 'cmen'

cObject = 'cobj'
cObjectSpecifier = 'obj '
cOpenableObject = 'coob'
cOval = 'covl'

cParagraph = 'cpar'
cPICT = 'PICT'
cPixel = 'cpxl'
cPixelMap = 'cpix'
cPolygon = 'cpgn'
cProperty = 'prop'

cQDPoint = 'QDpt'
cQDRectangle = 'qdrt'

cRectangle = 'crec'
cRGBColor = 'cRGB'
cRotation = 'trot'
cRoundedRectangle = 'crrc'
cRow = 'crow'

cSCSIAddress = 'cscs'
cSelection = 'csel'
cShortInteger = 'shor'

cTable = 'ctbl'
cText = 'ctxt'
cTextFlow = 'cflo'
cTextStyles = 'tsty'
cTokenRingAddress = 'ctok'
cType = 'type'

cURL = 'url '
cUSBAddress = 'cusb'

cVersion = 'vers'

cWindow = 'cwin'
cWord = 'cwor'

eADB = 'eadb'
eAddressSpec = 'eads'
eAnalogAudio = 'epau'
eAppleTalk = 'epat'
eAudioLineIn = 'ecai'
eAudioLineOut = 'ecal'
eAudioOut = 'ecao'

eBus = 'ebus'

eCapsLockDown = 'Kclk'
eCDROM = 'ecd '
eClearKey = 1802716928
eCommandDown = 'Kcmd'
eCommSlot = 'eccm'
eConduit = 'econ'
eControlDown = 'Kctl'

eDeleteKey = 1802711808
eDeviceType = 'edvt'
eDigitalAudio = 'epda'
eDisplay = 'edds'
eDownArrowKey = 1802730752
eDVD = 'edvd'

eEndKey = 1802729216
eEnterKey = 1802718208
eEscapeKey = 1802712320
eEthernet = 'ecen'

eF10Key = 1802726656
eF11Key = 1802725120
eF12Key = 1802727168
eF13Key = 1802725632
eF14Key = 1802726144
eF15Key = 1802727680
eF1Key = 1802729984
eF2Key = 1802729472
eF3Key = 1802724096
eF4Key = 1802728960
eF5Key = 1802723328
eF6Key = 1802723584
eF7Key = 1802723840
eF8Key = 1802724352
eF9Key = 1802724608
eFireWire = 'ecfw'
eFloppy = 'efd '
eForwardDelKey = 1802728704

eHD = 'ehd '
eHelpKey = 1802727936
eHomeKey = 1802728192

eInfrared = 'ecir'
eIP = 'epip'
eIrDA = 'epir'
eIRTalk = 'epit'

eKeyboard = 'ekbd'
eKeyKind = 'ekst'

eLCD = 'edlc'
eLeftArrowKey = 1802730240
eLocalTalk = 'eclt'

eMacIP = 'epmi'
eMacVideo = 'epmv'
eMicrophone = 'ecmi'
eModem = 'edmm'
eModemPort = 'ecmp'
eModemPrinterPort = 'empp'
eModifiers = 'eMds'
eMonitorOut = 'ecmn'
eMouse = 'emou'

eNuBus = 'enub'
eNuBusCard = 'ednb'

enumArrows = 'arro'
enumJustification = 'just'
enumKeyForm = 'kfrm'
enumPosition = 'posi'
enumProtection = 'prtn'
enumQuality = 'qual'
enumSaveOptions = 'savo'
enumStyle = 'styl'
enumTransferMode = 'tran'

eOptionDown = 'Kopt'

ePageDownKey = 1802729728
ePageUpKey = 1802728448
ePCcard = 'ecpc'
ePCIbus = 'ecpi'
ePCIcard = 'edpi'
ePDScard = 'epds'
ePDSslot = 'ecpd'
ePointingDevice = 'edpd'
ePostScript = 'epps'
ePPP = 'eppp'
ePrinter = 'edpr'
ePrinterPort = 'ecpp'
eProtocol = 'epro'

eReturnKey = 1802707968
eRightArrowKey = 1802730496

eScheme = 'esch'
eSCSI = 'ecsc'
eSerial = 'epsr'
eShiftDown = 'Ksft'
eSpeakers = 'edsp'
eStorageDevice = 'edst'
eSVGA = 'epsg'
eSvideo = 'epsv'

eTabKey = 1802711040
eTokenRing = 'etok'
eTrackball = 'etrk'
eTrackpad = 'edtp'

eUpArrowKey = 1802731008

eurlAFP = 'afp '
eurlAT = 'at  '
eurlEPPC = 'eppc'
eurlFile = 'file'
eurlFTP = 'ftp '
eurlGopher = 'gphr'
eurlHTTP = 'http'
eurlHTTPS = 'htps'
eurlIMAP = 'imap'
eurlLaunch = 'laun'
eurlLDAP = 'uldp'
eurlMail = 'mail'
eurlMailbox = 'mbox'
eurlMessage = 'mess'
eurlMulti = 'mult'
eurlNews = 'news'
eurlNFS = 'unfs'
eurlNNTP = 'nntp'
eurlPOP = 'upop'
eurlRTSP = 'rtsp'
eurlSNews = 'snws'
eurlTelnet = 'tlnt'
eurlUnknown = 'url?'

eUSB = 'ecus'

eVideoIn = 'ecvi'
eVideoMonitor = 'edvm'
eVideoOut = 'ecvo'

formAbsolutePosition = 'indx'
formName = 'name'
formPropertyID = 'prop'
formRange = 'rang'
formRelativePosition = 'rele'
formTest = 'test'
formUniqueID = 'ID  '
formWhose = 'whos'

kAEAbout = 'abou'
kAEActivate = 'actv'
kAEAfter = 'afte'
kAEAliasSelection = 'sali'
kAEAll = 'all '
kAEAllCaps = 'alcp'
kAEAlwaysInteract = 48
kAEAND = 'AND '
kAEAnswer = 'ansr'
kAEAny = 'any '
kAEApplicationClass = 'appl'
kAEApplicationDied = 'obit'
kAEArrowAtEnd = 'aren'
kAEArrowAtStart = 'arst'
kAEArrowBothEnds = 'arbo'
kAEAsk = 'ask '
kAEAutoDown = 'auto'
kAEBefore = 'befo'
kAEBeginning = 'bgng'
kAEBeginsWith = 'bgwt'
kAEBeginTransaction = 'begi'
kAEBold = 'bold'
kAECanInteract = 32
kAECanSwitchLayer = 64
kAECaseSensEquals = 'cseq'
kAECentered = 'cent'
kAEChangeView = 'view'
kAEClone = 'clon'
kAEClose = 'clos'
kAECommandClass = 'cmnd'
kAECondensed = 'cond'
kAEContains = 'cont'
kAECopy = 'copy'
kAECoreSuite = 'core'
kAECountElements = 'cnte'
kAECreateElement = 'crel'
kAECreatePublisher = 'cpub'
kAECut = 'cut '
kAEDataArray = 0
kAEDeactivate = 'dact'
kAEDefaultTimeout = -1
kAEDelete = 'delo'
kAEDescArray = 3
kAEDescListFactorNone = 0
kAEDescListFactorType = 4
kAEDescListFactorTypeAndSize = 8
kAEDirectCall = 1
kAEDiskEvent = 'disk'
kAEDoNotIgnoreHandler = 0
kAEDontExecute = 8192
kAEDontReconnect = 128
kAEDontRecord = 4096
kAEDoObjectsExist = 'doex'
kAEDoScript = 'dosc'
kAEDown = 'down'
kAEDrag = 'drag'
kAEDuplicateSelection = 'sdup'
kAEEditGraphic = 'edit'
kAEEmptyTrash = 'empt'
kAEEnd = 'end '
kAEEndsWith = 'ends'
kAEEndTransaction = 'endt'
kAEEquals = '=   '
kAEExpanded = 'pexp'
kAEFast = 'fast'
kAEFinderEvents = 'FNDR'
kAEFirst = 'firs'
kAEFormulaProtect = 'fpro'
kAEFullyJustified = 'full'
kAEGetClassInfo = 'qobj'
kAEGetData = 'getd'
kAEGetDataSize = 'dsiz'
kAEGetEventInfo = 'gtei'
kAEGetInfoSelection = 'sinf'
kAEGetPrivilegeSelection = 'sprv'
kAEGetSuiteInfo = 'gtsi'
kAEGreaterThan = '>   '
kAEGreaterThanEquals = '>=  '
kAEGrow = 'grow'
kAEHandleArray = 2
kAEHandleSimpleRanges = 32
kAEHidden = 'hidn'
kAEHighLevel = 'high'
kAEHighPriority = 1
kAEHiQuality = 'hiqu'
kAEIDoMarking = 4
kAEIDoMinimum = 0
kAEIDoWhose = 1
kAEIgnoreAppEventHandler = 2
kAEIgnoreAppPhacHandler = 1
kAEIgnoreSysEventHandler = 8
kAEIgnoreSysPhacHandler = 4
kAEImageGraphic = 'imgr'
kAEInfo = 11
kAEIngoreBuiltInEventHandler = 16
kAEInteractWithAll = 2
kAEInteractWithLocal = 1
kAEInteractWithSelf = 0
kAEInternetSuite = 'gurl'
kAEISAction = 'Kact'
kAEISActionPath = 'Kapt'
kAEISClientAddress = 'addr'
kAEISClientIP = 'Kcip'
kAEISContentType = 'ctyp'
kAEISFromUser = 'frmu'
kAEISFullRequest = 'Kfrq'
kAEISGetURL = 'gurl'

KAEISHandleCGI = 'sdoc'

kAEISHTTPSearchArgs = 'kfor'
kAEISMethod = 'meth'
kAEISPassword = 'pass'
kAEISPostArgs = 'post'
kAEISReferrer = 'refr'
kAEISScriptName = 'scnm'
kAEISServerName = 'svnm'
kAEISServerPort = 'svpt'
kAEIsUniform = 'isun'
kAEISUserAgent = 'Agnt'
kAEISUserName = 'user'
kAEISWebStarSuite = 'WWW\xbd'
kAEItalic = 'ital'
kAEKeyClass = 'keyc'
kAEKeyDescArray = 4
kAEKeyDown = 'kdwn'
kAELast = 'last'
kAELeftJustified = 'left'
kAELessThan = '<   '
kAELessThanEquals = '<=  '
kAELocalProcess = 3
kAELowercase = 'lowc'
kAEMain = 0
kAEMakeObjectsVisible = 'mvis'
kAEMenuClass = 'menu'
kAEMenuSelect = 'mhit'
kAEMiddle = 'midd'
kAEMiscStandards = 'misc'
kAEModifiable = 'modf'
kAEMouseClass = 'mous'
kAEMouseDown = 'mdwn'
kAEMouseDownInBack = 'mdbk'
kAEMove = 'move'
kAEMoved = 'move'
kAENavigationKey = 'nave'
kAENeverInteract = 16
kAENext = 'next'
kAENo = 'no  '
kAENoArrow = 'arno'
kAENoDispatch = 0
kAENonmodifiable = 'nmod'
kAENoReply = 1
kAENormalPriority = 0
kAENOT = 'NOT '
kAENotifyRecording = 'recr'
kAENotifyStartRecording = 'rec1'
kAENotifyStopRecording = 'rec0'
kAENullEvent = 'null'
kAEOpen = 'odoc'
kAEOpenApplication = 'oapp'
kAEOpenDocuments = 'odoc'
kAEOpenSelection = 'sope'
kAEOR = 'OR  '
kAEOutline = 'outl'
kAEPackedArray = 1
kAEPageSetup = 'pgsu'
kAEPassSubDescs = 8
kAEPaste = 'past'
kAEPlain = 'plan'
kAEPrevious = 'prev'
kAEPrint = 'pdoc'
kAEPrintDocuments = 'pdoc'
kAEPrintSelection = 'spri'
kAEPrintWindow = 'pwin'
kAEProcessNonReplyEvents = 32768
kAEPromise = 'prom'
kAEPutAwaySelection = 'sput'
kAEQDAddOver = 'addo'
kAEQDAddPin = 'addp'
kAEQDAdMax = 'admx'
kAEQDAdMin = 'admn'
kAEQDBic = 'bic '
kAEQDBlend = 'blnd'
kAEQDCopy = 'cpy '
kAEQDNotBic = 'nbic'
kAEQDNotCopy = 'ncpy'
kAEQDNotOr = 'ntor'
kAEQDNotXor = 'nxor'
kAEQDOr = 'or  '
kAEQDSubOver = 'subo'
kAEQDSubPin = 'subp'
kAEQDSupplementalSuite = 'qdsp'
kAEQDXor = 'xor '
kAEQueueReply = 2
kAEQuickdrawSuite = 'qdrw'
kAEQuitAll = 'quia'
kAEQuitApplication = 'quit'
kAERawKey = 'rkey'
kAERedo = 'redo'
kAERegular = 'regl'
kAERemoteProcess = 4
kAEReopenApplication = 'rapp'
kAEReplace = 'rplc'
kAERequiredSuite = 'reqd'
kAEResized = 'rsiz'
kAEResolveNestedLists = 16
kAERestart = 'rest'
kAEResume = 'rsme'
kAERevealSelection = 'srev'
kAERevert = 'rvrt'
kAERightJustified = 'rght'
kAESameProcess = 2
kAESave = 'save'
kAEScrapEvent = 'scrp'
kAESelect = 'slct'
kAESetData = 'setd'
kAESetPosition = 'posn'
kAEShadow = 'shad'
kAESharing = 13
kAEShowClipboard = 'shcl'
kAEShowPreferences = 'pref'
kAEShutDown = 'shut'
kAESleep = 'slep'
kAESmallCaps = 'smcp'
kAESpecialClassProperties = 'c@#!'
kAEStartRecording = 'reca'
kAEStoppedMoving = 'stop'
kAEStopRecording = 'recc'
kAEStrikethrough = 'strk'
kAESubscript = 'sbsc'
kAESuperscript = 'spsc'
kAESuspend = 'susp'
kAETableSuite = 'tbls'
kAETextSuite = 'TEXT'
kAETransactionTerminated = 'ttrm'
kAEUnderline = 'undl'
kAEUndo = 'undo'
kAEUnknownSource = 0
kAEUp = 'up  '
kAEUpdate = 'updt'
kAEUseRelativeIterators = 64
kAEVirtualKey = 'keyc'
kAEWaitReply = 3
kAEWakeUpEvent = 'wake'
kAEWantReceipt = 512
kAEWholeWordEquals = 'wweq'
kAEWindowClass = 'wind'
kAEYes = 'yes '
kAEZoom = 'zoom'
kAEZoomIn = 7
kAEZoomOut = 8
kAnyTransactionID = 0
kAutoGenerateReturnID = -1

kBlockFillText = 6
kByCommentView = 6
kByDateView = 3
kByIconView = 1
kByKindView = 5
kByLabelView = 7
kByNameView = 2
kBySizeView = 4
kBySmallIcon = 0
kByVersionView = 8

kCaretPosition = 1
kConnSuite = 'macc'
kConvertedText = 4
kCoreEventClass = 'aevt'

kDoFolderActionEvent = 'fola'

keyAcceptTimeoutAttr = 'actm'
keyAddressAttr = 'addr'
keyAEAdjustMarksProc = 'adjm'
keyAEAngle = 'kang'
keyAEArcAngle = 'parc'
keyAEBaseAddr = 'badd'
keyAEBestType = 'pbst'
keyAEBgndColor = 'kbcl'
keyAEBgndPattern = 'kbpt'
keyAEBounds = 'pbnd'
keyAEBufferSize = 'buff'
keyAECellList = 'kclt'
keyAEClassID = 'clID'
keyAEClauseOffsets = 'clau'
keyAEColor = 'colr'
keyAEColorTable = 'cltb'
keyAECompareProc = 'cmpr'
keyAECompOperator = 'relo'
keyAEContainer = 'from'
keyAECountProc = 'cont'
keyAECurrentPoint = 'cpos'
keyAECurveHeight = 'kchd'
keyAECurveWidth = 'kcwd'
keyAEDashStyle = 'pdst'
keyAEData = 'data'
keyAEDefaultType = 'deft'
keyAEDefinitionRect = 'pdrt'
keyAEDescType = 'dstp'
keyAEDesiredClass = 'want'
keyAEDestination = 'dest'
keyAEDoAntiAlias = 'anta'
keyAEDoDithered = 'gdit'
keyAEDoRotate = 'kdrt'
keyAEDoScale = 'ksca'
keyAEDoTranslate = 'ktra'
keyAEDragging = 'bool'
keyAEEditionFileLoc = 'eloc'
keyAEElements = 'elms'
keyAEEndPoint = 'pend'
keyAEEventClass = 'evcl'
keyAEEventID = 'evti'
keyAEFile = 'kfil'
keyAEFileType = 'fltp'
keyAEFillColor = 'flcl'
keyAEFillPattern = 'flpt'
keyAEFixLength = 'fixl'
keyAEFlipHorizontal = 'kfho'
keyAEFlipVertical = 'kfvt'
keyAEFont = 'font'
keyAEFormula = 'pfor'
keyAEGetErrDescProc = 'indc'
keyAEGraphicObjects = 'gobs'
keyAEHiliteRange = 'hrng'
keyAEID = 'ID  '
keyAEImageQuality = 'gqua'
keyAEIndex = 'kidx'
keyAEInsertHere = 'insh'
keyAEKeyData = 'seld'
keyAEKeyForm = 'form'
keyAEKeyForms = 'keyf'
keyAEKeyword = 'kywd'
keyAELeadingEdge = 'klef'
keyAELeftSide = 'klef'
keyAELevel = 'levl'
keyAELineArrow = 'arro'
keyAELogicalOperator = 'logc'
keyAELogicalTerms = 'term'
keyAEMarkProc = 'mark'
keyAEMarkTokenProc = 'mkid'
keyAEMoveView = 'mvvw'
keyAEName = 'pnam'
keyAENewElementLoc = 'pnel'
keyAENextBody = 'nxbd'
keyAEObject = 'kobj'
keyAEObject1 = 'obj1'
keyAEObject2 = 'obj2'
keyAEObjectClass = 'kocl'
keyAEOffset = 'ofst'
keyAEOffStyles = 'ofst'
keyAEOnStyles = 'onst'
keyAEParameters = 'prms'
keyAEParamFlags = 'pmfg'
keyAEPenColor = 'ppcl'
keyAEPenPattern = 'pppa'
keyAEPenWidth = 'ppwd'
keyAEPinRange = 'pnrg'
keyAEPixelDepth = 'pdpt'
keyAEPixMapMinus = 'kpmm'
keyAEPMTable = 'kpmt'
keyAEPoint = 'gpos'
keyAEPointList = 'ptlt'
keyAEPointSize = 'ptsz'
keyAEPosition = 'kpos'
keyAEPropData = 'prdt'
keyAEProperties = 'qpro'
keyAEProperty = 'kprp'
keyAEPropFlags = 'prfg'
keyAEPropID = 'prop'
keyAEProtection = 'ppro'
keyAERangeStart = 'star'
keyAERangeStop = 'stop'
keyAERecorderCount = 'recr'
keyAERegionClass = 'rgnc'
keyAERenderAs = 'kren'
keyAERequestedType = 'rtyp'
keyAEResult = '----'
keyAEResultInfo = 'rsin'
keyAERotation = 'prot'
keyAERotPoint = 'krtp'
keyAERowList = 'krls'
keyAESaveOptions = 'savo'
keyAEScale = 'pscl'
keyAEScriptTag = 'psct'
keyAEServerInstance = 'srvi'
keyAEShowWhere = 'show'
keyAEStartAngle = 'pang'
keyAEStartPoint = 'pstp'
keyAEStyles = 'ksty'
keyAESuiteID = 'suit'
keyAETest = 'ktst'
keyAEText = 'ktxt'
keyAETextColor = 'ptxc'
keyAETextFont = 'ptxf'
keyAETextLineAscent = 'ktas'
keyAETextLineHeight = 'ktlh'
keyAETextPointSize = 'ptps'
keyAETextServiceEncoding = 'tsen'
keyAETextServiceMacEncoding = 'tmen'
keyAETextStyles = 'txst'
keyAETheData = 'kdat'
keyAETheText = 'thtx'
keyAETransferMode = 'pptm'
keyAETranslation = 'ptrs'
keyAETryAsStructGraf = 'toog'
keyAETSMDocumentRefcon = 'refc'
keyAETSMEventRecord = 'tevt'
keyAETSMEventRef = 'tevr'
keyAETSMScriptTag = 'sclg'
keyAETSMTextFMFont = 'ktxm'
keyAETSMTextFont = 'ktxf'
keyAETSMTextPointSize = 'ktps'
keyAEUniformStyles = 'ustl'
keyAEUpdateOn = 'pupd'
keyAEUpdateRange = 'udng'
keyAEUserTerm = 'utrm'
keyAEVersion = 'vers'
keyAEWhoseRangeStart = 'wstr'
keyAEWhoseRangeStop = 'wstp'
keyAEWindow = 'wndw'
keyAEWritingCode = 'wrcd'
keyCloseAllWindows = 'caw '
keyDirectObject = '----'
keyDisposeTokenProc = 'xtok'
keyDriveNumber = 'drv#'
keyErrorCode = 'err#'
keyErrorNumber = 'errn'
keyErrorString = 'errs'
keyEventClassAttr = 'evcl'
keyEventIDAttr = 'evid'
keyEventSourceAttr = 'esrc'
keyHighLevelClass = 'hcls'
keyHighLevelID = 'hid '
keyInteractLevelAttr = 'inte'
keyKey = 'key '
keyKeyboard = 'keyb'
keyKeyCode = 'code'
keyLocalWhere = 'lwhr'
keyMenuID = 'mid '
keyMenuItem = 'mitm'
keyMiscellaneous = 'fmsc'
keyMissedKeywordAttr = 'miss'
keyModifiers = 'mods'
keyNewBounds = 'nbnd'
keyOptionalKeywordAttr = 'optk'
keyOriginalAddressAttr = 'from'
keyOriginalBounds = 'obnd'
keyPreDispatch = 'phac'
keyProcessSerialNumber = 'psn '
keyReturnIDAttr = 'rtid'
keySelection = 'fsel'
keySelectProc = 'selh'
keyTimeoutAttr = 'timo'
keyTransactionIDAttr = 'tran'
keyWhen = 'when'
keyWhere = 'wher'
keyWindow = 'kwnd'

kFAAttachCommand = 'atfa'
kFAEditCommand = 'edfa'
kFAFileParam = 'faal'
kFAIndexParam = 'indx'
kFARemoveCommand = 'rmfa'
kFAServerApp = 'ssrv'
kFASuiteCode = 'faco'
kFolderActionCode = 'actn'
kFolderClosedEvent = 'fclo'
kFolderItemsAddedEvent = 'fget'
kFolderItemsRemovedEvent = 'flos'
kFolderOpenedEvent = 'fopn'
kFolderWindowMovedEvent = 'fsiz'

kGetSelectedText = 'gtxt'

kItemList = 'flst'

kNewSizeParameter = 'fnsz'
kNextBody = 1
kNoTimeOut = -2

kOffset2Pos = 'st2p'
kOutlineText = 7

kPos2Offset = 'p2st'
kPreviousBody = 2

kRawText = 2

kSelectedConvertedText = 5
kSelectedRawText = 3
kSelectedText = 8
kShowHideInputWindow = 'shiw'

kTextServiceClass = 'tsvc'
kTSMInsideOfActiveInputArea = 3
kTSMInsideOfBody = 2
kTSMOutsideOfBody = 1

kUnicodeNotFromInputMethod = 'unim'
kUpdateActiveInputArea = 'updt'

pArcAngle = 'parc'
pATMachine = 'patm'
pATType = 'patt'
pATZone = 'patz'

pBackgroundColor = 'pbcl'
pBackgroundPattern = 'pbpt'
pBestType = 'pbst'
pBounds = 'pbnd'

pClass = 'pcls'
pClipboard = 'pcli'
pColor = 'colr'
pColorTable = 'cltb'
pConduit = 'pcon'
pContents = 'pcnt'
pCornerCurveHeight = 'pchd'
pCornerCurveWidth = 'pcwd'

pDashStyle = 'pdst'
pDefaultType = 'deft'
pDefinitionRect = 'pdrt'
pDeviceAddress = 'pdva'
pDeviceType = 'pdvt'
pDNS = 'pdns'
pDNSForm = 'pDNS'
pDottedDecimal = 'pipd'

pEnabled = 'enbl'
pEndPoint = 'pend'

pFillColor = 'flcl'
pFillPattern = 'flpt'
pFont = 'font'
pFormula = 'pfor'
pFTPKind = 'kind'

pGraphicObjects = 'gobs'

pHasCloseBox = 'hclb'
pHasTitleBar = 'ptit'
pHost = 'HOST'

pID = 'ID  '
pIndex = 'pidx'
pInsertionLoc = 'pins'
pIsFloating = 'isfl'
pIsFrontProcess = 'pisf'
pIsModal = 'pmod'
pIsModified = 'imod'
pIsResizable = 'prsz'
pIsStationeryPad = 'pspd'
pIsZoomable = 'iszm'
pIsZoomed = 'pzum'
pItemNumber = 'itmn'

pJustification = 'pjst'

pKeyKind = 'kknd'
pKeystrokeKey = 'kMsg'

pLineArrow = 'arro'

pMenuID = 'mnid'
pModifiers = 'kMod'

pName = 'pnam'
pNetwork = 'pnet'
pNewElementLoc = 'pnel'
pNode = 'pnod'

pPath = 'FTPc'
pPenColor = 'ppcl'
pPenPattern = 'pppa'
pPenWidth = 'ppwd'
pPixelDepth = 'pdpt'
pPointList = 'ptlt'
pPointSize = 'ptsz'
pPort = 'ppor'
pProtection = 'ppro'
pProtocol = 'pprt'

pRotation = 'prot'

pScale = 'pscl'
pScheme = 'pusc'
pScript = 'scpt'
pScriptTag = 'psct'
pSCSIBus = 'pscb'
pSCSILUN = 'pslu'
pSelected = 'selc'
pSelection = 'sele'
pSocket = 'psoc'
pStartAngle = 'pang'
pStartPoint = 'pstp'

pTextColor = 'ptxc'
pTextEncoding = 'ptxe'
pTextFont = 'ptxf'
pTextItemDelimiters = 'txdl'
pTextPointSize = 'ptps'
pTextStyles = 'txst'
pTransferMode = 'pptm'
pTranslation = 'ptrs'

pUniformStyles = 'ustl'
pUpdateOn = 'pupd'
pURL = 'pURL'
pUserName = 'RAun'
pUserPassword = 'RApw'
pUserSelection = 'pusl'

pVersion = 'vers'
pVisible = 'pvis'

type128BitFloatingPoint = 'ldbl'
typeAbsoluteOrdinal = 'abso'
typeAEList = 'list'
typeAERecord = 'reco'
typeAEText = 'tTXT'
typeAlias = 'alis'
typeAppleEvent = 'aevt'
typeApplicationBundleID = 'bund'
typeApplicationURL = 'aprl'
typeApplSignature = 'sign'
typeAppParameters = 'appa'
typeArc = 'carc'
typeBest = 'best'
typeBoolean = 'bool'
typeCell = 'ccel'
typeCentimeters = 'cmtr'
typeChar = 'TEXT'
typeClassInfo = 'gcli'
typeColorTable = 'clrt'
typeColumn = 'ccol'
typeComp = 'comp'
typeCompDescriptor = 'cmpd'
typeComponentInstance = 'cmpi'
typeCString = 'cstr'
typeCubicCentimeter = 'ccmt'
typeCubicFeet = 'cfet'
typeCubicInches = 'cuin'
typeCubicMeters = 'cmet'
typeCubicYards = 'cyrd'
typeCurrentContainer = 'ccnt'
typeDashStyle = 'tdas'
typeData = 'tdta'
typeDecimalStruct = 'decm'
typeDegreesC = 'degc'
typeDegreesF = 'degf'
typeDegreesK = 'degk'
typeDispatcherID = 'dspt'
typeDrawingArea = 'cdrw'
typeElemInfo = 'elin'
typeEncodedString = 'encs'
typeEnumerated = 'enum'
typeEnumeration = 'enum'
typeEPS = 'EPS '
typeEventInfo = 'evin'
typeEventRecord = 'evrc'
typeEventRef = 'evrf'
typeExtended = 'exte'
typeFalse = 'fals'
typeFeet = 'feet'
typeFileURL = 'furl'
typeFinderWindow = 'fwin'
typeFixed = 'fixd'
typeFixedPoint = 'fpnt'
typeFixedRectangle = 'frct'
typeFloat = 'doub'
typeFSRef = 'fsrf'
typeFSS = 'fss '
typeGallons = 'galn'
typeGrams = 'gram'
typeGraphicLine = 'glin'
typeGraphicText = 'cgtx'
typeGroupedGraphic = 'cpic'
typeHIMenu = 'mobj'
typeHIWindow = 'wobj'
typeIEEE32BitFloatingPoint = 'sing'
typeIEEE64BitFloatingPoint = 'doub'
typeInches = 'inch'
typeIndexDescriptor = 'inde'
typeInsertionLoc = 'insl'
typeInteger = 'long'
typeIntlText = 'itxt'
typeIntlWritingCode = 'intl'
typeKeyword = 'keyw'
typeKilograms = 'kgrm'
typeKilometers = 'kmtr'
typeLiters = 'litr'
typeLogicalDescriptor = 'logi'
typeLongDateTime = 'ldt '
typeLongFixed = 'lfxd'
typeLongFixedPoint = 'lfpt'
typeLongFixedRectangle = 'lfrc'
typeLongFloat = 'doub'
typeLongInteger = 'long'
typeLongPoint = 'lpnt'
typeLongRectangle = 'lrct'
typeLowLevelEventRecord = 'evtr'
typeMachineLoc = 'mLoc'
typeMagnitude = 'magn'
typeMeters = 'metr'
typeMiles = 'mile'
typeNull = 'null'
typeObjectBeingExamined = 'exmn'
typeObjectSpecifier = 'obj '
typeOffsetArray = 'ofay'
typeOSLTokenList = 'ostl'
typeOunces = 'ozs '
typeOval = 'covl'
typeParamInfo = 'pmin'
typePict = 'PICT'
typePixelMap = 'cpix'
typePixMapMinus = 'tpmm'
typePolygon = 'cpgn'
typePounds = 'lbs '
typeProcessSerialNumber = 'psn '
typeProperty = 'prop'
typePropInfo = 'pinf'
typePString = 'pstr'
typePtr = 'ptr '
typeQDPoint = 'QDpt'
typeQDRectangle = 'qdrt'
typeQDRegion = 'Qrgn'
typeQuarts = 'qrts'
typeRangeDescriptor = 'rang'
typeRectangle = 'crec'
typeRelativeDescriptor = 'rel '
typeRGB16 = 'tr16'
typeRGB96 = 'tr96'
typeRGBColor = 'cRGB'
typeRotation = 'trot'
typeRoundedRectangle = 'crrc'
typeRow = 'crow'
typeScrapStyles = 'styl'
typeScript = 'scpt'
typeSectionH = 'sect'
typeSessionID = 'ssid'
typeShortFloat = 'sing'
typeShortInteger = 'shor'
typeSInt16 = 'shor'
typeSInt32 = 'long'
typeSInt64 = 'comp'
typeSMFloat = 'sing'
typeSMInt = 'shor'
typeSquareFeet = 'sqft'
typeSquareKilometers = 'sqkm'
typeSquareMeters = 'sqrm'
typeSquareMiles = 'sqmi'
typeSquareYards = 'sqyd'
typeStyledText = 'STXT'
typeStyledUnicodeText = 'sutx'
typeSuiteInfo = 'suin'
typeTable = 'ctbl'
typeTargetID = 'targ'
typeText = 'TEXT'
typeTextRange = 'txrn'
typeTextRangeArray = 'tray'
typeTextStyles = 'tsty'
typeTIFF = 'TIFF'
typeToken = 'toke'
typeTrue = 'true'
typeType = 'type'
typeUInt32 = 'magn'
typeUnicodeText = 'utxt'
typeVersion = 'vers'
typeWhoseDescriptor = 'whos'
typeWhoseRange = 'wrng'
typeWildCard = '****'
typeYards = 'yard'

# functions

def coerce(data, egdata): # reliably restored by inspect
    """ Coerce a python object to another type using the AE coercers """
    pass


def FOUR_CHAR_CODE(x): # reliably restored by inspect
    # no doc
    pass


def getlong(s): # reliably restored by inspect
    # no doc
    pass


def getpstr(s): # reliably restored by inspect
    # no doc
    pass


def getword(s): # reliably restored by inspect
    # no doc
    pass


def mkaetext(dict): # reliably restored by inspect
    # no doc
    pass


def mkcomparison(dict): # reliably restored by inspect
    # no doc
    pass


def mkenum(enum): # reliably restored by inspect
    # no doc
    pass


def mkinsertionloc(dict): # reliably restored by inspect
    # no doc
    pass


def mkkeyword(keyword): # reliably restored by inspect
    # no doc
    pass


def mklocationnamerec(rec): # reliably restored by inspect
    # no doc
    pass


def mklogical(dict): # reliably restored by inspect
    # no doc
    pass


def mkobject(dict): # reliably restored by inspect
    # no doc
    pass


def mkobjectfrommodule(dict, modulename): # reliably restored by inspect
    # no doc
    pass


def mkppcportrec(rec): # reliably restored by inspect
    # no doc
    pass


def mkrange(dict): # reliably restored by inspect
    # no doc
    pass


def mkstyledtext(dict): # reliably restored by inspect
    # no doc
    pass


def mktargetid(data): # reliably restored by inspect
    # no doc
    pass


def mktype(typecode, modulename=None): # reliably restored by inspect
    # no doc
    pass


def mkunknown(type, data): # reliably restored by inspect
    # no doc
    pass


def pack(x, forcetype=None): # reliably restored by inspect
    """ Pack a python object into an AE descriptor """
    pass


def packkey(ae, key, value): # reliably restored by inspect
    # no doc
    pass


def unpack(desc, formodulename=None): # reliably restored by inspect
    """ Unpack an AE descriptor to a python object """
    pass


def warnpy3k(message, category=None, stacklevel=1): # reliably restored by inspect
    """
    Issue a deprecation warning for Python 3.x related changes.
    
        Warnings are omitted unless Python is started with the -3 option.
    """
    pass


# classes

class ObjectType:
    """ The most base type """
    def __class__(self, *args, **kwargs): # real signature unknown
        """
        type(object) -> the object's type
        type(name, bases, dict) -> a new type
        """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __format__(self, *args, **kwargs): # real signature unknown
        """ default object formatter """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __reduce_ex__(self, *args, **kwargs): # real signature unknown
        """ helper for pickle """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ helper for pickle """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ __sizeof__() -> size of object in memory, in bytes """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        """
        Abstract classes can override this to customize issubclass().
        
        This is invoked early on by abc.ABCMeta.__subclasscheck__().
        It should return True, False or NotImplemented.  If it returns
        NotImplemented, the normal algorithm is used.  Otherwise, it
        overrides the normal algorithm (and the outcome is cached).
        """
        pass


class AliasType(object):
    # no doc
    def FSFollowFinderAlias(self, *args, **kwargs): # real signature unknown
        """ (Boolean logon) -> (FSRef fromFile, FSRef target, Boolean wasChanged) """
        pass

    def FSResolveAlias(self, *args, **kwargs): # real signature unknown
        """ (FSRef fromFile) -> (FSRef target, Boolean wasChanged) """
        pass

    def FSResolveAliasWithMountFlags(self, *args, **kwargs): # real signature unknown
        """ (FSRef fromFile, unsigned long mountFlags) -> (FSRef target, Boolean wasChanged) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    data = property(lambda self: object()) # default


class IntType(object):
    """
    int(x[, base]) -> integer
    
    Convert a string or number to an integer, if possible.  A floating point
    argument will be truncated towards zero (this does not include a string
    representation of a floating point number!)  When converting a string, use
    the optional base.  It is an error to supply a base when converting a
    non-string.  If base is zero, the proper base is guessed based on the
    string content.  If the argument is outside the integer range a
    long object will be returned instead.
    """
    def bit_length(self): # real signature unknown; restored from __doc__
        """
        int.bit_length() -> int
        
        Number of bits necessary to represent self in binary.
        >>> bin(37)
        '0b100101'
        >>> (37).bit_length()
        6
        """
        return 0

    def conjugate(self, *args, **kwargs): # real signature unknown
        """ Returns self, the complex conjugate of any int. """
        pass

    def __abs__(self): # real signature unknown; restored from __doc__
        """ x.__abs__() <==> abs(x) """
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __and__(self, y): # real signature unknown; restored from __doc__
        """ x.__and__(y) <==> x&y """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __coerce__(self, y): # real signature unknown; restored from __doc__
        """ x.__coerce__(y) <==> coerce(x, y) """
        pass

    def __divmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__divmod__(y) <==> divmod(x, y) """
        pass

    def __div__(self, y): # real signature unknown; restored from __doc__
        """ x.__div__(y) <==> x/y """
        pass

    def __float__(self): # real signature unknown; restored from __doc__
        """ x.__float__() <==> float(x) """
        pass

    def __floordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__floordiv__(y) <==> x//y """
        pass

    def __format__(self, *args, **kwargs): # real signature unknown
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __hex__(self): # real signature unknown; restored from __doc__
        """ x.__hex__() <==> hex(x) """
        pass

    def __index__(self): # real signature unknown; restored from __doc__
        """ x[y:z] <==> x[y.__index__():z.__index__()] """
        pass

    def __init__(self, x, base=None): # real signature unknown; restored from __doc__
        pass

    def __int__(self): # real signature unknown; restored from __doc__
        """ x.__int__() <==> int(x) """
        pass

    def __invert__(self): # real signature unknown; restored from __doc__
        """ x.__invert__() <==> ~x """
        pass

    def __long__(self): # real signature unknown; restored from __doc__
        """ x.__long__() <==> long(x) """
        pass

    def __lshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__lshift__(y) <==> x<<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, y): # real signature unknown; restored from __doc__
        """ x.__mul__(y) <==> x*y """
        pass

    def __neg__(self): # real signature unknown; restored from __doc__
        """ x.__neg__() <==> -x """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __nonzero__(self): # real signature unknown; restored from __doc__
        """ x.__nonzero__() <==> x != 0 """
        pass

    def __oct__(self): # real signature unknown; restored from __doc__
        """ x.__oct__() <==> oct(x) """
        pass

    def __or__(self, y): # real signature unknown; restored from __doc__
        """ x.__or__(y) <==> x|y """
        pass

    def __pos__(self): # real signature unknown; restored from __doc__
        """ x.__pos__() <==> +x """
        pass

    def __pow__(self, y, z=None): # real signature unknown; restored from __doc__
        """ x.__pow__(y[, z]) <==> pow(x, y[, z]) """
        pass

    def __radd__(self, y): # real signature unknown; restored from __doc__
        """ x.__radd__(y) <==> y+x """
        pass

    def __rand__(self, y): # real signature unknown; restored from __doc__
        """ x.__rand__(y) <==> y&x """
        pass

    def __rdivmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdivmod__(y) <==> divmod(y, x) """
        pass

    def __rdiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdiv__(y) <==> y/x """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rfloordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rfloordiv__(y) <==> y//x """
        pass

    def __rlshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rlshift__(y) <==> y<<x """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmul__(y) <==> y*x """
        pass

    def __ror__(self, y): # real signature unknown; restored from __doc__
        """ x.__ror__(y) <==> y|x """
        pass

    def __rpow__(self, x, z=None): # real signature unknown; restored from __doc__
        """ y.__rpow__(x[, z]) <==> pow(x, y[, z]) """
        pass

    def __rrshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rrshift__(y) <==> y>>x """
        pass

    def __rshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rshift__(y) <==> x>>y """
        pass

    def __rsub__(self, y): # real signature unknown; restored from __doc__
        """ x.__rsub__(y) <==> y-x """
        pass

    def __rtruediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rtruediv__(y) <==> y/x """
        pass

    def __rxor__(self, y): # real signature unknown; restored from __doc__
        """ x.__rxor__(y) <==> y^x """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    def __sub__(self, y): # real signature unknown; restored from __doc__
        """ x.__sub__(y) <==> x-y """
        pass

    def __truediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__truediv__(y) <==> x/y """
        pass

    def __trunc__(self, *args, **kwargs): # real signature unknown
        """ Truncating an Integral returns itself. """
        pass

    def __xor__(self, y): # real signature unknown; restored from __doc__
        """ x.__xor__(y) <==> x^y """
        pass

    denominator = property(lambda self: object()) # default
    imag = property(lambda self: object()) # default
    numerator = property(lambda self: object()) # default
    real = property(lambda self: object()) # default


class BooleanType(int):
    """
    bool(x) -> bool
    
    Returns True when the argument x is true, False otherwise.
    The builtins True and False are the only two instances of the class bool.
    The class bool is a subclass of the class int, and cannot be subclassed.
    """
    def __and__(self, y): # real signature unknown; restored from __doc__
        """ x.__and__(y) <==> x&y """
        pass

    def __init__(self, x): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __or__(self, y): # real signature unknown; restored from __doc__
        """ x.__or__(y) <==> x|y """
        pass

    def __rand__(self, y): # real signature unknown; restored from __doc__
        """ x.__rand__(y) <==> y&x """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __ror__(self, y): # real signature unknown; restored from __doc__
        """ x.__ror__(y) <==> y|x """
        pass

    def __rxor__(self, y): # real signature unknown; restored from __doc__
        """ x.__rxor__(y) <==> y^x """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    def __xor__(self, y): # real signature unknown; restored from __doc__
        """ x.__xor__(y) <==> x^y """
        pass


class BufferType(object):
    """
    buffer(object [, offset[, size]])
    
    Create a new buffer object which references the given object.
    The buffer will reference a slice of the target object from the
    start of the object (or at the specified offset). The slice will
    extend to the end of the target object (or with the specified size).
    """
    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__delitem__(y) <==> del x[y] """
        pass

    def __delslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__delslice__(i, j) <==> del x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __getslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__getslice__(i, j) <==> x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, p_object, offset=None, size=None): # real signature unknown; restored from __doc__
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __mul__(self, n): # real signature unknown; restored from __doc__
        """ x.__mul__(n) <==> x*n """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rmul__(self, n): # real signature unknown; restored from __doc__
        """ x.__rmul__(n) <==> n*x """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ x.__setitem__(i, y) <==> x[i]=y """
        pass

    def __setslice__(self, i, j, y): # real signature unknown; restored from __doc__
        """
        x.__setslice__(i, j, y) <==> x[i:j]=y
                   
                   Use  of negative indices is not supported.
        """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass


class BuiltinMethodType(object):
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    __self__ = property(lambda self: object()) # default

    __name__ = 'builtin_function_or_method'


BuiltinFunctionType = BuiltinMethodType


class ClassType(object):
    """
    classobj(name, bases, dict)
    
    Create a class object.  The name must be a string; the second argument
    a tuple of classes, and the third a dictionary.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, name, bases, dict): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass


class CodeType(object):
    """
    code(argcount, nlocals, stacksize, flags, codestring, constants, names,
          varnames, filename, name, firstlineno, lnotab[, freevars[, cellvars]])
    
    Create a code object.  Not for the faint of heart.
    """
    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, argcount, nlocals, stacksize, flags, codestring, constants, names, varnames, filename, name, firstlineno, lnotab, freevars=None, cellvars=None): # real signature unknown; restored from __doc__
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    co_argcount = property(lambda self: object()) # default
    co_cellvars = property(lambda self: object()) # default
    co_code = property(lambda self: object()) # default
    co_consts = property(lambda self: object()) # default
    co_filename = property(lambda self: object()) # default
    co_firstlineno = property(lambda self: object()) # default
    co_flags = property(lambda self: object()) # default
    co_freevars = property(lambda self: object()) # default
    co_lnotab = property(lambda self: object()) # default
    co_name = property(lambda self: object()) # default
    co_names = property(lambda self: object()) # default
    co_nlocals = property(lambda self: object()) # default
    co_stacksize = property(lambda self: object()) # default
    co_varnames = property(lambda self: object()) # default


class ComplexType(object):
    """
    complex(real[, imag]) -> complex number
    
    Create a complex number from a real part and an optional imaginary part.
    This is equivalent to (real + imag*1j) where imag defaults to 0.
    """
    def conjugate(self): # real signature unknown; restored from __doc__
        """
        complex.conjugate() -> complex
        
        Returns the complex conjugate of its argument. (3-4j).conjugate() == 3+4j.
        """
        return complex(*(), **{})

    def __abs__(self): # real signature unknown; restored from __doc__
        """ x.__abs__() <==> abs(x) """
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __coerce__(self, y): # real signature unknown; restored from __doc__
        """ x.__coerce__(y) <==> coerce(x, y) """
        pass

    def __divmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__divmod__(y) <==> divmod(x, y) """
        pass

    def __div__(self, y): # real signature unknown; restored from __doc__
        """ x.__div__(y) <==> x/y """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __float__(self): # real signature unknown; restored from __doc__
        """ x.__float__() <==> float(x) """
        pass

    def __floordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__floordiv__(y) <==> x//y """
        pass

    def __format__(self): # real signature unknown; restored from __doc__
        """
        complex.__format__() -> str
        
        Converts to a string according to format_spec.
        """
        return ""

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, real, imag=None): # real signature unknown; restored from __doc__
        pass

    def __int__(self): # real signature unknown; restored from __doc__
        """ x.__int__() <==> int(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __long__(self): # real signature unknown; restored from __doc__
        """ x.__long__() <==> long(x) """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, y): # real signature unknown; restored from __doc__
        """ x.__mul__(y) <==> x*y """
        pass

    def __neg__(self): # real signature unknown; restored from __doc__
        """ x.__neg__() <==> -x """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __nonzero__(self): # real signature unknown; restored from __doc__
        """ x.__nonzero__() <==> x != 0 """
        pass

    def __pos__(self): # real signature unknown; restored from __doc__
        """ x.__pos__() <==> +x """
        pass

    def __pow__(self, y, z=None): # real signature unknown; restored from __doc__
        """ x.__pow__(y[, z]) <==> pow(x, y[, z]) """
        pass

    def __radd__(self, y): # real signature unknown; restored from __doc__
        """ x.__radd__(y) <==> y+x """
        pass

    def __rdivmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdivmod__(y) <==> divmod(y, x) """
        pass

    def __rdiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdiv__(y) <==> y/x """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rfloordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rfloordiv__(y) <==> y//x """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmul__(y) <==> y*x """
        pass

    def __rpow__(self, x, z=None): # real signature unknown; restored from __doc__
        """ y.__rpow__(x[, z]) <==> pow(x, y[, z]) """
        pass

    def __rsub__(self, y): # real signature unknown; restored from __doc__
        """ x.__rsub__(y) <==> y-x """
        pass

    def __rtruediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rtruediv__(y) <==> y/x """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    def __sub__(self, y): # real signature unknown; restored from __doc__
        """ x.__sub__(y) <==> x-y """
        pass

    def __truediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__truediv__(y) <==> x/y """
        pass

    imag = property(lambda self: object()) # default
    real = property(lambda self: object()) # default


class DictType(object):
    """
    dict() -> new empty dictionary
    dict(mapping) -> new dictionary initialized from a mapping object's
        (key, value) pairs
    dict(iterable) -> new dictionary initialized as if via:
        d = {}
        for k, v in iterable:
            d[k] = v
    dict(**kwargs) -> new dictionary initialized with the name=value pairs
        in the keyword argument list.  For example:  dict(one=1, two=2)
    """
    def clear(self): # real signature unknown; restored from __doc__
        """ D.clear() -> None.  Remove all items from D. """
        pass

    def copy(self): # real signature unknown; restored from __doc__
        """ D.copy() -> a shallow copy of D """
        pass

    @classmethod
    def fromkeys(cls, S, v=None): # real signature unknown; restored from __doc__
        """
        dict.fromkeys(S[,v]) -> New dict with keys from S and values equal to v.
        v defaults to None.
        """
        pass

    def get(self, k, d=None): # real signature unknown; restored from __doc__
        """ D.get(k[,d]) -> D[k] if k in D, else d.  d defaults to None. """
        pass

    def has_key(self, k): # real signature unknown; restored from __doc__
        """ D.has_key(k) -> True if D has a key k, else False """
        return False

    def items(self): # real signature unknown; restored from __doc__
        """ D.items() -> list of D's (key, value) pairs, as 2-tuples """
        return []

    def iteritems(self): # real signature unknown; restored from __doc__
        """ D.iteritems() -> an iterator over the (key, value) items of D """
        pass

    def iterkeys(self): # real signature unknown; restored from __doc__
        """ D.iterkeys() -> an iterator over the keys of D """
        pass

    def itervalues(self): # real signature unknown; restored from __doc__
        """ D.itervalues() -> an iterator over the values of D """
        pass

    def keys(self): # real signature unknown; restored from __doc__
        """ D.keys() -> list of D's keys """
        return []

    def pop(self, k, d=None): # real signature unknown; restored from __doc__
        """
        D.pop(k[,d]) -> v, remove specified key and return the corresponding value.
        If key is not found, d is returned if given, otherwise KeyError is raised
        """
        pass

    def popitem(self): # real signature unknown; restored from __doc__
        """
        D.popitem() -> (k, v), remove and return some (key, value) pair as a
        2-tuple; but raise KeyError if D is empty.
        """
        pass

    def setdefault(self, k, d=None): # real signature unknown; restored from __doc__
        """ D.setdefault(k[,d]) -> D.get(k,d), also set D[k]=d if k not in D """
        pass

    def update(self, E, **F): # real signature unknown; restored from __doc__
        """
        D.update(E, **F) -> None.  Update D from dict/iterable E and F.
        If E has a .keys() method, does:     for k in E: D[k] = E[k]
        If E lacks .keys() method, does:     for (k, v) in E: D[k] = v
        In either case, this is followed by: for k in F: D[k] = F[k]
        """
        pass

    def values(self): # real signature unknown; restored from __doc__
        """ D.values() -> list of D's values """
        return []

    def viewitems(self): # real signature unknown; restored from __doc__
        """ D.viewitems() -> a set-like object providing a view on D's items """
        pass

    def viewkeys(self): # real signature unknown; restored from __doc__
        """ D.viewkeys() -> a set-like object providing a view on D's keys """
        pass

    def viewvalues(self): # real signature unknown; restored from __doc__
        """ D.viewvalues() -> an object providing a view on D's values """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __contains__(self, k): # real signature unknown; restored from __doc__
        """ D.__contains__(k) -> True if D has a key k, else False """
        return False

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__delitem__(y) <==> del x[y] """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __init__(self): # real signature unknown; restored from __doc__
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ x.__setitem__(i, y) <==> x[i]=y """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ D.__sizeof__() -> size of D in memory, in bytes """
        pass

    __hash__ = None


DictionaryType = DictType


class DictProxyType(object):
    # no doc
    def copy(self): # real signature unknown; restored from __doc__
        """ D.copy() -> a shallow copy of D """
        pass

    def get(self, k, d=None): # real signature unknown; restored from __doc__
        """ D.get(k[,d]) -> D[k] if D.has_key(k), else d.  d defaults to None. """
        pass

    def has_key(self, k): # real signature unknown; restored from __doc__
        """ D.has_key(k) -> True if D has a key k, else False """
        return False

    def items(self): # real signature unknown; restored from __doc__
        """ D.items() -> list of D's (key, value) pairs, as 2-tuples """
        return []

    def iteritems(self): # real signature unknown; restored from __doc__
        """ D.iteritems() -> an iterator over the (key, value) items of D """
        pass

    def iterkeys(self): # real signature unknown; restored from __doc__
        """ D.iterkeys() -> an iterator over the keys of D """
        pass

    def itervalues(self): # real signature unknown; restored from __doc__
        """ D.itervalues() -> an iterator over the values of D """
        pass

    def keys(self): # real signature unknown; restored from __doc__
        """ D.keys() -> list of D's keys """
        return []

    def values(self): # real signature unknown; restored from __doc__
        """ D.values() -> list of D's values """
        return []

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass


class EllipsisType(object):
    # no doc
    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass


class FileType(object):
    """
    file(name[, mode[, buffering]]) -> file object
    
    Open a file.  The mode can be 'r', 'w' or 'a' for reading (default),
    writing or appending.  The file will be created if it doesn't exist
    when opened for writing or appending; it will be truncated when
    opened for writing.  Add a 'b' to the mode for binary files.
    Add a '+' to the mode to allow simultaneous reading and writing.
    If the buffering argument is given, 0 means unbuffered, 1 means line
    buffered, and larger numbers specify the buffer size.  The preferred way
    to open a file is with the builtin open() function.
    Add a 'U' to mode to open the file for input with universal newline
    support.  Any line ending in the input file will be seen as a '\n'
    in Python.  Also, a file so opened gains the attribute 'newlines';
    the value for this attribute is one of None (no newline read yet),
    '\r', '\n', '\r\n' or a tuple containing all the newline types seen.
    
    'U' cannot be combined with 'w' or '+' mode.
    """
    def close(self): # real signature unknown; restored from __doc__
        """
        close() -> None or (perhaps) an integer.  Close the file.
        
        Sets data attribute .closed to True.  A closed file cannot be used for
        further I/O operations.  close() may be called more than once without
        error.  Some kinds of file objects (for example, opened by popen())
        may return an exit status upon closing.
        """
        pass

    def fileno(self): # real signature unknown; restored from __doc__
        """
        fileno() -> integer "file descriptor".
        
        This is needed for lower-level file interfaces, such os.read().
        """
        return 0

    def flush(self): # real signature unknown; restored from __doc__
        """ flush() -> None.  Flush the internal I/O buffer. """
        pass

    def isatty(self): # real signature unknown; restored from __doc__
        """ isatty() -> true or false.  True if the file is connected to a tty device. """
        return False

    def next(self): # real signature unknown; restored from __doc__
        """ x.next() -> the next value, or raise StopIteration """
        pass

    def read(self, size=None): # real signature unknown; restored from __doc__
        """
        read([size]) -> read at most size bytes, returned as a string.
        
        If the size argument is negative or omitted, read until EOF is reached.
        Notice that when in non-blocking mode, less data than what was requested
        may be returned, even if no size parameter was given.
        """
        pass

    def readinto(self): # real signature unknown; restored from __doc__
        """ readinto() -> Undocumented.  Don't use this; it may go away. """
        pass

    def readline(self, size=None): # real signature unknown; restored from __doc__
        """
        readline([size]) -> next line from the file, as a string.
        
        Retain newline.  A non-negative size argument limits the maximum
        number of bytes to return (an incomplete line may be returned then).
        Return an empty string at EOF.
        """
        pass

    def readlines(self, size=None): # real signature unknown; restored from __doc__
        """
        readlines([size]) -> list of strings, each a line from the file.
        
        Call readline() repeatedly and return a list of the lines so read.
        The optional size argument, if given, is an approximate bound on the
        total number of bytes in the lines returned.
        """
        return []

    def seek(self, offset, whence=None): # real signature unknown; restored from __doc__
        """
        seek(offset[, whence]) -> None.  Move to new file position.
        
        Argument offset is a byte count.  Optional argument whence defaults to
        0 (offset from start of file, offset should be >= 0); other values are 1
        (move relative to current position, positive or negative), and 2 (move
        relative to end of file, usually negative, although many platforms allow
        seeking beyond the end of a file).  If the file is opened in text mode,
        only offsets returned by tell() are legal.  Use of other offsets causes
        undefined behavior.
        Note that not all file objects are seekable.
        """
        pass

    def tell(self): # real signature unknown; restored from __doc__
        """ tell() -> current file position, an integer (may be a long integer). """
        pass

    def truncate(self, size=None): # real signature unknown; restored from __doc__
        """
        truncate([size]) -> None.  Truncate the file to at most size bytes.
        
        Size defaults to the current file position, as returned by tell().
        """
        pass

    def write(self, p_str): # real signature unknown; restored from __doc__
        """
        write(str) -> None.  Write string str to file.
        
        Note that due to buffering, flush() or close() may be needed before
        the file on disk reflects the data written.
        """
        pass

    def writelines(self, sequence_of_strings): # real signature unknown; restored from __doc__
        """
        writelines(sequence_of_strings) -> None.  Write the strings to the file.
        
        Note that newlines are not added.  The sequence can be any iterable object
        producing strings. This is equivalent to calling write() for each string.
        """
        pass

    def xreadlines(self): # real signature unknown; restored from __doc__
        """
        xreadlines() -> returns self.
        
        For backward compatibility. File objects now include the performance
        optimizations previously implemented in the xreadlines module.
        """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __enter__(self): # real signature unknown; restored from __doc__
        """ __enter__() -> self. """
        return self

    def __exit__(self, *excinfo): # real signature unknown; restored from __doc__
        """ __exit__(*excinfo) -> None.  Closes the file. """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, name, mode=None, buffering=None): # real signature unknown; restored from __doc__
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    closed = property(lambda self: object()) # default
    encoding = property(lambda self: object()) # default
    errors = property(lambda self: object()) # default
    mode = property(lambda self: object()) # default
    name = property(lambda self: object()) # default
    newlines = property(lambda self: object()) # default
    softspace = property(lambda self: object()) # default


class FloatType(object):
    """
    float(x) -> floating point number
    
    Convert a string or number to a floating point number, if possible.
    """
    def as_integer_ratio(self): # real signature unknown; restored from __doc__
        """
        float.as_integer_ratio() -> (int, int)
        
        Returns a pair of integers, whose ratio is exactly equal to the original
        float and with a positive denominator.
        Raises OverflowError on infinities and a ValueError on NaNs.
        
        >>> (10.0).as_integer_ratio()
        (10, 1)
        >>> (0.0).as_integer_ratio()
        (0, 1)
        >>> (-.25).as_integer_ratio()
        (-1, 4)
        """
        pass

    def conjugate(self, *args, **kwargs): # real signature unknown
        """ Returns self, the complex conjugate of any float. """
        pass

    @classmethod
    def fromhex(cls, string): # real signature unknown; restored from __doc__
        """
        float.fromhex(string) -> float
        
        Create a floating-point number from a hexadecimal string.
        >>> float.fromhex('0x1.ffffp10')
        2047.984375
        >>> float.fromhex('-0x1p-1074')
        -4.9406564584124654e-324
        """
        return 0.0

    def hex(self): # real signature unknown; restored from __doc__
        """
        float.hex() -> string
        
        Return a hexadecimal representation of a floating-point number.
        >>> (-0.1).hex()
        '-0x1.999999999999ap-4'
        >>> 3.14159.hex()
        '0x1.921f9f01b866ep+1'
        """
        return ""

    def is_integer(self, *args, **kwargs): # real signature unknown
        """ Returns True if the float is an integer. """
        pass

    def __abs__(self): # real signature unknown; restored from __doc__
        """ x.__abs__() <==> abs(x) """
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __coerce__(self, y): # real signature unknown; restored from __doc__
        """ x.__coerce__(y) <==> coerce(x, y) """
        pass

    def __divmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__divmod__(y) <==> divmod(x, y) """
        pass

    def __div__(self, y): # real signature unknown; restored from __doc__
        """ x.__div__(y) <==> x/y """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __float__(self): # real signature unknown; restored from __doc__
        """ x.__float__() <==> float(x) """
        pass

    def __floordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__floordiv__(y) <==> x//y """
        pass

    def __format__(self, format_spec): # real signature unknown; restored from __doc__
        """
        float.__format__(format_spec) -> string
        
        Formats the float according to format_spec.
        """
        return ""

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    @classmethod
    def __getformat__(cls, typestr): # real signature unknown; restored from __doc__
        """
        float.__getformat__(typestr) -> string
        
        You probably don't want to use this function.  It exists mainly to be
        used in Python's test suite.
        
        typestr must be 'double' or 'float'.  This function returns whichever of
        'unknown', 'IEEE, big-endian' or 'IEEE, little-endian' best describes the
        format of floating point numbers used by the C type named by typestr.
        """
        return ""

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, x): # real signature unknown; restored from __doc__
        pass

    def __int__(self): # real signature unknown; restored from __doc__
        """ x.__int__() <==> int(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __long__(self): # real signature unknown; restored from __doc__
        """ x.__long__() <==> long(x) """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, y): # real signature unknown; restored from __doc__
        """ x.__mul__(y) <==> x*y """
        pass

    def __neg__(self): # real signature unknown; restored from __doc__
        """ x.__neg__() <==> -x """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __nonzero__(self): # real signature unknown; restored from __doc__
        """ x.__nonzero__() <==> x != 0 """
        pass

    def __pos__(self): # real signature unknown; restored from __doc__
        """ x.__pos__() <==> +x """
        pass

    def __pow__(self, y, z=None): # real signature unknown; restored from __doc__
        """ x.__pow__(y[, z]) <==> pow(x, y[, z]) """
        pass

    def __radd__(self, y): # real signature unknown; restored from __doc__
        """ x.__radd__(y) <==> y+x """
        pass

    def __rdivmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdivmod__(y) <==> divmod(y, x) """
        pass

    def __rdiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdiv__(y) <==> y/x """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rfloordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rfloordiv__(y) <==> y//x """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmul__(y) <==> y*x """
        pass

    def __rpow__(self, x, z=None): # real signature unknown; restored from __doc__
        """ y.__rpow__(x[, z]) <==> pow(x, y[, z]) """
        pass

    def __rsub__(self, y): # real signature unknown; restored from __doc__
        """ x.__rsub__(y) <==> y-x """
        pass

    def __rtruediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rtruediv__(y) <==> y/x """
        pass

    @classmethod
    def __setformat__(cls, typestr, fmt): # real signature unknown; restored from __doc__
        """
        float.__setformat__(typestr, fmt) -> None
        
        You probably don't want to use this function.  It exists mainly to be
        used in Python's test suite.
        
        typestr must be 'double' or 'float'.  fmt must be one of 'unknown',
        'IEEE, big-endian' or 'IEEE, little-endian', and in addition can only be
        one of the latter two if it appears to match the underlying C reality.
        
        Overrides the automatic determination of C-level floating point type.
        This affects how floats are converted to and from binary strings.
        """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    def __sub__(self, y): # real signature unknown; restored from __doc__
        """ x.__sub__(y) <==> x-y """
        pass

    def __truediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__truediv__(y) <==> x/y """
        pass

    def __trunc__(self, *args, **kwargs): # real signature unknown
        """ Returns the Integral closest to x between 0 and x. """
        pass

    imag = property(lambda self: object()) # default
    real = property(lambda self: object()) # default


class FrameType(object):
    # no doc
    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ F.__sizeof__() -> size of F in memory, in bytes """
        pass

    f_back = property(lambda self: object()) # default
    f_builtins = property(lambda self: object()) # default
    f_code = property(lambda self: object()) # default
    f_exc_traceback = property(lambda self: object()) # default
    f_exc_type = property(lambda self: object()) # default
    f_exc_value = property(lambda self: object()) # default
    f_globals = property(lambda self: object()) # default
    f_lasti = property(lambda self: object()) # default
    f_lineno = property(lambda self: object()) # default
    f_locals = property(lambda self: object()) # default
    f_restricted = property(lambda self: object()) # default
    f_trace = property(lambda self: object()) # default


class FSRefType(object):
    # no doc
    def as_pathname(self, *args, **kwargs): # real signature unknown
        """ () -> string """
        pass

    def FNNotify(self, *args, **kwargs): # real signature unknown
        """ (FNMessage message, OptionBits flags) -> None """
        pass

    def FSCompareFSRefs(self, *args, **kwargs): # real signature unknown
        """ (FSRef ref2) -> None """
        pass

    def FSCreateDirectoryUnicode(self, *args, **kwargs): # real signature unknown
        """ (Buffer nameLength, FSCatalogInfoBitmap whichInfo, FSCatalogInfo catalogInfo) -> (FSRef newRef, FSSpec newSpec, UInt32 newDirID) """
        pass

    def FSCreateFileUnicode(self, *args, **kwargs): # real signature unknown
        """ (Buffer nameLength, FSCatalogInfoBitmap whichInfo, FSCatalogInfo catalogInfo) -> (FSRef newRef, FSSpec newSpec) """
        pass

    def FSCreateFork(self, *args, **kwargs): # real signature unknown
        """ (Buffer forkNameLength) -> None """
        pass

    def FSDeleteFork(self, *args, **kwargs): # real signature unknown
        """ (Buffer forkNameLength) -> None """
        pass

    def FSDeleteObject(self, *args, **kwargs): # real signature unknown
        """ () -> None """
        pass

    def FSExchangeObjects(self, *args, **kwargs): # real signature unknown
        """ (FSRef destRef) -> None """
        pass

    def FSGetCatalogInfo(self, *args, **kwargs): # real signature unknown
        """ (FSCatalogInfoBitmap whichInfo) -> (FSCatalogInfo catalogInfo, HFSUniStr255 outName, FSSpec fsSpec, FSRef parentRef) """
        pass

    def FSIsAliasFile(self, *args, **kwargs): # real signature unknown
        """ () -> (Boolean aliasFileFlag, Boolean folderFlag) """
        pass

    def FSMakeFSRefUnicode(self, *args, **kwargs): # real signature unknown
        """ (Buffer nameLength, TextEncoding textEncodingHint) -> (FSRef newRef) """
        pass

    def FSMoveObject(self, *args, **kwargs): # real signature unknown
        """ (FSRef destDirectory) -> (FSRef newRef) """
        pass

    def FSNewAliasMinimal(self, *args, **kwargs): # real signature unknown
        """ () -> (AliasHandle inAlias) """
        pass

    def FSOpenFork(self, *args, **kwargs): # real signature unknown
        """ (Buffer forkNameLength, SInt8 permissions) -> (SInt16 forkRefNum) """
        pass

    def FSRefMakePath(self, *args, **kwargs): # real signature unknown
        """ () -> string """
        pass

    def FSRenameUnicode(self, *args, **kwargs): # real signature unknown
        """ (Buffer nameLength, TextEncoding textEncodingHint) -> (FSRef newRef) """
        pass

    def FSSetCatalogInfo(self, *args, **kwargs): # real signature unknown
        """ (FSCatalogInfoBitmap whichInfo, FSCatalogInfo catalogInfo) -> None """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    data = property(lambda self: object()) # default


class LambdaType(object):
    """
    function(code, globals[, name[, argdefs[, closure]]])
    
    Create a function object from a code object and a dictionary.
    The optional name string overrides the name from the code object.
    The optional argdefs tuple specifies the default argument values.
    The optional closure tuple supplies the bindings for free variables.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __init__(self, code, globals, name=None, argdefs=None, closure=None): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    func_closure = property(lambda self: object()) # default
    func_code = property(lambda self: object()) # default
    func_defaults = property(lambda self: object()) # default
    func_dict = property(lambda self: object()) # default
    func_doc = property(lambda self: object()) # default
    func_globals = property(lambda self: object()) # default
    func_name = property(lambda self: object()) # default
    __closure__ = property(lambda self: object()) # default
    __code__ = property(lambda self: object()) # default
    __defaults__ = property(lambda self: object()) # default
    __globals__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''
    __name__ = 'function'


FunctionType = LambdaType


class GeneratorType(object):
    # no doc
    def close(self, arg): # real signature unknown; restored from __doc__
        """ close(arg) -> raise GeneratorExit inside generator. """
        pass

    def next(self): # real signature unknown; restored from __doc__
        """ x.next() -> the next value, or raise StopIteration """
        pass

    def send(self, arg): # real signature unknown; restored from __doc__
        """
        send(arg) -> send 'arg' into generator,
        return next yielded value or raise StopIteration.
        """
        pass

    def throw(self, typ, val=None, tb=None): # real signature unknown; restored from __doc__
        """
        throw(typ[,val[,tb]]) -> raise exception in generator,
        return next yielded value or raise StopIteration.
        """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    gi_code = property(lambda self: object()) # default
    gi_frame = property(lambda self: object()) # default
    gi_running = property(lambda self: object()) # default

    __name__ = 'generator'


class GetSetDescriptorType(object):
    def __delete__(self, obj): # real signature unknown; restored from __doc__
        """ descr.__delete__(obj) """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __set__(self, obj, value): # real signature unknown; restored from __doc__
        """ descr.__set__(obj, value) """
        pass

    __objclass__ = property(lambda self: object()) # default

    __name__ = 'getset_descriptor'


class InstanceType(object):
    """
    instance(class[, dict])
    
    Create an instance without calling its __init__() method.
    The class must be a classic class.
    If present, dict must be a dictionary or None.
    """
    def next(self): # real signature unknown; restored from __doc__
        """ x.next() -> the next value, or raise StopIteration """
        pass

    def __abs__(self): # real signature unknown; restored from __doc__
        """ x.__abs__() <==> abs(x) """
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __and__(self, y): # real signature unknown; restored from __doc__
        """ x.__and__(y) <==> x&y """
        pass

    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __coerce__(self, y): # real signature unknown; restored from __doc__
        """ x.__coerce__(y) <==> coerce(x, y) """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__delitem__(y) <==> del x[y] """
        pass

    def __delslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__delslice__(i, j) <==> del x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __divmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__divmod__(y) <==> divmod(x, y) """
        pass

    def __div__(self, y): # real signature unknown; restored from __doc__
        """ x.__div__(y) <==> x/y """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __float__(self): # real signature unknown; restored from __doc__
        """ x.__float__() <==> float(x) """
        pass

    def __floordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__floordiv__(y) <==> x//y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __getslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__getslice__(i, j) <==> x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __hex__(self): # real signature unknown; restored from __doc__
        """ x.__hex__() <==> hex(x) """
        pass

    def __iadd__(self, y): # real signature unknown; restored from __doc__
        """ x.__iadd__(y) <==> x+y """
        pass

    def __iand__(self, y): # real signature unknown; restored from __doc__
        """ x.__iand__(y) <==> x&y """
        pass

    def __idiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__idiv__(y) <==> x/y """
        pass

    def __ifloordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__ifloordiv__(y) <==> x//y """
        pass

    def __ilshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__ilshift__(y) <==> x<<y """
        pass

    def __imod__(self, y): # real signature unknown; restored from __doc__
        """ x.__imod__(y) <==> x%y """
        pass

    def __imul__(self, y): # real signature unknown; restored from __doc__
        """ x.__imul__(y) <==> x*y """
        pass

    def __index__(self): # real signature unknown; restored from __doc__
        """ x[y:z] <==> x[y.__index__():z.__index__()] """
        pass

    def __init__(self): # real signature unknown; restored from __doc__
        pass

    def __int__(self): # real signature unknown; restored from __doc__
        """ x.__int__() <==> int(x) """
        pass

    def __invert__(self): # real signature unknown; restored from __doc__
        """ x.__invert__() <==> ~x """
        pass

    def __ior__(self, y): # real signature unknown; restored from __doc__
        """ x.__ior__(y) <==> x|y """
        pass

    def __ipow__(self, y): # real signature unknown; restored from __doc__
        """ x.__ipow__(y) <==> x**y """
        pass

    def __irshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__irshift__(y) <==> x>>y """
        pass

    def __isub__(self, y): # real signature unknown; restored from __doc__
        """ x.__isub__(y) <==> x-y """
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __itruediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__itruediv__(y) <==> x/y """
        pass

    def __ixor__(self, y): # real signature unknown; restored from __doc__
        """ x.__ixor__(y) <==> x^y """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __long__(self): # real signature unknown; restored from __doc__
        """ x.__long__() <==> long(x) """
        pass

    def __lshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__lshift__(y) <==> x<<y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, y): # real signature unknown; restored from __doc__
        """ x.__mul__(y) <==> x*y """
        pass

    def __neg__(self): # real signature unknown; restored from __doc__
        """ x.__neg__() <==> -x """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __nonzero__(self): # real signature unknown; restored from __doc__
        """ x.__nonzero__() <==> x != 0 """
        pass

    def __oct__(self): # real signature unknown; restored from __doc__
        """ x.__oct__() <==> oct(x) """
        pass

    def __or__(self, y): # real signature unknown; restored from __doc__
        """ x.__or__(y) <==> x|y """
        pass

    def __pos__(self): # real signature unknown; restored from __doc__
        """ x.__pos__() <==> +x """
        pass

    def __pow__(self, y, z=None): # real signature unknown; restored from __doc__
        """ x.__pow__(y[, z]) <==> pow(x, y[, z]) """
        pass

    def __radd__(self, y): # real signature unknown; restored from __doc__
        """ x.__radd__(y) <==> y+x """
        pass

    def __rand__(self, y): # real signature unknown; restored from __doc__
        """ x.__rand__(y) <==> y&x """
        pass

    def __rdivmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdivmod__(y) <==> divmod(y, x) """
        pass

    def __rdiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdiv__(y) <==> y/x """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rfloordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rfloordiv__(y) <==> y//x """
        pass

    def __rlshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rlshift__(y) <==> y<<x """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmul__(y) <==> y*x """
        pass

    def __ror__(self, y): # real signature unknown; restored from __doc__
        """ x.__ror__(y) <==> y|x """
        pass

    def __rpow__(self, x, z=None): # real signature unknown; restored from __doc__
        """ y.__rpow__(x[, z]) <==> pow(x, y[, z]) """
        pass

    def __rrshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rrshift__(y) <==> y>>x """
        pass

    def __rshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rshift__(y) <==> x>>y """
        pass

    def __rsub__(self, y): # real signature unknown; restored from __doc__
        """ x.__rsub__(y) <==> y-x """
        pass

    def __rtruediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rtruediv__(y) <==> y/x """
        pass

    def __rxor__(self, y): # real signature unknown; restored from __doc__
        """ x.__rxor__(y) <==> y^x """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ x.__setitem__(i, y) <==> x[i]=y """
        pass

    def __setslice__(self, i, j, y): # real signature unknown; restored from __doc__
        """
        x.__setslice__(i, j, y) <==> x[i:j]=y
                   
                   Use  of negative indices is not supported.
        """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    def __sub__(self, y): # real signature unknown; restored from __doc__
        """ x.__sub__(y) <==> x-y """
        pass

    def __truediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__truediv__(y) <==> x/y """
        pass

    def __xor__(self, y): # real signature unknown; restored from __doc__
        """ x.__xor__(y) <==> x^y """
        pass


class ListType(object):
    """
    list() -> new empty list
    list(iterable) -> new list initialized from iterable's items
    """
    def append(self, p_object): # real signature unknown; restored from __doc__
        """ L.append(object) -- append object to end """
        pass

    def count(self, value): # real signature unknown; restored from __doc__
        """ L.count(value) -> integer -- return number of occurrences of value """
        return 0

    def extend(self, iterable): # real signature unknown; restored from __doc__
        """ L.extend(iterable) -- extend list by appending elements from the iterable """
        pass

    def index(self, value, start=None, stop=None): # real signature unknown; restored from __doc__
        """
        L.index(value, [start, [stop]]) -> integer -- return first index of value.
        Raises ValueError if the value is not present.
        """
        return 0

    def insert(self, index, p_object): # real signature unknown; restored from __doc__
        """ L.insert(index, object) -- insert object before index """
        pass

    def pop(self, index=None): # real signature unknown; restored from __doc__
        """
        L.pop([index]) -> item -- remove and return item at index (default last).
        Raises IndexError if list is empty or index is out of range.
        """
        pass

    def remove(self, value): # real signature unknown; restored from __doc__
        """
        L.remove(value) -- remove first occurrence of value.
        Raises ValueError if the value is not present.
        """
        pass

    def reverse(self): # real signature unknown; restored from __doc__
        """ L.reverse() -- reverse *IN PLACE* """
        pass

    def sort(self, cmp=None, key=None, reverse=False): # real signature unknown; restored from __doc__
        """
        L.sort(cmp=None, key=None, reverse=False) -- stable sort *IN PLACE*;
        cmp(x, y) -> -1, 0, 1
        """
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x """
        pass

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__delitem__(y) <==> del x[y] """
        pass

    def __delslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__delslice__(i, j) <==> del x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __getslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__getslice__(i, j) <==> x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __iadd__(self, y): # real signature unknown; restored from __doc__
        """ x.__iadd__(y) <==> x+=y """
        pass

    def __imul__(self, y): # real signature unknown; restored from __doc__
        """ x.__imul__(y) <==> x*=y """
        pass

    def __init__(self): # real signature unknown; restored from __doc__
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mul__(self, n): # real signature unknown; restored from __doc__
        """ x.__mul__(n) <==> x*n """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __reversed__(self): # real signature unknown; restored from __doc__
        """ L.__reversed__() -- return a reverse iterator over the list """
        pass

    def __rmul__(self, n): # real signature unknown; restored from __doc__
        """ x.__rmul__(n) <==> n*x """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ x.__setitem__(i, y) <==> x[i]=y """
        pass

    def __setslice__(self, i, j, y): # real signature unknown; restored from __doc__
        """
        x.__setslice__(i, j, y) <==> x[i:j]=y
                   
                   Use  of negative indices is not supported.
        """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ L.__sizeof__() -- size of L in memory, in bytes """
        pass

    __hash__ = None


class LongType(object):
    """
    long(x[, base]) -> integer
    
    Convert a string or number to a long integer, if possible.  A floating
    point argument will be truncated towards zero (this does not include a
    string representation of a floating point number!)  When converting a
    string, use the optional base.  It is an error to supply a base when
    converting a non-string.
    """
    def bit_length(self): # real signature unknown; restored from __doc__
        """
        long.bit_length() -> int or long
        
        Number of bits necessary to represent self in binary.
        >>> bin(37L)
        '0b100101'
        >>> (37L).bit_length()
        6
        """
        return 0

    def conjugate(self, *args, **kwargs): # real signature unknown
        """ Returns self, the complex conjugate of any long. """
        pass

    def __abs__(self): # real signature unknown; restored from __doc__
        """ x.__abs__() <==> abs(x) """
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __and__(self, y): # real signature unknown; restored from __doc__
        """ x.__and__(y) <==> x&y """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __coerce__(self, y): # real signature unknown; restored from __doc__
        """ x.__coerce__(y) <==> coerce(x, y) """
        pass

    def __divmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__divmod__(y) <==> divmod(x, y) """
        pass

    def __div__(self, y): # real signature unknown; restored from __doc__
        """ x.__div__(y) <==> x/y """
        pass

    def __float__(self): # real signature unknown; restored from __doc__
        """ x.__float__() <==> float(x) """
        pass

    def __floordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__floordiv__(y) <==> x//y """
        pass

    def __format__(self, *args, **kwargs): # real signature unknown
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __hex__(self): # real signature unknown; restored from __doc__
        """ x.__hex__() <==> hex(x) """
        pass

    def __index__(self): # real signature unknown; restored from __doc__
        """ x[y:z] <==> x[y.__index__():z.__index__()] """
        pass

    def __init__(self, x, base=None): # real signature unknown; restored from __doc__
        pass

    def __int__(self): # real signature unknown; restored from __doc__
        """ x.__int__() <==> int(x) """
        pass

    def __invert__(self): # real signature unknown; restored from __doc__
        """ x.__invert__() <==> ~x """
        pass

    def __long__(self): # real signature unknown; restored from __doc__
        """ x.__long__() <==> long(x) """
        pass

    def __lshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__lshift__(y) <==> x<<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, y): # real signature unknown; restored from __doc__
        """ x.__mul__(y) <==> x*y """
        pass

    def __neg__(self): # real signature unknown; restored from __doc__
        """ x.__neg__() <==> -x """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __nonzero__(self): # real signature unknown; restored from __doc__
        """ x.__nonzero__() <==> x != 0 """
        pass

    def __oct__(self): # real signature unknown; restored from __doc__
        """ x.__oct__() <==> oct(x) """
        pass

    def __or__(self, y): # real signature unknown; restored from __doc__
        """ x.__or__(y) <==> x|y """
        pass

    def __pos__(self): # real signature unknown; restored from __doc__
        """ x.__pos__() <==> +x """
        pass

    def __pow__(self, y, z=None): # real signature unknown; restored from __doc__
        """ x.__pow__(y[, z]) <==> pow(x, y[, z]) """
        pass

    def __radd__(self, y): # real signature unknown; restored from __doc__
        """ x.__radd__(y) <==> y+x """
        pass

    def __rand__(self, y): # real signature unknown; restored from __doc__
        """ x.__rand__(y) <==> y&x """
        pass

    def __rdivmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdivmod__(y) <==> divmod(y, x) """
        pass

    def __rdiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rdiv__(y) <==> y/x """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rfloordiv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rfloordiv__(y) <==> y//x """
        pass

    def __rlshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rlshift__(y) <==> y<<x """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmul__(y) <==> y*x """
        pass

    def __ror__(self, y): # real signature unknown; restored from __doc__
        """ x.__ror__(y) <==> y|x """
        pass

    def __rpow__(self, x, z=None): # real signature unknown; restored from __doc__
        """ y.__rpow__(x[, z]) <==> pow(x, y[, z]) """
        pass

    def __rrshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rrshift__(y) <==> y>>x """
        pass

    def __rshift__(self, y): # real signature unknown; restored from __doc__
        """ x.__rshift__(y) <==> x>>y """
        pass

    def __rsub__(self, y): # real signature unknown; restored from __doc__
        """ x.__rsub__(y) <==> y-x """
        pass

    def __rtruediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__rtruediv__(y) <==> y/x """
        pass

    def __rxor__(self, y): # real signature unknown; restored from __doc__
        """ x.__rxor__(y) <==> y^x """
        pass

    def __sizeof__(self, *args, **kwargs): # real signature unknown
        """ Returns size in memory, in bytes """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass

    def __sub__(self, y): # real signature unknown; restored from __doc__
        """ x.__sub__(y) <==> x-y """
        pass

    def __truediv__(self, y): # real signature unknown; restored from __doc__
        """ x.__truediv__(y) <==> x/y """
        pass

    def __trunc__(self, *args, **kwargs): # real signature unknown
        """ Truncating an Integral returns itself. """
        pass

    def __xor__(self, y): # real signature unknown; restored from __doc__
        """ x.__xor__(y) <==> x^y """
        pass

    denominator = property(lambda self: object()) # default
    imag = property(lambda self: object()) # default
    numerator = property(lambda self: object()) # default
    real = property(lambda self: object()) # default


class MemberDescriptorType(object):
    def __delete__(self, obj): # real signature unknown; restored from __doc__
        """ descr.__delete__(obj) """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __set__(self, obj, value): # real signature unknown; restored from __doc__
        """ descr.__set__(obj, value) """
        pass

    __objclass__ = property(lambda self: object()) # default

    __name__ = 'member_descriptor'


class UnboundMethodType(object):
    """
    instancemethod(function, instance, class)
    
    Create an instance method object.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, function, instance, p_class): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    im_class = property(lambda self: object()) # default
    im_func = property(lambda self: object()) # default
    im_self = property(lambda self: object()) # default
    __func__ = property(lambda self: object()) # default
    __self__ = property(lambda self: object()) # default


MethodType = UnboundMethodType


class ModuleType(object):
    """
    module(name[, doc])
    
    Create a module object.
    The name must be a string; the optional doc argument can have any type.
    """
    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, name, doc=None): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    __dict__ = None # (!) real value is ''


class NoneType(object):
    # no doc
    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass


class NotImplementedType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass


class SliceType(object):
    """
    slice([start,] stop[, step])
    
    Create a slice object.  This is used for extended slicing (e.g. a[0:10:2]).
    """
    def indices(self, len): # real signature unknown; restored from __doc__
        """
        S.indices(len) -> (start, stop, stride)
        
        Assuming a sequence of length len, calculate the start and stop
        indices, and the stride length of the extended slice described by
        S. Out of bounds indices are clipped in a manner consistent with the
        handling of normal slices.
        """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, start=None, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling. """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    start = property(lambda self: object()) # default
    step = property(lambda self: object()) # default
    stop = property(lambda self: object()) # default


class StringType(basestring):
    """
    str(object) -> string
    
    Return a nice string representation of the object.
    If the argument is a string, the return value is the same object.
    """
    def capitalize(self): # real signature unknown; restored from __doc__
        """
        S.capitalize() -> string
        
        Return a copy of the string S with only its first character
        capitalized.
        """
        return ""

    def center(self, width, fillchar=None): # real signature unknown; restored from __doc__
        """
        S.center(width[, fillchar]) -> string
        
        Return S centered in a string of length width. Padding is
        done using the specified fill character (default is a space)
        """
        return ""

    def count(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.count(sub[, start[, end]]) -> int
        
        Return the number of non-overlapping occurrences of substring sub in
        string S[start:end].  Optional arguments start and end are interpreted
        as in slice notation.
        """
        return 0

    def decode(self, encoding=None, errors=None): # real signature unknown; restored from __doc__
        """
        S.decode([encoding[,errors]]) -> object
        
        Decodes S using the codec registered for encoding. encoding defaults
        to the default encoding. errors may be given to set a different error
        handling scheme. Default is 'strict' meaning that encoding errors raise
        a UnicodeDecodeError. Other possible values are 'ignore' and 'replace'
        as well as any other name registered with codecs.register_error that is
        able to handle UnicodeDecodeErrors.
        """
        return object()

    def encode(self, encoding=None, errors=None): # real signature unknown; restored from __doc__
        """
        S.encode([encoding[,errors]]) -> object
        
        Encodes S using the codec registered for encoding. encoding defaults
        to the default encoding. errors may be given to set a different error
        handling scheme. Default is 'strict' meaning that encoding errors raise
        a UnicodeEncodeError. Other possible values are 'ignore', 'replace' and
        'xmlcharrefreplace' as well as any other name registered with
        codecs.register_error that is able to handle UnicodeEncodeErrors.
        """
        return object()

    def endswith(self, suffix, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.endswith(suffix[, start[, end]]) -> bool
        
        Return True if S ends with the specified suffix, False otherwise.
        With optional start, test S beginning at that position.
        With optional end, stop comparing S at that position.
        suffix can also be a tuple of strings to try.
        """
        return False

    def expandtabs(self, tabsize=None): # real signature unknown; restored from __doc__
        """
        S.expandtabs([tabsize]) -> string
        
        Return a copy of S where all tab characters are expanded using spaces.
        If tabsize is not given, a tab size of 8 characters is assumed.
        """
        return ""

    def find(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.find(sub [,start [,end]]) -> int
        
        Return the lowest index in S where substring sub is found,
        such that sub is contained within s[start:end].  Optional
        arguments start and end are interpreted as in slice notation.
        
        Return -1 on failure.
        """
        return 0

    def format(self, *args, **kwargs): # real signature unknown; restored from __doc__
        """
        S.format(*args, **kwargs) -> string
        
        Return a formatted version of S, using substitutions from args and kwargs.
        The substitutions are identified by braces ('{' and '}').
        """
        return ""

    def index(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.index(sub [,start [,end]]) -> int
        
        Like S.find() but raise ValueError when the substring is not found.
        """
        return 0

    def isalnum(self): # real signature unknown; restored from __doc__
        """
        S.isalnum() -> bool
        
        Return True if all characters in S are alphanumeric
        and there is at least one character in S, False otherwise.
        """
        return False

    def isalpha(self): # real signature unknown; restored from __doc__
        """
        S.isalpha() -> bool
        
        Return True if all characters in S are alphabetic
        and there is at least one character in S, False otherwise.
        """
        return False

    def isdigit(self): # real signature unknown; restored from __doc__
        """
        S.isdigit() -> bool
        
        Return True if all characters in S are digits
        and there is at least one character in S, False otherwise.
        """
        return False

    def islower(self): # real signature unknown; restored from __doc__
        """
        S.islower() -> bool
        
        Return True if all cased characters in S are lowercase and there is
        at least one cased character in S, False otherwise.
        """
        return False

    def isspace(self): # real signature unknown; restored from __doc__
        """
        S.isspace() -> bool
        
        Return True if all characters in S are whitespace
        and there is at least one character in S, False otherwise.
        """
        return False

    def istitle(self): # real signature unknown; restored from __doc__
        """
        S.istitle() -> bool
        
        Return True if S is a titlecased string and there is at least one
        character in S, i.e. uppercase characters may only follow uncased
        characters and lowercase characters only cased ones. Return False
        otherwise.
        """
        return False

    def isupper(self): # real signature unknown; restored from __doc__
        """
        S.isupper() -> bool
        
        Return True if all cased characters in S are uppercase and there is
        at least one cased character in S, False otherwise.
        """
        return False

    def join(self, iterable): # real signature unknown; restored from __doc__
        """
        S.join(iterable) -> string
        
        Return a string which is the concatenation of the strings in the
        iterable.  The separator between elements is S.
        """
        return ""

    def ljust(self, width, fillchar=None): # real signature unknown; restored from __doc__
        """
        S.ljust(width[, fillchar]) -> string
        
        Return S left-justified in a string of length width. Padding is
        done using the specified fill character (default is a space).
        """
        return ""

    def lower(self): # real signature unknown; restored from __doc__
        """
        S.lower() -> string
        
        Return a copy of the string S converted to lowercase.
        """
        return ""

    def lstrip(self, chars=None): # real signature unknown; restored from __doc__
        """
        S.lstrip([chars]) -> string or unicode
        
        Return a copy of the string S with leading whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is unicode, S will be converted to unicode before stripping
        """
        return ""

    def partition(self, sep): # real signature unknown; restored from __doc__
        """
        S.partition(sep) -> (head, sep, tail)
        
        Search for the separator sep in S, and return the part before it,
        the separator itself, and the part after it.  If the separator is not
        found, return S and two empty strings.
        """
        pass

    def replace(self, old, new, count=None): # real signature unknown; restored from __doc__
        """
        S.replace(old, new[, count]) -> string
        
        Return a copy of string S with all occurrences of substring
        old replaced by new.  If the optional argument count is
        given, only the first count occurrences are replaced.
        """
        return ""

    def rfind(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.rfind(sub [,start [,end]]) -> int
        
        Return the highest index in S where substring sub is found,
        such that sub is contained within s[start:end].  Optional
        arguments start and end are interpreted as in slice notation.
        
        Return -1 on failure.
        """
        return 0

    def rindex(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.rindex(sub [,start [,end]]) -> int
        
        Like S.rfind() but raise ValueError when the substring is not found.
        """
        return 0

    def rjust(self, width, fillchar=None): # real signature unknown; restored from __doc__
        """
        S.rjust(width[, fillchar]) -> string
        
        Return S right-justified in a string of length width. Padding is
        done using the specified fill character (default is a space)
        """
        return ""

    def rpartition(self, sep): # real signature unknown; restored from __doc__
        """
        S.rpartition(sep) -> (head, sep, tail)
        
        Search for the separator sep in S, starting at the end of S, and return
        the part before it, the separator itself, and the part after it.  If the
        separator is not found, return two empty strings and S.
        """
        pass

    def rsplit(self, sep=None, maxsplit=None): # real signature unknown; restored from __doc__
        """
        S.rsplit([sep [,maxsplit]]) -> list of strings
        
        Return a list of the words in the string S, using sep as the
        delimiter string, starting at the end of the string and working
        to the front.  If maxsplit is given, at most maxsplit splits are
        done. If sep is not specified or is None, any whitespace string
        is a separator.
        """
        return []

    def rstrip(self, chars=None): # real signature unknown; restored from __doc__
        """
        S.rstrip([chars]) -> string or unicode
        
        Return a copy of the string S with trailing whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is unicode, S will be converted to unicode before stripping
        """
        return ""

    def split(self, sep=None, maxsplit=None): # real signature unknown; restored from __doc__
        """
        S.split([sep [,maxsplit]]) -> list of strings
        
        Return a list of the words in the string S, using sep as the
        delimiter string.  If maxsplit is given, at most maxsplit
        splits are done. If sep is not specified or is None, any
        whitespace string is a separator and empty strings are removed
        from the result.
        """
        return []

    def splitlines(self, keepends=None): # real signature unknown; restored from __doc__
        """
        S.splitlines([keepends]) -> list of strings
        
        Return a list of the lines in S, breaking at line boundaries.
        Line breaks are not included in the resulting list unless keepends
        is given and true.
        """
        return []

    def startswith(self, prefix, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.startswith(prefix[, start[, end]]) -> bool
        
        Return True if S starts with the specified prefix, False otherwise.
        With optional start, test S beginning at that position.
        With optional end, stop comparing S at that position.
        prefix can also be a tuple of strings to try.
        """
        return False

    def strip(self, chars=None): # real signature unknown; restored from __doc__
        """
        S.strip([chars]) -> string or unicode
        
        Return a copy of the string S with leading and trailing
        whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is unicode, S will be converted to unicode before stripping
        """
        return ""

    def swapcase(self): # real signature unknown; restored from __doc__
        """
        S.swapcase() -> string
        
        Return a copy of the string S with uppercase characters
        converted to lowercase and vice versa.
        """
        return ""

    def title(self): # real signature unknown; restored from __doc__
        """
        S.title() -> string
        
        Return a titlecased version of S, i.e. words start with uppercase
        characters, all remaining cased characters have lowercase.
        """
        return ""

    def translate(self, table, deletechars=None): # real signature unknown; restored from __doc__
        """
        S.translate(table [,deletechars]) -> string
        
        Return a copy of the string S, where all characters occurring
        in the optional argument deletechars are removed, and the
        remaining characters have been mapped through the given
        translation table, which must be a string of length 256.
        """
        return ""

    def upper(self): # real signature unknown; restored from __doc__
        """
        S.upper() -> string
        
        Return a copy of the string S converted to uppercase.
        """
        return ""

    def zfill(self, width): # real signature unknown; restored from __doc__
        """
        S.zfill(width) -> string
        
        Pad a numeric string S with zeros on the left, to fill a field
        of the specified width.  The string S is never truncated.
        """
        return ""

    def _formatter_field_name_split(self, *args, **kwargs): # real signature unknown
        pass

    def _formatter_parser(self, *args, **kwargs): # real signature unknown
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __format__(self, format_spec): # real signature unknown; restored from __doc__
        """
        S.__format__(format_spec) -> string
        
        Return a formatted version of S as described by format_spec.
        """
        return ""

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __getslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__getslice__(i, j) <==> x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, p_object): # real signature unknown; restored from __doc__
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, n): # real signature unknown; restored from __doc__
        """ x.__mul__(n) <==> x*n """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, n): # real signature unknown; restored from __doc__
        """ x.__rmul__(n) <==> n*x """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ S.__sizeof__() -> size of S in memory, in bytes """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass


class TracebackType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    tb_frame = property(lambda self: object()) # default
    tb_lasti = property(lambda self: object()) # default
    tb_lineno = property(lambda self: object()) # default
    tb_next = property(lambda self: object()) # default


class TupleType(object):
    """
    tuple() -> empty tuple
    tuple(iterable) -> tuple initialized from iterable's items
    
    If the argument is a tuple, the return value is the same object.
    """
    def count(self, value): # real signature unknown; restored from __doc__
        """ T.count(value) -> integer -- return number of occurrences of value """
        return 0

    def index(self, value, start=None, stop=None): # real signature unknown; restored from __doc__
        """
        T.index(value, [start, [stop]]) -> integer -- return first index of value.
        Raises ValueError if the value is not present.
        """
        return 0

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __getslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__getslice__(i, j) <==> x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self): # real signature unknown; restored from __doc__
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mul__(self, n): # real signature unknown; restored from __doc__
        """ x.__mul__(n) <==> x*n """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rmul__(self, n): # real signature unknown; restored from __doc__
        """ x.__rmul__(n) <==> n*x """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ T.__sizeof__() -- size of T in memory, in bytes """
        pass


class TypeType(object):
    """
    type(object) -> the object's type
    type(name, bases, dict) -> a new type
    """
    def mro(self): # real signature unknown; restored from __doc__
        """
        mro() -> list
        return a type's method resolution order
        """
        return []

    def __base__(self, *args, **kwargs): # real signature unknown
        """ The most base type """
        pass

    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, p_object): # real signature unknown; restored from __doc__
        pass

    def __instancecheck__(self): # real signature unknown; restored from __doc__
        """ __instancecheck__() -> check if an object is an instance """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __subclasscheck__(self): # real signature unknown; restored from __doc__
        """ __subclasscheck__() -> check if a class is a subclass """
        pass

    def __subclasses__(self): # real signature unknown; restored from __doc__
        """ __subclasses__() -> list of immediate subclasses """
        return []

    __abstractmethods__ = property(lambda self: object()) # default

    __bases__ = (
        object,
    )
    __basicsize__ = 872
    __dictoffset__ = 264
    __dict__ = None # (!) real value is ''
    __flags__ = 2148423147
    __itemsize__ = 40
    __mro__ = (
        type,
        object,
    )
    __name__ = 'type'
    __weakrefoffset__ = 368


class UnicodeType(basestring):
    """
    unicode(string [, encoding[, errors]]) -> object
    
    Create a new Unicode object from the given encoded string.
    encoding defaults to the current default string encoding.
    errors can be 'strict', 'replace' or 'ignore' and defaults to 'strict'.
    """
    def capitalize(self): # real signature unknown; restored from __doc__
        """
        S.capitalize() -> unicode
        
        Return a capitalized version of S, i.e. make the first character
        have upper case and the rest lower case.
        """
        return u""

    def center(self, width, fillchar=None): # real signature unknown; restored from __doc__
        """
        S.center(width[, fillchar]) -> unicode
        
        Return S centered in a Unicode string of length width. Padding is
        done using the specified fill character (default is a space)
        """
        return u""

    def count(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.count(sub[, start[, end]]) -> int
        
        Return the number of non-overlapping occurrences of substring sub in
        Unicode string S[start:end].  Optional arguments start and end are
        interpreted as in slice notation.
        """
        return 0

    def decode(self, encoding=None, errors=None): # real signature unknown; restored from __doc__
        """
        S.decode([encoding[,errors]]) -> string or unicode
        
        Decodes S using the codec registered for encoding. encoding defaults
        to the default encoding. errors may be given to set a different error
        handling scheme. Default is 'strict' meaning that encoding errors raise
        a UnicodeDecodeError. Other possible values are 'ignore' and 'replace'
        as well as any other name registerd with codecs.register_error that is
        able to handle UnicodeDecodeErrors.
        """
        return ""

    def encode(self, encoding=None, errors=None): # real signature unknown; restored from __doc__
        """
        S.encode([encoding[,errors]]) -> string or unicode
        
        Encodes S using the codec registered for encoding. encoding defaults
        to the default encoding. errors may be given to set a different error
        handling scheme. Default is 'strict' meaning that encoding errors raise
        a UnicodeEncodeError. Other possible values are 'ignore', 'replace' and
        'xmlcharrefreplace' as well as any other name registered with
        codecs.register_error that can handle UnicodeEncodeErrors.
        """
        return ""

    def endswith(self, suffix, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.endswith(suffix[, start[, end]]) -> bool
        
        Return True if S ends with the specified suffix, False otherwise.
        With optional start, test S beginning at that position.
        With optional end, stop comparing S at that position.
        suffix can also be a tuple of strings to try.
        """
        return False

    def expandtabs(self, tabsize=None): # real signature unknown; restored from __doc__
        """
        S.expandtabs([tabsize]) -> unicode
        
        Return a copy of S where all tab characters are expanded using spaces.
        If tabsize is not given, a tab size of 8 characters is assumed.
        """
        return u""

    def find(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.find(sub [,start [,end]]) -> int
        
        Return the lowest index in S where substring sub is found,
        such that sub is contained within s[start:end].  Optional
        arguments start and end are interpreted as in slice notation.
        
        Return -1 on failure.
        """
        return 0

    def format(self, *args, **kwargs): # real signature unknown; restored from __doc__
        """
        S.format(*args, **kwargs) -> unicode
        
        Return a formatted version of S, using substitutions from args and kwargs.
        The substitutions are identified by braces ('{' and '}').
        """
        return u""

    def index(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.index(sub [,start [,end]]) -> int
        
        Like S.find() but raise ValueError when the substring is not found.
        """
        return 0

    def isalnum(self): # real signature unknown; restored from __doc__
        """
        S.isalnum() -> bool
        
        Return True if all characters in S are alphanumeric
        and there is at least one character in S, False otherwise.
        """
        return False

    def isalpha(self): # real signature unknown; restored from __doc__
        """
        S.isalpha() -> bool
        
        Return True if all characters in S are alphabetic
        and there is at least one character in S, False otherwise.
        """
        return False

    def isdecimal(self): # real signature unknown; restored from __doc__
        """
        S.isdecimal() -> bool
        
        Return True if there are only decimal characters in S,
        False otherwise.
        """
        return False

    def isdigit(self): # real signature unknown; restored from __doc__
        """
        S.isdigit() -> bool
        
        Return True if all characters in S are digits
        and there is at least one character in S, False otherwise.
        """
        return False

    def islower(self): # real signature unknown; restored from __doc__
        """
        S.islower() -> bool
        
        Return True if all cased characters in S are lowercase and there is
        at least one cased character in S, False otherwise.
        """
        return False

    def isnumeric(self): # real signature unknown; restored from __doc__
        """
        S.isnumeric() -> bool
        
        Return True if there are only numeric characters in S,
        False otherwise.
        """
        return False

    def isspace(self): # real signature unknown; restored from __doc__
        """
        S.isspace() -> bool
        
        Return True if all characters in S are whitespace
        and there is at least one character in S, False otherwise.
        """
        return False

    def istitle(self): # real signature unknown; restored from __doc__
        """
        S.istitle() -> bool
        
        Return True if S is a titlecased string and there is at least one
        character in S, i.e. upper- and titlecase characters may only
        follow uncased characters and lowercase characters only cased ones.
        Return False otherwise.
        """
        return False

    def isupper(self): # real signature unknown; restored from __doc__
        """
        S.isupper() -> bool
        
        Return True if all cased characters in S are uppercase and there is
        at least one cased character in S, False otherwise.
        """
        return False

    def join(self, iterable): # real signature unknown; restored from __doc__
        """
        S.join(iterable) -> unicode
        
        Return a string which is the concatenation of the strings in the
        iterable.  The separator between elements is S.
        """
        return u""

    def ljust(self, width, fillchar=None): # real signature unknown; restored from __doc__
        """
        S.ljust(width[, fillchar]) -> int
        
        Return S left-justified in a Unicode string of length width. Padding is
        done using the specified fill character (default is a space).
        """
        return 0

    def lower(self): # real signature unknown; restored from __doc__
        """
        S.lower() -> unicode
        
        Return a copy of the string S converted to lowercase.
        """
        return u""

    def lstrip(self, chars=None): # real signature unknown; restored from __doc__
        """
        S.lstrip([chars]) -> unicode
        
        Return a copy of the string S with leading whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is a str, it will be converted to unicode before stripping
        """
        return u""

    def partition(self, sep): # real signature unknown; restored from __doc__
        """
        S.partition(sep) -> (head, sep, tail)
        
        Search for the separator sep in S, and return the part before it,
        the separator itself, and the part after it.  If the separator is not
        found, return S and two empty strings.
        """
        pass

    def replace(self, old, new, count=None): # real signature unknown; restored from __doc__
        """
        S.replace(old, new[, count]) -> unicode
        
        Return a copy of S with all occurrences of substring
        old replaced by new.  If the optional argument count is
        given, only the first count occurrences are replaced.
        """
        return u""

    def rfind(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.rfind(sub [,start [,end]]) -> int
        
        Return the highest index in S where substring sub is found,
        such that sub is contained within s[start:end].  Optional
        arguments start and end are interpreted as in slice notation.
        
        Return -1 on failure.
        """
        return 0

    def rindex(self, sub, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.rindex(sub [,start [,end]]) -> int
        
        Like S.rfind() but raise ValueError when the substring is not found.
        """
        return 0

    def rjust(self, width, fillchar=None): # real signature unknown; restored from __doc__
        """
        S.rjust(width[, fillchar]) -> unicode
        
        Return S right-justified in a Unicode string of length width. Padding is
        done using the specified fill character (default is a space).
        """
        return u""

    def rpartition(self, sep): # real signature unknown; restored from __doc__
        """
        S.rpartition(sep) -> (head, sep, tail)
        
        Search for the separator sep in S, starting at the end of S, and return
        the part before it, the separator itself, and the part after it.  If the
        separator is not found, return two empty strings and S.
        """
        pass

    def rsplit(self, sep=None, maxsplit=None): # real signature unknown; restored from __doc__
        """
        S.rsplit([sep [,maxsplit]]) -> list of strings
        
        Return a list of the words in S, using sep as the
        delimiter string, starting at the end of the string and
        working to the front.  If maxsplit is given, at most maxsplit
        splits are done. If sep is not specified, any whitespace string
        is a separator.
        """
        return []

    def rstrip(self, chars=None): # real signature unknown; restored from __doc__
        """
        S.rstrip([chars]) -> unicode
        
        Return a copy of the string S with trailing whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is a str, it will be converted to unicode before stripping
        """
        return u""

    def split(self, sep=None, maxsplit=None): # real signature unknown; restored from __doc__
        """
        S.split([sep [,maxsplit]]) -> list of strings
        
        Return a list of the words in S, using sep as the
        delimiter string.  If maxsplit is given, at most maxsplit
        splits are done. If sep is not specified or is None, any
        whitespace string is a separator and empty strings are
        removed from the result.
        """
        return []

    def splitlines(self, keepends=None): # real signature unknown; restored from __doc__
        """
        S.splitlines([keepends]) -> list of strings
        
        Return a list of the lines in S, breaking at line boundaries.
        Line breaks are not included in the resulting list unless keepends
        is given and true.
        """
        return []

    def startswith(self, prefix, start=None, end=None): # real signature unknown; restored from __doc__
        """
        S.startswith(prefix[, start[, end]]) -> bool
        
        Return True if S starts with the specified prefix, False otherwise.
        With optional start, test S beginning at that position.
        With optional end, stop comparing S at that position.
        prefix can also be a tuple of strings to try.
        """
        return False

    def strip(self, chars=None): # real signature unknown; restored from __doc__
        """
        S.strip([chars]) -> unicode
        
        Return a copy of the string S with leading and trailing
        whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is a str, it will be converted to unicode before stripping
        """
        return u""

    def swapcase(self): # real signature unknown; restored from __doc__
        """
        S.swapcase() -> unicode
        
        Return a copy of S with uppercase characters converted to lowercase
        and vice versa.
        """
        return u""

    def title(self): # real signature unknown; restored from __doc__
        """
        S.title() -> unicode
        
        Return a titlecased version of S, i.e. words start with title case
        characters, all remaining cased characters have lower case.
        """
        return u""

    def translate(self, table): # real signature unknown; restored from __doc__
        """
        S.translate(table) -> unicode
        
        Return a copy of the string S, where all characters have been mapped
        through the given translation table, which must be a mapping of
        Unicode ordinals to Unicode ordinals, Unicode strings or None.
        Unmapped characters are left untouched. Characters mapped to None
        are deleted.
        """
        return u""

    def upper(self): # real signature unknown; restored from __doc__
        """
        S.upper() -> unicode
        
        Return a copy of S converted to uppercase.
        """
        return u""

    def zfill(self, width): # real signature unknown; restored from __doc__
        """
        S.zfill(width) -> unicode
        
        Pad a numeric string S with zeros on the left, to fill a field
        of the specified width. The string S is never truncated.
        """
        return u""

    def _formatter_field_name_split(self, *args, **kwargs): # real signature unknown
        pass

    def _formatter_parser(self, *args, **kwargs): # real signature unknown
        pass

    def __add__(self, y): # real signature unknown; restored from __doc__
        """ x.__add__(y) <==> x+y """
        pass

    def __contains__(self, y): # real signature unknown; restored from __doc__
        """ x.__contains__(y) <==> y in x """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __format__(self, format_spec): # real signature unknown; restored from __doc__
        """
        S.__format__(format_spec) -> unicode
        
        Return a formatted version of S as described by format_spec.
        """
        return u""

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __getslice__(self, i, j): # real signature unknown; restored from __doc__
        """
        x.__getslice__(i, j) <==> x[i:j]
                   
                   Use of negative indices is not supported.
        """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, string, encoding=None, errors=None): # real signature unknown; restored from __doc__
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    def __mod__(self, y): # real signature unknown; restored from __doc__
        """ x.__mod__(y) <==> x%y """
        pass

    def __mul__(self, n): # real signature unknown; restored from __doc__
        """ x.__mul__(n) <==> x*n """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __rmod__(self, y): # real signature unknown; restored from __doc__
        """ x.__rmod__(y) <==> y%x """
        pass

    def __rmul__(self, n): # real signature unknown; restored from __doc__
        """ x.__rmul__(n) <==> n*x """
        pass

    def __sizeof__(self): # real signature unknown; restored from __doc__
        """ S.__sizeof__() -> size of S in memory, in bytes """
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass


class XRangeType(object):
    """
    xrange([start,] stop[, step]) -> xrange object
    
    Like range(), but instead of returning a list, returns an object that
    generates the numbers in the range on demand.  For looping, this is 
    slightly faster than range() and more memory efficient.
    """
    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __init__(self, start=None, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __reversed__(self, *args, **kwargs): # real signature unknown
        """ Returns a reverse iterator. """
        pass


# variables with complex values

FSSType = None # (!) real value is ''

ObjectSpecifier = aetypes.ObjectSpecifier

StringTypes = aetypes.StringTypes

unpacker_coercions = {
    'STXT': 'reco',
    'cdrw': 'reco',
    'clrt': 'list',
    'comp': 'doub',
    'cpix': 'reco',
    'exte': 'doub',
    'fixd': 'doub',
    'trot': 'reco',
    'tsty': 'reco',
}

