# encoding: utf-8
# module atexit
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/atexit.pyo by generator 1.99
"""
atexit.py - allow programmer to define multiple exit functions to be executed
upon normal program termination.

One public function, register, is defined.
"""

# imports
import sys as sys # <module 'sys' (built-in)>

# functions

def register(func, *targs, **kargs): # reliably restored by inspect
    """
    register a function to be executed upon normal program termination
    
        func - function to be called at exit
        targs - optional arguments to pass to func
        kargs - optional keyword arguments to pass to func
    
        func is returned to facilitate usage as a decorator.
    """
    pass


def _run_exitfuncs(): # reliably restored by inspect
    """
    run any registered exit functions
    
        _exithandlers is traversed in reverse order so functions are executed
        last in, first out.
    """
    pass


# no classes
# variables with complex values

_exithandlers = []

__all__ = [
    'register',
]

