# encoding: utf-8
# module collections
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/collections.pyo by generator 1.99
# no doc

# imports
import heapq as _heapq # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/heapq.pyc
import _abcoll as _abcoll # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/_abcoll.pyc
import sys as _sys # <module 'sys' (built-in)>
from itertools import _chain, _ifilter, _imap, _repeat, _starmap

from operator import _eq, _itemgetter

from thread import get_ident

import _abcoll as ___abcoll


# functions

def namedtuple(typename, field_names, verbose=False, rename=False): # reliably restored by inspect
    """
    Returns a new subclass of tuple with named fields.
    
        >>> Point = namedtuple('Point', 'x y')
        >>> Point.__doc__                   # docstring for the new class
        'Point(x, y)'
        >>> p = Point(11, y=22)             # instantiate with positional args or keywords
        >>> p[0] + p[1]                     # indexable like a plain tuple
        33
        >>> x, y = p                        # unpack like a regular tuple
        >>> x, y
        (11, 22)
        >>> p.x + p.y                       # fields also accessable by name
        33
        >>> d = p._asdict()                 # convert to a dictionary
        >>> d['x']
        11
        >>> Point(**d)                      # convert from a dictionary
        Point(x=11, y=22)
        >>> p._replace(x=100)               # _replace() is like str.replace() but targets named fields
        Point(x=100, y=22)
    """
    pass


def _iskeyword(*args, **kwargs): # real signature unknown
    """ x.__contains__(y) <==> y in x. """
    pass


def _recursive_repr(user_function): # reliably restored by inspect
    """ Decorator to make a repr function return "..." for a recursive call """
    pass


# classes

class Callable(object):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Container(object):
    # no doc
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Counter(dict):
    """
    Dict subclass for counting hashable items.  Sometimes called a bag
        or multiset.  Elements are stored as dictionary keys and their counts
        are stored as dictionary values.
    
        >>> c = Counter('abracadabra')      # count elements from a string
    
        >>> c.most_common(3)                # three most common elements
        [('a', 5), ('r', 2), ('b', 2)]
        >>> sorted(c)                       # list all unique elements
        ['a', 'b', 'c', 'd', 'r']
        >>> ''.join(sorted(c.elements()))   # list elements with repetitions
        'aaaaabbcdrr'
        >>> sum(c.values())                 # total of all counts
        11
    
        >>> c['a']                          # count of letter 'a'
        5
        >>> for elem in 'shazam':           # update counts from an iterable
        ...     c[elem] += 1                # by adding 1 to each element's count
        >>> c['a']                          # now there are seven 'a'
        7
        >>> del c['r']                      # remove all 'r'
        >>> c['r']                          # now there are zero 'r'
        0
    
        >>> d = Counter('simsalabim')       # make another counter
        >>> c.update(d)                     # add in the second counter
        >>> c['a']                          # now there are nine 'a'
        9
    
        >>> c.clear()                       # empty the counter
        >>> c
        Counter()
    
        Note:  If a count is set to zero or reduced to zero, it will remain
        in the counter until the entry is deleted or the counter is cleared:
    
        >>> c = Counter('aaabbc')
        >>> c['b'] -= 2                     # reduce the count of 'b' by two
        >>> c.most_common()                 # 'b' is still in, but its count is zero
        [('a', 3), ('c', 1), ('b', 0)]
    """
    def copy(self): # real signature unknown; restored from __doc__
        """ Like dict.copy() but returns a Counter instance instead of a dict. """
        pass

    def elements(self): # real signature unknown; restored from __doc__
        """
        Iterator over elements repeating each as many times as its count.
        
                >>> c = Counter('ABCABC')
                >>> sorted(c.elements())
                ['A', 'A', 'B', 'B', 'C', 'C']
        
                # Knuth's example for prime factors of 1836:  2**2 * 3**3 * 17**1
                >>> prime_factors = Counter({2: 2, 3: 3, 17: 1})
                >>> product = 1
                >>> for factor in prime_factors.elements():     # loop over factors
                ...     product *= factor                       # and multiply them
                >>> product
                1836
        
                Note, if an element's count has been set to zero or is a negative
                number, elements() will ignore it.
        """
        pass

    @classmethod
    def fromkeys(cls, *args, **kwargs): # real signature unknown
        pass

    def most_common(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        List the n most common elements and their counts from the most
                common to the least.  If n is None, then list all element counts.
        
                >>> Counter('abracadabra').most_common(3)
                [('a', 5), ('r', 2), ('b', 2)]
        """
        pass

    def subtract(self, witch): # real signature unknown; restored from __doc__
        """
        Like dict.update() but subtracts counts instead of replacing them.
                Counts can be reduced below zero.  Both the inputs and outputs are
                allowed to contain zero and negative counts.
        
                Source can be an iterable, a dictionary, or another Counter instance.
        
                >>> c = Counter('which')
                >>> c.subtract('witch')             # subtract elements from another iterable
                >>> c.subtract(Counter('watch'))    # subtract elements from another counter
                >>> c['h']                          # 2 in which, minus 1 in witch, minus 1 in watch
                0
                >>> c['w']                          # 1 in which, minus 1 in witch, minus 1 in watch
                -1
        """
        pass

    def update(self): # real signature unknown; restored from __doc__
        """
        Like dict.update() but add counts instead of replacing them.
        
                Source can be an iterable, a dictionary, or another Counter instance.
        
                >>> c = Counter('which')
                >>> c.update('witch')           # add elements from another iterable
                >>> d = Counter('watch')
                >>> c.update(d)                 # add elements from another counter
                >>> c['h']                      # four 'h' in which, witch, and watch
                4
        """
        pass

    def __add__(self, *args, **kwargs): # real signature unknown
        """
        Add counts from two counters.
        
                >>> Counter('abbb') + Counter('bcc')
                Counter({'b': 4, 'c': 2, 'a': 1})
        """
        pass

    def __and__(self, *args, **kwargs): # real signature unknown
        """
        Intersection is the minimum of corresponding counts.
        
                >>> Counter('abbb') & Counter('bcc')
                Counter({'b': 1})
        """
        pass

    def __delitem__(self): # real signature unknown; restored from __doc__
        """ Like dict.__delitem__() but does not raise KeyError for missing values. """
        pass

    def __init__(self): # real signature unknown; restored from __doc__
        """
        Create a new, empty Counter object.  And if given, count elements
                from an input iterable.  Or, initialize the count from another mapping
                of elements to their counts.
        
                >>> c = Counter()                           # a new, empty counter
                >>> c = Counter('gallahad')                 # a new counter from an iterable
                >>> c = Counter({'a': 4, 'b': 2})           # a new counter from a mapping
                >>> c = Counter(a=4, b=2)                   # a new counter from keyword args
        """
        pass

    def __missing__(self, *args, **kwargs): # real signature unknown
        """ The count of elements not in the Counter is zero. """
        pass

    def __or__(self, *args, **kwargs): # real signature unknown
        """
        Union is the maximum of value in either of the input counters.
        
                >>> Counter('abbb') | Counter('bcc')
                Counter({'b': 3, 'c': 2, 'a': 1})
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        """
        Subtract count, but keep only results with positive counts.
        
                >>> Counter('abbbc') - Counter('bccd')
                Counter({'b': 2, 'a': 1})
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class defaultdict(dict):
    """
    defaultdict(default_factory) --> dict with default factory
    
    The default factory is called without arguments to produce
    a new value when a key is not present, in __getitem__ only.
    A defaultdict compares equal to a dict with the same items.
    """
    def copy(self): # real signature unknown; restored from __doc__
        """ D.copy() -> a shallow copy of D. """
        pass

    def __copy__(self, *args, **kwargs): # real signature unknown
        """ D.copy() -> a shallow copy of D. """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, default_factory=None, **kwargs): # known case of collections.defaultdict.__init__
        """
        defaultdict(default_factory) --> dict with default factory
        
        The default factory is called without arguments to produce
        a new value when a key is not present, in __getitem__ only.
        A defaultdict compares equal to a dict with the same items.
        
        # (copied from class doc)
        """
        pass

    def __missing__(self, key): # real signature unknown; restored from __doc__
        """
        __missing__(key) # Called by __getitem__ for missing key; pseudo-code:
          if self.default_factory is None: raise KeyError((key,))
          self[key] = value = self.default_factory()
          return value
        """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling. """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    default_factory = property(lambda self: object()) # default


class deque(object):
    """
    deque(iterable[, maxlen]) --> deque object
    
    Build an ordered collection accessible from endpoints only.
    """
    def append(self, *args, **kwargs): # real signature unknown
        """ Add an element to the right side of the deque. """
        pass

    def appendleft(self, *args, **kwargs): # real signature unknown
        """ Add an element to the left side of the deque. """
        pass

    def clear(self, *args, **kwargs): # real signature unknown
        """ Remove all elements from the deque. """
        pass

    def count(self, value): # real signature unknown; restored from __doc__
        """ D.count(value) -> integer -- return number of occurrences of value """
        return 0

    def extend(self, *args, **kwargs): # real signature unknown
        """ Extend the right side of the deque with elements from the iterable """
        pass

    def extendleft(self, *args, **kwargs): # real signature unknown
        """ Extend the left side of the deque with elements from the iterable """
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        """ Remove and return the rightmost element. """
        pass

    def popleft(self, *args, **kwargs): # real signature unknown
        """ Remove and return the leftmost element. """
        pass

    def remove(self, value): # real signature unknown; restored from __doc__
        """ D.remove(value) -- remove first occurrence of value. """
        pass

    def reverse(self): # real signature unknown; restored from __doc__
        """ D.reverse() -- reverse *IN PLACE* """
        pass

    def rotate(self, *args, **kwargs): # real signature unknown
        """ Rotate the deque n steps to the right (default n=1).  If n is negative, rotates left. """
        pass

    def __copy__(self, *args, **kwargs): # real signature unknown
        """ Return a shallow copy of a deque. """
        pass

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__delitem__(y) <==> del x[y] """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __getitem__(self, y): # real signature unknown; restored from __doc__
        """ x.__getitem__(y) <==> x[y] """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __iadd__(self, y): # real signature unknown; restored from __doc__
        """ x.__iadd__(y) <==> x+=y """
        pass

    def __init__(self, iterable=(), maxlen=None): # known case of collections.deque.__init__
        """
        deque(iterable[, maxlen]) --> deque object
        
        Build an ordered collection accessible from endpoints only.
        # (copied from class doc)
        """
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ x.__iter__() <==> iter(x) """
        pass

    def __len__(self): # real signature unknown; restored from __doc__
        """ x.__len__() <==> len(x) """
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling. """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __reversed__(self): # real signature unknown; restored from __doc__
        """ D.__reversed__() -- return a reverse iterator over the deque """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ x.__setitem__(i, y) <==> x[i]=y """
        pass

    maxlen = property(lambda self: object()) # default

    __hash__ = None


class Hashable(object):
    # no doc
    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 0
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Iterable(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 0
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Sized(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __len__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class MappingView(___abcoll.Sized):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __len__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Set(___abcoll.Sized, ___abcoll.Iterable, ___abcoll.Container):
    """
    A set is a finite, iterable container.
    
        This class provides concrete generic implementations of all
        methods except for __contains__, __iter__ and __len__.
    
        To override the comparisons (presumably for speed, as the
        semantics are fixed), all you have to do is redefine __le__ and
        then the other operations will automatically follow suit.
    """
    def isdisjoint(self, *args, **kwargs): # real signature unknown
        pass

    @classmethod
    def _from_iterable(cls, *args, **kwargs): # real signature unknown
        """
        Construct an instance of the class from any iterable input.
        
                Must override this method if the class constructor signature
                does not accept an iterable for an input.
        """
        pass

    def _hash(self, *args, **kwargs): # real signature unknown
        """
        Compute the hash value of a set.
        
                Note that we don't define __hash__: not all sets are hashable.
                But if you define a hashable set type, its __hash__ should
                call this function.
        
                This must be compatible __eq__.
        
                All sets ought to compare equal if they contain the same
                elements, regardless of how they are implemented, and
                regardless of the order of the elements; so there's not much
                freedom for __eq__ or __hash__.  We match the algorithm used
                by the built-in frozenset type.
        """
        pass

    def __and__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __ge__(self, *args, **kwargs): # real signature unknown
        pass

    def __gt__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __le__(self, *args, **kwargs): # real signature unknown
        pass

    def __lt__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __or__(self, *args, **kwargs): # real signature unknown
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        pass

    def __xor__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __hash__ = None


class ItemsView(___abcoll.MappingView, ___abcoll.Set):
    # no doc
    @classmethod
    def _from_iterable(cls, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Iterator(___abcoll.Iterable):
    # no doc
    def next(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class KeysView(___abcoll.MappingView, ___abcoll.Set):
    # no doc
    @classmethod
    def _from_iterable(cls, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Mapping(___abcoll.Sized, ___abcoll.Iterable, ___abcoll.Container):
    # no doc
    def get(self, *args, **kwargs): # real signature unknown
        pass

    def items(self, *args, **kwargs): # real signature unknown
        pass

    def iteritems(self, *args, **kwargs): # real signature unknown
        pass

    def iterkeys(self, *args, **kwargs): # real signature unknown
        pass

    def itervalues(self, *args, **kwargs): # real signature unknown
        pass

    def keys(self, *args, **kwargs): # real signature unknown
        pass

    def values(self, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __hash__ = None


class MutableMapping(___abcoll.Mapping):
    # no doc
    def clear(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def popitem(self, *args, **kwargs): # real signature unknown
        pass

    def setdefault(self, *args, **kwargs): # real signature unknown
        pass

    def update(self, *args, **kwargs): # real signature unknown
        pass

    def __delitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __setitem__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 9
    _abc_registry = None # (!) real value is ''
    _MutableMapping__marker = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Sequence(___abcoll.Sized, ___abcoll.Iterable, ___abcoll.Container):
    """
    All the operations on a read-only sequence.
    
        Concrete subclasses must override __new__ or __init__,
        __getitem__, and __len__.
    """
    def count(self, *args, **kwargs): # real signature unknown
        pass

    def index(self, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __reversed__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 7
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class MutableSequence(___abcoll.Sequence):
    # no doc
    def append(self, *args, **kwargs): # real signature unknown
        pass

    def extend(self, *args, **kwargs): # real signature unknown
        pass

    def insert(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        pass

    def reverse(self, *args, **kwargs): # real signature unknown
        pass

    def __delitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __iadd__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __setitem__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 8
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class MutableSet(___abcoll.Set):
    # no doc
    def add(self, *args, **kwargs): # real signature unknown
        """ Add an element. """
        pass

    def clear(self, *args, **kwargs): # real signature unknown
        """ This is slow (creates N new iterators!) but effective. """
        pass

    def discard(self, *args, **kwargs): # real signature unknown
        """ Remove an element.  Do not raise an exception if absent. """
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        """ Return the popped value.  Raise KeyError if empty. """
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        """ Remove an element. If not a member, raise a KeyError. """
        pass

    def __iand__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ior__(self, *args, **kwargs): # real signature unknown
        pass

    def __isub__(self, *args, **kwargs): # real signature unknown
        pass

    def __ixor__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 2
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class OrderedDict(dict, ___abcoll.MutableMapping):
    """ Dictionary that remembers insertion order """
    def clear(self): # real signature unknown; restored from __doc__
        """ od.clear() -> None.  Remove all items from od. """
        pass

    def copy(self): # real signature unknown; restored from __doc__
        """ od.copy() -> a shallow copy of od """
        pass

    @classmethod
    def fromkeys(cls, S, v=None): # real signature unknown; restored from __doc__
        """
        OD.fromkeys(S[, v]) -> New ordered dictionary with keys from S
                and values equal to v (which defaults to None).
        """
        pass

    def items(self, *args, **kwargs): # real signature unknown
        pass

    def iteritems(self, *args, **kwargs): # real signature unknown
        pass

    def iterkeys(self, *args, **kwargs): # real signature unknown
        pass

    def itervalues(self, *args, **kwargs): # real signature unknown
        pass

    def keys(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def popitem(self): # real signature unknown; restored from __doc__
        """
        od.popitem() -> (k, v), return and remove a (key, value) pair.
                Pairs are returned in LIFO order if last is true or FIFO order if false.
        """
        pass

    def setdefault(self, *args, **kwargs): # real signature unknown
        pass

    def update(self, *args, **kwargs): # real signature unknown
        pass

    def values(self, *args, **kwargs): # real signature unknown
        pass

    def viewitems(self): # real signature unknown; restored from __doc__
        """ od.viewitems() -> a set-like object providing a view on od's items """
        pass

    def viewkeys(self): # real signature unknown; restored from __doc__
        """ od.viewkeys() -> a set-like object providing a view on od's keys """
        pass

    def viewvalues(self): # real signature unknown; restored from __doc__
        """ od.viewvalues() -> an object providing a view on od's values """
        pass

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ od.__delitem__(y) <==> del od[y] """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """
        od.__eq__(y) <==> od==y.  Comparison to another OD is order-sensitive
                while comparison to a regular mapping is order-insensitive.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize an ordered dictionary.  Signature is the same as for
                regular dictionaries, but keyword arguments are not recommended
                because their insertion order is arbitrary.
        """
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ od.__iter__() <==> iter(od) """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ od.__repr__() <==> repr(od) """
        pass

    def __reversed__(self): # real signature unknown; restored from __doc__
        """ od.__reversed__() <==> reversed(od) """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ od.__setitem__(i, y) <==> od[i]=y """
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 10
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class ValuesView(___abcoll.MappingView):
    # no doc
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


# variables with complex values

__all__ = [
    'Counter',
    'deque',
    'defaultdict',
    'namedtuple',
    'OrderedDict',
    'Hashable',
    'Iterable',
    'Iterator',
    'Sized',
    'Container',
    'Callable',
    'Set',
    'MutableSet',
    'Mapping',
    'MutableMapping',
    'MappingView',
    'KeysView',
    'ItemsView',
    'ValuesView',
    'Sequence',
    'MutableSequence',
]

