# encoding: utf-8
# module cookielib
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/cookielib.pyo by generator 1.99
"""
HTTP cookie handling for web clients.

This module has (now fairly distant) origins in Gisle Aas' Perl module
HTTP::Cookies, from the libwww-perl library.

Docstrings, comments and debug strings in this code refer to the
attributes of the HTTP cookie system as cookie-attributes, to distinguish
them clearly from Python attributes.

Class diagram (note that BSDDBCookieJar and the MSIE* classes are not
distributed with the Python standard library, but are available from
http://wwwsearch.sf.net/):

                        CookieJar____
                        /     \                  FileCookieJar      \                   /    |   \         \       MozillaCookieJar | LWPCookieJar \                        |               |                        |   ---MSIEBase |                         |  /      |     |                          | /   MSIEDBCookieJar BSDDBCookieJar
                  |/
               MSIECookieJar
"""

# imports
import urllib as urllib # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/urllib.py
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import copy as copy # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/copy.pyc
import httplib as httplib # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/httplib.pyc
import threading as _threading # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/threading.pyc
import urlparse as urlparse # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/urlparse.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so

# Variables with simple values

debug = False

DEFAULT_HTTP_PORT = '80'

EPOCH_YEAR = 1970

HTTP_PATH_SAFE = "%/;:@&=+$,!~*'()"

logger = None

MISSING_FILENAME_TEXT = 'a filename was not supplied (nor was the CookieJar instance initialised with one)'

month = 'Dec'

# functions

def deepvalues(mapping): # reliably restored by inspect
    """ Iterates over nested mapping, depth-first, in sorted order by key. """
    pass


def domain_match(A, B): # reliably restored by inspect
    """
    Return True if domain A domain-matches domain B, according to RFC 2965.
    
        A and B may be host domain names or IP addresses.
    
        RFC 2965, section 1:
    
        Host names can be specified either as an IP address or a HDN string.
        Sometimes we compare one host name with another.  (Such comparisons SHALL
        be case-insensitive.)  Host A's name domain-matches host B's if
    
             *  their host name strings string-compare equal; or
    
             * A is a HDN string and has the form NB, where N is a non-empty
                name string, B has the form .B', and B' is a HDN string.  (So,
                x.y.com domain-matches .Y.com but not Y.com.)
    
        Note that domain-match is not a commutative operation: a.b.c.com
        domain-matches .c.com, but not the reverse.
    """
    pass


def eff_request_host(request): # reliably restored by inspect
    """
    Return a tuple (request-host, effective request-host name).
    
        As defined by RFC 2965, except both are lowercased.
    """
    pass


def escape_path(path): # reliably restored by inspect
    """ Escape any invalid characters in HTTP URL, and uppercase all escapes. """
    pass


def http2time(text): # reliably restored by inspect
    """
    Returns time in seconds since epoch of time represented by a string.
    
        Return value is an integer.
    
        None is returned if the format of str is unrecognized, the time is outside
        the representable range, or the timezone string is not recognized.  If the
        string contains no timezone, UTC is assumed.
    
        The timezone in the string may be numerical (like "-0800" or "+0100") or a
        string timezone (like "UTC", "GMT", "BST" or "EST").  Currently, only the
        timezone strings equivalent to UTC (zero offset) are known to the function.
    
        The function loosely parses the following formats:
    
        Wed, 09 Feb 1994 22:23:32 GMT       -- HTTP format
        Tuesday, 08-Feb-94 14:15:29 GMT     -- old rfc850 HTTP format
        Tuesday, 08-Feb-1994 14:15:29 GMT   -- broken rfc850 HTTP format
        09 Feb 1994 22:23:32 GMT            -- HTTP format (no weekday)
        08-Feb-94 14:15:29 GMT              -- rfc850 format (no weekday)
        08-Feb-1994 14:15:29 GMT            -- broken rfc850 format (no weekday)
    
        The parser ignores leading and trailing whitespace.  The time may be
        absent.
    
        If the year is given with only 2 digits, the function will select the
        century that makes the year closest to the current date.
    """
    pass


def iso2time(text): # reliably restored by inspect
    """
    As for http2time, but parses the ISO 8601 formats:
    
        1994-02-03 14:15:29 -0100    -- ISO 8601 format
        1994-02-03 14:15:29          -- zone is optional
        1994-02-03                   -- only date
        1994-02-03T14:15:29          -- Use T as separator
        19940203T141529Z             -- ISO 8601 compact format
        19940203                     -- only date
    """
    pass


def is_HDN(text): # reliably restored by inspect
    """ Return True if text is a host domain name. """
    pass


def is_third_party(request): # reliably restored by inspect
    """
    RFC 2965, section 3.3.6:
    
            An unverifiable transaction is to a third-party host if its request-
            host U does not domain-match the reach R of the request-host O in the
            origin transaction.
    """
    pass


def join_header_words(lists): # reliably restored by inspect
    """
    Do the inverse (almost) of the conversion done by split_header_words.
    
        Takes a list of lists of (key, value) pairs and produces a single header
        value.  Attribute values are quoted if needed.
    
        >>> join_header_words([[("text/plain", None), ("charset", "iso-8859/1")]])
        'text/plain; charset="iso-8859/1"'
        >>> join_header_words([[("text/plain", None)], [("charset", "iso-8859/1")]])
        'text/plain, charset="iso-8859/1"'
    """
    pass


def liberal_is_HDN(text): # reliably restored by inspect
    """
    Return True if text is a sort-of-like a host domain name.
    
        For accepting/blocking domains.
    """
    pass


def lwp_cookie_str(cookie): # reliably restored by inspect
    """
    Return string representation of Cookie in an the LWP cookie file format.
    
        Actually, the format is extended a bit -- see module docstring.
    """
    pass


def offset_from_tz_string(tz): # reliably restored by inspect
    # no doc
    pass


def parse_ns_headers(ns_headers): # reliably restored by inspect
    """
    Ad-hoc parser for Netscape protocol cookie-attributes.
    
        The old Netscape cookie format for Set-Cookie can for instance contain
        an unquoted "," in the expires field, so we have to use this ad-hoc
        parser instead of split_header_words.
    
        XXX This may not make the best possible effort to parse all the crap
        that Netscape Cookie headers contain.  Ronald Tschalar's HTTPClient
        parser is probably better, so could do worse than following that if
        this ever gives any trouble.
    
        Currently, this is also used for parsing RFC 2109 cookies.
    """
    pass


def reach(h): # reliably restored by inspect
    """
    Return reach of host h, as defined by RFC 2965, section 1.
    
        The reach R of a host name H is defined as follows:
    
           *  If
    
              -  H is the host domain name of a host; and,
    
              -  H has the form A.B; and
    
              -  A has no embedded (that is, interior) dots; and
    
              -  B has at least one embedded dot, or B is the string "local".
                 then the reach of H is .B.
    
           *  Otherwise, the reach of H is H.
    
        >>> reach("www.acme.com")
        '.acme.com'
        >>> reach("acme.com")
        'acme.com'
        >>> reach("acme.local")
        '.local'
    """
    pass


def request_host(request): # reliably restored by inspect
    """
    Return request-host, as defined by RFC 2965.
    
        Variation from RFC: returned value is lowercased, for convenient
        comparison.
    """
    pass


def request_path(request): # reliably restored by inspect
    """ Path component of request-URI, as defined by RFC 2965. """
    pass


def request_port(request): # reliably restored by inspect
    # no doc
    pass


def split_header_words(header_values): # reliably restored by inspect
    """
    Parse header values into a list of lists containing key,value pairs.
    
        The function knows how to deal with ",", ";" and "=" as well as quoted
        values after "=".  A list of space separated tokens are parsed as if they
        were separated by ";".
    
        If the header_values passed as argument contains multiple values, then they
        are treated as if they were a single value separated by comma ",".
    
        This means that this function is useful for parsing header fields that
        follow this syntax (BNF as from the HTTP/1.1 specification, but we relax
        the requirement for tokens).
    
          headers           = #header
          header            = (token | parameter) *( [";"] (token | parameter))
    
          token             = 1*<any CHAR except CTLs or separators>
          separators        = "(" | ")" | "<" | ">" | "@"
                            | "," | ";" | ":" | "\" | <">
                            | "/" | "[" | "]" | "?" | "="
                            | "{" | "}" | SP | HT
    
          quoted-string     = ( <"> *(qdtext | quoted-pair ) <"> )
          qdtext            = <any TEXT except <">>
          quoted-pair       = "\" CHAR
    
          parameter         = attribute "=" value
          attribute         = token
          value             = token | quoted-string
    
        Each header is represented by a list of key/value pairs.  The value for a
        simple token (not part of a parameter) is None.  Syntactically incorrect
        headers will not necessarily be parsed as you would want.
    
        This is easier to describe with some examples:
    
        >>> split_header_words(['foo="bar"; port="80,81"; discard, bar=baz'])
        [[('foo', 'bar'), ('port', '80,81'), ('discard', None)], [('bar', 'baz')]]
        >>> split_header_words(['text/html; charset="iso-8859-1"'])
        [[('text/html', None), ('charset', 'iso-8859-1')]]
        >>> split_header_words([r'Basic realm="\"foo\bar\""'])
        [[('Basic', None), ('realm', '"foobar"')]]
    """
    pass


def time2isoz(t=None): # reliably restored by inspect
    """
    Return a string representing time in seconds since epoch, t.
    
        If the function is called without an argument, it will use the current
        time.
    
        The format of the returned string is like "YYYY-MM-DD hh:mm:ssZ",
        representing Universal Time (UTC, aka GMT).  An example of this format is:
    
        1994-11-24 08:49:37Z
    """
    pass


def time2netscape(t=None): # reliably restored by inspect
    """
    Return a string representing time in seconds since epoch, t.
    
        If the function is called without an argument, it will use the current
        time.
    
        The format of the returned string is like this:
    
        Wed, DD-Mon-YYYY HH:MM:SS GMT
    """
    pass


def timegm(tuple): # reliably restored by inspect
    """ Unrelated but handy function to calculate Unix timestamp from GMT. """
    pass


def unmatched(match): # reliably restored by inspect
    """ Return unmatched part of re.Match object. """
    pass


def uppercase_escaped_char(match): # reliably restored by inspect
    # no doc
    pass


def user_domain_match(A, B): # reliably restored by inspect
    """
    For blocking/accepting domains.
    
        A and B may be host domain names or IP addresses.
    """
    pass


def vals_sorted_by_key(adict): # reliably restored by inspect
    # no doc
    pass


def _debug(*args): # reliably restored by inspect
    # no doc
    pass


def _str2time(day, mon, yr, hr, min, sec, tz): # reliably restored by inspect
    # no doc
    pass


def _strip_quotes(text): # reliably restored by inspect
    # no doc
    pass


def _timegm(tt): # reliably restored by inspect
    # no doc
    pass


def _warn_unhandled_exception(): # reliably restored by inspect
    # no doc
    pass


# classes

class LoadError(IOError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

Absent = None # (!) real value is ''

Cookie = None # (!) real value is ''

CookieJar = None # (!) real value is ''

CookiePolicy = None # (!) real value is ''

cut_port_re = None # (!) real value is ''

DAYS = [
    'Mon',
    'Tue',
    'Wed',
    'Thu',
    'Fri',
    'Sat',
    'Sun',
]

DefaultCookiePolicy = None # (!) real value is ''

ESCAPED_CHAR_RE = None # (!) real value is ''

FileCookieJar = None # (!) real value is ''

HEADER_ESCAPE_RE = None # (!) real value is ''

HEADER_JOIN_ESCAPE_RE = None # (!) real value is ''

HEADER_QUOTED_VALUE_RE = None # (!) real value is ''

HEADER_TOKEN_RE = None # (!) real value is ''

HEADER_VALUE_RE = None # (!) real value is ''

IPV4_RE = None # (!) real value is ''

ISO_DATE_RE = None # (!) real value is ''

LOOSE_HTTP_DATE_RE = None # (!) real value is ''

LWPCookieJar = None # (!) real value is ''

MONTHS = [
    'Jan',
    'Feb',
    'Mar',
    'Apr',
    'May',
    'Jun',
    'Jul',
    'Aug',
    'Sep',
    'Oct',
    'Nov',
    'Dec',
]

MONTHS_LOWER = [
    'jan',
    'feb',
    'mar',
    'apr',
    'may',
    'jun',
    'jul',
    'aug',
    'sep',
    'oct',
    'nov',
    'dec',
]

MozillaCookieJar = None # (!) real value is ''

STRICT_DATE_RE = None # (!) real value is ''

TIMEZONE_RE = None # (!) real value is ''

UTC_ZONES = {
    'GMT': None,
    'UT': None,
    'UTC': None,
    'Z': None,
}

WEEKDAY_RE = None # (!) real value is ''

__all__ = [
    'Cookie',
    'CookieJar',
    'CookiePolicy',
    'DefaultCookiePolicy',
    'FileCookieJar',
    'LWPCookieJar',
    'lwp_cookie_str',
    'LoadError',
    'MozillaCookieJar',
]

