# encoding: utf-8
# module distutils.ccompiler
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/ccompiler.pyo by generator 1.99
"""
distutils.ccompiler

Contains CCompiler, an abstract base class that defines the interface
for the Distutils compiler abstraction model.
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/log.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import sys as sys # <module 'sys' (built-in)>
import sysconfig as _sysconfig # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/sysconfig.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: ccompiler.py 86238 2010-11-06 04:06:18Z eric.araujo $'

# functions

def customize_compiler(compiler): # reliably restored by inspect
    """
    Do any platform-specific customization of a CCompiler instance.
    
        Mainly needed on Unix, so we can plug in the information that
        varies across Unices and is stored in Python's Makefile.
    """
    pass


def execute(func, args, msg=None, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Perform some action that affects the outside world (eg.  by
        writing to the filesystem).  Such actions are special because they
        are disabled by the 'dry_run' flag.  This method takes care of all
        that bureaucracy for you; all you have to do is supply the
        function to call and an argument tuple for it (to embody the
        "external action" being performed), and an optional message to
        print.
    """
    pass


def gen_lib_options(compiler, library_dirs, runtime_library_dirs, libraries): # reliably restored by inspect
    """
    Generate linker options for searching library directories and
        linking with specific libraries.
    
        'libraries' and 'library_dirs' are, respectively, lists of library names
        (not filenames!) and search directories.  Returns a list of command-line
        options suitable for use with some compiler (depending on the two format
        strings passed in).
    """
    pass


def gen_preprocess_options(macros, include_dirs): # reliably restored by inspect
    """
    Generate C pre-processor options (-D, -U, -I) as used by at least
        two types of compilers: the typical Unix compiler and Visual C++.
        'macros' is the usual thing, a list of 1- or 2-tuples, where (name,)
        means undefine (-U) macro 'name', and (name,value) means define (-D)
        macro 'name' to 'value'.  'include_dirs' is just a list of directory
        names to be added to the header file search path (-I).  Returns a list
        of command-line options suitable for either Unix compilers or Visual
        C++.
    """
    pass


def get_default_compiler(osname=None, platform=None): # reliably restored by inspect
    """
    Determine the default compiler to use for the given platform.
    
            osname should be one of the standard Python OS names (i.e. the
            ones returned by os.name) and platform the common value
            returned by sys.platform for the platform in question.
    
            The default values are os.name and sys.platform in case the
            parameters are not given.
    """
    pass


def mkpath(name, mode=511, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Create a directory and any missing ancestor directories.
    
        If the directory already exists (or if 'name' is the empty string, which
        means the current directory, which of course exists), then do nothing.
        Raise DistutilsFileError if unable to create some directory along the way
        (eg. some sub-path exists, but is a file rather than a directory).
        If 'verbose' is true, print a one-line summary of each mkdir to stdout.
        Return the list of directories actually created.
    """
    pass


def move_file(src, dst, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Move a file 'src' to 'dst'.
    
        If 'dst' is a directory, the file will be moved into it with the same
        name; otherwise, 'src' is just renamed to 'dst'.  Return the new
        full name of the file.
    
        Handles cross-device moves on Unix using 'copy_file()'.  What about
        other systems???
    """
    pass


def newer_group(sources, target, missing=None): # reliably restored by inspect
    """
    Return true if 'target' is out-of-date with respect to any file
        listed in 'sources'.
    
        In other words, if 'target' exists and is newer
        than every file in 'sources', return false; otherwise return true.
        'missing' controls what we do when a source file is missing; the
        default ("error") is to blow up with an OSError from inside 'stat()';
        if it is "ignore", we silently drop any missing source files; if it is
        "newer", any missing source files make us assume that 'target' is
        out-of-date (this is handy in "dry-run" mode: it'll make you pretend to
        carry out commands that wouldn't work because inputs are missing, but
        that doesn't matter because you're not actually going to run the
        commands).
    """
    pass


def new_compiler(plat=None, compiler=None, verbose=0, dry_run=0, force=0): # reliably restored by inspect
    """
    Generate an instance of some CCompiler subclass for the supplied
        platform/compiler combination.  'plat' defaults to 'os.name'
        (eg. 'posix', 'nt'), and 'compiler' defaults to the default compiler
        for that platform.  Currently only 'posix' and 'nt' are supported, and
        the default compilers are "traditional Unix interface" (UnixCCompiler
        class) and Visual C++ (MSVCCompiler class).  Note that it's perfectly
        possible to ask for a Unix compiler object under Windows, and a
        Microsoft compiler object under Unix -- if you supply a value for
        'compiler', 'plat' is ignored.
    """
    pass


def show_compilers(): # reliably restored by inspect
    """
    Print list of available compilers (used by the "--help-compiler"
        options to "build", "build_ext", "build_clib").
    """
    pass


def spawn(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Run another program, specified as a command list 'cmd', in a new process.
    
        'cmd' is just the argument list for the new process, ie.
        cmd[0] is the program to run and cmd[1:] are the rest of its arguments.
        There is no way to run a program with a name different from that of its
        executable.
    
        If 'search_path' is true (the default), the system's executable
        search path will be used to find the program; otherwise, cmd[0]
        must be the exact path to the executable.  If 'dry_run' is true,
        the command will not actually be run.
    
        Raise DistutilsExecError if running the program fails in any way; just
        return on success.
    """
    pass


def split_quoted(s): # reliably restored by inspect
    """
    Split a string up according to Unix shell-like rules for quotes and
        backslashes.  In short: words are delimited by spaces, as long as those
        spaces are not escaped by a backslash, or inside a quoted string.
        Single and double quotes are equivalent, and the quote characters can
        be backslash-escaped.  The backslash is stripped from any two-character
        escape sequence, leaving only the escaped character.  The quote
        characters are stripped from any quoted string.  Returns a list of
        words.
    """
    pass


# classes

class CompileError(__distutils_errors.CCompilerError):
    """ Failure to compile one or more C/C++ source files. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsModuleError(__distutils_errors.DistutilsError):
    """
    Unable to load an expected module, or to find an expected class
        within some module (in particular, command modules and classes).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsPlatformError(__distutils_errors.DistutilsError):
    """
    We don't know how to do something on the current platform (but
        we do know how to do it on some platform) -- eg. trying to compile
        C files on a platform not supported by a CCompiler subclass.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class LinkError(__distutils_errors.CCompilerError):
    """
    Failure to link one or more C/C++ object files into an executable
        or shared library file.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnknownFileError(__distutils_errors.CCompilerError):
    """ Attempt to process an unknown file type. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

CCompiler = None # (!) real value is ''

compiler_class = {
    'bcpp': (
        'bcppcompiler',
        'BCPPCompiler',
        'Borland C++ Compiler',
    ),
    'cygwin': (
        'cygwinccompiler',
        'CygwinCCompiler',
        'Cygwin port of GNU C Compiler for Win32',
    ),
    'emx': (
        'emxccompiler',
        'EMXCCompiler',
        'EMX port of GNU C Compiler for OS/2',
    ),
    'mingw32': (
        'cygwinccompiler',
        'Mingw32CCompiler',
        'Mingw32 port of GNU C Compiler for Win32',
    ),
    'msvc': (
        'msvccompiler',
        'MSVCCompiler',
        'Microsoft Visual C++',
    ),
    'unix': (
        'unixccompiler',
        'UnixCCompiler',
        'standard UNIX-style compiler',
    ),
}

_default_compilers = (
    (
        'cygwin.*',
        'unix',
    ),
    (
        'os2emx',
        'emx',
    ),
    (
        'posix',
        'unix',
    ),
    (
        'nt',
        'msvc',
    ),
)

