# encoding: utf-8
# module distutils.dir_util
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/dir_util.pyo by generator 1.99
"""
distutils.dir_util

Utility functions for manipulating directories and directory trees.
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/log.pyc
import errno as errno # <module 'errno' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: dir_util.py 86609 2010-11-20 20:02:41Z eric.araujo $'

# functions

def copy_tree(src, dst, preserve_mode=1, preserve_times=1, preserve_symlinks=0, update=0, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Copy an entire directory tree 'src' to a new location 'dst'.
    
        Both 'src' and 'dst' must be directory names.  If 'src' is not a
        directory, raise DistutilsFileError.  If 'dst' does not exist, it is
        created with 'mkpath()'.  The end result of the copy is that every
        file in 'src' is copied to 'dst', and directories under 'src' are
        recursively copied to 'dst'.  Return the list of files that were
        copied or might have been copied, using their output name.  The
        return value is unaffected by 'update' or 'dry_run': it is simply
        the list of all files under 'src', with the names changed to be
        under 'dst'.
    
        'preserve_mode' and 'preserve_times' are the same as for
        'copy_file'; note that they only apply to regular files, not to
        directories.  If 'preserve_symlinks' is true, symlinks will be
        copied as symlinks (on platforms that support them!); otherwise
        (the default), the destination of the symlink will be copied.
        'update' and 'verbose' are the same as for 'copy_file'.
    """
    pass


def create_tree(base_dir, files, mode=511, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Create all the empty directories under 'base_dir' needed to put 'files'
        there.
    
        'base_dir' is just the a name of a directory which doesn't necessarily
        exist yet; 'files' is a list of filenames to be interpreted relative to
        'base_dir'.  'base_dir' + the directory portion of every file in 'files'
        will be created if it doesn't already exist.  'mode', 'verbose' and
        'dry_run' flags are as for 'mkpath()'.
    """
    pass


def ensure_relative(path): # reliably restored by inspect
    """
    Take the full path 'path', and make it a relative path.
    
        This is useful to make 'path' the second argument to os.path.join().
    """
    pass


def mkpath(name, mode=511, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Create a directory and any missing ancestor directories.
    
        If the directory already exists (or if 'name' is the empty string, which
        means the current directory, which of course exists), then do nothing.
        Raise DistutilsFileError if unable to create some directory along the way
        (eg. some sub-path exists, but is a file rather than a directory).
        If 'verbose' is true, print a one-line summary of each mkdir to stdout.
        Return the list of directories actually created.
    """
    pass


def remove_tree(directory, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Recursively remove an entire directory tree.
    
        Any errors are ignored (apart from being reported to stdout if 'verbose'
        is true).
    """
    pass


def _build_cmdtuple(path, cmdtuples): # reliably restored by inspect
    """ Helper for remove_tree(). """
    pass


# classes

class DistutilsFileError(__distutils_errors.DistutilsError):
    """
    Any problems in the filesystem: expected file not found, etc.
        Typically this is for problems that we detect before IOError or
        OSError could be raised.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsInternalError(__distutils_errors.DistutilsError):
    """
    Internal inconsistencies or impossibilities (obviously, this
        should never be seen if the code is working!).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

_path_created = {}

