# encoding: utf-8
# module distutils.emxccompiler
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/emxccompiler.pyo by generator 1.99
"""
distutils.emxccompiler

Provides the EMXCCompiler class, a subclass of UnixCCompiler that
handles the EMX port of the GNU C compiler to OS/2.
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/log.pyc
import sys as sys # <module 'sys' (built-in)>
import copy as copy # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/copy.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

CONFIG_H_NOTOK = 'not ok'
CONFIG_H_OK = 'ok'
CONFIG_H_UNCERTAIN = 'uncertain'

__revision__ = '$Id: emxccompiler.py 86238 2010-11-06 04:06:18Z eric.araujo $'

# functions

def check_config_h(): # reliably restored by inspect
    """
    Check if the current Python installation (specifically, pyconfig.h)
        appears amenable to building extensions with GCC.  Returns a tuple
        (status, details), where 'status' is one of the following constants:
          CONFIG_H_OK
            all is well, go ahead and compile
          CONFIG_H_NOTOK
            doesn't look good
          CONFIG_H_UNCERTAIN
            not sure -- unable to read pyconfig.h
        'details' is a human-readable string explaining the situation.
    
        Note there are two ways to conclude "OK": either 'sys.version' contains
        the string "GCC" (implying that this Python was built with GCC), or the
        installed "pyconfig.h" contains the string "__GNUC__".
    """
    pass


def gen_lib_options(compiler, library_dirs, runtime_library_dirs, libraries): # reliably restored by inspect
    """
    Generate linker options for searching library directories and
        linking with specific libraries.
    
        'libraries' and 'library_dirs' are, respectively, lists of library names
        (not filenames!) and search directories.  Returns a list of command-line
        options suitable for use with some compiler (depending on the two format
        strings passed in).
    """
    pass


def gen_preprocess_options(macros, include_dirs): # reliably restored by inspect
    """
    Generate C pre-processor options (-D, -U, -I) as used by at least
        two types of compilers: the typical Unix compiler and Visual C++.
        'macros' is the usual thing, a list of 1- or 2-tuples, where (name,)
        means undefine (-U) macro 'name', and (name,value) means define (-D)
        macro 'name' to 'value'.  'include_dirs' is just a list of directory
        names to be added to the header file search path (-I).  Returns a list
        of command-line options suitable for either Unix compilers or Visual
        C++.
    """
    pass


def get_versions(): # reliably restored by inspect
    """
    Try to find out the versions of gcc and ld.
            If not possible it returns None for it.
    """
    pass


def write_file(filename, contents): # reliably restored by inspect
    """
    Create a file with the specified name and write 'contents' (a
        sequence of strings without line terminators) to it.
    """
    pass


# classes

class CompileError(__distutils_errors.CCompilerError):
    """ Failure to compile one or more C/C++ source files. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsExecError(__distutils_errors.DistutilsError):
    """
    Any problems executing an external program (such as the C
        compiler, when compiling C files).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnknownFileError(__distutils_errors.CCompilerError):
    """ Attempt to process an unknown file type. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

EMXCCompiler = None # (!) real value is ''

UnixCCompiler = None # (!) real value is ''

