# encoding: utf-8
# module doctest
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/doctest.pyo by generator 1.99
"""
Module doctest -- a framework for running examples in docstrings.

In simplest use, end each module M to be tested with:

def _test():
    import doctest
    doctest.testmod()

if __name__ == "__main__":
    _test()

Then running the module as a script will cause the examples in the
docstrings to get executed and verified:

python M.py

This won't display anything unless an example fails, in which case the
failing example(s) and the cause(s) of the failure(s) are printed to stdout
(why not stderr? because stderr is a lame hack <0.2 wink>), and the final
line of output is "Test failed.".

Run it with the -v switch instead:

python M.py -v

and a detailed report of all examples tried is printed to stdout, along
with assorted summaries at the end.

You can force verbose mode by passing "verbose=True" to testmod, or prohibit
it by passing "verbose=False".  In either of those cases, sys.argv is not
examined by testmod.

There are a variety of other ways to run doctests, including integration
with the unittest framework, and support for running non-Python text
files containing doctests.  There are also many ways to override parts
of doctest's default behaviors.  See the Library Reference Manual for
details.
"""

# imports
import __future__ as __future__ # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/__future__.pyc
import unittest as unittest # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/unittest/__init__.pyc
import tempfile as tempfile # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/tempfile.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import inspect as inspect # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/inspect.pyc
import sys as sys # <module 'sys' (built-in)>
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/traceback.pyc
import difflib as difflib # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/difflib.pyc
import linecache as linecache # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/linecache.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import pdb as pdb # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/pdb.pyc
import unittest.case as __unittest_case


# Variables with simple values

BLANKLINE_MARKER = '<BLANKLINE>'

COMPARISON_FLAGS = 63

DONT_ACCEPT_BLANKLINE = 2

DONT_ACCEPT_TRUE_FOR_1 = 1

ELLIPSIS = 8

ELLIPSIS_MARKER = '...'

IGNORE_EXCEPTION_DETAIL = 32

master = None

NORMALIZE_WHITESPACE = 4

REPORTING_FLAGS = 960

REPORT_CDIFF = 128
REPORT_NDIFF = 256

REPORT_ONLY_FIRST_FAILURE = 512

REPORT_UDIFF = 64

SKIP = 16

_encoding = 'utf-8'

_unittest_reportflags = 0

__docformat__ = 'reStructuredText en'

# functions

def debug(module, name, pm=False): # reliably restored by inspect
    """
    Debug a single doctest docstring.
    
        Provide the module (or dotted name of the module) containing the
        test to be debugged and the name (within the module) of the object
        with the docstring with tests to be debugged.
    """
    pass


def debug_script(src, pm=False, globs=None): # reliably restored by inspect
    """ Debug a test script.  `src` is the script, as a string. """
    pass


def debug_src(src, pm=False, globs=None): # reliably restored by inspect
    """ Debug a single doctest docstring, in argument `src`' """
    pass


def DocFileSuite(*paths, **kw): # reliably restored by inspect
    """
    A unittest suite for one or more doctest files.
    
        The path to each doctest file is given as a string; the
        interpretation of that string depends on the keyword argument
        "module_relative".
    
        A number of options may be provided as keyword arguments:
    
        module_relative
          If "module_relative" is True, then the given file paths are
          interpreted as os-independent module-relative paths.  By
          default, these paths are relative to the calling module's
          directory; but if the "package" argument is specified, then
          they are relative to that package.  To ensure os-independence,
          "filename" should use "/" characters to separate path
          segments, and may not be an absolute path (i.e., it may not
          begin with "/").
    
          If "module_relative" is False, then the given file paths are
          interpreted as os-specific paths.  These paths may be absolute
          or relative (to the current working directory).
    
        package
          A Python package or the name of a Python package whose directory
          should be used as the base directory for module relative paths.
          If "package" is not specified, then the calling module's
          directory is used as the base directory for module relative
          filenames.  It is an error to specify "package" if
          "module_relative" is False.
    
        setUp
          A set-up function.  This is called before running the
          tests in each file. The setUp function will be passed a DocTest
          object.  The setUp function can access the test globals as the
          globs attribute of the test passed.
    
        tearDown
          A tear-down function.  This is called after running the
          tests in each file.  The tearDown function will be passed a DocTest
          object.  The tearDown function can access the test globals as the
          globs attribute of the test passed.
    
        globs
          A dictionary containing initial global variables for the tests.
    
        optionflags
          A set of doctest option flags expressed as an integer.
    
        parser
          A DocTestParser (or subclass) that should be used to extract
          tests from the files.
    
        encoding
          An encoding that will be used to convert the files to unicode.
    """
    pass


def DocFileTest(path, module_relative=True, package=None, globs=None, parser='<doctest.DocTestParser instance at 0x108ab6170>', encoding=None, **options): # reliably restored by inspect
    # no doc
    pass


def DocTestSuite(module=None, globs=None, extraglobs=None, test_finder=None, **options): # reliably restored by inspect
    """
    Convert doctest tests for a module to a unittest test suite.
    
        This converts each documentation string in a module that
        contains doctest tests to a unittest test case.  If any of the
        tests in a doc string fail, then the test case fails.  An exception
        is raised showing the name of the file containing the test and a
        (sometimes approximate) line number.
    
        The `module` argument provides the module to be tested.  The argument
        can be either a module or a module name.
    
        If no argument is given, the calling module is used.
    
        A number of options may be provided as keyword arguments:
    
        setUp
          A set-up function.  This is called before running the
          tests in each file. The setUp function will be passed a DocTest
          object.  The setUp function can access the test globals as the
          globs attribute of the test passed.
    
        tearDown
          A tear-down function.  This is called after running the
          tests in each file.  The tearDown function will be passed a DocTest
          object.  The tearDown function can access the test globals as the
          globs attribute of the test passed.
    
        globs
          A dictionary containing initial global variables for the tests.
    
        optionflags
           A set of doctest option flags expressed as an integer.
    """
    pass


def namedtuple(typename, field_names, verbose=False, rename=False): # reliably restored by inspect
    """
    Returns a new subclass of tuple with named fields.
    
        >>> Point = namedtuple('Point', 'x y')
        >>> Point.__doc__                   # docstring for the new class
        'Point(x, y)'
        >>> p = Point(11, y=22)             # instantiate with positional args or keywords
        >>> p[0] + p[1]                     # indexable like a plain tuple
        33
        >>> x, y = p                        # unpack like a regular tuple
        >>> x, y
        (11, 22)
        >>> p.x + p.y                       # fields also accessable by name
        33
        >>> d = p._asdict()                 # convert to a dictionary
        >>> d['x']
        11
        >>> Point(**d)                      # convert from a dictionary
        Point(x=11, y=22)
        >>> p._replace(x=100)               # _replace() is like str.replace() but targets named fields
        Point(x=100, y=22)
    """
    pass


def register_optionflag(name): # reliably restored by inspect
    # no doc
    pass


def run_docstring_examples(f, globs, verbose=False, name=None, compileflags=None, optionflags=0): # reliably restored by inspect
    """
    Test examples in the given object's docstring (`f`), using `globs`
        as globals.  Optional argument `name` is used in failure messages.
        If the optional argument `verbose` is true, then generate output
        even if there are no failures.
    
        `compileflags` gives the set of flags that should be used by the
        Python compiler when running the examples.  If not specified, then
        it will default to the set of future-import flags that apply to
        `globs`.
    
        Optional keyword arg `optionflags` specifies options for the
        testing and output.  See the documentation for `testmod` for more
        information.
    """
    pass


def script_from_examples(s): # reliably restored by inspect
    """
    Extract script from text with examples.
    
           Converts text with examples to a Python script.  Example input is
           converted to regular code.  Example output and all other words
           are converted to comments:
    
           >>> text = '''
           ...       Here are examples of simple math.
           ...
           ...           Python has super accurate integer addition
           ...
           ...           >>> 2 + 2
           ...           5
           ...
           ...           And very friendly error messages:
           ...
           ...           >>> 1/0
           ...           To Infinity
           ...           And
           ...           Beyond
           ...
           ...           You can use logic if you want:
           ...
           ...           >>> if 0:
           ...           ...    blah
           ...           ...    blah
           ...           ...
           ...
           ...           Ho hum
           ...           '''
    
           >>> print script_from_examples(text)
           # Here are examples of simple math.
           #
           #     Python has super accurate integer addition
           #
           2 + 2
           # Expected:
           ## 5
           #
           #     And very friendly error messages:
           #
           1/0
           # Expected:
           ## To Infinity
           ## And
           ## Beyond
           #
           #     You can use logic if you want:
           #
           if 0:
              blah
              blah
           #
           #     Ho hum
           <BLANKLINE>
    """
    pass


def set_unittest_reportflags(flags): # reliably restored by inspect
    """
    Sets the unittest option flags.
    
        The old flag is returned so that a runner could restore the old
        value if it wished to:
    
          >>> import doctest
          >>> old = doctest._unittest_reportflags
          >>> doctest.set_unittest_reportflags(REPORT_NDIFF |
          ...                          REPORT_ONLY_FIRST_FAILURE) == old
          True
    
          >>> doctest._unittest_reportflags == (REPORT_NDIFF |
          ...                                   REPORT_ONLY_FIRST_FAILURE)
          True
    
        Only reporting flags can be set:
    
          >>> doctest.set_unittest_reportflags(ELLIPSIS)
          Traceback (most recent call last):
          ...
          ValueError: ('Only reporting flags allowed', 8)
    
          >>> doctest.set_unittest_reportflags(old) == (REPORT_NDIFF |
          ...                                   REPORT_ONLY_FIRST_FAILURE)
          True
    """
    pass


def testfile(filename, module_relative=True, name=None, package=None, globs=None, verbose=None, report=True, optionflags=0, extraglobs=None, raise_on_error=False, parser='<doctest.DocTestParser instance at 0x108ab6320>', encoding=None): # reliably restored by inspect
    """
    Test examples in the given file.  Return (#failures, #tests).
    
        Optional keyword arg "module_relative" specifies how filenames
        should be interpreted:
    
          - If "module_relative" is True (the default), then "filename"
             specifies a module-relative path.  By default, this path is
             relative to the calling module's directory; but if the
             "package" argument is specified, then it is relative to that
             package.  To ensure os-independence, "filename" should use
             "/" characters to separate path segments, and should not
             be an absolute path (i.e., it may not begin with "/").
    
          - If "module_relative" is False, then "filename" specifies an
            os-specific path.  The path may be absolute or relative (to
            the current working directory).
    
        Optional keyword arg "name" gives the name of the test; by default
        use the file's basename.
    
        Optional keyword argument "package" is a Python package or the
        name of a Python package whose directory should be used as the
        base directory for a module relative filename.  If no package is
        specified, then the calling module's directory is used as the base
        directory for module relative filenames.  It is an error to
        specify "package" if "module_relative" is False.
    
        Optional keyword arg "globs" gives a dict to be used as the globals
        when executing examples; by default, use {}.  A copy of this dict
        is actually used for each docstring, so that each docstring's
        examples start with a clean slate.
    
        Optional keyword arg "extraglobs" gives a dictionary that should be
        merged into the globals that are used to execute examples.  By
        default, no extra globals are used.
    
        Optional keyword arg "verbose" prints lots of stuff if true, prints
        only failures if false; by default, it's true iff "-v" is in sys.argv.
    
        Optional keyword arg "report" prints a summary at the end when true,
        else prints nothing at the end.  In verbose mode, the summary is
        detailed, else very brief (in fact, empty if all tests passed).
    
        Optional keyword arg "optionflags" or's together module constants,
        and defaults to 0.  Possible values (see the docs for details):
    
            DONT_ACCEPT_TRUE_FOR_1
            DONT_ACCEPT_BLANKLINE
            NORMALIZE_WHITESPACE
            ELLIPSIS
            SKIP
            IGNORE_EXCEPTION_DETAIL
            REPORT_UDIFF
            REPORT_CDIFF
            REPORT_NDIFF
            REPORT_ONLY_FIRST_FAILURE
    
        Optional keyword arg "raise_on_error" raises an exception on the
        first unexpected exception or failure. This allows failures to be
        post-mortem debugged.
    
        Optional keyword arg "parser" specifies a DocTestParser (or
        subclass) that should be used to extract tests from the files.
    
        Optional keyword arg "encoding" specifies an encoding that should
        be used to convert the file to unicode.
    
        Advanced tomfoolery:  testmod runs methods of a local instance of
        class doctest.Tester, then merges the results into (or creates)
        global Tester instance doctest.master.  Methods of doctest.master
        can be called directly too, if you want to do something unusual.
        Passing report=0 to testmod is especially useful then, to delay
        displaying a summary.  Invoke doctest.master.summarize(verbose)
        when you're done fiddling.
    """
    pass


def testmod(m=None, name=None, globs=None, verbose=None, report=True, optionflags=0, extraglobs=None, raise_on_error=False, exclude_empty=False): # reliably restored by inspect
    """
    m=None, name=None, globs=None, verbose=None, report=True,
           optionflags=0, extraglobs=None, raise_on_error=False,
           exclude_empty=False
    
        Test examples in docstrings in functions and classes reachable
        from module m (or the current module if m is not supplied), starting
        with m.__doc__.
    
        Also test examples reachable from dict m.__test__ if it exists and is
        not None.  m.__test__ maps names to functions, classes and strings;
        function and class docstrings are tested even if the name is private;
        strings are tested directly, as if they were docstrings.
    
        Return (#failures, #tests).
    
        See help(doctest) for an overview.
    
        Optional keyword arg "name" gives the name of the module; by default
        use m.__name__.
    
        Optional keyword arg "globs" gives a dict to be used as the globals
        when executing examples; by default, use m.__dict__.  A copy of this
        dict is actually used for each docstring, so that each docstring's
        examples start with a clean slate.
    
        Optional keyword arg "extraglobs" gives a dictionary that should be
        merged into the globals that are used to execute examples.  By
        default, no extra globals are used.  This is new in 2.4.
    
        Optional keyword arg "verbose" prints lots of stuff if true, prints
        only failures if false; by default, it's true iff "-v" is in sys.argv.
    
        Optional keyword arg "report" prints a summary at the end when true,
        else prints nothing at the end.  In verbose mode, the summary is
        detailed, else very brief (in fact, empty if all tests passed).
    
        Optional keyword arg "optionflags" or's together module constants,
        and defaults to 0.  This is new in 2.3.  Possible values (see the
        docs for details):
    
            DONT_ACCEPT_TRUE_FOR_1
            DONT_ACCEPT_BLANKLINE
            NORMALIZE_WHITESPACE
            ELLIPSIS
            SKIP
            IGNORE_EXCEPTION_DETAIL
            REPORT_UDIFF
            REPORT_CDIFF
            REPORT_NDIFF
            REPORT_ONLY_FIRST_FAILURE
    
        Optional keyword arg "raise_on_error" raises an exception on the
        first unexpected exception or failure. This allows failures to be
        post-mortem debugged.
    
        Advanced tomfoolery:  testmod runs methods of a local instance of
        class doctest.Tester, then merges the results into (or creates)
        global Tester instance doctest.master.  Methods of doctest.master
        can be called directly too, if you want to do something unusual.
        Passing report=0 to testmod is especially useful then, to delay
        displaying a summary.  Invoke doctest.master.summarize(verbose)
        when you're done fiddling.
    """
    pass


def testsource(module, name): # reliably restored by inspect
    """
    Extract the test sources from a doctest docstring as a script.
    
        Provide the module (or dotted name of the module) containing the
        test to be debugged and the name (within the module) of the object
        with the doc string with tests to be debugged.
    """
    pass


def _comment_line(line): # reliably restored by inspect
    """ Return a commented form of the given line """
    pass


def _ellipsis_match(want, got): # reliably restored by inspect
    """
    Essentially the only subtle case:
        >>> _ellipsis_match('aa...aa', 'aaa')
        False
    """
    pass


def _exception_traceback(exc_info): # reliably restored by inspect
    """
    Return a string containing a traceback message for the given
        exc_info tuple (as returned by sys.exc_info()).
    """
    pass


def _extract_future_flags(globs): # reliably restored by inspect
    """
    Return the compiler-flags associated with the future features that
        have been imported into the given namespace (globs).
    """
    pass


def _indent(s, indent=4): # reliably restored by inspect
    """
    Add the given number of space characters to the beginning of
        every non-blank line in `s`, and return the result.
        If the string `s` is Unicode, it is encoded using the stdout
        encoding and the `backslashreplace` error handler.
    """
    pass


def _load_testfile(filename, package, module_relative): # reliably restored by inspect
    # no doc
    pass


def _module_relative_path(module, path): # reliably restored by inspect
    # no doc
    pass


def _normalize_module(module, depth=2): # reliably restored by inspect
    """
    Return the module specified by `module`.  In particular:
          - If `module` is a module, then return module.
          - If `module` is a string, then import and return the
            module with that name.
          - If `module` is None, then return the calling module.
            The calling module is assumed to be the module of
            the stack frame at the given depth in the call stack.
    """
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# classes

class DocTestCase(__unittest_case.TestCase):
    # no doc
    def debug(self): # real signature unknown; restored from __doc__
        """
        Run the test case without results and without catching exceptions
        
                   The unit test framework includes a debug method on test cases
                   and test suites to support post-mortem debugging.  The test code
                   is run in such a way that errors are not caught.  This way a
                   caller can catch the errors and initiate post-mortem debugging.
        
                   The DocTestCase provides a debug method that raises
                   UnexpectedException errors if there is an unexepcted
                   exception:
        
                     >>> test = DocTestParser().get_doctest('>>> raise KeyError\n42',
                     ...                {}, 'foo', 'foo.py', 0)
                     >>> case = DocTestCase(test)
                     >>> try:
                     ...     case.debug()
                     ... except UnexpectedException, failure:
                     ...     pass
        
                   The UnexpectedException contains the test, the example, and
                   the original exception:
        
                     >>> failure.test is test
                     True
        
                     >>> failure.example.want
                     '42\n'
        
                     >>> exc_info = failure.exc_info
                     >>> raise exc_info[0], exc_info[1], exc_info[2]
                     Traceback (most recent call last):
                     ...
                     KeyError
        
                   If the output doesn't match, then a DocTestFailure is raised:
        
                     >>> test = DocTestParser().get_doctest('''
                     ...      >>> x = 1
                     ...      >>> x
                     ...      2
                     ...      ''', {}, 'foo', 'foo.py', 0)
                     >>> case = DocTestCase(test)
        
                     >>> try:
                     ...    case.debug()
                     ... except DocTestFailure, failure:
                     ...    pass
        
                   DocTestFailure objects provide access to the test:
        
                     >>> failure.test is test
                     True
        
                   As well as to the example:
        
                     >>> failure.example.want
                     '2\n'
        
                   and the actual output:
        
                     >>> failure.got
                     '1\n'
        """
        pass

    def format_failure(self, *args, **kwargs): # real signature unknown
        pass

    def id(self, *args, **kwargs): # real signature unknown
        pass

    def runTest(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class DocFileCase(DocTestCase):
    # no doc
    def format_failure(self, *args, **kwargs): # real signature unknown
        pass

    def id(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class DocTestFailure(Exception):
    """
    A DocTest example has failed in debugging mode.
    
        The exception instance has variables:
    
        - test: the DocTest object being run
    
        - example: the Example object that failed
    
        - got: the actual output
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class SkipDocTestCase(DocTestCase):
    # no doc
    def setUp(self, *args, **kwargs): # real signature unknown
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        pass

    def test_skip(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class TestResults(tuple):
    """ TestResults(failed, attempted) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new TestResults object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new TestResults object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, failed, attempted): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, failed, attempted): # reliably restored by inspect
        """ Create new instance of TestResults(failed, attempted) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    attempted = property(lambda self: object()) # default
    failed = property(lambda self: object()) # default

    _fields = (
        'failed',
        'attempted',
    )
    __slots__ = ()


class UnexpectedException(Exception):
    """
    A DocTest example has encountered an unexpected exception
    
        The exception instance has variables:
    
        - test: the DocTest object being run
    
        - example: the Example object that failed
    
        - exc_info: the exception info
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

DebugRunner = None # (!) real value is ''

DocTest = None # (!) real value is ''

DocTestFinder = None # (!) real value is ''

DocTestParser = None # (!) real value is ''

DocTestRunner = None # (!) real value is ''

Example = None # (!) real value is ''

OPTIONFLAGS_BY_NAME = {
    'DONT_ACCEPT_BLANKLINE': 2,
    'DONT_ACCEPT_TRUE_FOR_1': 1,
    'ELLIPSIS': 8,
    'IGNORE_EXCEPTION_DETAIL': 32,
    'NORMALIZE_WHITESPACE': 4,
    'REPORT_CDIFF': 128,
    'REPORT_NDIFF': 256,
    'REPORT_ONLY_FIRST_FAILURE': 512,
    'REPORT_UDIFF': 64,
    'SKIP': 16,
}

OutputChecker = None # (!) real value is ''

StringIO = None # (!) real value is ''

Tester = None # (!) real value is ''

_OutputRedirectingPdb = None # (!) real value is ''

_SpoofOut = None # (!) real value is ''

_TestClass = None # (!) real value is ''

__all__ = [
    'register_optionflag',
    'DONT_ACCEPT_TRUE_FOR_1',
    'DONT_ACCEPT_BLANKLINE',
    'NORMALIZE_WHITESPACE',
    'ELLIPSIS',
    'SKIP',
    'IGNORE_EXCEPTION_DETAIL',
    'COMPARISON_FLAGS',
    'REPORT_UDIFF',
    'REPORT_CDIFF',
    'REPORT_NDIFF',
    'REPORT_ONLY_FIRST_FAILURE',
    'REPORTING_FLAGS',
    'Example',
    'DocTest',
    'DocTestParser',
    'DocTestFinder',
    'DocTestRunner',
    'OutputChecker',
    'DocTestFailure',
    'UnexpectedException',
    'DebugRunner',
    'testmod',
    'testfile',
    'run_docstring_examples',
    'Tester',
    'DocTestSuite',
    'DocFileSuite',
    'set_unittest_reportflags',
    'script_from_examples',
    'testsource',
    'debug_src',
    'debug',
]

__test__ = {
    '_TestClass': _TestClass,
    'blank lines': "\n                Blank lines can be marked with <BLANKLINE>:\n                    >>> print 'foo\\n\\nbar\\n'\n                    foo\n                    <BLANKLINE>\n                    bar\n                    <BLANKLINE>\n            ",
    'bool-int equivalence': '\n                                    In 2.2, boolean expressions displayed\n                                    0 or 1.  By default, we still accept\n                                    them.  This can be disabled by passing\n                                    DONT_ACCEPT_TRUE_FOR_1 to the new\n                                    optionflags argument.\n                                    >>> 4 == 4\n                                    1\n                                    >>> 4 == 4\n                                    True\n                                    >>> 4 > 4\n                                    0\n                                    >>> 4 > 4\n                                    False\n                                    ',
    'ellipsis': "\n                If the ellipsis flag is used, then '...' can be used to\n                elide substrings in the desired output:\n                    >>> print range(1000) #doctest: +ELLIPSIS\n                    [0, 1, 2, ..., 999]\n            ",
    'string': '\n                      Example of a string object, searched as-is.\n                      >>> x = 1; y = 2\n                      >>> x + y, x * y\n                      (3, 2)\n                      ',
    'whitespace normalization': '\n                If the whitespace normalization flag is used, then\n                differences in whitespace are ignored.\n                    >>> print range(30) #doctest: +NORMALIZE_WHITESPACE\n                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,\n                     15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,\n                     27, 28, 29]\n            ',
}

