# encoding: utf-8
# module dummy_thread
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/dummy_thread.pyo by generator 1.99
"""
Drop-in replacement for the thread module.

Meant to be used as a brain-dead substitute so that threaded code does
not need to be rewritten for when the thread module is not present.

Suggested usage is::

    try:
        import thread
    except ImportError:
        import dummy_thread as thread
"""

# imports
import traceback as _traceback # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/traceback.pyc

# Variables with simple values

_interrupt = False

_main = True

# functions

def allocate_lock(): # reliably restored by inspect
    """ Dummy implementation of thread.allocate_lock(). """
    pass


def exit(): # reliably restored by inspect
    """ Dummy implementation of thread.exit(). """
    pass


def get_ident(): # reliably restored by inspect
    """
    Dummy implementation of thread.get_ident().
    
        Since this module should only be used when threadmodule is not
        available, it is safe to assume that the current process is the
        only thread.  Thus a constant can be safely returned.
    """
    pass


def interrupt_main(): # reliably restored by inspect
    """
    Set _interrupt flag to True to have start_new_thread raise
        KeyboardInterrupt upon exiting.
    """
    pass


def stack_size(size=None): # reliably restored by inspect
    """ Dummy implementation of thread.stack_size(). """
    pass


def start_new_thread(function, args, kwargs='{}'): # reliably restored by inspect
    """
    Dummy implementation of thread.start_new_thread().
    
        Compatibility is maintained by making sure that ``args`` is a
        tuple and ``kwargs`` is a dictionary.  If an exception is raised
        and it is SystemExit (which can be done by thread.exit()) it is
        caught and nothing is done; all other exceptions are printed out
        by using traceback.print_exc().
    
        If the executed function calls interrupt_main the KeyboardInterrupt will be
        raised when the function returns.
    """
    pass


# classes

class error(Exception):
    """ Dummy implementation of thread.error. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class LockType(object):
    """
    Class implementing dummy implementation of thread.LockType.
    
        Compatibility is maintained by maintaining self.locked_status
        which is a boolean that stores the state of the lock.  Pickling of
        the lock, though, should not be done since if the thread module is
        then used with an unpickled ``lock()`` from here problems could
        occur from this class not having atomic methods.
    """
    def acquire(self): # real signature unknown; restored from __doc__
        """
        Dummy implementation of acquire().
        
                For blocking calls, self.locked_status is automatically set to
                True and returned appropriately based on value of
                ``waitflag``.  If it is non-blocking, then the value is
                actually checked and not set if it is already acquired.  This
                is all done so that threading.Condition's assert statements
                aren't triggered and throw a little fit.
        """
        pass

    def locked(self, *args, **kwargs): # real signature unknown
        pass

    def release(self, *args, **kwargs): # real signature unknown
        """ Release the dummy lock. """
        pass

    def __enter__(self, *args, **kwargs): # real signature unknown
        """
        Dummy implementation of acquire().
        
                For blocking calls, self.locked_status is automatically set to
                True and returned appropriately based on value of
                ``waitflag``.  If it is non-blocking, then the value is
                actually checked and not set if it is already acquired.  This
                is all done so that threading.Condition's assert statements
                aren't triggered and throw a little fit.
        """
        pass

    def __exit__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

__all__ = [
    'error',
    'start_new_thread',
    'exit',
    'get_ident',
    'allocate_lock',
    'interrupt_main',
    'LockType',
]

