# encoding: utf-8
# module email.errors
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/email/errors.pyo by generator 1.99
""" email package exception classes. """
# no imports

# no functions
# classes

class MessageError(Exception):
    """ Base class for errors in the email package. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class MessageParseError(MessageError):
    """ Base class for message parsing errors. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class BoundaryError(MessageParseError):
    """ Couldn't find terminating boundary. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class CharsetError(MessageError):
    """ An illegal charset was given. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class HeaderParseError(MessageParseError):
    """ Error while parsing headers. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class MultipartConversionError(MessageError, TypeError):
    """ Conversion to a multipart is prohibited. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

FirstHeaderLineIsContinuationDefect = None # (!) real value is ''

MalformedHeaderDefect = None # (!) real value is ''

MessageDefect = None # (!) real value is ''

MisplacedEnvelopeHeaderDefect = None # (!) real value is ''

MultipartInvariantViolationDefect = None # (!) real value is ''

NoBoundaryInMultipartDefect = None # (!) real value is ''

StartBoundaryNotFoundDefect = None # (!) real value is ''

