# encoding: utf-8
# module email.feedparser
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/email/feedparser.pyo by generator 1.99
"""
FeedParser - An email feed parser.

The feed parser implements an interface for incrementally parsing an email
message, line by line.  This has advantages for certain applications, such as
those reading email messages off a socket.

FeedParser.feed() is the primary interface for pushing new data into the
parser.  It returns when there's nothing more it can do with the available
data.  When you have no more data to push into the parser, call .close().
This completes the parsing and returns the root message object.

The other advantage of this parser is that it will never throw a parsing
exception.  Instead, when it finds something unexpected, it adds a 'defect' to
the current message.  Defects are just instances that live on the message
object's .defects attribute.
"""

# imports
import email.errors as errors # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/email/errors.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import email.message as message # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/email/message.pyc

# Variables with simple values

EMPTYSTRING = ''

NL = '\n'

# no functions
# classes

class BufferedSubFile(object):
    """
    A file-ish object that can have new data loaded into it.
    
        You can also push and pop line-matching predicates onto a stack.  When the
        current predicate matches the current line, a false EOF response
        (i.e. empty string) is returned instead.  This lets the parser adhere to a
        simple abstraction -- it parses until EOF closes the current message.
    """
    def close(self, *args, **kwargs): # real signature unknown
        pass

    def is_closed(self, *args, **kwargs): # real signature unknown
        pass

    def next(self, *args, **kwargs): # real signature unknown
        pass

    def pop_eof_matcher(self, *args, **kwargs): # real signature unknown
        pass

    def push(self, *args, **kwargs): # real signature unknown
        """ Push some new data into this object. """
        pass

    def pushlines(self, *args, **kwargs): # real signature unknown
        pass

    def push_eof_matcher(self, *args, **kwargs): # real signature unknown
        pass

    def readline(self, *args, **kwargs): # real signature unknown
        pass

    def unreadline(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

FeedParser = None # (!) real value is ''

headerRE = None # (!) real value is ''

NeedMoreData = None # (!) real value is ''

NLCRE = None # (!) real value is ''

NLCRE_bol = None # (!) real value is ''

NLCRE_crack = NLCRE_bol

NLCRE_eol = None # (!) real value is ''

__all__ = [
    'FeedParser',
]

