# encoding: utf-8
# module fnmatch
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/fnmatch.pyo by generator 1.99
"""
Filename matching with shell patterns.

fnmatch(FILENAME, PATTERN) matches according to the local convention.
fnmatchcase(FILENAME, PATTERN) always takes case in account.

The functions operate by translating the pattern into a regular
expression.  They cache the compiled regular expressions for speed.

The function translate(PATTERN) returns a regular expression
corresponding to PATTERN.  (It does not compile it.)
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc

# Variables with simple values

_MAXCACHE = 100

# functions

def filter(names, pat): # reliably restored by inspect
    """ Return the subset of the list NAMES that match PAT """
    pass


def fnmatch(name, pat): # reliably restored by inspect
    """
    Test whether FILENAME matches PATTERN.
    
        Patterns are Unix shell style:
    
        *       matches everything
        ?       matches any single character
        [seq]   matches any character in seq
        [!seq]  matches any char not in seq
    
        An initial period in FILENAME is not special.
        Both FILENAME and PATTERN are first case-normalized
        if the operating system requires it.
        If you don't want this, use fnmatchcase(FILENAME, PATTERN).
    """
    pass


def fnmatchcase(name, pat): # reliably restored by inspect
    """
    Test whether FILENAME matches PATTERN, including case.
    
        This is a version of fnmatch() which doesn't case-normalize
        its arguments.
    """
    pass


def translate(pat): # reliably restored by inspect
    """
    Translate a shell PATTERN to a regular expression.
    
        There is no way to quote meta-characters.
    """
    pass


def _purge(): # reliably restored by inspect
    """ Clear the pattern cache """
    pass


# no classes
# variables with complex values

_cache = {}

__all__ = [
    'filter',
    'fnmatch',
    'fnmatchcase',
    'translate',
]

