# encoding: utf-8
# module ftplib
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/ftplib.pyo by generator 1.99
"""
An FTP client class and some helper functions.

Based on RFC 959: File Transfer Protocol (FTP), by J. Postel and J. Reynolds

Example:

>>> from ftplib import FTP
>>> ftp = FTP('ftp.python.org') # connect to host, default port
>>> ftp.login() # default, i.e.: user anonymous, passwd anonymous@
'230 Guest login ok, access restrictions apply.'
>>> ftp.retrlines('LIST') # list directory contents
total 9
drwxr-xr-x   8 root     wheel        1024 Jan  3  1994 .
drwxr-xr-x   8 root     wheel        1024 Jan  3  1994 ..
drwxr-xr-x   2 root     wheel        1024 Jan  3  1994 bin
drwxr-xr-x   2 root     wheel        1024 Jan  3  1994 etc
d-wxrwxr-x   2 ftp      wheel        1024 Sep  5 13:43 incoming
drwxr-xr-x   2 root     wheel        1024 Nov 17  1993 lib
drwxr-xr-x   6 1094     wheel        1024 Sep 13 19:07 pub
drwxr-xr-x   3 root     wheel        1024 Jan  3  1994 usr
-rw-r--r--   1 root     root          312 Aug  1  1994 welcome.msg
'226 Transfer complete.'
>>> ftp.quit()
'221 Goodbye.'
>>>

A nice test that reveals some of the network dialogue would be:
python ftplib.py -d localhost -l -p -l
"""

# imports
import sys as sys # <module 'sys' (built-in)>
import ssl as ssl # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/ssl.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

CRLF = '\r\n'

FTP_PORT = 21

MSG_OOB = 1

_150_re = None

_227_re = None

# functions

def ftpcp(source, sourcename, target, targetname=None, type=None): # reliably restored by inspect
    """ Copy file from one FTP-instance to another. """
    pass


def parse150(resp): # reliably restored by inspect
    """
    Parse the '150' response for a RETR request.
        Returns the expected transfer size or None; size is not guaranteed to
        be present in the 150 message.
    """
    pass


def parse227(resp): # reliably restored by inspect
    """
    Parse the '227' response for a PASV request.
        Raises error_proto if it does not contain '(h1,h2,h3,h4,p1,p2)'
        Return ('host.addr.as.numbers', port#) tuple.
    """
    pass


def parse229(resp, peer): # reliably restored by inspect
    """
    Parse the '229' response for a EPSV request.
        Raises error_proto if it does not contain '(|||port|)'
        Return ('host.addr.as.numbers', port#) tuple.
    """
    pass


def parse257(resp): # reliably restored by inspect
    """
    Parse the '257' response for a MKD or PWD request.
        This is a response to a MKD or PWD request: a directory name.
        Returns the directoryname in the 257 reply.
    """
    pass


def print_line(line): # reliably restored by inspect
    """ Default retrlines callback to print a line. """
    pass


def test(): # reliably restored by inspect
    """
    Test program.
        Usage: ftp [-d] [-r[file]] host [-l[dir]] [-d[dir]] [-p] [file] ...
    
        -d dir
        -l list
        -p password
    """
    pass


# classes

class Error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class error_perm(Error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class error_proto(Error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class error_reply(Error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class error_temp(Error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

all_errors = (
    Error,
    IOError,
    EOFError,
    socket.sslerror,
)

FTP = None # (!) real value is ''

FTP_TLS = None # (!) real value is ''

Netrc = None # (!) real value is ''

_GLOBAL_DEFAULT_TIMEOUT = socket._GLOBAL_DEFAULT_TIMEOUT

__all__ = [
    'FTP',
    'Netrc',
    'FTP_TLS',
]

