# encoding: utf-8
# module icopen
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/plat-mac/icopen.pyo by generator 1.99
"""
icopen patch

OVERVIEW

icopen patches MacOS Python to use the Internet Config file mappings to select
the type and creator for a file.

Version 1 released to the public domain 3 November 1999
by Oliver Steele (steele@cs.brandeis.edu).

DETAILS

This patch causes files created by Python's open(filename, 'w') command (and
by functions and scripts that call it) to set the type and creator of the file
to the type and creator associated with filename's extension (the
portion of the filename after the last period), according to Internet Config.
Thus, a script that creates a file foo.html will create one that opens in whatever
browser you've set to handle *.html files, and so on.

Python IDE uses its own algorithm to select the type and creator for saved
editor windows, so this patch won't effect their types.

As of System 8.6 at least, Internet Config is built into the system, and the
file mappings are accessed from the Advanced pane of the Internet control
panel.  User Mode (in the Edit menu) needs to be set to Advanced in order to
access this pane.

INSTALLATION

Put this file in your Python path, and create a file named {Python}:sitecustomize.py
that contains:
        import icopen

(If {Python}:sitecustomizer.py already exists, just add the 'import' line to it.)

The next time you launch PythonInterpreter or Python IDE, the patch will take
effect.
"""

# imports
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>

# functions

def warnpy3k(message, category=None, stacklevel=1): # reliably restored by inspect
    """
    Issue a deprecation warning for Python 3.x related changes.
    
        Warnings are omitted unless Python is started with the -3 option.
    """
    pass


def _builtin_open(*args, **kwargs): # real signature unknown
    """
    open(name[, mode[, buffering]]) -> file object
    
    Open a file using the file() type, returns a file object.  This is the
    preferred way to open a file.  See file.__doc__ for further information.
    """
    pass


def _open_with_typer(*args): # reliably restored by inspect
    # no doc
    pass


# no classes
