# encoding: utf-8
# module io
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/io.pyo by generator 1.99
"""
The io module provides the Python interfaces to stream handling. The
builtin open function is defined in this module.

At the top of the I/O hierarchy is the abstract base class IOBase. It
defines the basic interface to a stream. Note, however, that there is no
separation between reading and writing to streams; implementations are
allowed to throw an IOError if they do not support a given operation.

Extending IOBase is RawIOBase which deals simply with the reading and
writing of raw bytes to a stream. FileIO subclasses RawIOBase to provide
an interface to OS files.

BufferedIOBase deals with buffering on a raw byte stream (RawIOBase). Its
subclasses, BufferedWriter, BufferedReader, and BufferedRWPair buffer
streams that are readable, writable, and both respectively.
BufferedRandom provides a buffered interface to random access
streams. BytesIO is a simple stream of in-memory bytes.

Another IOBase subclass, TextIOBase, deals with the encoding and decoding
of streams into text. TextIOWrapper, which extends it, is a buffered text
interface to a buffered raw stream (`BufferedIOBase`). Finally, StringIO
is a in-memory stream for text.

Argument names are not part of the specification, and only the arguments
of open() are intended to be used as keyword arguments.

data:

DEFAULT_BUFFER_SIZE

   An int containing the default buffer size used by the module's buffered
   I/O classes. open() uses the file's blksize (as obtained by os.stat) if
   possible.
"""

# imports
import abc as abc # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/abc.pyc
import _io as _io # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/_io.so
from _io import (BufferedRWPair, BufferedRandom, BufferedReader, 
    BufferedWriter, BytesIO, FileIO, IncrementalNewlineDecoder, OpenWrapper, 
    StringIO, TextIOWrapper, open)

import _io as ___io


# Variables with simple values

DEFAULT_BUFFER_SIZE = 8192

SEEK_CUR = 1
SEEK_END = 2
SEEK_SET = 0

__author__ = "Guido van Rossum <guido@python.org>, Mike Verdone <mike.verdone@gmail.com>, Mark Russell <mark.russell@zen.co.uk>, Antoine Pitrou <solipsis@pitrou.net>, Amaury Forgeot d'Arc <amauryfa@gmail.com>, Benjamin Peterson <benjamin@python.org>"

# no functions
# classes

class BlockingIOError(IOError):
    """ Exception raised when I/O would block on a non-blocking I/O stream """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    characters_written = property(lambda self: object()) # default


class IOBase(___io._IOBase):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 10
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class BufferedIOBase(___io._BufferedIOBase, IOBase):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 15
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class RawIOBase(___io._RawIOBase, IOBase):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 10
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class TextIOBase(___io._TextIOBase, IOBase):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 17
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class UnsupportedOperation(ValueError, IOError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

__all__ = [
    'BlockingIOError',
    'open',
    'IOBase',
    'RawIOBase',
    'FileIO',
    'BytesIO',
    'StringIO',
    'BufferedIOBase',
    'BufferedReader',
    'BufferedWriter',
    'BufferedRWPair',
    'BufferedRandom',
    'TextIOBase',
    'TextIOWrapper',
    'UnsupportedOperation',
    'SEEK_SET',
    'SEEK_CUR',
    'SEEK_END',
]

