# encoding: utf-8
# module json.encoder
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/json/encoder.pyo by generator 1.99
""" Implementation of JSONEncoder """

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
from _json import (c_encode_basestring_ascii, c_make_encoder, 
    encode_basestring_ascii)


# Variables with simple values
i = 31

INFINITY = inf

# functions

def encode_basestring(s): # reliably restored by inspect
    """ Return a JSON representation of a Python string """
    pass


def FLOAT_REPR(*args, **kwargs): # real signature unknown
    """
    repr(object) -> string
    
    Return the canonical string representation of the object.
    For most object types, eval(repr(object)) == object.
    """
    pass


def py_encode_basestring_ascii(s): # reliably restored by inspect
    """ Return an ASCII-only JSON representation of a Python string """
    pass


def _make_iterencode(markers, _default, _encoder, _indent, _floatstr, _key_separator, _item_separator, _sort_keys, _skipkeys, _one_shot, ValueError="<type 'exceptions.ValueError'>", basestring=basestring, dict=dict, float=float, id=id, int=int, isinstance=isinstance, list=list, long=long, str=str, tuple=tuple): # reliably restored by inspect
    # no doc
    pass


# classes

class JSONEncoder(object):
    """
    Extensible JSON <http://json.org> encoder for Python data structures.
    
        Supports the following objects and types by default:
    
        +-------------------+---------------+
        | Python            | JSON          |
        +===================+===============+
        | dict              | object        |
        +-------------------+---------------+
        | list, tuple       | array         |
        +-------------------+---------------+
        | str, unicode      | string        |
        +-------------------+---------------+
        | int, long, float  | number        |
        +-------------------+---------------+
        | True              | true          |
        +-------------------+---------------+
        | False             | false         |
        +-------------------+---------------+
        | None              | null          |
        +-------------------+---------------+
    
        To extend this to recognize other objects, subclass and implement a
        ``.default()`` method with another method that returns a serializable
        object for ``o`` if possible, otherwise it should call the superclass
        implementation (to raise ``TypeError``).
    """
    def default(self, o): # real signature unknown; restored from __doc__
        """
        Implement this method in a subclass such that it returns
                a serializable object for ``o``, or calls the base implementation
                (to raise a ``TypeError``).
        
                For example, to support arbitrary iterators, you could
                implement default like this::
        
                    def default(self, o):
                        try:
                            iterable = iter(o)
                        except TypeError:
                            pass
                        else:
                            return list(iterable)
                        return JSONEncoder.default(self, o)
        """
        pass

    def encode(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Return a JSON string representation of a Python data structure.
        
                >>> JSONEncoder().encode({"foo": ["bar", "baz"]})
                '{"foo": ["bar", "baz"]}'
        """
        pass

    def iterencode(self, bigobject): # real signature unknown; restored from __doc__
        """
        Encode the given object and yield each string
                representation as available.
        
                For example::
        
                    for chunk in JSONEncoder().iterencode(bigobject):
                        mysocket.write(chunk)
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Constructor for JSONEncoder, with sensible defaults.
        
                If skipkeys is false, then it is a TypeError to attempt
                encoding of keys that are not str, int, long, float or None.  If
                skipkeys is True, such items are simply skipped.
        
                If ensure_ascii is true, the output is guaranteed to be str
                objects with all incoming unicode characters escaped.  If
                ensure_ascii is false, the output will be unicode object.
        
                If check_circular is true, then lists, dicts, and custom encoded
                objects will be checked for circular references during encoding to
                prevent an infinite recursion (which would cause an OverflowError).
                Otherwise, no such check takes place.
        
                If allow_nan is true, then NaN, Infinity, and -Infinity will be
                encoded as such.  This behavior is not JSON specification compliant,
                but is consistent with most JavaScript based encoders and decoders.
                Otherwise, it will be a ValueError to encode such floats.
        
                If sort_keys is true, then the output of dictionaries will be
                sorted by key; this is useful for regression tests to ensure
                that JSON serializations can be compared on a day-to-day basis.
        
                If indent is a non-negative integer, then JSON array
                elements and object members will be pretty-printed with that
                indent level.  An indent level of 0 will only insert newlines.
                None is the most compact representation.
        
                If specified, separators should be a (item_separator, key_separator)
                tuple.  The default is (', ', ': ').  To get the most compact JSON
                representation you should specify (',', ':') to eliminate whitespace.
        
                If specified, default is a function that gets called for objects
                that can't otherwise be serialized.  It should return a JSON encodable
                version of the object or raise a ``TypeError``.
        
                If encoding is not None, then all input strings will be
                transformed into unicode using that encoding prior to JSON-encoding.
                The default is UTF-8.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    item_separator = ', '
    key_separator = ': '
    __dict__ = None # (!) real value is ''


# variables with complex values

ESCAPE = None # (!) real value is ''

ESCAPE_ASCII = None # (!) real value is ''

ESCAPE_DCT = {
    '\x00': '\\u0000',
    '\x01': '\\u0001',
    '\x02': '\\u0002',
    '\x03': '\\u0003',
    '\x04': '\\u0004',
    '\x05': '\\u0005',
    '\x06': '\\u0006',
    '\x07': '\\u0007',
    '\x08': '\\b',
    '\t': '\\t',
    '\n': '\\n',
    '\x0b': '\\u000b',
    '\x0c': '\\f',
    '\r': '\\r',
    '\x0e': '\\u000e',
    '\x0f': '\\u000f',
    '\x10': '\\u0010',
    '\x11': '\\u0011',
    '\x12': '\\u0012',
    '\x13': '\\u0013',
    '\x14': '\\u0014',
    '\x15': '\\u0015',
    '\x16': '\\u0016',
    '\x17': '\\u0017',
    '\x18': '\\u0018',
    '\x19': '\\u0019',
    '\x1a': '\\u001a',
    '\x1b': '\\u001b',
    '\x1c': '\\u001c',
    '\x1d': '\\u001d',
    '\x1e': '\\u001e',
    '\x1f': '\\u001f',
    '"': '\\"',
    '\\': '\\\\',
}

HAS_UTF8 = None # (!) real value is ''

