# encoding: utf-8
# module lib2to3.fixes.fix_filter
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixes/fix_filter.pyo by generator 1.99
"""
Fixer that changes filter(F, X) into list(filter(F, X)).

We avoid the transformation if the filter() call is directly contained
in iter(<>), list(<>), tuple(<>), sorted(<>), ...join(<>), or
for V in <>:.

NOTE: This is still not correct if the original code was depending on
filter(F, X) to return a string if X is a string and a tuple if X is a
tuple.  That would require type inference, which we don't do.  Let
Python 2.6 figure it out.
"""

# imports
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# functions

def Call(func_name, args=None, prefix=None): # reliably restored by inspect
    """ A function call """
    pass


def in_special_context(node): # reliably restored by inspect
    """
    Returns true if node is in an environment where all that is required
            of it is being itterable (ie, it doesn't matter if it returns a list
            or an itterator).
            See test_map_nochange in test_fixers.py for some examples and tests.
    """
    pass


def ListComp(xp, fp, it, test=None): # reliably restored by inspect
    """
    A list comprehension of the form [xp for fp in it if test].
    
        If test is None, the "if test" part is omitted.
    """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


# classes

class FixFilter(__lib2to3_fixer_base.ConditionalFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    BM_compatible = True
    PATTERN = "\n    filter_lambda=power<\n        'filter'\n        trailer<\n            '('\n            arglist<\n                lambdef< 'lambda'\n                         (fp=NAME | vfpdef< '(' fp=NAME ')'> ) ':' xp=any\n                >\n                ','\n                it=any\n            >\n            ')'\n        >\n    >\n    |\n    power<\n        'filter'\n        trailer< '(' arglist< none='None' ',' seq=any > ')' >\n    >\n    |\n    power<\n        'filter'\n        args=trailer< '(' [any] ')' >\n    >\n    "
    skip_on = 'future_builtins.filter'


